#include "cppdefs.h"
#if defined MY25_MIXING && defined SOLVE3D
      subroutine my25_prestep (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine perfoms the predictor step for turbulent kinetic     !
!  energy prognostic variables, tke and gls. A NON-conservative,     !
!  but constancy preserving, auxiliary advective substep for tke     !
!  gls equations is carried out. The result of this substep will     !
!  be used to compute advective terms in the corrector substep.      !
!  No dissipation terms are included here.                           !
!                                                                    !
!====================================================================!
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (20)
# endif
      call my25_prestep_tile (Istr,Iend,Jstr,Jend,
     &                        A3d(1,1),A2d(1,1),A2d(1,2),A2d(1,3),
     &                        A2d(1,4),A2d(1,5),A2d(1,6),A2d(1,7),
     &                        A2d(1,8),A2d(1,1),A2d(1,2),A2d(1,3))
# ifdef PROFILE
      call wclock_off (20)
# endif
      return
      end
!
!*********************************************************************
      subroutine my25_prestep_tile (Istr,Iend,Jstr,Jend,Hz_half,
     &                              XF,FX,FXL,EF,FE,FEL,grad,gradL,
     &                              CF,FC,FCL)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "mask.h"
# include "mixing.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, indx, j, k
      REAL_TYPE
     &        cff, cff1, cff2, cff3, cff4, Gamma
      REAL_TYPE
     &             CF(PRIVATE_1D_SCRATCH_ARRAY,N),
     &             FC(PRIVATE_1D_SCRATCH_ARRAY,N),
     &            FCL(PRIVATE_1D_SCRATCH_ARRAY,N),
     &        Hz_half(PRIVATE_2D_SCRATCH_ARRAY,N),
     &             EF(PRIVATE_2D_SCRATCH_ARRAY),
     &             FE(PRIVATE_2D_SCRATCH_ARRAY),
     &            FEL(PRIVATE_2D_SCRATCH_ARRAY),
     &             FX(PRIVATE_2D_SCRATCH_ARRAY),
     &            FXL(PRIVATE_2D_SCRATCH_ARRAY),
     &             XF(PRIVATE_2D_SCRATCH_ARRAY),
     &           grad(PRIVATE_2D_SCRATCH_ARRAY),
     &          gradL(PRIVATE_2D_SCRATCH_ARRAY)
!
      parameter (Gamma=1.0_r8/6.0_r8)
!
# include "set_bounds.h"
!
!---------------------------------------------------------------------
!  Predictor step for advection of turbulent kinetic energy variables.
!---------------------------------------------------------------------
!
! Start computation of auxiliary time step fields tke(:,:,:,n+1/2) and
! gls(:,:,:,n+1/2) with computation of horizontal advection terms and
! auxiliary grid-box height field Hz_new()=Hz(:,:,k+1/2,n+1/2);
! This is effectivey an LF step with subsequent interpolation of the
! result half step back, using AM3 weights. The LF step and
! interpolation are perfomed as a single operation, which results in
! weights cff1,cff2,cff3 below.
!
! Either centered fourth-order accurate or standard second order
! accurate versions are supported.
!
! At the same time prepare for corrector step for tke,gls: set tke,
! gls(:,:,:,nnew) to  tke, gls(:,:,:,nstp) multiplied by the
! corresponding grid-box height. This needs done at this time because
! array Hz(:,:,:) will overwritten after 2D time stepping with the
! values computed from zeta(:,:,n+1) rather than zeta(:,:,n), so that
! the old-time-step Hz will be no longer awailable.
!

      do k=1,N-1
# ifdef K_C2ADVECTION
!
!  Second-order, centered differences advection.
!
        do j=Jstr,Jend
          do i=Istr,Iend+1
            XF(i,j)=0.5_r8*(Huon(i,j,k)+Huon(i,j,k+1))
            FX (i,j)=XF(i,j)*
     &               0.5_r8*(tke(i,j,k,nstp)+tke(i-1,j,k,nstp))
            FXL(i,j)=XF(i,j)*
     &               0.5_r8*(gls(i,j,k,nstp)+gls(i-1,j,k,nstp))
          enddo
        enddo
        do j=Jstr,Jend+1
          do i=Istr,Iend
            EF(i,j)=0.5*(Hvom(i,j,k)+Hvom(i,j,k+1))
            FE (i,j)=EF(i,j)*
     &               0.5*(tke(i,j,k,nstp)+tke(i,j-1,k,nstp))
            FEL(i,j)=EF(i,j)*
     &               0.5*(gls(i,j,k,nstp)+gls(i,j-1,k,nstp))
          enddo
        enddo
# else
!
!  Fourth-order, centered differences advection.
!
#  ifdef EW_PERIODIC
#   define I_RANGE Istr-1,Iend+2
#  else
#   define I_RANGE max(Istr-1,1),min(Iend+2,Lm+1)
#  endif
        do j=Jstr,Jend
          do i=I_RANGE
            grad (i,j)=(tke(i,j,k,nstp)-tke(i-1,j,k,nstp))
#  ifdef MASKING
     &                *umask(i,j)
#  endif
            gradL(i,j)=(gls(i,j,k,nstp)-gls(i-1,j,k,nstp))
#  ifdef MASKING
     &                *umask(i,j)
#  endif
          enddo
        enddo
#  undef I_RANGE
#  ifndef EW_PERIODIC
        if (WESTERN_EDGE) then
          do j=Jstr,Jend
            grad (Istr-1,j)=grad (Istr,j)
            gradL(Istr-1,j)=gradL(Istr,j)
          enddo
        endif
        if (EASTERN_EDGE) then
          do j=Jstr,Jend
            grad (Iend+2,j)=grad (Iend+1,j)
            gradL(Iend+2,j)=gradL(Iend+1,j)
          enddo
        endif
#  endif
        cff=1.0_r8/6.0_r8
        do j=Jstr,Jend
          do i=Istr,Iend+1
            XF(i,j)=0.5_r8*(Huon(i,j,k)+Huon(i,j,k+1))
            FX (i,j)=XF(i,j)*
     &               0.5_r8*(tke(i-1,j,k,nstp)+tke(i,j,k,nstp)-
     &                       cff*(grad (i+1,j)-grad (i-1,j)))
            FXL(i,j)=XF(i,j)*
     &               0.5_r8*(gls(i-1,j,k,nstp)+gls(i,j,k,nstp)-
     &                       cff*(gradL(i+1,j)-gradL(i-1,j)))
          enddo
        enddo
!
#  ifdef NS_PERIODIC
#   define J_RANGE Jstr-1,Jend+2
#  else
#   define J_RANGE max(Jstr-1,1),min(Jend+2,Mm+1)
#  endif
        do j=J_RANGE
          do i=Istr,Iend
            grad (i,j)=(tke(i,j,k,nstp)-tke(i,j-1,k,nstp))
#  ifdef MASKING
     &                *vmask(i,j)
#  endif
            gradL(i,j)=(gls(i,j,k,nstp)-gls(i,j-1,k,nstp))
#  ifdef MASKING
     &                *vmask(i,j)
#  endif
          enddo
        enddo
#  undef J_RANGE
#  ifndef NS_PERIODIC
        if (SOUTHERN_EDGE) then
          do i=Istr,Iend
            grad (i,Jstr-1)=grad (i,Jstr)
            gradL(i,Jstr-1)=gradL(i,Jstr)
          enddo
        endif
        if (NORTHERN_EDGE) then
          do i=Istr,Iend
            grad (i,Jend+2)=grad (i,Jend+1)
            gradL(i,Jend+2)=gradL(i,Jend+1)
          enddo
        endif
#  endif
        cff=1.0_r8/6.0_r8
        do j=Jstr,Jend+1
          do i=Istr,Iend
            EF(i,j)=0.5_r8*(Hvom(i,j,k)+Hvom(i,j,k+1))
            FE (i,j)=EF(i,j)*
     &               0.5_r8*(tke(i,j-1,k,nstp)+tke(i,j,k,nstp)-
     &                       cff*(grad (i,j+1)-grad (i,j-1)))
            FEL(i,j)=EF(i,j)*
     &               0.5_r8*(gls(i,j-1,k,nstp)+gls(i,j,k,nstp)-
     &                       cff*(gradL(i,j+1)-gradL(i,j-1)))
          enddo
        enddo
# endif
!
!  Time-step horizontal advection.
!
        if (iic.eq.ntfirst) then
          cff1=1.0_r8
          cff2=0.0_r8
          cff3=0.5_r8*dt
          indx=nstp
        else
          cff1=0.5_r8+Gamma
          cff2=0.5_r8-Gamma
          cff3=(1.0_r8-Gamma)*dt
          indx=3-nstp
        endif
        do j=Jstr,Jend
          do i=Istr,Iend
            cff=0.5_r8*(Hz(i,j,k)+Hz(i,j,k+1))
            cff4=cff3*pm(i,j)*pn(i,j)
            Hz_half(i,j,k)=cff-cff4*(XF(i+1,j)-XF(i,j)+
     &                               EF(i,j+1)-EF(i,j))
            tke(i,j,k,3)=cff*(cff1*tke(i,j,k,nstp)+
     &                        cff2*tke(i,j,k,indx))-
     &                   cff4*(FX (i+1,j)-FX (i,j)+
     &                         FE (i,j+1)-FE (i,j))
            gls(i,j,k,3)=cff*(cff1*gls(i,j,k,nstp)+
     &                        cff2*gls(i,j,k,indx))-
     &                   cff4*(FXL(i+1,j)-FXL(i,j)+
     &                         FEL(i,j+1)-FEL(i,j))
            tke(i,j,k,nnew)=cff*tke(i,j,k,nstp)
            gls(i,j,k,nnew)=cff*gls(i,j,k,nstp)
          enddo
        enddo
      enddo
!
! Compute vertical advection term.
!
      do j=Jstr,Jend
# ifdef K_C2ADVECTION
        do k=1,N
          do i=Istr,Iend
            CF(i,k)=0.5_r8*(W(i,j,k)+W(i,j,k-1))
            FC (i,k)=CF(i,k)*
     &               0.5_r8*(tke(i,j,k-1,nstp)+tke(i,j,k,nstp))
            FCL(i,k)=CF(i,k)*
     &               0.5_r8*(gls(i,j,k-1,nstp)+gls(i,j,k,nstp))
          enddo
        enddo
# else
        cff1=7.0_r8/12.0_r8
        cff2=1.0_r8/12.0_r8
        do k=2,N-1
          do i=Istr,Iend
            CF(i,k)=0.5_r8*(W(i,j,k)+W(i,j,k-1))
            FC (i,k)=CF(i,k)*(cff1*(tke(i,j,k-1,nstp)+
     &                              tke(i,j,k  ,nstp))-
     &                        cff2*(tke(i,j,k-2,nstp)+
     &                              tke(i,j,k+1,nstp)))
            FCL(i,k)=CF(i,k)*(cff1*(gls(i,j,k-1,nstp)+
     &                              gls(i,j,k  ,nstp))-
     &                        cff2*(gls(i,j,k-2,nstp)+
     &                              gls(i,j,k+1,nstp)))
          enddo
        enddo
        cff1=1.0_r8/3.0_r8
        cff2=5.0_r8/6.0_r8
        cff3=1.0_r8/6.0_r8
        do i=Istr,Iend
          CF(i,1)=0.5*(W(i,j,0)+W(i,j,1))
          FC (i,1)=CF(i,1)*(cff1*tke(i,j,0,nstp)+
     &                      cff2*tke(i,j,1,nstp)-
     &                      cff3*tke(i,j,2,nstp))
          FCL(i,1)=CF(i,1)*(cff1*gls(i,j,0,nstp)+
     &                      cff2*gls(i,j,1,nstp)-
     &                      cff3*gls(i,j,2,nstp))
          CF(i,N)=0.5*(W(i,j,N)+W(i,j,N-1))
          FC (i,N)=CF(i,N)*(cff1*tke(i,j,N  ,nstp)+
     &                      cff2*tke(i,j,N-1,nstp)-
     &                      cff3*tke(i,j,N-2,nstp))
          FCL(i,N)=CF(i,N)*(cff1*gls(i,j,N  ,nstp)+
     &                      cff2*gls(i,j,N-1,nstp)-
     &                      cff3*gls(i,j,N-2,nstp))
        enddo
# endif
!
!  Time-step vertical advection term.
!
        if (iic.eq.ntfirst) then
          cff3=0.5_r8*dt
        else
          cff3=(1.0_r8-Gamma)*dt
        endif
        do k=1,N-1
          do i=Istr,Iend
            cff4=cff3*pm(i,j)*pn(i,j)
            Hz_half(i,j,k)=Hz_half(i,j,k)-cff4*(CF(i,k+1)-CF(i,k))
            cff1=1.0_r8/Hz_half(i,j,k)
            tke(i,j,k,3)=cff1*(tke(i,j,k,3)-
     &                         cff4*(FC (i,k+1)-FC (i,k)))
            gls(i,j,k,3)=cff1*(gls(i,j,k,3)-
     &                         cff4*(FCL(i,k+1)-FCL(i,k)))
          enddo
        enddo
      enddo
!
!  Apply lateral boundary conditions.
!
      call tkebc_tile (Istr,Iend,Jstr,Jend,3,grad,gradL)
# if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_w3d_tile (Istr,Iend,Jstr,Jend,
     &                        tke(START_2D_ARRAY,0,3))
      call exchange_w3d_tile (Istr,Iend,Jstr,Jend,
     &                        gls(START_2D_ARRAY,0,3))
# endif
#else
      subroutine my25_prestep
#endif
      return
      end
