#include "cppdefs.h"
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This package contains multi-processing routines used during       !
!  parallel applications:                                            !
!                                                                    !
!     my_getpid        Returns process ID of the calling process.    !
!     my_numthreads    Returns number of threads that would          !
!                        execute in parallel regions.                !
!     my_threadnum     Returns which thread number is working        !
!                        in a parallel region.                       !
!     my_initlock      Initializes a given lock.                     !
!     my_setlock       Allows locking in parallel regions for        !
!                        serializing access to shared variables.     !
!     my_unsetlock     Allows unlocking in parallel regions.         !
!     my_destroylock   Destroys a given lock.                        !
!     my_wtime         Returns an elapsed wall time in seconds since !
!                        an arbitrary time in the past.              !
!                                                                    !
!=====================================================================
!
!
!---------------------------------------------------------------------
      function my_getpid ()
!---------------------------------------------------------------------
!
      implicit none
      INTEGER_TYPE
     &        my_getpid
      INTEGER_TYPE
     &        getpid
      my_getpid=getpid()
      return
      end
!
!---------------------------------------------------------------------
      function my_numthreads ()
!---------------------------------------------------------------------
!
      implicit none
      INTEGER_TYPE
     &        my_numthreads
!
#if defined _OPENMP
      INTEGER_TYPE
     &        omp_get_num_threads
      my_numthreads=omp_get_num_threads()
#elif defined SGI
      INTEGER_TYPE
     &        mp_numthreads
      my_numthreads=mp_numthreads()
#else
      my_numthreads=1
#endif
      return
      end
!
!---------------------------------------------------------------------
      function my_threadnum ()
!---------------------------------------------------------------------
!
      implicit none
      INTEGER_TYPE
     &        my_threadnum
!
#if defined _OPENMP
      INTEGER_TYPE
     &        omp_get_thread_num
      my_threadnum=omp_get_thread_num()
#elif defined SGI
      INTEGER_TYPE
     &        mp_my_threadnum
      my_threadnum=mp_my_threadnum()
#else
      my_threadnum=0
#endif
      return
      end
!
!---------------------------------------------------------------------
      subroutine my_initlock (lock)
!---------------------------------------------------------------------
!
      implicit none
      POINTER_TYPE
     &        lock
!
#if defined _OPENMP
      call omp_init_lock (lock)
#else
      lock=-1
#endif
      return
      end
!
!---------------------------------------------------------------------
      subroutine my_setlock (lock)
!---------------------------------------------------------------------
!
      implicit none
      POINTER_TYPE
     &        lock
!
#if defined _OPENMP
      call omp_set_lock (lock)
#elif defined SGI
      call mp_setlock ()
#else
      lock=1
#endif
      return
      end
!
!---------------------------------------------------------------------
      subroutine my_unsetlock (lock)
!---------------------------------------------------------------------
!
      implicit none
      POINTER_TYPE
     &        lock
!
#if defined _OPENMP
      call omp_unset_lock (lock)
#elif defined SGI
      call mp_unsetlock ()
#else
      lock=-1
#endif
      return
      end
!
!---------------------------------------------------------------------
      subroutine my_destroylock (lock)
!---------------------------------------------------------------------
!
      implicit none
      POINTER_TYPE
     &        lock
!
#if defined _OPENMP
      call omp_destroy_lock (lock)
#else
      lock=0
#endif
      return
      end
!
!---------------------------------------------------------------------
      function my_wtime (wtime)
!---------------------------------------------------------------------
!
      implicit none
      REAL_TYPE
     &        wtime(2)
      real*8  my_wtime
#if defined _OPENMP
      real*8  omp_get_wtime
      my_wtime=omp_get_wtime()        ! not available on OpenMP 1.0

#elif defined SUN || defined SGI || defined DECALPHA
      real*4 etime, rtime(2)
      my_wtime=DBLE(etime(rtime))
      wtime(1)=DBLE(rtime(1))         ! user time
      wtime(2)=DBLE(rtime(2))         ! system time
#else
      my_wtime=0.0_r8
#endif
#ifdef REMOVE
      call cpu_time(wtime(1))
      my_wtime=wtime(1)
#endif
      return
      end
