/*
** Include file "mixing.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Akk_bak      Background vertical mixing coefficient (m2/s) for   **
**                turbulent energy.                                 **
** Akp_bak      Background vertical mixing coefficient (m2/s) for   **
**                generic statistical field "psi".                  ** 
** Akt          Vertical mixing coefficient (m2/s) for tracers.     **
** dAktdz       Vertical gradient in mixing coefficient (m/s) for   **
**                tracer 1, used in float random walk calculations  **
** Akt_bak      Background vertical mixing coefficient (m2/s) for   **
**                tracers.                                          **
** Akv          Vertical mixing coefficient (m2/s) for momentum.    **
** Akv_bak      Background vertical mixing coefficient (m2/s) for   **
**                momentum.                                         **
** Kdiff        Isopycnal mixing thickness diffusivity (m2/s) for   **
**                tracers.                                          **
** alpha        Surface thermal expansion coefficient (1/Celsius).  **
** beta         Surface saline contraction coefficient (1/PSU).     **
** bvf          Brunt-Vaisala frequency squared (1/s2).             **
** tkenu2       Lateral harmonic constant mixing coefficient        **
**                (m2/s) for turbulent energy.                      **
** tkenu4       Square root lateral biharmonic constant mixing      **
**                coefficient (m^2 s^-1/2) for turbulent energy.    **
** tnu2         Lateral harmonic constant mixing coefficient        **
**                (m2/s) for tracer type variables.                 **
** tnu4         Square root lateral biharmonic constant mixing      **
**                coefficient (m^2 s^-1/2) for tracer type          **
**                variables.                                        **
** visc2        Lateral harmonic constant mixing coefficient        **
**                (m2/s) for momentum.                              **
** visc4        Square root lateral biharmonic constant mixing      **
**                coefficient (m^2 s^-1/2) for momentum.            **
**                                                                  **
**********************************************************************
*/

      common /smixing/
     &        Akk_bak,           Akp_bak,           Akt_bak,
     &        Akv_bak,           Kdiff,             tkenu2,
     &        tkenu4,            tnu2,              tnu4,
     &        visc2,             visc4
      REAL_TYPE
     &        Akk_bak,           Akp_bak,           Akt_bak(NT+1),
     &        Akv_bak,           Kdiff(NT+1),       tkenu2,
     &        tkenu4,            tnu2(NT+1),        tnu4(NT+1),
     &        visc2,             visc4

#ifdef UV_VIS2
      common /mixing_visc2_p/ visc2_p
      REAL_TYPE visc2_p(GLOBAL_2D_ARRAY)

      common /mixing_visc2_r/ visc2_r
      REAL_TYPE visc2_r(GLOBAL_2D_ARRAY)
#endif

#ifdef UV_VIS4
      common /mixing_visc4_p/ visc4_p
      REAL_TYPE visc4_p(GLOBAL_2D_ARRAY)

      common /mixing_visc4_r/ visc4_r
      REAL_TYPE visc4_r(GLOBAL_2D_ARRAY)
#endif

#ifdef TS_DIF2
      common /mixing_diff2/ diff2
      REAL_TYPE diff2(GLOBAL_2D_ARRAY,NT)
#endif

#ifdef TS_DIF4
      common /mixing_diff4/ diff4
      REAL_TYPE diff4(GLOBAL_2D_ARRAY,NT)
#endif

      common /mixing_Akv/ Akv
      REAL_TYPE Akv(GLOBAL_2D_ARRAY,0:N)

      common /mixing_Akt/ Akt
      REAL_TYPE Akt(GLOBAL_2D_ARRAY,0:N,NAT)

#ifdef FLOAT_VWALK
      common /mixing_dAktdz/ dAktdz
      REAL_TYPE dAktdz(GLOBAL_2D_ARRAY,N)
#endif

#if defined LMD_SKPP || defined LMD_BKPP || defined BULK_FLUXES
      common /mixing_alpha/ alpha
      REAL_TYPE alpha(GLOBAL_2D_ARRAY)

      common /mixing_beta/ beta
      REAL_TYPE beta(GLOBAL_2D_ARRAY)
#endif

#ifdef BV_FREQUENCY
      common /mixing_bvf/ bvf
      REAL_TYPE bvf(GLOBAL_2D_ARRAY,0:N)
#endif

#if defined MIX_ISO_TS || defined GENT_McWILLIAMS

/*
**********************************************************************
** Rotated horizontal mixing tensor variables.                      **
**********************************************************************
**                                                                  **
** neutral      Coefficient to convert "in situ" density to neutral **
**                surface.                                          **
**                                                                  **
**********************************************************************
*/

      common /mixing_neutral/ neutral
      REAL_TYPE neutral(GLOBAL_2D_ARRAY,0:N)

#endif /* MIX_ISO_TS || GENT_McWILLIAMS */

#ifdef BVF_MIXING

/*
**********************************************************************
** Brunt-Vaisala frequency based vertical mixing variables.         **
**********************************************************************
**                                                                  **
** bvf_numax    Upper bound vertical diffusion (m2/s).              **
** bvf_numin    Lower bound vertical diffusion (m2/s).              **
** bvf_nu0      Proportionality constant (m2/s2).                   **
** bvf_nu0c     Convective diffusion (m2/s) in static unstable      **
**                regime.                                           **
**                                                                  **
**********************************************************************
*/
      common /mixing_sbvf/
     &        bvf_numax,         bvf_numin,         bvf_nu0,
     &        bvf_nu0c
      REAL_TYPE
     &        bvf_numax,         bvf_numin,         bvf_nu0,
     &        bvf_nu0c

#endif /* BVF_MIXING */

/*
**********************************************************************
** Vertical turbulent closure variables.                            **
**********************************************************************
**                                                                  **
** tke          Turbulent energy squared (m2/s2) at horizontal      **
**                at W-points.                                      **
** gls          Turbulent energy squared times turbulent length     **
**                scale (m3/s2) at W-points.                        **
**                                                                  **
** Generic Length Scale parameters:                                 **
**                                                                  **
** gls_Ghcri                                                        **
** gls_Ghmin                                                        **
** gls_Kmin     Minimum value of specific turbulent kinetic energy. **
** gls_Pmin     Minimum Value of dissipation.                       **
** gls_cmu0     Stability coefficient (non-dimensional).            **
** gls_c1       Shear production coefficient (non-dimensional).     **
** gls_c2       Dissipation coefficient (non-dimensional).          **
** gls_c3m      Buoyancy production coefficient (minus).            **
** gls_c3p      Buoyancy production coefficient (plus).             **
** gls_E2                                                           **
** gls_m        Turbulent kinetic energy exponent (non-dimensional).**
** gls_n        Turbulent length scale exponent (non-dimensional).  **
** gls_p        Stability exponent (non-dimensional).               **
** gls_sigk     Constant Schmidt number (non-dimensional) for       **
**                turbulent kinetic energy diffusivity.             **
** gls_sigp     Constant Schmidt number (non-dimensional) for       **
**                turbulent generic statistical field, "psi".       **
**                                                                  **
** Mellor-Yamada (1982) Level 2.5 parameters:                       **
**                                                                  **
** my_A1        Turbulent closure A1 constant.                      **
** my_A2        Turbulent closure A2 constant.                      **
** my_B1        Turbulent closure B1 constant.                      **
** my_B1p2o3    Constant, B1**(2/3).                                **
** my_B1pm1o3   Constant, B1**(-1/3).                               **
** my_B2        Turbulent closure B2 constant.                      **
** my_C1        Turbulent closure C1 constant.                      **
** my_C2        Turbulent closure C2 constant.                      **
** my_C3        Turbulent closure C3 constant.                      **
** my_E1        Turbulent closure E1 constant.                      **
** my_E1o2      0.5*E1                                              **
** my_E2        Turbulent closure E2 constant.                      **
** my_Gh0       Lower bound on Galperin et al. stability function.  **
** my_Sh1       Tracers stability function constant factor.         **
** my_Sh2       Tracers stability function constant factor.         **
** my_Sm1       Momentum stability function constant factor.        **
** my_Sm2       Momentum stability function constant factor.        **
** my_Sm3       Momentum stability function constant factor.        **
** my_Sm4       Momentum stability function constant factor.        **
** my_Sq        Scale for vertical mixing of turbulent energy.      **
** my_dtfac     Asselin time filter coefficient.                    **
** my_lmax      Upper bound on the turbulent length scale.          **
** my_qmin      Lower bound on turbulent energy "tke" and "gls".    **
**                                                                  **
**********************************************************************
*/

      common /sgls_mix/
     &        gls_Ghcri,         gls_Ghmin,         gls_Gh0,
     &        gls_Kmin,          gls_L1,            gls_L2,
     &        gls_L3,            gls_L4,            gls_L5,
     &        gls_L6,            gls_L7,            gls_L8,
     &        gls_Pmin,          gls_b0,            gls_b1,
     &        gls_b2,            gls_b3,            gls_b4,
     &        gls_b5,            gls_cmu0,          gls_cmupr,
     &        gls_c1,            gls_c2,            gls_c3m,
     &        gls_c3p,           gls_E2,            gls_m,
     &        gls_n,             gls_p,             gls_sigk,
     &        gls_sigp,          gls_s0,            gls_s1,
     &        gls_s2,            gls_s4,            gls_s5,
     &        gls_s6
      REAL_TYPE
     &        gls_Ghcri,         gls_Ghmin,         gls_Gh0,
     &        gls_Kmin,          gls_L1,            gls_L2,
     &        gls_L3,            gls_L4,            gls_L5,
     &        gls_L6,            gls_L7,            gls_L8,
     &        gls_Pmin,          gls_b0,            gls_b1,
     &        gls_b2,            gls_b3,            gls_b4,
     &        gls_b5,            gls_cmu0,          gls_cmupr,
     &        gls_c1,            gls_c2,            gls_c3m,
     &        gls_c3p,           gls_E2,            gls_m,
     &        gls_n,             gls_p,             gls_sigk,
     &        gls_sigp,          gls_s0,            gls_s1,
     &        gls_s2,            gls_s4,            gls_s5,
     &        gls_s6

      common /smy25_mix/
     &        my_A1,             my_A2,             my_B1,
     &        my_B1p2o3,         my_B1pm1o3,        my_B2,
     &        my_C1,             my_C2,             my_C3,
     &        my_E1,             my_E1o2,           my_E2,
     &        my_Gh0,            my_Sh1,            my_Sh2,
     &        my_Sm1,            my_Sm2,            my_Sm3,
     &        my_Sm4,            my_Sq,             my_dtfac,
     &        my_lmax,           my_qmin
      REAL_TYPE
     &        my_A1,             my_A2,             my_B1,
     &        my_B1p2o3,         my_B1pm1o3,        my_B2,
     &        my_C1,             my_C2,             my_C3,
     &        my_E1,             my_E1o2,           my_E2,
     &        my_Gh0,            my_Sh1,            my_Sh2,
     &        my_Sm1,            my_Sm2,            my_Sm3,
     &        my_Sm4,            my_Sq,             my_dtfac,
     &        my_lmax,           my_qmin

#if defined GLS_MIXING || defined MY25_MIXING

      common /tke_mix_tke/ tke
      REAL_TYPE tke(GLOBAL_2D_ARRAY,0:N,3)

      common /tke_mix_gls/ gls
      REAL_TYPE gls(GLOBAL_2D_ARRAY,0:N,3)

      common /tke_mix_Lscale/ Lscale
      REAL_TYPE Lscale(GLOBAL_2D_ARRAY,0:N)

      common /tke_mix_Akk/ Akk
      REAL_TYPE Akk(GLOBAL_2D_ARRAY,0:N)

# ifdef GLS_MIXING
      common /gls_mix_Akp/ Akp
      REAL_TYPE Akp(GLOBAL_2D_ARRAY,0:N)
# endif

#endif /* GLS_MIXING || MY25_MIXING */

#ifdef LMD_MIXING

/*
**********************************************************************
** Large/McWilliams/Doney interior vertical mixing variables.       **
**********************************************************************
**                                                                  **
** alfaobeta    Ratio of thermal expansion and saline contraction   **
**                coefficients (Celsius/PSU) used in double         **
**                diffusion.                                        **
** lmd_Ri0      Critical gradient Richardson number below which     **
**                turbulent mixing occurs.                          **
** lmd_Rrho0    Value of double-diffusive density ratio where       **
**                mixing goes to zero in salt fingering.            **
** lmd_bvfcon   Brunt-Vaisala frequency (1/s2) limit for convection **
** lmd_fdd      Scaling factor for double diffusion of temperature  **
**                in salt fingering case (lmd_fdd=0.7).             **
** lmd_nu       Molecular viscosity (m2/s).                         **
** lmd_nu0c     Maximum interior convective viscosity and           **
**                diffusivity due to shear instability.             **
** lmd_nu0m     Maximum interior viscosity (m2/s) due shear         **
**                instability.                                      **
** lmd_nu0s     Maximum interior diffusivity (m2/s) due shear       **
**                instability.                                      **
** lmd_nuf      Scaling factor for double diffusion in salt         **
**                fingering.                                        **
** lmd_nuwm     Interior viscosity (m2/s) due to wave breaking.     **
** lmd_nuws     Interior diffusivity (m2/s) due to wave breaking.   **
** lmd_sdd1     Double diffusion constant for salinity in diffusive **
**                convection case (lmd_sdd1=0.15).                  **
** lmd_sdd2     Double diffusion constant for salinity in diffusive **
**                convection case (lmd_sdd2=1.85).                  **
** lmd_sdd3     Double diffusion constant for salinity in diffusive **
**                convection case (lmd_sdd3=0.85).                  **
** lmd_tdd1     Double diffusion constant for temperature           **
**                in diffusive convection case (lmd_tdd1=0.909).    **
** lmd_tdd2     Double diffusion constant for temperature in        **
**                diffusive convection case (lmd_tdd2=4.6).         **
** lmd_tdd3     Double diffusion constant for temperature in        **
**                diffusive convection case (lmd_tdd3=0.54).        **
**                                                                  **
**********************************************************************
*/

      common /mixing_slmd/
     &        lmd_Ri0,           lmd_Rrho0,         lmd_bvfcon,
     &        lmd_fdd,           lmd_nu,            lmd_nu0c,
     &        lmd_nu0m,          lmd_nu0s,          lmd_nuf,
     &        lmd_nuwm,          lmd_nuws,          lmd_sdd1,
     &        lmd_sdd2,          lmd_sdd3,          lmd_tdd1,
     &        lmd_tdd2,          lmd_tdd3
      REAL_TYPE
     &        lmd_Ri0,           lmd_Rrho0,         lmd_bvfcon,
     &        lmd_fdd,           lmd_nu,            lmd_nu0c,
     &        lmd_nu0m,          lmd_nu0s,          lmd_nuf,
     &        lmd_nuwm,          lmd_nuws,          lmd_sdd1,
     &        lmd_sdd2,          lmd_sdd3,          lmd_tdd1,
     &        lmd_tdd2,          lmd_tdd3

# ifdef LMD_DDMIX
      common /mixing_alfaobeta/ alfaobeta
      REAL_TYPE alfaobeta(GLOBAL_2D_ARRAY,0:N)
# endif

#endif /* LMD_MIXING */

#if defined LMD_SKPP || defined SOLAR_SOURCE
/*
**********************************************************************
** Water clarity parameters                                         **
**********************************************************************
**                                                                  **
** Jwtype       Water clarity (Jerlov water type classification).   **
** lmd_Jwt      Jerlov water type to assign everywhere.             **
** lmd_mu1      Reciprocal of the absorption coefficient for solar  **
**                wavelength band 1 as a function of the Jerlov     **
**                water type.                                       **
** lmd_mu2      Reciprocal of the absorption coefficient for solar  **
**                wavelength band 2 as a function of the Jerlov     **
**                water type.                                       **
** lmd_r1       Fraction of total radiance for wavelength band 1 as **
**                a function of the Jerlov water type.              **
**                                                                  **
**********************************************************************
*/

      INTEGER_TYPE
     &        lmd_nwt
      parameter (lmd_nwt=5)

      common /mixing_iwtype/
     &        lmd_Jwt
      INTEGER_TYPE
     &        lmd_Jwt

      common /mixing_swtype/
     &        lmd_mu1,           lmd_mu2,           lmd_r1
      REAL_TYPE
     &        lmd_mu1(lmd_nwt),  lmd_mu2(lmd_nwt),  lmd_r1(lmd_nwt)

      common /mixing_Jwtype/ Jwtype
      INTEGER_TYPE Jwtype(GLOBAL_2D_ARRAY)

#endif /* LMD_SKPP || SOLAR_SOURCE */

#if defined LMD_SKPP || defined LMD_BKPP

/*
**********************************************************************
** Large/McWilliams/Doney oceanic boundary layer variables          **
**********************************************************************
**                                                                  **
** ghats        Boundary layer nonlocal transport (T units/m).      **
** hbbl         Depth of bottom oceanic boundary layer (m).         **
** hsbl         Depth of surface oceanic boundary layer (m).        **
** kbbl         Index of grid level above bottom  boundary layer.   **
** ksbl         Index of grid level below surface boundary layer.   **
** lmd_Cg       Proportionality coefficient parameterizing nonlocal **
**                transport.                                        **
** lmd_Cstar    Proportionality coefficient parameterizing nonlocal **
**                transport.                                        **
** lmd_Cv       Ratio of interior Brunt-Vaisala frequency "N" to    **
**                "N" at entrainment depth "he".                    **
** lmd_Ric      Critical bulk Richardson number.                    **
** lmd_am       Coefficient of flux profile for momentum in their   **
**                1/3 power law regimes.                            **
** lmd_as       Coefficient of flux profile for tracers in their    **
**                1/3 power law regimes.                            **
** lmd_betaT    Ratio of entrainment flux to surface buoyancy flux. **
** lmd_cekman   Constant used in the computation of Ekman depth.    **
** lmd_cmonob   Constant used in the computation of Monin-Obukhov   **
**                depth.                                            **
** lmd_cm       Coefficient of flux profile for momentum in their   **
**                1/3 power law regimes.                            **
** lmd_cs       Coefficient of flux profile for tracers in their    **
**                1/3 power law regimes                             **
** lmd_epsilon  Non-dimensional extent of the surface layer.        **
** lmd_nwt      Number of Jerlow water types.                       **
** lmd_zetam    Maximum stability parameter "zeta" value of the 1/3 **
**                power law regime of flux profile for momentum.    **
** lmd_zetas    Maximum stability parameter "zeta" value of the 1/3 **
**                power law regime of flux profile for tracers.     **
**                                                                  **
**********************************************************************
*/

      common /mixing_kpp/
     &        lmd_Cg,            lmd_Cstar,         lmd_Cv,
     &        lmd_Ric,           lmd_am,            lmd_as,
     &        lmd_betaT,         lmd_cekman,        lmd_cmonob,
     &        lmd_cm,            lmd_cs,            lmd_epsilon,
     &        lmd_zetam,         lmd_zetas
      REAL_TYPE
     &        lmd_Cg,            lmd_Cstar,         lmd_Cv,
     &        lmd_Ric,           lmd_am,            lmd_as,
     &        lmd_betaT,         lmd_cekman,        lmd_cmonob,
     &        lmd_cm,            lmd_cs,            lmd_epsilon,
     &        lmd_zetam,         lmd_zetas

# ifdef LMD_BKPP
      common /mixing_hbbl/ hbbl
      REAL_TYPE hbbl(GLOBAL_2D_ARRAY)

      common /mixing_kbbl/ kbbl
      INTEGER_TYPE kbbl(GLOBAL_2D_ARRAY)
# endif

      common /mixing_hsbl/ hsbl
      REAL_TYPE hsbl(GLOBAL_2D_ARRAY)

      common /mixing_ksbl/ ksbl
      INTEGER_TYPE ksbl(GLOBAL_2D_ARRAY)

# ifdef LMD_NONLOCAL
      common /mixing_ghats/ ghats
      REAL_TYPE ghats(GLOBAL_2D_ARRAY,0:N,2)
# endif

#endif /* LMD_SKPP || defined BKPP */
