#include "cppdefs.h"
      subroutine metrics (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine computes various horizontal metric terms.            !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
#include "param.h"
#include "tile.h"
!
      call metrics_tile (Istr,Iend,Jstr,Jend)
      return
      end
!
!*********************************************************************
      subroutine metrics_tile (Istr,Iend,Jstr,Jend)
!*********************************************************************
!
      implicit none
#include "param.h"
#include "grid.h"
#include "iounits.h"
#include "mask.h"
#include "scalars.h"
#include "wclock.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
#if defined VISC_GRID || defined DIFF_GRID
      REAL_TYPE
     &        NSUB, cff
#endif
!
#include "set_bounds.h"
!
#ifdef EW_PERIODIC
# define IU_RANGE Istr,Iend
# define IV_RANGE Istr,Iend
#else
# define IU_RANGE Istr,IendR
# define IV_RANGE IstrR,IendR
#endif
#ifdef NS_PERIODIC
# define JU_RANGE Jstr,Jend
# define JV_RANGE Jstr,Jend
#else
# define JU_RANGE JstrR,JendR
# define JV_RANGE Jstr,JendR
#endif
!
!---------------------------------------------------------------------
!  Compute 1/m, 1/n, 1/mn, and f/mn at horizontal RHO-points.
!---------------------------------------------------------------------
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          om_r(i,j)=1.0_r8/pm(i,j)
          on_r(i,j)=1.0_r8/pn(i,j)
          omn(i,j)=1.0_r8/(pm(i,j)*pn(i,j))
          fomn(i,j)=f(i,j)*omn(i,j)
        enddo
      enddo
#if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,omn)
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,om_r)
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,on_r)
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,fomn)
#endif /* EW_PERIODIC || NS_PERIODIC */
!
!---------------------------------------------------------------------
!  Compute n/m, and m/n at horizontal RHO-points.
!---------------------------------------------------------------------
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          pnom_r(i,j)=pn(i,j)/pm(i,j)
          pmon_r(i,j)=pm(i,j)/pn(i,j)
        enddo
      enddo
#if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,pnom_r)
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,pmon_r)
#endif /* EW_PERIODIC || NS_PERIODIC */
!
!---------------------------------------------------------------------
!  Compute m/n, 1/m, and 1/n at horizontal U-points.
!---------------------------------------------------------------------
!
      do j=JU_RANGE
        do i=IU_RANGE
          pmon_u(i,j)=(pm(i-1,j)+pm(i,j))/(pn(i-1,j)+pn(i,j))
          pnom_u(i,j)=(pn(i-1,j)+pn(i,j))/(pm(i-1,j)+pm(i,j))
          om_u(i,j)=2.0_r8/(pm(i-1,j)+pm(i,j))
          on_u(i,j)=2.0_r8/(pn(i-1,j)+pn(i,j))
        enddo
      enddo
#if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_u2d_tile (Istr,Iend,Jstr,Jend,pmon_u)
      call exchange_u2d_tile (Istr,Iend,Jstr,Jend,pnom_u)
      call exchange_u2d_tile (Istr,Iend,Jstr,Jend,  om_u)
      call exchange_u2d_tile (Istr,Iend,Jstr,Jend,  on_u)
#endif /* EW_PERIODIC || NS_PERIODIC */
!
!---------------------------------------------------------------------
!  Compute n/m, 1/m, and 1/m at horizontal V-points.
!---------------------------------------------------------------------
!
      do j=JV_RANGE
        do i=IV_RANGE
          pmon_v(i,j)=(pm(i,j-1)+pm(i,j))/(pn(i,j-1)+pn(i,j))
          pnom_v(i,j)=(pn(i,j-1)+pn(i,j))/(pm(i,j-1)+pm(i,j))
          om_v(i,j)=2.0_r8/(pm(i,j-1)+pm(i,j))
          on_v(i,j)=2.0_r8/(pn(i,j-1)+pn(i,j))
        enddo
      enddo
#if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_v2d_tile (Istr,Iend,Jstr,Jend,pmon_v)
      call exchange_v2d_tile (Istr,Iend,Jstr,Jend,pnom_v)
      call exchange_v2d_tile (Istr,Iend,Jstr,Jend,  om_v)
      call exchange_v2d_tile (Istr,Iend,Jstr,Jend,  on_v)
#endif /* EW_PERIODIC || NS_PERIODIC */
!
!---------------------------------------------------------------------
!  Compute n/m and m/n at horizontal PSI-points.
!---------------------------------------------------------------------
!
      do j=JV_RANGE
        do i=IU_RANGE
          pnom_p(i,j)=(pn(i-1,j-1)+pn(i-1,j)+pn(i,j-1)+pn(i,j))/
     &                (pm(i-1,j-1)+pm(i-1,j)+pm(i,j-1)+pm(i,j))
          pmon_p(i,j)=(pm(i-1,j-1)+pm(i-1,j)+pm(i,j-1)+pm(i,j))/
     &                (pn(i-1,j-1)+pn(i-1,j)+pn(i,j-1)+pn(i,j))
          om_p(i,j)=4.0_r8/(pm(i-1,j-1)+pm(i-1,j)+pm(i,j-1)+pm(i,j))
          on_p(i,j)=4.0_r8/(pn(i-1,j-1)+pn(i-1,j)+pn(i,j-1)+pn(i,j))
        enddo
      enddo
#if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_p2d_tile (Istr,Iend,Jstr,Jend,pnom_p)
      call exchange_p2d_tile (Istr,Iend,Jstr,Jend,pmon_p)
      call exchange_p2d_tile (Istr,Iend,Jstr,Jend,  om_p)
      call exchange_p2d_tile (Istr,Iend,Jstr,Jend,  on_p)
#endif /* EW_PERIODIC || NS_PERIODIC */
#if defined CURVGRID && defined UV_ADV
# if defined EW_PERIODIC || defined NS_PERIODIC
!
!----------------------------------------------------------------------
!  Apply periodic boundary conditions to curviliniar metrics.
!----------------------------------------------------------------------
!
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,dndx)
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,dmde)
# endif /* EW_PERIODIC || NS_PERIODIC */
#endif /* CURVGRID && UV_ADV */
#ifdef MASKING
# if defined EW_PERIODIC || defined NS_PERIODIC
!
!----------------------------------------------------------------------
!  Apply periodic boundary conditions to Land/Sea masking arrays.
!----------------------------------------------------------------------
!
      call exchange_p2d_tile (Istr,Iend,Jstr,Jend,pmask)
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,rmask)
      call exchange_u2d_tile (Istr,Iend,Jstr,Jend,umask)
      call exchange_v2d_tile (Istr,Iend,Jstr,Jend,vmask)
# endif /* EW_PERIODIC || NS_PERIODIC */
#endif /* MASKING */
#if defined VISC_GRID || defined DIFF_GRID
!
!---------------------------------------------------------------------
! Determine maximum size of the grid box over the whole curvilinear
! grid of the model. Used for scaling horizontal mixing by the grid
! size.
!---------------------------------------------------------------------
!
      cff=0.0_r8
      do j=JstrR,JendR
        do i=IstrR,IendR
          grdscl(i,j)=SQRT(om_r(i,j)*om_r(i,j)+on_r(i,j)*on_r(i,j))
          cff=MAX(cff,grdscl(i,j))
        enddo
      enddo
!
! Determine global maximum.
!
      if (WESTERN_EDGE .and. EASTERN_EDGE .and.
     &    SOUTHERN_EDGE .and. NORTHERN_EDGE) then
        NSUB=0.5_r8
      else
        NSUB=FLOAT(NSUB_X*NSUB_E)-0.5_r8
      endif
      call my_setlock (lock)
      if (dia_count.lt.0.5_r8) then
        grdmax=cff
      else
        grdmax=MAX(grdmax,cff)
      endif
      dia_count=dia_count+1.0_r8
      if (dia_count.gt.NSUB) then
        dia_count=0.0_r8
        write(stdout,10) grdmax/1000.0_r8
 10     format(/,' Horizontal mixing scaled by grid size,',
     &           ' GRDMAX = ',1pe15.8,' km',/)
      endif
      call my_unsetlock (lock)
#endif
      return
      end

