#include "cppdefs.h"
      subroutine main2d
#ifndef SOLVE3D
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine is the main driver for ROMS when configurated as     !
!  shallow water (barotropic) ocean model only.  It advances the     !
!  vertically  integrated  primitive equations for a single time     !
!  step.                                                             !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "floats.h"
# include "iounits.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        next_indx1, subs, tile, thread
# ifdef FLOATS
      INTEGER_TYPE
     &        Lend, Lstr, chunk_size
# endif
!
!=====================================================================
!  Time-step vertically integrated equations.
!=====================================================================
!
!  Set time clock.
!
      time=time+dt
      tdays=time*sec2day
!
!---------------------------------------------------------------------
!  Read forcing, climatology and assimilation data from input NetCDF
!  files, if any.
!---------------------------------------------------------------------
!
      call get_data
      if (exit_flag.ne.0) return
!
!---------------------------------------------------------------------
!  Process forcing, climatology and assimilation input data: time
!  interpolate between snapshots. If appropriate, compute and report
!  diagnostics.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
      do thread=0,numthreads-1
        subs=NSUB_X*NSUB_E/numthreads
        do tile=subs*thread,subs*(thread+1)-1,+1
          call set_data (tile)
# ifdef AVERAGES
          call set_avg (tile)
# endif
          call diag (tile)
        enddo
      enddo
!$OMP END PARALLEL DO
      if (exit_flag.ne.0) return!
# if defined SSH_TIDES || defined UV_TIDES
!
!---------------------------------------------------------------------
!  Process tidal forcing.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
      do thread=0,numthreads-1
        subs=NSUB_X*NSUB_E/numthreads
        do tile=subs*thread,subs*(thread+1)-1,+1
          call clm_tides (tile)
        enddo
      enddo
!$OMP END PARALLEL DO
# endif

!---------------------------------------------------------------------
!  If appropriate, write out fields into output NetCDF files.  Notice
!  that IO data is written in delayed and serial mode.  If last time
!  step, stop all clocks.
!---------------------------------------------------------------------
!
      call output
      if (exit_flag.ne.0) return
      if (iic.eq.(ntend+1)) then
        write(stdout,10) ' Elapsed CPU time (seconds):'
 10     format(/,a,/)
!$OMP PARALLEL DO PRIVATE(thread) SHARED(numthreads)
        do thread=0,numthreads-1
          call wclock_off (0)
        enddo
!$OMP END PARALLEL DO
        return
      endif
!
!---------------------------------------------------------------------
!  Solve the vertically integrated primitive equations for the
!  free-surface and momentum components.
!---------------------------------------------------------------------
!
!  Set time indices for predictor step. The PREDICTOR_2D_STEP switch
!  it is assumed to be false before the first time-step.
!
      iif=1
      nfast=1
      next_indx1=3-indx1
      if (.not.PREDICTOR_2D_STEP) then
        PREDICTOR_2D_STEP=.TRUE.
        if (FIRST_2D_STEP) then
          kstp=indx1
        else
          kstp=3-indx1
        endif
        knew=3
        krhs=indx1
      endif
!
!  Predictor step - Advance barotropic equations using 2D time-step
!  ==============   predictor scheme.
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
      do thread=0,numthreads-1
        subs=NSUB_X*NSUB_E/numthreads
        do tile=subs*(thread+1)-1,subs*thread,-1
          call step2d (tile)
        enddo
      enddo
!$OMP END PARALLEL DO
!
!  Set time indices for corrector step.
!
      if (PREDICTOR_2D_STEP) then
        PREDICTOR_2D_STEP=.FALSE.
        knew=next_indx1
        kstp=3-knew
        krhs=3
        if (iif.lt.(nfast+1)) indx1=next_indx1
      endif
!
!  Corrector step - Apply 2D time-step corrector scheme.  Notice that
!  ==============   there is not need for a corrector step during the
!  auxiliary (nfast+1) time-step.
!
      if (iif.lt.(nfast+1)) then
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
        do thread=0,numthreads-1
          subs=NSUB_X*NSUB_E/numthreads
          do tile=subs*thread,subs*(thread+1)-1,+1
            call step2d (tile)
          enddo
        enddo
!$OMP END PARALLEL DO
      endif
# ifdef ASSIMILATION
!
!---------------------------------------------------------------------
!  Assimilation of observations via optimal interpolation.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
      do thread=0,numthreads-1
        subs=NSUB_X*NSUB_E/numthreads
        do tile=subs*thread,subs*(thread+1)-1,+1
          call oi_update (tile)
        enddo
      enddo
!$OMP END PARALLEL DO
# endif /* ASSIMILATION */
# ifdef FLOATS
!
!---------------------------------------------------------------------
!  Compute Lagrangian drifters trajectories.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,chunk_size,Lstr,Lend)
!$OMP&            SHARED(numthreads,nfloats)
      do thread=0,numthreads-1
        chunk_size=(nfloats+numthreads-1)/numthreads
        Lstr=1+thread*chunk_size
        Lend=MIN(nfloats,Lstr+chunk_size-1)
        call step_floats (Lstr,Lend)
      enddo
!$OMP END PARALLEL DO
!
!  Shift floats time indices.
!
      nfp1=MOD(nfp1+1,NFT+1)
      nf  =MOD(nf  +1,NFT+1)
      nfm1=MOD(nfm1+1,NFT+1)
      nfm2=MOD(nfm2+1,NFT+1)
      nfm3=MOD(nfm3+1,NFT+1)
# endif /* FLOATS */
#endif
      return
      end
