#include "cppdefs.h"
#if defined LMD_SKPP || defined LMD_BKPP
      subroutine lmd_wscale (Bfsfc,Ustar,sigma,wm,ws)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine computes the turbulent velocity scale for momentum   !
!  and tracer as a function of turbulent friction velocity "Ustar"   !
!  and stability parameter "zetahat".                                !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     Bfsfc    surface buoyancy forcing (m2/s2).                     !
!     Ustar    Tubulent friction velocity (m/s).                     !
!     sigma    boundary layer depth (m).                             !
!                                                                    !
!  On Output:                                                        !
!                                                                    !
!     wm       turbulent velocity scale (m/s) at sigma for momentum. !
!     ws       turbulent velocity scale (m/s) at sigma for tracer.   !
!                                                                    !
!  This routine was adapted from Bill Large 1995 code.               !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "mixing.h"
# include "scalars.h"
!
      REAL_TYPE
     &        Bfsfc, Ustar, sigma, wm, ws
      REAL_TYPE
     &        Ustar3, eps, r3, zetahat, zetapar
      parameter (eps=1.0_e8-20, r3=1.0_r8/3.0_r8)
!
!---------------------------------------------------------------------
!  Compute turbulent velocity scale for momentum and tracers.
!---------------------------------------------------------------------
!
      Ustar3=Ustar*Ustar*Ustar
      zetahat=vonKar*sigma*Bfsfc
      zetapar=zetahat/(Ustar3+eps)
!
!  Stable regime.
!
      if (zetahat.ge.0.0_r8) then
        wm=vonKar*Ustar/(1.0_r8+5.0_r8*zetapar)
        ws=wm
!
!  Unstable regime.
!
      else
        if (zetapar.gt.lmd_zetam) then
          wm=vonKar*Ustar*(1.0_r8-16.0_r8*zetapar)**0.25_r8
        else
          wm=vonKar*(lmd_am*Ustar3-lmd_cm*zetahat)**r3
        endif
        if (zetapar.gt.lmd_zetas) then
          ws=vonKar*Ustar*(1.0_r8-16.0_r8*zetapar)**0.5_r8
        else
          ws=vonKar*(lmd_as*Ustar3-lmd_cs*zetahat)**r3
        endif
      endif
#else
      subroutine lmd_wscale
#endif /* LMD_SKPP || LMD_BKPP */
      return
      end
