#include "cppdefs.h"
#if defined LMD_SKPP || defined SOLAR_SOURCE
      subroutine lmd_swfrac_tile (Istr,Iend,Jstr,Jend,Zscale,Z,swdk)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine computes the  fraction  of  solar shortwave flux  !
!  penetrating to specified depth (times Zscale) due to exponential  !
!  decay in Jerlov water type.                                       !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     Zscale   scale factor to apply to depth array.                 !
!     Z        vertical height (meters, negative) for                !
!              desired solar short-wave fraction.                    !
!                                                                    !
!  On Output:                                                        !
!                                                                    !
!     swdk     shortwave (radiation) fractional decay.               !
!                                                                    !
!  Reference:                                                        !
!                                                                    !
!  Paulson, C.A., and J.J. Simpson, 1977: Irradiance meassurements   !
!     in the upper ocean, J. Phys. Oceanogr., 7, 952-956.            !
!                                                                    !
!  This routine was adapted from Bill Large 1995 code.               !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "mixing.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, index, j
!
      REAL_TYPE
     &        Zscale
      REAL_TYPE
     &           Z(PRIVATE_2D_SCRATCH_ARRAY),
     &        swdk(PRIVATE_2D_SCRATCH_ARRAY)
!
!---------------------------------------------------------------------
!  Use Paulson and Simpson (1977) two wavelength bands solar
!  absorption model.
!---------------------------------------------------------------------
!
      do j=Jstr,Jend
        do i=Istr,Iend
          index=Jwtype(i,j)
          swdk(i,j)=lmd_r1(index)*
     &              EXP(Z(i,j)*Zscale/lmd_mu1(index))+
     &              (1.0_r8-lmd_r1(index))*
     &              EXP(Z(i,j)*Zscale/lmd_mu2(index))
        enddo
      enddo
#else
      subroutine lmd_swfrac
#endif /* LMD_SKPP | SOLAR_SOURCE */
      return
      end
