/*
** Include file "iounits.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Nlev        Number of levels to write out in history file.       **
** Lev         Levels to write out in history file.                 **
** ESname      Input error subspace file name.                      **
** Rerror      Running error messages.                              **
** SSHname     Input SSH observations file name.                    **
** SSTname     Input SST observations file name.                    **
** TOBSname    Input tracer observations file name.                 **
** VSURname    Input surface currents observations file name.       **
** VOBSname    Input horizontal currents observations file name.    **
** aparnam     Input assimilation parameters file name.             **
** avgbase     Output averages base file name.                      **
** avgname     Output averages file name.                           **
** bparnam     Input biology parameters file name.                  **
** bryname     Input boundary data file name.                       **
** clmname     Input climatology file name.                         **
** fltname     Output floats file name.                             **
** fposnam     Input initial floats positions file name.            **
** frcname     Input forcing fields file name.                      **
** fwdname     Input forward solution file name.                    **
** grdname     Input grid file name.                                **
** hisbase     Output history base file name.                       **
** hisname     Output history file name.                            **
** ininame     Input initial conditions file name.                  **
** ispos       I-index for station positions.                       **
** jspos       J-index for station positions.                       **
** nstation    Number of output stations.                           **
** rstname     Output restart file name.                            **
** sparnam     Input sediment transport parameters file name.       **
** sposnam     Input station positions file name.                   **
** staname     Output station data file name.                       **
** stdinp      Unit number for standard input (often 5).            **
** stdout      Unit number for standard output (often 6).           **
** usrout      Unit number for generic USER output.                 **
** usrname     USERs input/output generic file name.                **
**                                                                  **
**********************************************************************
*/

      common /iiounits/
     &        Nlev,              Lev,               ispos,
     &        jspos,             nstation,          stdinp,
     &        stdout,            usrout
      INTEGER_TYPE
     &        Nlev,              nstation,          stdinp,
     &        stdout,            usrout
      INTEGER_TYPE
     &        Lev(Np),           ispos(NS),         jspos(NS)

      common /eiounits/
     &        Rerror
      character*45
     &        Rerror(6)

      common /ciounits/
     &        ESname,            SSHname,           SSTname,
     &        TOBSname,          VSURname,          VOBSname,
     &        aparnam,           avgbase,           avgname,
     &        bparnam,           bryname,           clmname,
     &        fltname,           fposnam,           frcname,
     &        fwdname,           grdname,           hisbase,
     &        hisname,           ininame,           rstname,
     &        sparnam,           sposnam,           staname,
     &        usrname
      character*80
     &        ESname,            SSHname,           SSTname,
     &        TOBSname,          VSURname,          VOBSname,
     &        aparnam,           avgbase,           avgname,
     &        bparnam,           bryname,           clmname,
     &        fltname,           fposnam,           frcname,
     &        fwdname,           grdname,           hisbase,
     &        hisname,           ininame,           rstname,
     &        sparnam,           sposnam,           staname,
     &        usrname
