#include "cppdefs.h"
      subroutine initial
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine initializes all model variables.                     !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "bbl.h"
#include "iounits.h"
#include "ncparam.h"
#include "ocean.h"
#include "scalars.h"
!
      logical update
      INTEGER_TYPE
     &        subs, tile, thread
      INTEGER_TYPE
     &        my_numthreads
!
!---------------------------------------------------------------------
!  Inquire number of threads in parallel region.
!---------------------------------------------------------------------
!
!$OMP PARALLEL SHARED(numthreads)
      numthreads=my_numthreads()
!$OMP END PARALLEL
      write(stdout,10) numthreads, NSUB_X, NSUB_E
 10   format(/,' Number of Parallel Threads: ',i3,
     &       5x,'Domain Partition: ',i2,' x ',i2,/)
      if (MOD(NSUB_X*NSUB_E,numthreads).ne.0) then
        write(stdout,20)
 20     format(/,' ROMS: Wrong choice of domain partion or number ',
     &         'of parallel threads.',/,7x,
     &         'NSUB_X * NSUB_E must be a multiple of the number ',
     &         'parallel threads.',/,7x,
     &         'Change number of threads (environment variable) or',/,
     &         7x,'change domain partition in param.h and recompile.')
        exit_flag=6
        return
      endif
#ifdef PERTURBATION
      write(stdout,30) Nrun
 30   format(/,' <<<< Ensemble/Perturbation Run: ',i5.5,' >>>>',/)
#endif
      write(stdout,40)' INITIAL: Configurating and initializing ...'
 40   format(/,a,/)
!
!--------------------------------------------------------------------
!  Initialize time stepping indices and counters.
!---------------------------------------------------------------------
!
      iif=1
      indx1=1
      kstp=1
      krhs=1
      knew=1
      PREDICTOR_2D_STEP=.false.
!
      iic=0
      ntend=ntimes
      nstp=1
      nrhs=1
      nnew=1
#ifdef FLOATS
      nf=0
      nfp1=1
      nfm1=4
      nfm2=3
      nfm3=2
#endif
      tdays=dstart
      time=tdays*day2sec
      update=.false.
!
!---------------------------------------------------------------------
!  Start time wall clocks.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread) SHARED(numthreads)
      do thread=0,numthreads-1
        call wclock_on (0)
#ifdef PROFILE
        call wclock_on (1)
#endif
      enddo
!$OMP END PARALLEL DO
!
!---------------------------------------------------------------------
!  Initialize (zero out) all shared arrays.  Allocate according with
!  the first touch policy.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
      do thread=0,numthreads-1
        subs=NSUB_X*NSUB_E/numthreads
        do tile=subs*thread,subs*(thread+1)-1
          call init_arrays (tile)
        enddo
      enddo
!$OMP END PARALLEL DO
!
!=====================================================================
!  On first pass of ensemble run loop, initialize model configuration.
!=====================================================================
!
      if (Nrun.eq.1) then
!
!---------------------------------------------------------------------
!  Set horizontal grid, bathymetry, and Land/Sea masking (if any).
!  Use analytical functions or read in from a grid NetCDF.
!---------------------------------------------------------------------
!
#ifdef ANA_GRID
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
        do thread=0,numthreads-1
          subs=NSUB_X*NSUB_E/numthreads
          do tile=subs*thread,subs*(thread+1)-1
            call ana_grid (tile)
          enddo
        enddo
!$OMP END PARALLEL DO
#else
        call get_grid
        if (exit_flag.ne.0) return
#endif
#ifdef MASKING
# ifdef ANA_MASK
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
        do thread=0,numthreads-1
          subs=NSUB_X*NSUB_E/numthreads
          do tile=subs*thread,subs*(thread+1)-1
            call ana_mask (tile)
          enddo
        enddo
!$OMP END PARALLEL DO
# else
        call get_mask
        if (exit_flag.ne.0) return
# endif
#endif
#ifdef SOLVE3D
!
!---------------------------------------------------------------------
!  Set vertical S-coordinate transformation function.
!---------------------------------------------------------------------
!
        call set_scoord
#endif
!
!---------------------------------------------------------------------
!  Set barotropic time-steps average weighting function.
!---------------------------------------------------------------------
!
        call set_weights
!
!---------------------------------------------------------------------
!  Compute various metric term combinations.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
        do thread=0,numthreads-1
          subs=NSUB_X*NSUB_E/numthreads
          do tile=subs*thread,subs*(thread+1)-1
            call metrics (tile)
          enddo
        enddo
!$OMP END PARALLEL DO
!
#if defined VISC_GRID || defined DIFF_GRID || defined SPONGE
!---------------------------------------------------------------------
!  Set horizontal mixing coefficients. Rescale according to the local
!  grid size. If applicable, increases horizontal mixing in sponge
!  areas.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
        do thread=0,numthreads-1
          subs=NSUB_X*NSUB_E/numthreads
          do tile=subs*thread,subs*(thread+1)-1
            call horz_mix (tile)
          enddo
        enddo
!$OMP END PARALLEL DO
#endif
#ifdef NUDGING_COFF
!
!---------------------------------------------------------------------
!  If appropriate, set nudging coefficiests time scales.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
        do thread=0,numthreads-1
          subs=NSUB_X*NSUB_E/numthreads
          do tile=subs*thread,subs*(thread+1)-1
            call set_nudgcof (tile)
          enddo
        enddo
!$OMP END PARALLEL DO
#endif
      endif
!
!=====================================================================
!  Initialize model state variables and forcing.  This part is
!  executed for each ensemble run.
!=====================================================================
!
#if defined SOLVE3D && defined ANA_INITIAL
!---------------------------------------------------------------------
!  Compute initial time-evolving depths with zero free-surface.  The
!  grid depths are sometimes needed during analytical initialization.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
      do thread=0,numthreads-1
        subs=NSUB_X*NSUB_E/numthreads
        do tile=subs*thread,subs*(thread+1)-1
          call set_depth (tile)
        enddo       
      enddo
!$OMP END PARALLEL DO
#endif /* SOLVE3D && ANA_INITIAL */
!
!---------------------------------------------------------------------
!  Set primitive variables initial conditions.  Use analytical
!  functions or read from an initial or restart NetCDF file.
!---------------------------------------------------------------------
!
#ifdef ANA_INITIAL
      if (nrrec.eq.0) then
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
        do thread=0,numthreads-1
          subs=NSUB_X*NSUB_E/numthreads
          do tile=subs*thread,subs*(thread+1)-1
            call ana_initial (tile)
          enddo
        enddo
!$OMP END PARALLEL DO
      else
        call get_initial
      endif
#else
      call get_initial
#endif
#if defined BIOLOGY && defined ANA_BIOLOGY && defined SOLVE3D
!
!  Analytical initial conditions for biology.
!
      if (nrrec.eq.0) then
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
        do thread=0,numthreads-1
          subs=NSUB_X*NSUB_E/numthreads
          do tile=subs*thread,subs*(thread+1)-1
            call ana_biology (tile)
          enddo
        enddo
!$OMP END PARALLEL DO
      endif
#endif
#if defined SEDIMENT && defined ANA_SEDIMENT && defined SOLVE3D
!
!  Analytical initial conditions for sediment.
!
      if (nrrec.eq.0) then
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
        do thread=0,numthreads-1
          subs=NSUB_X*NSUB_E/numthreads
          do tile=subs*thread,subs*(thread+1)-1
            call ana_sediment (tile)
          enddo
        enddo
!$OMP END PARALLEL DO
      endif
#endif
      if (exit_flag.ne.0) return
!
#ifdef PERTURBATION
!---------------------------------------------------------------------
!  Perturb initial conditions with a ramdon linear combination of
!  error subspaces.
!---------------------------------------------------------------------
!
# ifdef RANDOM_ESPERT
      call res_pert
# endif
#endif
#ifdef SOLVE3D
!---------------------------------------------------------------------
!  Compute initial time-evolving depths.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
      do thread=0,numthreads-1
        subs=NSUB_X*NSUB_E/numthreads
        do tile=subs*thread,subs*(thread+1)-1
          call set_depth (tile)
        enddo
      enddo
!$OMP END PARALLEL DO
!
!---------------------------------------------------------------------
!  Compute initial horizontal mass fluxes, Hz*u/n and Hz*v/m.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
      do thread=0,numthreads-1
        subs=NSUB_X*NSUB_E/numthreads
        do tile=subs*thread,subs*(thread+1)-1
          call set_massflux (tile)
        enddo
      enddo
!$OMP END PARALLEL DO
!
!---------------------------------------------------------------------
!  Compute initial S-coordinates vertical velocity.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
      do thread=0,numthreads-1
        subs=NSUB_X*NSUB_E/numthreads
        do tile=subs*thread,subs*(thread+1)-1
          call omega (tile)
        enddo
      enddo
!$OMP END PARALLEL DO
#endif /* SOLVED3D */
!
!---------------------------------------------------------------------
!  Read in initial forcing, climatology and assimilation data from
!  input NetCDF files.  It loads the first relevant data record for
!  the time-interpolation between snapshots.
!---------------------------------------------------------------------
!
      call get_data
      if (exit_flag.ne.0) return
!
#ifdef BBL
!---------------------------------------------------------------------
!  Set initial bottom sediment size and density.  Use analytical
!  functions or read in from forcing NetCDF file.
!---------------------------------------------------------------------
!
# ifdef ANA_BSEDIM
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
      do thread=0,numthreads-1
        subs=NSUB_X*NSUB_E/numthreads
        do tile=subs*thread,subs*(thread+1)-1
          call ana_bsedim (tile)
        enddo
      enddo
!$OMP END PARALLEL DO
# else
      call get_2dfld (Ssize(START_2D_ARRAY),1,1,
     &                idSsiz,ncfrcid,frcname,update)
      call get_2dfld (Sdens(START_2D_ARRAY),1,1,
     &                idSden,ncfrcid,frcname,update)
      if (exit_flag.ne.0) return
# endif
#endif
#ifdef SOLVE3D
!---------------------------------------------------------------------
!  Compute initial density anomaly from potential temperature and
!  salinity via equation of state for seawater.  Also compute other
!  equation of state related quatities.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
      do thread=0,numthreads-1
        subs=NSUB_X*NSUB_E/numthreads
        do tile=subs*thread,subs*(thread+1)-1
          call rho_eos (tile)
        enddo
      enddo
!$OMP END PARALLEL DO
!
!---------------------------------------------------------------------
!  Compute grid stiffness.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread,subs,tile) SHARED(numthreads)
      do thread=0,numthreads-1
        subs=NSUB_X*NSUB_E/numthreads
        do tile=subs*thread,subs*(thread+1)-1
          call stiffness (tile)
        enddo
      enddo
!$OMP END PARALLEL DO
#endif /* SOLVE3D */
#ifdef FLOATS
!
!---------------------------------------------------------------------
!  Initialize float tracjetories computation.
!---------------------------------------------------------------------
!
      call init_floats
#endif /* FLOATS */
#ifdef PROFILE
!
!---------------------------------------------------------------------
!  Turn off initiialization time wall clock.
!---------------------------------------------------------------------
!
!$OMP PARALLEL DO PRIVATE(thread) SHARED(numthreads)
      do thread=0,numthreads-1
        call wclock_off (1)
      enddo
!$OMP END PARALLEL DO
#endif
      return
      end
