#include "cppdefs.h"
       subroutine init_scalars
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine initializes some variables and stored in common   !
!  blocks.                                                           !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "bbl.h"
#include "biology.h"
#include "boundary.h"
#include "ecosim.h"
#include "floats.h"
#include "grid.h"
#include "iounits.h"
#include "mixing.h"
#include "ncparam.h"
#include "obs.h"
#include "scalars.h"
#include "sediment.h"
#include "sources.h"
#include "wclock.h"
!
      INTEGER_TYPE
     &        i, ic, ifield, ilast, j
!
!---------------------------------------------------------------------
!  Set tracer identification indices.
!---------------------------------------------------------------------
!
      ic=NAT
#ifdef SEDIMENT
!
!  Cohesive and noncohesive suspended sediment tracers indices.
!
      do i=1,NCS
        ic=ic+1
        idmud(i)=ic
        idsed(i)=idmud(i)
      enddo
      do i=1,NNS
        ic=ic+1
        isand(i)=ic
        idsed(NCS+i)=isand(i)
      enddo
#endif
#if defined BIO_FASHAM
!  
!  Set Fasham Nitrogen-based biological tracer indices.
!
      iNO3_=ic+1
      iPhyt=ic+2
      iZoop=ic+3
      iNH4_=ic+4
      iLDet=ic+5
      iSDet=ic+6
      iChlo=ic+7
      ic=ic+7
#elif defined ECOSIM
!
!  Set full phytoplankton/pigment matrix (see "ecosim.h" for details).
!
      do i=1,7
        do j=1,7
          PIG(i,j)=0
        enddo
        PIG(i,1)=1
        PIG(i,5)=1
      enddo
      do i=6,7
        PIG(i,2)=1
      endo
      do j=3,4
        do i=1,3
          PIG(i,j)=1
        enddo
        PIG(4,j)=1
      enddo
      PIG(5,7)=1
!
!  Set bio-optical tracer indices.
!
      iDIC_=ic+1
      iFeO_=ic+2
      iNH4_=ic+3
      iNO3_=ic+4
      iPO4_=ic+5
      iSiO_=ic+6
      ic=ic+6
      do i=1,Nbac
        iBacC(i)=ic+1
        iBacF(i)=ic+2
        iBacN(i)=ic+3
        iBacP(i)=ic+4
        ic=ic+4
      enddo
      do i=1,Ndom
        iCDMC(i)=ic+1
        iDOMC(i)=ic+2
        iDOMN(i)=ic+3
        iDOMP(i)=ic+4
        ic=ic+4
      enddo
      do i=1,Nfec
        iFecC(i)=ic+1
        iFecF(i)=ic+2
        iFecN(i)=ic+3
        iFecP(i)=ic+4
        iFecS(i)=ic+5
        ic=ic+5
      enddo
      do i=1,Nphy
        iPhyC(i)=ic+1
        iPhyF(i)=ic+2
        iPhyN(i)=ic+3
        iPhyP(i)=ic+4
        iPhyS(i)=ic+5
        ic=ic+5
      enddo
      do j=1,Npig
        do i=1,Nphy
          iPigs(i,j)=0
          if (PIG(PHY(i),j).eq.1) then
            ic=ic+1
            iPigs(i,j)=ic
          endif
        enddo
      enddo
#endif
!
!---------------------------------------------------------------------
!  Set various parameters.
!---------------------------------------------------------------------
!
!  Initialize ensemble run starting and ending values.
!
      Nrun=1
      ERstr=1
      ERend=1
!
!  Set evolving time indices to their default initial values.
!
      iif=1
      indx1=1
      kstp=1
      krhs=1
      knew=1
      PREDICTOR_2D_STEP=.false.
!
      ntstart=1
      ntfirst=ntstart
      iic=0
      nstp=1
      nrhs=1
      nnew=1
#ifdef FLOATS
      nf=0
      nfp1=1
      nfm1=4
      nfm2=3
      nfm3=2
#endif
!
!  Set intra-thread communication flags and counters.
!
      synchro_flag=.true.
      first_time=0
      exit_flag=0
!
!  Initialize process ID and time wall clocks.
!
      do i=0,1
        proc(i)=0
      enddo
      do j=0,35
        Cstr(j)=0.0_r8
        Cend(j)=0.0_r8
        Csum(j)=0.0_r8
      enddo
      trd_count=0
#ifdef PROFILE
!
!  Set regions identifiers used for time profiling.
!
      Pregion( 1)='Initialization ...................................'
      Pregion( 2)='OI data assimilation .............................'
      Pregion( 3)='Reading of input data ............................'
      Pregion( 4)='Processing of input data .........................'
      Pregion( 5)='Processing of output time averaged data ..........'
      Pregion( 6)='Computation of vertical boundary conditions ......'
      Pregion( 7)='Computation of diagnostics .......................'
      Pregion( 8)='Writing of output data ...........................'
      Pregion( 9)='Model 2D kernel ..................................'
      Pregion(10)='Lagrangian floats trajectories ...................'
      Pregion(11)='Tidal forcing ....................................'
      Pregion(12)='Vertical metrics .................................'
      Pregion(13)='Omega vertical velocity ..........................'
      Pregion(14)='Equation of state for seawater ...................'
      Pregion(15)='Biological module, source/sink terms .............'
      Pregion(16)='Sediment tranport module, source/sink terms ......'
      Pregion(17)='Atmospheric boundary layer coupler ...............'
      Pregion(18)='KPP vertical mixing parameterization .............'
      Pregion(19)='GLS vertical mixing parameterization .............'
      Pregion(20)='My2.5 vertical mixing parameterization ...........'
      Pregion(21)='3D equations right-side terms ....................'
      Pregion(22)='3D equations predictor step ......................'
      Pregion(23)='Pressure gradient ................................'
      Pregion(24)='Harmonic mixing of tracers, S-surfaces ...........'
      Pregion(25)='Harmonic mixing of tracers, geopotentials ........'
      Pregion(26)='Harmonic mixing of tracers, isopycnals ...........'
      Pregion(27)='Biharmonic mixing of tracers, S-surfaces .........'
      Pregion(28)='Biharmonic mixing of tracers, geopotentials ......'
      Pregion(29)='Biharmonic mixing of tracers, isopycnals .........'
      Pregion(30)='Harmonic sress tensor, S-surfaces ................'
      Pregion(31)='Harmonic stress tensor, geopotentials ............'
      Pregion(32)='Biharmonic stress tensor, S-surfaces .............'
      Pregion(33)='Biharmonic stress tensor, geopotentials ..........'
      Pregion(34)='Corrector time-step for 3D momentum ..............'
      Pregion(35)='Corrector Time-step for tracers ..................'
#endif
!
!  Initialize switches to activate creation of NetCDF files and reset
!  record counters for output NetCDF files.
!
      LdefAVG=.true.
      LdefFLT=.true.
      LdefHIS=.true.
      LdefRST=.true.
      LdefSTA=.true.
      nrecavg=0
      nrechis=0
      nrecrst=0
      nrecavg=0
      nrecsta=0
      icavg=0
      idefhis=0
      idefavg=0
!
!  Initialize assimilation state variable indices.
!
      isFsur=1
      isUbar=2
      isVbar=3
      isUvel=4
      isVvel=5
      do i=1,NT
        isTvar(i)=5+i
      enddo
!
!  Reset global sums and counters needed by volume/energy
!  diagnostics and volume conservation constraint.
!
      dia_count=0.0_r8
      avgke=0.0_r8
      avgpe=0.0_r8
      avgkp=0.0_r8
      volume=0.0_r8
      grdmax=0.0_r8
#ifdef OBC_VOLCONS
      bc_count=0.0_r8
      bc_flux=0.0_r8
      bc_area=0.0_r8
      ubar_xs=0.0_r8
#endif
!
!  Set various constants.
!
      pi=4.0_r8*ATAN(1.0_r8)
      rad2deg=180.0_r8/pi
      deg2rad=pi/180.0_r8
      day2sec=86400.0_r8
      sec2day=1.0_r8/86400.0_r8
      Eradius=6371315.0_r8
      jul_off=2440000.0_r8
      spval=1.0_e8+35
!
!  Set acceleration of gravity (m/s2).
!
# ifdef SOLITON
      g=1.0_r8
# else
      g=9.81_r8
# endif
!
!  Set background mean density (kg/m3).  Notice that value will be
!  overwriten in routine "inp_par" when is read from standard input.
!
      rho0=1025.0_r8
!
!  Set Crack-Nicolson scheme new time step weight coefficient
!  (usually 0.5).
!
#ifdef SPLINES
      lambda=1.0_r8    !backward implicit
#else
!!    lambda=0.5_r8
      lambda=1.0_r8    !backward implicit
#endif
!
!  Set specific heat (Joules/kg/degC) for seawater.
!  It is approximately 4000, and varies only slightly (see Gill,
!  1982, Appendix 3).
!
      Cp=3985.0_r8
!
!  Solar constant used to compute the analytical shortwave radiation.
!  It ranges from 1360 to 1380 W/m2 (Kyle, et al. 1985).  Some of
!  this radiation is attenuated by scattering, absortion, and
!  reflexion from clouds.
!
!     Csolar=1000.0_r8
!     Csolar=800.0_r8
      Csolar=700.0_r8
!
!  Set bottom drag coefficient limits to avoid having values to large
!  and law-of-the-wall to extend indefinitely.
!
      Cdb_min=1.0_e8-6
!!    Cdb_max=1.0_e8-2
      Cdb_max=0.5_r8
!
!  Define von Karman constant.
!
      vonKar=0.41_r8
!
!  Stefan-Boltzmann constant (W/m2/K4).
!
      StefBo=5.67_e8-8
!
!  Infrared emmissivity. It usually ranges from 0.9 - 9.97.
!
      emmiss=0.97_r8
!
!  Initialize grid type switch to its default value: Cartesian grid.
!
      spherical=.false.
#ifdef TS_PSOURCE
!
!  Initialize switch to apply tracer sources and sinks.
!
       do j=1,NT
         do i=1,Msrc
           Lsrc(i,j)=.false.
         enddo
       enddo
#endif
#if defined ASSIMILATION || defined NUDGING
!
!  Initialize data assimilation switches.
!
       update_SSH=.false.
       update_SST=.false.
       update_UV=.false.
       do i=1,NT
         update_T(i)=.false.
         first_T(i)=.true.
       enddo
       first_SSH=.true.
       first_UV=.true.
#endif
!
!  Set I/O units.
!
      stdinp=5
      stdout=6
      usrout=10
!
!  Initialize NetCDF files IDs to close state.
!
      ncavgid=-1
      ncbryid=-1
      ncclmid=-1
      ncfrcid=-1
      ncfwdid=-1
      ncgrdid=-1
      nchisid=-1
      ncrstid=-1
      ncSSHid=-1
      ncSSTid=-1
      ncTOBSid=-1
      ncVSURid=-1
      ncVOBSid=-1
      ncesid=-1
!
!  Initialize NetCDF variable information arrays.  See include file
!  "ncparam.h" for details.
!
      do i=1,NV
        Linfo(1,i)=.false.
        Linfo(2,i)=.false.
        Linfo(3,i)=.false.
        Hout(i)=.false.
        Sout(i)=.false.
        Iinfo(1,i)=0
        Iinfo(2,i)=-1
        Iinfo(3,i)=-1
        Iinfo(4,i)=0
        Iinfo(5,i)=0
        Iinfo(6,i)=0
        Finfo(1,i)=0.0_r8
        Finfo(2,i)=0.0_r8
        Finfo(3,i)=0.0_r8
        Finfo(5,i)=0.0_r8
        Fscale(i)=1.0_r8
        Fpoint(1,i)=0.0_r8
        Fpoint(2,i)=0.0_r8
        Tintrp(1,i)=0.0_r8
        Tintrp(2,i)=0.0_r8
        Tmono(i)=0.0_r8
        Vtime(1,i)=0.0_r8
        Vtime(2,i)=0.0_r8
      enddo
!
!  Set running error messages.
!
      Rerror(1)=' ROMS - Blows up ................ exit_flag: '
      Rerror(2)=' ROMS - Input error ............. exit_flag: '
      Rerror(3)=' ROMS - Output error ............ exit_flag: '
      Rerror(4)=' ROMS - IO error ................ exit_flag: '
      Rerror(5)=' ROMS - Configuration error ..... exit_flag: '
      Rerror(6)=' ROMS - Partition error ......... exit_flag: '

#ifdef BVF_MIXING
!
!---------------------------------------------------------------------
!  Define parameters associated with Brunt-Vaisala frequency based
!  vertical mixing scheme:
!---------------------------------------------------------------------
!
!  Lower and upper bound values for vertical diffusion.
!
      bvf_numin=3.0_e8-5
      bvf_numax=4.0_e8-4
!
!  Convective diffusion (m2/s) in static unstable regime.
!
      bvf_nu0c=1.0_r8
!
!  Proportionality constat (m2/s2).
!
      bvf_nu0=1.0_e8-7
#endif
#if defined GLS_MIXING || defined MY25_MIXING
!
!---------------------------------------------------------------------
!  Define parameters associated with the generic length-scale
!  turbulence closure.
!---------------------------------------------------------------------
!
      gls_E2=1.33_r8
      gls_Ghmin=-0.28_r8
      gls_Ghcri=0.026_r8
      gls_Gh0=0.028_r8
!
! Define parameters for Canuto et al. (2001) stability functions.
!   (Canuto, V.M., Cheng, H.Y., and Dubovikov, M.S., 2001: Ocean
!    turbulence. Part I: One-point closure model - momentum and
!    heat vertical diffusivities, JPO, 1413-1426).
!
# ifdef CANUTO_A
      gls_Gh0=0.0329_r8         ! 0.0329 in GOTM, 0.0673 in Burchard
      gls_Ghcri=0.03_r8
      gls_L1=0.107_r8
      gls_L2=0.0032_r8
      gls_L3=0.0864_r8
      gls_L4=0.12_r8
      gls_L5=11.9_r8
      gls_L6=0.4_r8
      gls_L7=0.0_r8
      gls_L8=0.48_r8
# elif defined CANUTO_B
      gls_Gh0=0.0444_r8         ! 0.044 in GOTM, 0.0673 in Burchard
      gls_Ghcri=0.0414_r8
      gls_L1=0.127_r8
      gls_L2=0.00336_r8
      gls_L3=0.0906_r8
      gls_L4=0.101_r8
      gls_L5=11.2_r8
      gls_L6=0.4_r8
      gls_L7=0.0_r8
      gls_L8=0.318_r8
# endif
# if defined CANUTO_A || defined CANUTO_B
      gls_s0=3.0_r8/2.0_r8*gls_L1*gls_L5**2
      gls_s1=-gls_L4*(gls_L6+gls_L7)+2.0_r8*gls_L4*gls_L5*
     &        (gls_L1-1.0_r8/3.0_r8*gls_L2-gls_L3)+3.0_r8/2.0_r8*
     &        gls_L1*gls_L5*gls_L8
      gls_s2=-3.0_r8/8.0_r8*gls_L1*(gls_L6**2-gls_L7**2)
      gls_s4=2.0_r8*gls_L5
      gls_s5=2.0_r8*gls_L4
      gls_s6=2.0_r8/3.0_r8*gls_L5*(3.0_r8*gls_L3**2-gls_L2**2)-
     &       1.0_r8/2.0_r8*gls_L5*gls_L1*(3.0_r8*gls_L3-gls_L2)+
     &       3.0_r8/4.0_r8*gls_L1*(gls_L6-gls_L7)
      gls_b0=3.0_r8*gls_L5**2
      gls_b1=gls_L5*(7.0_r8*gls_L4+3.0_r8*gls_L8)
      gls_b2=gls_L5**2*(3.0_r8*gls_L3**2-gls_L2**2)-
     &       3.0_r8/4.0_r8*(gls_L6**2-gls_L7**2)
      gls_b3=gls_L4*(4.0_r8*gls_L4+3.0_r8*gls_L8)
      gls_b5=1.0_r8/4.0_r8*(gls_L2**2-3.0_r8*gls_L3**2)*
     &       (gls_L6**2-gls_L7**2)
      gls_b4=gls_L4*(gls_L2*gls_L6-3.0_r8*gls_L3*gls_L7-
     &       gls_L5*(gls_L2**2-gls_L3**2))+gls_L5*gls_L8*
     &       (3.0_r8*gls_L3**2-gls_L2**2)
# endif
!
!---------------------------------------------------------------------
!  Define parameters associated with Mellor-Yamada (1982) level 2.5
!  turbulence closure:
!     Ref: M-Y (1982):  A1=0.92,  A2=0.74,  B1=16.6, B2=10.1,
!                                 C1=0.08,  E1=1.8,  E2=1.33
!---------------------------------------------------------------------
!
      my_A1=0.92_r8
      my_A2=0.74_r8
      my_B1=16.6_r8
      my_B2=10.1_r8
      my_C1=0.08_r8
      my_C2=0.7_r8
      my_C3=0.2_r8
      my_E1=1.8_r8
      my_E2=1.33_r8
      my_Sq=0.2_r8
!
!  Lower bound on Galperin et al. (1988) stability function.
!
!!    my_Gh0=0.0233_r8
      my_Gh0=0.028_r8
!
!  Upper bound on the turbulent length scale.
!
      my_lmax=0.53_r8
!
!  Lower bound on tubulent energy "q2" and "q2l".
!
      my_qmin=1.0_e8-8
!
!  Asselin (1972) time filter coefficient.
!
      my_dtfac=0.05_r8
!
!  Coefficients used to compute stability functions for tracer and
!  momentum.
!
      my_B1p2o3=my_B1**(2.0_r8/3.0_r8)
      my_B1pm1o3=1.0_r8/(my_B1**(1.0_r8/3.0_r8))
      my_E1o2=0.5_r8*my_E1
      my_Sm1=my_A1*my_A2*((my_B2-3.0_r8*my_A2)*
     &                    (1.0_r8-6.0_r8*my_A1/my_B1)-
     &                    3.0_r8*my_C1*(my_B2+6.0_r8*my_A1))
      my_Sm2=9.0_r8*my_A1*my_A2
      my_Sh1=my_A2*(1.0_r8-6.0_r8*my_A1/my_B1)
# ifdef KANTHA_CLAYSON
      my_Sh2=3.0_r8*my_A2*(6.0_r8*my_A1+my_B2*(1.0_r8-my_C3))
      my_Sm4=18.0_r8*my_A1*my_A1+9.0_r8*my_A1*my_A2*(1.0_r8-my_C2)
# else
      my_Sh2=3.0_r8*my_A2*(6.0_r8*my_A1+my_B2)
      my_Sm3=my_A1*(1.0_r8-3.0_r8*my_C1-6.0_r8*my_A1/my_B1)
      my_Sm4=18.0_r8*my_A1*my_A1+9.0_r8*my_A1*my_A2
# endif
#endif
#ifdef LMD_MIXING
!
!---------------------------------------------------------------------
!  Define parameters associated with Large/McWilliams/Doney (1994)
!  mixing scheme.
!---------------------------------------------------------------------
!
!  Critical gradient Richardson number below which turbulent mixing
!  occurs.
!
      lmd_Ri0=0.7_r8
!
!  Interior viscosity/diffusivity (m2/s) due to wave breaking.
!  (Default: 1e-4 and 1-e5, respectively).
!
# if defined DAMEE_4 || defined DAMEE_5 || defined DAMME_6 || \
     defined DAMEE_7 || defined DAMEE_9
      lmd_nuwm=1.0_e8-4
      lmd_nuws=0.1_e8-4
# else
      lmd_nuwm=1.0_e8-5
      lmd_nuws=1.0_e8-6
# endif /* NJ_BIGHT */
!
!  Maximum interior viscosity/diffusivity (m2/s) due to shear
!  instability.
!
!!    lmd_nu0m=50_e8-4
!!    lmd_nu0s=50_e8-4
      lmd_nu0m=10_e8-4
      lmd_nu0s=10_e8-4
!
!  Brunt-Vaisala frequency squared (1/s2) limit for convection and
!  maximum interior convective viscosity and diffusivity (m2/s) due
!  to shear instability.
!
      lmd_bvfcon=-2.0_e8-5
!     lmd_nu0c=0.1_r8
      lmd_nu0c=0.01_r8
!     lmd_nu0c=0.05_r8
!
!  Molecular viscosity (m2/s).
!
      lmd_nu=1.5_e8-6
!
!  Value of double-diffusive density ratio where diffusivity goes
!  to zero in salt fingering.
!
      lmd_Rrho0=1.9_r8
!
!  Scaling factors for double diffusion coefficient in salt fingering.
!
      lmd_nuf=10.0_e8-4
      lmd_fdd=0.7_r8
!
!  Double diffusion constants for temperature (Marmorino and
!  Caldwell, 1976) and salinity (Fedorov, 1988).
!
      lmd_tdd1=0.909_r8
      lmd_tdd2=4.6_r8
      lmd_tdd3=0.54_r8
      lmd_sdd1=0.15_r8
      lmd_sdd2=1.85_r8
      lmd_sdd3=0.85_r8
#endif
#if defined LMD_SKPP | defined SOLAR_SOURCE
!
!---------------------------------------------------------------------
!  Water clarity parameters.
!---------------------------------------------------------------------
!
!  Set Jerlov water type to assign everywhere; choose an integer
!  value from 1 to 5.
!
      lmd_Jwt=1
!
!  Define reciprocal of the absorption coefficcient for each of
!  two solar wavelength bands as a function of Jerlov water type
!  (Ref: Paulson and Simpson, 1977).
!
      lmd_mu1(1)=0.35_r8
      lmd_mu1(2)=0.6_r8
      lmd_mu1(3)=1.0_r8
      lmd_mu1(4)=1.5_r8
      lmd_mu1(5)=1.4_r8
!
      lmd_mu2(1)=23.0_r8
      lmd_mu2(2)=20.0_r8
      lmd_mu2(3)=17.0_r8
      lmd_mu2(4)=14.0_r8
      lmd_mu2(5)=7.9_r8
!
!  Define fraction of the total radiance for wavelength band 1 as
!  a function of Jerlov water type.  The fraction for wavelength
!  band 2 is lmd_r2=1-lmd_r1.
!
      lmd_r1(1)=0.58_r8
      lmd_r1(2)=0.62_r8
      lmd_r1(3)=0.67_r8
      lmd_r1(4)=0.77_r8
      lmd_r1(5)=0.78_r8
#endif /* LMD_SKPP || SOLAR_SOURCE */
#if defined LMD_SKPP || defined LMD_BKPP
!
!---------------------------------------------------------------------
!  Define parameters associated with Large/McWilliams/Doney (1994)
!  local K-Profile Parameterization (KPP) of the oceanic planetary
!  boundary layer.
!---------------------------------------------------------------------
!
!  Define parameters associated with turbulent velocity scales.
!
      lmd_zetam=-0.2_r8
      lmd_zetas=-1.0_r8
      lmd_am=1.257_r8
      lmd_cm=8.36_r8
      lmd_as=-28.86_r8
      lmd_cs=98.96_r8
!
!  Ratio of interior Brunt-Vaisala frequency "N" to that at
!  entrainment depth "he".
!
      lmd_Cv=1.25_r8
!     lmd_Cv=1.4_r8
!     lmd_Cv=1.6_r8
!     lmd_Cv=1.8_r8
!
!  Critical bulk Richardson number.
!
!     lmd_Ric=0.25_r8
      lmd_Ric=0.3_r8
!     lmd_Ric=0.5_r8
!     lmd_Ric=0.75_r8
!
!  Ratio of entrainment flux to surface buoyancy flux.
!
      lmd_betaT=-0.2_r8
!
!  Nondimensional extent of the surface layer.
!
      lmd_epsilon=0.1_r8
!
!  Constant used in the computation of Ekman depth.
!
      lmd_cekman=0.7_r8
!
!  Constant used in the computaion of Monin-Obukhov depth.
!
      lmd_cmonob=1.0_r8
!
!  Proportionality coefficient parameterizing nonlocal transport.
!
      lmd_Cstar=10.0_r8
!
!  Proportionality coefficient parameterizing boundary layer
!  nonlocal transport.
!
      lmd_Cg=lmd_Cstar*
     &       vonKar*(lmd_cs*vonKar*lmd_epsilon)**(1.0_r8/3.0_r8)
#endif
#ifdef BULK_FLUXES
!
!---------------------------------------------------------------------
!  Define parameters associated with the bulk parameterization of
!  air-sea fluxes, Fairall et al. (1996) COARE scheme.
!---------------------------------------------------------------------
!
!  Set height of air water vapor, temperature, and wind meassurement.
!
      blk_ZQ=10.0_r8
      blk_ZT=10.0_r8
      blk_ZW=10.0_r8
!
!  Thermal conductivity of water (W/m/K).
!
      blk_tcw=0.6_r8
!
!  Kinematic viscosity water (m2/s).
!
      blk_visw=1.0_e8-6
!
!  Specific heat capacity for dry air and seawater (J/kg/K).
!
      blk_Cpa=1004.67_r8       ! (Businger 1982)
      blk_Cpw=4000.0_r8
!
!  Gas constant for dry air (J/kg/K).
!
      blk_Rgas=287.1_r8
!
!  Beta parameter evaluated from Fairall low windspeed turbulence
!  data.
!
      blk_beta=1.2_r8
!
!  Fairall LKB roughness Reynolds number to Von Karman adjustment.
!
      blk_fdg=1.0_r8
!
!  Depth of atmospheric boundary layer (m).  Use 600m if unavailable
!  data.
!
      blk_Zabl=600.0_r8
!
!  Liu et al. (1976) look-up table coefficients to compute roughness
!  Reynolds number for temperature (Rt) and moisture (Rq) as a
!  function wind Reynolds number (Rr):
!
!        Rt = Liu_a(:,1) * Rr ** Liu_b(:,1)
!        Rq = Liu_a(:,2) * Rr ** Liu_b(:,2)
!
      Liu_Rr(1)=0.0_r8             ! valid wind Reynold number range
      Liu_Rr(2)=0.11_r8
      Liu_Rr(3)=0.825_r8
      Liu_Rr(4)=3.0_r8
      Liu_Rr(5)=10.0_r8
      Liu_Rr(6)=30.0_r8
      Liu_Rr(7)=100.0_r8
      Liu_Rr(8)=300.0_r8
      Liu_Rr(9)=1000.0_r8
!
      Liu_a(1,1)=0.177_r8          ! coefficient "a" for temperature
      Liu_a(2,1)=1.376_r8
      Liu_a(3,1)=1.026_r8
      Liu_a(4,1)=1.625_r8
      Liu_a(5,1)=4.661_r8
      Liu_a(6,1)=34.904_r8
      Liu_a(7,1)=1667.19_r8
      Liu_a(8,1)=5.88_e8+5
!
      Liu_b(1,1)=0.0_r8            ! coefficient "b" for temperature
      Liu_b(2,1)=0.929_r8
      Liu_b(3,1)=-0.599_r8
      Liu_b(4,1)=-1.018_r8
      Liu_b(5,1)=-1.475_r8
      Liu_b(6,1)=-2.067_r8
      Liu_b(7,1)=-2.907_r8
      Liu_b(8,1)=-3.935_r8
!
      Liu_a(1,2)=0.292_r8          ! coefficient "a" for moisture
      Liu_a(2,2)=1.808_r8
      Liu_a(3,2)=1.393_r8
      Liu_a(4,2)=1.956_r8
      Liu_a(5,2)=4.994_r8
      Liu_a(6,2)=30.709_r8
      Liu_a(7,2)=1448.68_r8
      Liu_a(8,2)=2.98_e8+5
!
      Liu_b(1,2)=0.0_r8            ! coefficient "b" for moisture
      Liu_b(2,2)=0.826_r8
      Liu_b(3,2)=-0.528_r8
      Liu_b(4,2)=-0.870_r8
      Liu_b(5,2)=-1.297_r8
      Liu_b(6,2)=-1.845_r8
      Liu_b(7,2)=-2.682_r8
      Liu_b(8,2)=-3.616_r8
#endif /* BULK_FLUXES */
#ifdef SG_BBL
!
!---------------------------------------------------------------------
!  Define parameters associated with Styles and Glenn (1999) bottom
!  currents and waves boundary layer.
!---------------------------------------------------------------------
!
!  Nondimensional closure parameters.
!
      sg_alpha=1.0_r8
      sg_z1p=sg_alpha
!
!  Nondimensional closure complex constant.
!
      sg_mp=CMPLX(SQRT(1.0_r8/(2.0_r8*sg_z1p)),
     &            SQRT(1.0_r8/(2.0_r8*sg_z1p)))
!
!  Acceleration due to gravity (m/s2), Von Karman constant, an
!  ratio of circumference to diameter.
!
      sg_g=g
      sg_kappa=vonKar
      sg_pi=pi
!
!  Kinematic viscosity of seawater (m2/s).
!
      sg_nu=1.19_e8-6
!
!  Closure convergence criterion.
!
      sg_tol=1.0_e8-4
!
!  Depth (m), 100 cm above bottom.
!
      sg_z100=1.0_r8
!
!  Minimum allowed height (m) of current above bed.  Otherwise,
!  currents are logarithmic interpolated this depth, if smaller.
!
      sg_z1min=0.20_r8
!
!  Upper limit in bottom drag coefficient.
!
      sg_Cdmax=0.01_r8
!
!  Default values.
!
      sg_ustarcdef=0.01_r8
      sg_znotcdef=0.02_r8
#endif
!
!---------------------------------------------------------------------
!  Define names of variables in NetCDF output files.
!---------------------------------------------------------------------
!
!  Set ROMS version (string of five characters).
!
      version='2.0  '
!
!  IDs for position variables.
!
      idXgrd=-1
      idYgrd=-2
      idZgrd=-3
      iddpth=-4
      idglon=-5
      idglat=-6
!
!  Inner dimension is for variable type and outer is for variable
!  attributes (name, long-name, units, field, associated time).
!  Set scale to convert input data to model units.
!
      idtime=1
      Fscale(idtime)=1.0_r8
      Iinfo(1,idtime)=0
      Vname(1,idtime)='ocean_time                                    '
      Vname(2,idtime)='time since initialization                     '
      Vname(3,idtime)='second                                        '
      Vname(4,idtime)='time, scalar, series                          '
      Vname(5,idtime)='time                                          '

      idUvel=2
      Fscale(idUvel)=1.0_r8
      Iinfo(1,idUvel)=u3dvar
      Vname(1,idUvel)='u                                             '
      Vname(2,idUvel)='u-momentum component                          '
      Vname(3,idUvel)='meter second-1                                '
      Vname(4,idUvel)='u-velocity, scalar, series                    '
      Vname(5,idUvel)='ocean_time                                    '

      idVvel=3
      Fscale(idVvel)=1.0_r8
      Iinfo(1,idVvel)=v3dvar
      Vname(1,idVvel)='v                                             '
      Vname(2,idVvel)='v-momentum component                          '
      Vname(3,idVvel)='meter second-1                                '
      Vname(4,idVvel)='v-velocity, scalar, series                    '
      Vname(5,idVvel)='ocean_time                                    '

      idWvel=4
      Fscale(idWvel)=1.0_r8
      Iinfo(1,idWvel)=w3dvar
      Vname(1,idWvel)='w                                             '
      Vname(2,idWvel)='vertical momentum component                   '
      Vname(3,idWvel)='meter second-1                                '
      Vname(4,idWvel)='w-velocity, scalar, series                    '
      Vname(5,idWvel)='ocean_time                                    '

      idOvel=5
      Fscale(idOvel)=1.0_r8
      Iinfo(1,idOvel)=w3dvar
      Vname(1,idOvel)='omega                                         '
      Vname(2,idOvel)='S-coordinate vertical momentum component      '
      Vname(3,idOvel)='meter3 second-1                               '
      Vname(4,idOvel)='omega, scalar, series                         '
      Vname(5,idOvel)='ocean_time                                    '

      idUbar=6
      Fscale(idUbar)=1.0_r8
      Iinfo(1,idUbar)=u2dvar
      Vname(1,idUbar)='ubar                                          '
      Vname(2,idUbar)='vertically integrated u-momentum component    '
      Vname(3,idUbar)='meter second-1                                '
      Vname(4,idUbar)='ubar-velocity, scalar, series                 '
      Vname(5,idUbar)='ocean_time                                    '

      idVbar=7
      Fscale(idVbar)=1.0_r8
      Iinfo(1,idVbar)=v2dvar
      Vname(1,idVbar)='vbar                                          '
      Vname(2,idVbar)='vertically integrated v-momentum component    '
      Vname(3,idVbar)='meter second-1                                '
      Vname(4,idVbar)='vbar-velocity, scalar, series                 '
      Vname(5,idVbar)='ocean_time                                    '

      idPbar=8
      Fscale(idPbar)=1.0_r8
      Iinfo(1,idPbar)=p2dvar
      Vname(1,idPbar)='psi                                           '
      Vname(2,idPbar)='depth-integrated streamfunction               '
      Vname(3,idPbar)='meter3 second-1                               '
      Vname(4,idPbar)='streamfunction, scalar, series                '
      Vname(5,idPbar)='ocean_time                                    '

      idU3bc(iwest)=9
      ifield=idU3bc(iwest)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='u_west                                        '
      Vname(2,ifield)='3D u-momentum western boundary condition      '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='u_west, scalar, series                        '
      Vname(5,ifield)='v3d_time                                      '

      idU3bc(ieast)=10
      ifield=idU3bc(ieast)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='u_east                                        '
      Vname(2,ifield)='3D u-momentum eastern boundary condition      '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='u_east, scalar, series                        '
      Vname(5,ifield)='v3d_time                                      '

      idU3bc(isouth)=11
      ifield=idU3bc(isouth)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='u_south                                       '
      Vname(2,ifield)='3D u-momentum southern boundary condition     '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='u_south, scalar, series                       '
      Vname(5,ifield)='v3d_time                                      '

      idU3bc(inorth)=12
      ifield=idU3bc(inorth)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='u_north                                       '
      Vname(2,ifield)='3D u-momentum northern boundary condition     '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='u_north, scalar, series                       '
      Vname(5,ifield)='v3d_time                                      '

      idV3bc(iwest)=13
      ifield=idV3bc(iwest)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='v_west                                        '
      Vname(2,ifield)='3D v-momentum western boundary condition      '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='v_west, scalar, series                        '
      Vname(5,ifield)='v3d_time                                      '

      idV3bc(ieast)=14
      ifield=idV3bc(ieast)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='v_east                                        '
      Vname(2,ifield)='3D v-momentum eastern boundary condition      '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='v_east, scalar, series                        '
      Vname(5,ifield)='v3d_time                                      '

      idV3bc(isouth)=15
      ifield=idV3bc(isouth)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='v_south                                       '
      Vname(2,ifield)='3D v-momentum southern boundary condition     '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='v_south, scalar, series                       '
      Vname(5,ifield)='v3d_time                                      '

      idV3bc(inorth)=16
      ifield=idV3bc(inorth)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='v_north                                       '
      Vname(2,ifield)='3D v-momentum northern boundary condition     '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='v_north, scalar, series                       '
      Vname(5,ifield)='v3d_time                                      '

      idU2bc(iwest)=17
      ifield=idU2bc(iwest)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='ubar_west                                     '
      Vname(2,ifield)='2D u-momentum western boundary condition      '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='ubar_west, scalar, series                     '
      Vname(5,ifield)='v2d_time                                      '

      idU2bc(ieast)=18
      ifield=idU2bc(ieast)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='ubar_east                                     '
      Vname(2,ifield)='2D u-momentum eastern boundary condition      '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='ubar_east, scalar, series                     '
      Vname(5,ifield)='v2d_time                                      '

      idU2bc(isouth)=19
      ifield=idU2bc(isouth)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='ubar_south                                    '
      Vname(2,ifield)='2D u-momentum southern boundary condition     '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='ubar_south, scalar, series                    '
      Vname(5,ifield)='v2d_time                                      '

      idU2bc(inorth)=20
      ifield=idU2bc(inorth)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='ubar_north                                    '
      Vname(2,ifield)='2D u-momentum northern boundary condition     '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='ubar_north, scalar, series                    '
      Vname(5,ifield)='v2d_time                                      '

      idV2bc(iwest)=21
      ifield=idV2bc(iwest)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='vbar_west                                     '
      Vname(2,ifield)='2D v-momentum western boundary condition      '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='vbar_west, scalar, series                     '
      Vname(5,ifield)='v2d_time                                      '

      idV2bc(ieast)=22
      ifield=idV2bc(ieast)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='vbar_east                                     '
      Vname(2,ifield)='2D v-momentum eastern boundary condition      '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='vbar_east, scalar, series                     '
      Vname(5,ifield)='v2d_time                                      '

      idV2bc(isouth)=23
      ifield=idV2bc(isouth)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='vbar_south                                    '
      Vname(2,ifield)='2D v-momentum southern boundary condition     '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='vbar_south, scalar, series                    '
      Vname(5,ifield)='v2d_time                                      '

      idV2bc(inorth)=24
      ifield=idV2bc(inorth)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='vbar_north                                    '
      Vname(2,ifield)='2D v-momentum northern boundary condition     '
      Vname(3,ifield)='meter second-1                                '
      Vname(4,ifield)='vbar_north, scalar, series                    '
      Vname(5,ifield)='v2d_time                                      '

      idUclm=25
      Fscale(idUclm)=1.0_r8
      Iinfo(1,idUclm)=u3dvar
      Vname(1,idUclm)='u                                             '
      Vname(2,idUclm)='u-momentum component climatology              '
      Vname(3,idUclm)='meter second-1                                '
      Vname(4,idUclm)='u-velocity, scalar, series                    '
      Vname(5,idUclm)='v3d_time                                      '

      idVclm=26
      Fscale(idVclm)=1.0_r8
      Iinfo(1,idVclm)=v3dvar
      Vname(1,idVclm)='v                                             '
      Vname(2,idVclm)='v-momentum component climatology              '
      Vname(3,idVclm)='meter second-1                                '
      Vname(4,idVclm)='v-velocity, scalar, series                    '
      Vname(5,idVclm)='v3d_time                                      '

      idUbcl=27
      Fscale(idUbcl)=1.0_r8
      Iinfo(1,idUbcl)=u2dvar
      Vname(1,idUbcl)='ubar                                          '
      Vname(2,idUbcl)='vertically integrated u-momentum climatology  '
      Vname(3,idUbcl)='meter second-1                                '
      Vname(4,idUbcl)='ubar-velocity, scalar, series                 '
      Vname(5,idUbcl)='v2d_time                                      '

      idVbcl=28
      Fscale(idVbcl)=1.0_r8
      Iinfo(1,idVbcl)=v2dvar
      Vname(1,idVbcl)='vbar                                          '
      Vname(2,idVbcl)='vertically integrated v-momentum climatology  '
      Vname(3,idVbcl)='meter second-1                                '
      Vname(4,idVbcl)='vbar-velocity, scalar, series                 '
      Vname(5,idVbcl)='v2d_time                                      '

      idUobs=29
      Fscale(idUobs)=1.0_r8
      Iinfo(1,idUobs)=u3dvar
      Vname(1,idUobs)='u                                             '
      Vname(2,idUobs)='u-momentum component observations             '
      Vname(3,idUobs)='meter second-1                                '
      Vname(4,idUobs)='Uobs, scalar, series                          '
      Vname(5,idUobs)='Vobs_time                                     '

      idVobs=30
      Fscale(idVobs)=1.0_r8
      Iinfo(1,idVobs)=v3dvar
      Vname(1,idVobs)='v                                             '
      Vname(2,idVobs)='v-momentum component observations             '
      Vname(3,idVobs)='meter second-1                                '
      Vname(4,idVobs)='Vobs, scalar, series                          '
      Vname(5,idVobs)='Vobs_time                                     '

      idUVer=31
      Fscale(idUVer)=1.0_r8
      Iinfo(1,idUVer)=r3dvar
      Vname(1,idUVer)='Evel                                          '
      Vname(2,idUVer)='horizontal velocity error variance            '
      Vname(3,idUVer)='nondimensional                                '
      Vname(4,idUVer)='Evel, scalar, series                          '
      Vname(5,idUVer)='Vobs_time                                     '

      idUsur=32
      Fscale(idUsur)=1.0_r8
      Iinfo(1,idUsur)=u2dvar
      Vname(1,idUsur)='Usur                                          '
      Vname(2,idUsur)='surface u-momentum component observations     '
      Vname(3,idUsur)='meter second-1                                '
      Vname(4,idUsur)='Usur, scalar, series                          '
      Vname(5,idUsur)='Vsur_time                                     '

      idVsur=33
      Fscale(idVsur)=1.0_r8
      Iinfo(1,idVsur)=v2dvar
      Vname(1,idVsur)='Vsur                                          '
      Vname(2,idVsur)='surface v-momentum component observations     '
      Vname(3,idVsur)='meter second-1                                '
      Vname(4,idVsur)='Vsur, scalar, series                          '
      Vname(5,idVsur)='Vsur_time                                     '

      idUVse=34
      Fscale(idUVse)=1.0_r8
      Iinfo(1,idUVse)=r2dvar
      Vname(1,idUVse)='Esur                                          '
      Vname(2,idUVse)='surface velocity error variance               '
      Vname(3,idUVse)='meter second-1                                '
      Vname(4,idUVse)='Esur, scalar, series                          '
      Vname(5,idUVse)='Vsur_time                                     '

      idSvar(isUvel)=35
      ifield=idSvar(isUvel)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=u3dvar
      Vname(1,ifield)='u_es                                          '
      Vname(2,ifield)='u-momentum error subspace                     '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='u_es, scalar, series                          '
      Vname(5,ifield)='time                                          '

      idSvar(isVvel)=36
      ifield=idSvar(isVvel)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=v3dvar
      Vname(1,ifield)='v_es                                          '
      Vname(2,ifield)='v-momentum error subspace                     '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='v_es, scalar, series                          '
      Vname(5,ifield)='time                                          '

      idSvar(isUbar)=37
      ifield=idSvar(isUbar)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=u2dvar
      Vname(1,ifield)='ubar_es                                       '
      Vname(2,ifield)='barotropic u-momentum error subspace          '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='ubar_es, scalar, series                       '
      Vname(5,ifield)='time                                          '

      idSvar(isVbar)=38
      ifield=idSvar(isVbar)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=v2dvar
      Vname(1,ifield)='vbar_es                                       '
      Vname(2,ifield)='barotropic v-momentum error subspace          '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='vbar_es, scalar, series                       '
      Vname(5,ifield)='time                                          '

      idFsur=39
      Fscale(idFsur)=1.0_r8
      Iinfo(1,idFsur)=r2dvar
      Vname(1,idFsur)='zeta                                          '
      Vname(2,idFsur)='free-surface                                  '
      Vname(3,idFsur)='meter                                         '
      Vname(4,idFsur)='free-surface, scalar, series                  '
      Vname(5,idFsur)='ocean_time                                    '

      idZbry(iwest)=40
      ifield=idZbry(iwest)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='zeta_west                                     '
      Vname(2,ifield)='free-surface western boundary condition       '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='zeta_west, scalar, series                     '
      Vname(5,ifield)='zeta_time                                     '

      idZbry(ieast)=41
      ifield=idZbry(ieast)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='zeta_east                                     '
      Vname(2,ifield)='free-surface eastern boundary condition       '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='zeta_east, scalar, series                     '
      Vname(5,ifield)='zeta_time                                     '

      idZbry(isouth)=42
      ifield=idZbry(isouth)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='zeta_south                                    '
      Vname(2,ifield)='free-surface southern boundary condition      '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='zeta_south, scalar, series                    '
      Vname(5,ifield)='zeta_time                                     '

      idZbry(inorth)=43
      ifield=idZbry(inorth)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='zeta_north                                    '
      Vname(2,ifield)='free-surface northern boundary condition      '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='zeta_north, scalar, series                    '
      Vname(5,ifield)='zeta_time                                     '

      idVvis=44
      Fscale(idVvis)=1.0_r8
      Iinfo(1,idVvis)=w3dvar
      Vname(1,idVvis)='AKv                                           '
      Vname(2,idVvis)='vertical viscosity coefficient                '
      Vname(3,idVvis)='meter2 second-1                               '
      Vname(4,idVvis)='AKv, scalar, series                           '
      Vname(5,idVvis)='ocean_time                                    '

      idTdif=45
      Fscale(idTdif)=1.0_r8
      Iinfo(1,idTdif)=w3dvar
      Vname(1,idTdif)='AKt                                           '
      Vname(2,idTdif)='temperature vertical diffusion coefficient    '
      Vname(3,idTdif)='meter2 second-1                               '
      Vname(4,idTdif)='AKt, scalar, series                           '
      Vname(5,idTdif)='ocean_time                                    '

      idSdif=46
      Fscale(idSdif)=1.0_r8
      Iinfo(1,idSdif)=w3dvar
      Vname(1,idSdif)='AKs                                           '
      Vname(2,idSdif)='salinity vertical diffusion coefficient       '
      Vname(3,idSdif)='meter2 second-1                               '
      Vname(4,idSdif)='AKs, scalar, series                           '
      Vname(5,idSdif)='ocean_time                                    '

      idHsbl=47
      Fscale(idHsbl)=1.0_r8
      Iinfo(1,idHsbl)=r2dvar
      Vname(1,idHsbl)='Hsbl                                          '
      Vname(2,idHsbl)='depth of oceanic surface boundary layer       '
      Vname(3,idHsbl)='meter                                         '
      Vname(4,idHsbl)='Hsbl, scalar, series                          '
      Vname(5,idHsbl)='ocean_time                                    '

      idHbbl=48
      Fscale(idHbbl)=1.0_r8
      Iinfo(1,idHbbl)=r2dvar
      Vname(1,idHbbl)='Hbbl                                          '
      Vname(2,idHbbl)='depth of oceanic bottom boundary layer        '
      Vname(3,idHbbl)='meter                                         '
      Vname(4,idHbbl)='Hbbl, scalar, series                          '
      Vname(5,idHbbl)='ocean_time                                    '

      idDano=49
      Fscale(idDano)=1.0_r8
      Iinfo(1,idDano)=r3dvar
      Vname(1,idDano)='rho                                           '
      Vname(2,idDano)='density anomaly                               '
      Vname(3,idDano)='kilogram meter-3                              '
      Vname(4,idDano)='density, scalar, series                       '
      Vname(5,idDano)='ocean_time                                    '

      idTvar(itemp)=50
      ifield=idTvar(itemp)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='temp                                          '
      Vname(2,ifield)='potential temperature                         '
      Vname(3,ifield)='Celsius                                       '
      Vname(4,ifield)='temperature, scalar, series                   '
      Vname(5,ifield)='ocean_time                                    '

      idTvar(isalt)=51
      ifield=idTvar(isalt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='salt                                          '
      Vname(2,ifield)='salinity                                      '
      Vname(3,ifield)='PSU                                           '
      Vname(4,ifield)='salinity, scalar, series                      '
      Vname(5,ifield)='ocean_time                                    '

      idTbry(iwest,itemp)=52
      ifield=idTbry(iwest,itemp)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='temp_west                                     '
      Vname(2,ifield)='temperature western boundary condition        '
      Vname(3,ifield)='Celsius                                       '
      Vname(4,ifield)='temp_west, scalar, series                     '
      Vname(5,ifield)='temp_time                                     '

      idTbry(ieast,itemp)=53
      ifield=idTbry(ieast,itemp)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='temp_east                                     '
      Vname(2,ifield)='temperature eastern boundary condition        '
      Vname(3,ifield)='Celsius                                       '
      Vname(4,ifield)='temp_east, scalar, series                     '
      Vname(5,ifield)='temp_time                                     '

      idTbry(isouth,itemp)=54
      ifield=idTbry(isouth,itemp)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='temp_south                                    '
      Vname(2,ifield)='temperature southern boundary condition       '
      Vname(3,ifield)='Celsius                                       '
      Vname(4,ifield)='temp_south, scalar, series                    '
      Vname(5,ifield)='temp_time                                     '

      idTbry(inorth,itemp)=55
      ifield=idTbry(inorth,itemp)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='temp_north                                    '
      Vname(2,ifield)='temperature northern boundary condition       '
      Vname(3,ifield)='Celsius                                       '
      Vname(4,ifield)='temp_north, scalar, series                    '
      Vname(5,ifield)='temp_time                                     '

      idTbry(iwest,isalt)=56
      ifield=idTbry(iwest,isalt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='salt_west                                     '
      Vname(2,ifield)='salinity western boundary condition           '
      Vname(3,ifield)='PSU                                           '
      Vname(4,ifield)='salt_west, scalar, series                     '
      Vname(5,ifield)='salt_time                                     '

      idTbry(ieast,isalt)=57
      ifield=idTbry(ieast,isalt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='salt_east                                     '
      Vname(2,ifield)='salinity eastern boundary condition           '
      Vname(3,ifield)='PSU                                           '
      Vname(4,ifield)='salt_east, scalar, series                     '
      Vname(5,ifield)='salt_time                                     '

      idTbry(isouth,isalt)=58
      ifield=idTbry(isouth,isalt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='salt_south                                    '
      Vname(2,ifield)='salinity southern boundary condition          '
      Vname(3,ifield)='PSU                                           '
      Vname(4,ifield)='salt_south, scalar, series                    '
      Vname(5,ifield)='salt_time                                     '

      idTbry(inorth,isalt)=59
      ifield=idTbry(inorth,isalt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='salt_north                                    '
      Vname(2,ifield)='salinity northern boundary condition          '
      Vname(3,ifield)='PSU                                           '
      Vname(4,ifield)='salt_north, scalar, series                    '
      Vname(5,ifield)='salt_time                                     '

      idTclm(itemp)=60
      ifield=idTclm(itemp)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='temp                                          '
      Vname(2,ifield)='potential temperature climatology             '
      Vname(3,ifield)='Celsius                                       '
      Vname(4,ifield)='temp_time, scalar, series                     '
      Vname(5,ifield)='temp_time                                     '

      idTclm(isalt)=61
      ifield=idTclm(isalt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='salt                                          '
      Vname(2,ifield)='salinity climatology                          '
      Vname(3,ifield)='PSU                                           '
      Vname(4,ifield)='salt_time, scalar, series                     '
      Vname(5,ifield)='salt_time                                     '

      idTobs(itemp)=62
      ifield=idTobs(itemp)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='temp                                          '
      Vname(2,ifield)='potential temperature observations            '
      Vname(3,ifield)='Celsius                                       '
      Vname(4,ifield)='Tobs, scalar, series                          '
      Vname(5,ifield)='Tobs_time                                     '

      idTobs(isalt)=63
      ifield=idTobs(isalt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='salt                                          '
      Vname(2,ifield)='salinity observations                         '
      Vname(3,ifield)='PSU                                           '
      Vname(4,ifield)='Sobs, scalar, series                          '
      Vname(5,ifield)='Sobs_time                                     '

      idTerr(itemp)=64
      ifield=idTerr(itemp)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='temp_err                                      '
      Vname(2,ifield)='potential temperature error variance          '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='temp_err, scalar, series                      '
      Vname(5,ifield)='Tobs_time                                     '

      idTerr(isalt)=65
      ifield=idTerr(isalt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='salt_err                                      '
      Vname(2,ifield)='salinity error variance                       '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='salt_err, scalar, series                      '
      Vname(5,ifield)='Sobs_time                                     '

      idSvar(isTvar(itemp))=66
      ifield=idSvar(isTvar(itemp))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='temp_es                                       '
      Vname(2,ifield)='potential temperature error subspace          '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='temp_es, scalar, series                       '
      Vname(5,ifield)='time                                          '

      idSvar(isTvar(itemp))=67
      ifield=idSvar(isTvar(itemp))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='salt_es                                       '
      Vname(2,ifield)='salinity error subspace                       '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='salt_es, scalar, series                       '
      Vname(5,ifield)='time                                          '

      idMtke=68
      Fscale(idMtke)=1.0_r8
      Iinfo(1,idMtke)=w3dvar
      Vname(1,idMtke)='tke                                           '
      Vname(2,idMtke)='turbulent kinetic energy                      '
      Vname(3,idMtke)='meter2 second-2                               '
      Vname(4,idMtke)='tke, scalar, series                           '
      Vname(5,idMtke)='ocean_time                                    '

      idMtls=69
      Fscale(idMtls)=1.0_r8
      Iinfo(1,idMtls)=w3dvar
      Vname(1,idMtls)='gls                                           '
      Vname(2,idMtls)='turbulent generic length scale                '
      Vname(3,idMtls)='meter3 second-2                               '
      Vname(4,idMtls)='gls, scalar, series                           '
      Vname(5,idMtls)='ocean_time                                    '

      idUair=70
      Fscale(idUair)=1.0_r8
      Iinfo(1,idUair)=r2dvar
      Vname(1,idUair)='Uwind                                         '
      Vname(2,idUair)='surface u-wind component                      '
      Vname(3,idUair)='meter second-1                                '
      Vname(4,idUair)='u-wind, scalar, series                        '
      Vname(5,idUair)='wind_time                                     '

      idVair=71
      Fscale(idVair)=1.0_r8
      Iinfo(1,idVair)=r2dvar
      Vname(1,idVair)='Vwind                                         '
      Vname(2,idVair)='surface v-wind component                      '
      Vname(3,idVair)='meter second-1                                '
      Vname(4,idVair)='v-wind, scalar, series                        '
      Vname(5,idVair)='wind_time                                     '

      idUsms=72
      Fscale(idUsms)=1.0_r8/rho0
      Iinfo(1,idUsms)=u2dvar
      Vname(1,idUsms)='sustr                                         '
      Vname(2,idUsms)='surface u-momentum stress                     '
      Vname(3,idUsms)='Newton meter-2                                '
      Vname(4,idUsms)='surface u-momentum stress, scalar, series     '
      Vname(5,idUsms)='sms_time                                      '

      idVsms=73
      Fscale(idVsms)=1.0_r8/rho0
      Iinfo(1,idVsms)=v2dvar
      Vname(1,idVsms)='svstr                                         '
      Vname(2,idVsms)='surface v-momentum stress                     '
      Vname(3,idVsms)='Newton meter-2                                '
      Vname(4,idVsms)='surface v-momentum stress, scalar, series     '
      Vname(5,idVsms)='sms_time                                      '

      idUbms=74
      Fscale(idUbms)=1.0_r8/rho0
      Iinfo(1,idUbms)=u2dvar
      Vname(1,idUbms)='bustr                                         '
      Vname(2,idUbms)='bottom u-momentum stress                      '
      Vname(3,idUbms)='Newton meter-2                                '
      Vname(4,idUbms)='bottom u-momentum stress, scalar, series      '
      Vname(5,idUbms)='bms_time                                      '

      idVbms=75
      Fscale(idVbms)=1.0_r8/rho0
      Iinfo(1,idVbms)=v2dvar
      Vname(1,idVbms)='bvstr                                         '
      Vname(2,idVbms)='bottom v-momentum stress                      '
      Vname(3,idVbms)='Newton meter-2                                '
      Vname(4,idVbms)='bottom v-momentum stress, scalar, series      '
      Vname(5,idVbms)='bms_time                                      '

      idUbws=76
      Fscale(idUbws)=1.0_r8/rho0
      Iinfo(1,idUbws)=u2dvar
      Vname(1,idUbws)='bustrw                                        '
      Vname(2,idUbws)='wind-induced, bottom u-wave stress            '
      Vname(3,idUbws)='Newton meter-2                                '
      Vname(4,idUbws)='bottom u-wave stress, scalar, series          '
      Vname(5,idUbws)='ocean_time                                    '

      idVbws=77
      Fscale(idVbws)=1.0_r8/rho0
      Iinfo(1,idVbws)=v2dvar
      Vname(1,idVbws)='bvstrw                                        '
      Vname(2,idVbws)='wind-induced, bottom v-wave stress            '
      Vname(3,idVbws)='Newton meter-2                                '
      Vname(4,idVbws)='bottom v-wave stress, scalar, series          '
      Vname(5,idVbws)='ocean_time                                    '

      idUbot=78
      Fscale(idUbot)=1.0_r8
      Iinfo(1,idUbot)=u2dvar
      Vname(1,idUbot)='Ubot                                          '
      Vname(2,idUbot)='bottom u-momentum above bed                   '
      Vname(3,idUbot)='meter second-1                                '
      Vname(4,idUbot)='bottom u-velocity, scalar, series             '
      Vname(5,idUbot)='ocean_time                                    '

      idVbot=79
      Fscale(idVbot)=1.0_r8
      Iinfo(1,idVbot)=v2dvar
      Vname(1,idVbot)='Vbot                                          '
      Vname(2,idVbot)='bottom v-momentum above bed                   '
      Vname(3,idVbot)='meter second-1                                '
      Vname(4,idVbot)='bottom v-velocity, scalar, series             '
      Vname(5,idVbot)='ocean_time                                    '

      idUbed=80
      Fscale(idUbed)=1.0_r8
      Iinfo(1,idUbed)=u2dvar
      Vname(1,idUbed)='Ubed                                          '
      Vname(2,idUbed)='wind-induced, bed wave orbital u-velocity     '
      Vname(3,idUbed)='meter second-1                                '
      Vname(4,idUbed)='bed wave u-velocity, scalar, series           '
      Vname(5,idUbed)='ocean_time                                    '

      idVbed=81
      Fscale(idVbed)=1.0_r8
      Iinfo(1,idVbed)=v2dvar
      Vname(1,idVbed)='Vbed                                          '
      Vname(2,idVbed)='wind-induced, bed wave orbital v-velocity     '
      Vname(3,idVbed)='meter second-1                                '
      Vname(4,idVbed)='bed wave v-velocity, scalar, series           '
      Vname(5,idVbed)='ocean_time                                    '

      idAbed=82
      Fscale(idAbed)=1.0_r8
      Iinfo(1,idAbed)=r2dvar
      Vname(1,idAbed)='Abed                                          '
      Vname(2,idAbed)='wind-induced, bed wave excursion amplitude    '
      Vname(3,idAbed)='meter                                         '
      Vname(4,idAbed)='bed wave excursion, scalar, series            '
      Vname(5,idAbed)='ocean_time                                    '

      idZnot=83
      Fscale(idZnot)=1.0_r8
      Iinfo(1,idZnot)=r2dvar
      Vname(1,idZnot)='Zbnot                                         '
      Vname(2,idZnot)='hydraulic bottom roughness                    '
      Vname(3,idZnot)='meter                                         '
      Vname(4,idZnot)='bottom roughness, scalar, series              '
      Vname(5,idZnot)='ocean_time                                    '

      idZapp=84
      Fscale(idZapp)=1.0_r8
      Iinfo(1,idZapp)=r2dvar
      Vname(1,idZapp)='Zbnotc                                        '
      Vname(2,idZapp)='apparent hydraulic bottom roughness           '
      Vname(3,idZapp)='meter                                         '
      Vname(4,idZapp)='bottom roughness, scalar, series              '
      Vname(5,idZapp)='ocean_time                                    '

      idHrip=85
      Fscale(idHrip)=1.0_r8
      Iinfo(1,idHrip)=r2dvar
      Vname(1,idHrip)='Hripple                                       '
      Vname(2,idHrip)='bed ripple height                             '
      Vname(3,idHrip)='meter                                         '
      Vname(4,idHrip)='ripple height, scalar, series                 '
      Vname(5,idHrip)='ocean_time                                    '

      idLrip=86
      Fscale(idLrip)=1.0_r8
      Iinfo(1,idLrip)=r2dvar
      Vname(1,idLrip)='Lripple                                       '
      Vname(2,idLrip)='bed ripple length                             '
      Vname(3,idLrip)='meter                                         '
      Vname(4,idLrip)='ripple length, scalar, series                 '
      Vname(5,idLrip)='ocean_time                                    '

      idPair=87
      Fscale(idPair)=1.0_r8
      Iinfo(1,idPair)=r2dvar
      Vname(1,idPair)='Pair                                          '
      Vname(2,idPair)='surface air pressure                          '
      Vname(3,idPair)='millibar                                      '
      Vname(4,idPair)='Pair, scalar, series                          '
      Vname(5,idPair)='pair_time                                     '

      idTair=88
      Fscale(idTair)=1.0_r8
      Iinfo(1,idTair)=r2dvar
      Vname(1,idTair)='Tair                                          '
      Vname(2,idTair)='surface air temperature                       '
      Vname(3,idTair)='Celsius                                       '
      Vname(4,idTair)='Tair, scalar, series                          '
      Vname(5,idTair)='tair_time                                     '

      idQair=89
      Fscale(idQair)=0.01_r8
      Iinfo(1,idQair)=r2dvar
      Vname(1,idQair)='Qair                                          '
      Vname(2,idQair)='surface air relative humidity                 '
      Vname(3,idQair)='percentage                                    '
      Vname(4,idQair)='Qair, scalar, series                          '
      Vname(5,idQair)='qair_time                                     '

      idCfra=90
      Fscale(idCfra)=1.0_r8
      Iinfo(1,idCfra)=r2dvar
      Vname(1,idCfra)='cloud                                         '
      Vname(2,idCfra)='cloud fraction                                '
      Vname(3,idCfra)='nondimensional                                '
      Vname(4,idCfra)='cloud, scalar, series                         '
      Vname(5,idCfra)='cloud_time                                    '

      idrain=91
      Fscale(idrain)=1.0_r8
      Iinfo(1,idrain)=r2dvar
      Vname(1,idrain)='rain                                          '
      Vname(2,idrain)='rain fall rate                                '
      Vname(3,idrain)='kilogram meter-2 second-1                     '
      Vname(4,idrain)='rain, scalar, series                          '
      Vname(5,idrain)='rain_time                                     '

      idevap=92
      Fscale(idevap)=1.0_r8
      Iinfo(1,idevap)=r2dvar
      Vname(1,idevap)='evaporation                                   '
      Vname(2,idevap)='evaporation rate                              '
      Vname(3,idevap)='kilogram meter-2 second-1                     '
      Vname(4,idevap)='evaporation, scalar, series                   '
      Vname(5,idevap)='evap_time                                     '

      idSrad=93
      Fscale(idSrad)=1.0_r8/(rho0*Cp)
      Iinfo(1,idSrad)=r2dvar
      Vname(1,idSrad)='swrad                                         '
      Vname(2,idSrad)='solar shortwave radiation flux                '
      Vname(3,idSrad)='Watts meter-2                                 '
      Vname(4,idSrad)='shortwave radiation, scalar, series           '
      Vname(5,idSrad)='srf_time                                      '

      idLrad=94
      Fscale(idLrad)=1.0_r8/(rho0*Cp)
      Iinfo(1,idLrad)=r2dvar
      Vname(1,idLrad)='lwrad                                         '
      Vname(2,idLrad)='net longwave radiation flux                   '
      Vname(3,idLrad)='Watts meter-2                                 '
      Vname(4,idLrad)='longwave radiation, scalar, series            '
      Vname(5,idLrad)='lrf_time                                      '

      idLhea=95
      Fscale(idLhea)=1.0_r8/(rho0*Cp)
      Iinfo(1,idLhea)=r2dvar
      Vname(1,idLhea)='latent                                        '
      Vname(2,idLhea)='net latent heat flux                          '
      Vname(3,idLhea)='Watts meter-2                                 '
      Vname(4,idLhea)='latent heat flux, scalar, series              '
      Vname(5,idLhea)='lhf_time                                      '

      idShea=96
      Fscale(idShea)=1.0_r8/(rho0*Cp)
      Iinfo(1,idShea)=r2dvar
      Vname(1,idShea)='sensible                                      '
      Vname(2,idShea)='net sensible heat flux                        '
      Vname(3,idShea)='Watts meter-2                                 '
      Vname(4,idShea)='sensible heat flux, scalar, series            '
      Vname(5,idShea)='shf_time                                      '

      idTsur(itemp)=97
      ifield=idTsur(itemp)
      Fscale(ifield)=1.0_r8/(rho0*Cp)
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='shflux                                        '
      Vname(2,ifield)='surface net heat flux                         '
      Vname(3,ifield)='Watts meter-2                                 '
      Vname(4,ifield)='surface heat flux, scalar, series             '
      Vname(5,ifield)='shf_time                                      '

      idTsur(isalt)=98
      ifield=idTsur(isalt)
      Fscale(ifield)=0.01_r8/86400.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='swflux                                        '
      Vname(2,ifield)='surface net freshwater flux (E-P)             '
      Vname(3,ifield)='centimeter day-1                              '
      Vname(4,ifield)='surface freshwater flux, scalar, series       '
      Vname(5,ifield)='swf_time                                      '

      idTbot(itemp)=99
      ifield=idTbot(itemp)
      Fscale(ifield)=1.0_r8/(rho0*Cp)
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='bhflux                                        '
      Vname(2,ifield)='bottom net heat flux                          '
      Vname(3,ifield)='Watts meter-2                                 '
      Vname(4,ifield)='bottom heat flux, scalar, series              '
      Vname(5,ifield)='bhf_time                                      '

      idTbot(isalt)=100
      ifield=idTbot(isalt)
      Fscale(ifield)=0.01_r8/86550.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='bwflux                                        '
      Vname(2,ifield)='bottom net freshwater flux                    '
      Vname(3,ifield)='centimeter day-1                              '
      Vname(4,ifield)='bottom water flux, scalar, series             '
      Vname(5,ifield)='bwf_time                                      '

      idWamp=101
      Fscale(idWamp)=1.0_r8
      Iinfo(1,idWamp)=r2dvar
      Vname(1,idWamp)='Awave                                         '
      Vname(2,idWamp)='wind-induced wave amplitude                   '
      Vname(3,idWamp)='meter                                         '
      Vname(4,idWamp)='Awave, scalar, series                         '
      Vname(5,idWamp)='wave_time                                     '

      idWdir=102
      Fscale(idWdir)=deg2rad
      Iinfo(1,idWdir)=r2dvar
      Vname(1,idWdir)='Dwave                                         '
      Vname(2,idWdir)='wind-induced wave direction                   '
      Vname(3,idWdir)='degrees                                       '
      Vname(4,idWdir)='Dwave, scalar, series                         '
      Vname(5,idWdir)='wave_time                                     '

      idWper=103
      Fscale(idWper)=1.0_r8
      Iinfo(1,idWper)=r2dvar
      Vname(1,idWper)='Pwave                                         '
      Vname(2,idWper)='wind-induced wave Period                      '
      Vname(3,idWper)='second                                        '
      Vname(4,idWper)='Pwave, scalar, series                         '
      Vname(5,idWper)='wave_time                                     '

      idSsiz=104
      Fscale(idSsiz)=1.0_r8
      Iinfo(1,idSsiz)=r2dvar
      Vname(1,idSsiz)='Ssize                                         '
      Vname(2,idSsiz)='bottom sediment grain diameter size           '
      Vname(3,idSsiz)='meter                                         '
      Vname(4,idSsiz)='Ssize, scalar, series                         '
      Vname(5,idSsiz)='                                              '

      idSden=105
      Fscale(idSden)=1.0_r8
      Iinfo(1,idSden)=r2dvar
      Vname(1,idSden)='Sdens                                         '
      Vname(2,idSden)='bottom sediment grain density                 '
      Vname(3,idSden)='kilogram meter-3                              '
      Vname(4,idSden)='Sdens, scalar, series                         '
      Vname(5,idSden)='                                              '

      idSSSc=106
      Fscale(idSSSc)=1.0_r8
      Iinfo(1,idSSSc)=r2dvar
      Vname(1,idSSSc)='SSS                                           '
      Vname(2,idSSSc)='sea surface salinity                          '
      Vname(3,idSSSc)='PSU                                           '
      Vname(4,idSSSc)='SSS, scalar, series                           '
      Vname(5,idSSSc)='sss_time                                      '

      idSSTc=107
      Fscale(idSSTc)=1.0_r8
      Iinfo(1,idSSTc)=r2dvar
      Vname(1,idSSTc)='SST                                           '
      Vname(2,idSSTc)='sea surface temperature climatology           '
      Vname(3,idSSTc)='Celsius                                       '
      Vname(4,idSSTc)='SST, scalar, series                           '
      Vname(5,idSSTc)='sst_time                                      '

      idSSTo=108
      Fscale(idSSTo)=1.0_r8
      Iinfo(1,idSSTo)=r2dvar
      Vname(1,idSSTo)='SST                                           '
      Vname(2,idSSTo)='sea surface temperature observations          '
      Vname(3,idSSTo)='Celsius                                       '
      Vname(4,idSSTo)='SSTobs, scalar, series                        '
      Vname(5,idSSTo)='SSTobs_time                                   '

      idSSTe=109
      Fscale(idSSTe)=1.0_r8
      Iinfo(1,idSSTe)=r2dvar
      Vname(1,idSSTe)='SST_err                                       '
      Vname(2,idSSTe)='sea surface temperature error variance        '
      Vname(3,idSSTe)='nondimensional                                '
      Vname(4,idSSTe)='SST_err, scalar, series                       '
      Vname(5,idSSTe)='SSTobs_time                                   '

      iddQdT=110
      Fscale(iddQdT)=1.0_r8/(rho0*Cp)
      Iinfo(1,iddQdT)=r2dvar
      Vname(1,iddQdT)='dQdSST                                        '
      Vname(2,iddQdT)='surface net heat flux sensitivity to SST      '
      Vname(3,iddQdT)='Watts meter-2 Celsius-1                       '
      Vname(4,iddQdT)='dQdSST, scalar, series                        '
      Vname(5,iddQdT)='sst_time                                      '

      idSSHc=111
      Fscale(idSSHc)=1.0_r8
      Iinfo(1,idSSHc)=r2dvar
      Vname(1,idSSHc)='zeta                                          '
      Vname(2,idSSHc)='sea surface height climatology                '
      Vname(3,idSSHc)='meter                                         '
      Vname(4,idSSHc)='zeta, scalar, series                          '
      Vname(5,idSSHc)='temp_time                                     '

      idSSHo=112
      Fscale(idSSHo)=1.0_r8
      Iinfo(1,idSSHo)=r2dvar
      Vname(1,idSSHo)='SSH                                           '
      Vname(2,idSSHo)='sea surface height observations               '
      Vname(3,idSSHo)='meter                                         '
      Vname(4,idSSHo)='SSHobs, scalar, series                        '
      Vname(5,idSSHo)='SSHobs_time                                   '

      idSSHe=113
      Fscale(idSSHe)=1.0_r8
      Iinfo(1,idSSHe)=r2dvar
      Vname(1,idSSHe)='SSH_err                                       '
      Vname(2,idSSHe)='sea surface height error variance             '
      Vname(3,idSSHe)='nondimensional                                '
      Vname(4,idSSHe)='SSH_err, scalar, series                       '
      Vname(5,idSSHe)='SSHobs_time                                   '

      idSvar(isFsur)=114
      ifield=idSvar(isFsur)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='zeta_es                                       '
      Vname(2,ifield)='free-surface error subspace                   '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='zeta_es, scalar, series                       '
      Vname(5,ifield)='time                                          '

      idUice=115
      Fscale(idUice)=1.0_r8
      Iinfo(1,idUice)=u2dvar
      Vname(1,idUice)='uice                                          '
      Vname(2,idUice)='u-component of ice velocity                   '
      Vname(3,idUice)='meter sec-1                                   '
      Vname(4,idUice)='uice, scalar, series                          '
      Vname(5,idUice)='ice_time                                      '

      idVice=116
      Fscale(idVice)=1.0_r8
      Iinfo(1,idVice)=v2dvar
      Vname(1,idVice)='vice                                          '
      Vname(2,idVice)='v-component of ice velocity                   '
      Vname(3,idVice)='meter sec-1                                   '
      Vname(4,idVice)='vice, scalar, series                          '
      Vname(5,idVice)='ice_time                                      '

      idAice=117
      Fscale(idAice)=1.0_r8
      Iinfo(1,idAice)=r2dvar
      Vname(1,idAice)='aice                                          '
      Vname(2,idAice)='fraction of cell covered by ice               '
      Vname(3,idAice)='nondimensional                                '
      Vname(4,idAice)='aice, scalar, series                          '
      Vname(5,idAice)='ice_time                                      '

      idHice=118
      Fscale(idHice)=1.0_r8
      Iinfo(1,idHice)=r2dvar
      Vname(1,idHice)='hice                                          '
      Vname(2,idHice)='depth of ice cover                            '
      Vname(3,idHice)='meter                                         '
      Vname(4,idHice)='hice, scalar, series                          '
      Vname(5,idHice)='ice_time                                      '

      idHsno=119
      Fscale(idHsno)=1.0_r8
      Iinfo(1,idHsno)=r2dvar
      Vname(1,idHsno)='snow_thick                                    '
      Vname(2,idHsno)='depth of snow cover                           '
      Vname(3,idHsno)='meter                                         '
      Vname(4,idHsno)='snow_thick, scalar, series                    '
      Vname(5,idHsno)='ice_time                                      '

      idTice=120
      Fscale(idTice)=1.0_r8
      Iinfo(1,idTice)=r2dvar
      Vname(1,idTice)='tisrf                                         '
      Vname(2,idTice)='temperature of ice surface                    '
      Vname(3,idTice)='Kelvin                                        '
      Vname(4,idTice)='tsrf, scalar, series                          '
      Vname(5,idTice)='ice_time                                      '

      idTper=121
      Fscale(idTper)=3600.0_r8
      Iinfo(1,idTper)=0
      Vname(1,idTper)='tide_period                                   '
      Vname(2,idTper)='tidal period                                  '
      Vname(3,idTper)='hours                                         '
      Vname(4,idTper)='tide_period, scalar, series                   '
      Vname(5,idTper)='tide_period                                   '

      idTzam=122
      Fscale(idTzam)=1.0_r8
      Iinfo(1,idTzam)=r2dvar
      Vname(1,idTzam)='tide_Eamp                                     '
      Vname(2,idTzam)='tidal elevation amplitude                     '
      Vname(3,idTzam)='meter                                         '
      Vname(4,idTzam)='SSH_Tamp, scalar, series                      '
      Vname(5,idTzam)='tide_period                                   '

      idTzph=123
      Fscale(idTzph)=deg2rad
      Iinfo(1,idTzph)=r2dvar
      Vname(1,idTzph)='tide_Ephase                                   '
      Vname(2,idTzph)='tidal elevation phase angle                   '
      Vname(3,idTzph)='degrees                                       '
      Vname(4,idTzph)='SSH_Tphase, scalar, series                    '
      Vname(5,idTzph)='tide_period                                   '

      idTvph=124
      Fscale(idTvph)=deg2rad
      Iinfo(1,idTvph)=r2dvar
      Vname(1,idTvph)='tide_Cphase                                   '
      Vname(2,idTvph)='tidal current phase angle                     '
      Vname(3,idTvph)='degrees                                       '
      Vname(4,idTvph)='tide_Cphase, scalar, series                   '
      Vname(5,idTvph)='tide_period                                   '

      idTvan=125
      Fscale(idTvan)=deg2rad
      Iinfo(1,idTvan)=r2dvar
      Vname(1,idTvan)='tide_Cangle                                   '
      Vname(2,idTvan)='tidal current inclination angle               '
      Vname(3,idTvan)='degrees                                       '
      Vname(4,idTvan)='tide_Cangle, scalar, series                   '
      Vname(5,idTvan)='tide_period                                   '

      idTvma=126
      Fscale(idTvma)=1.0_r8
      Iinfo(1,idTvma)=r2dvar
      Vname(1,idTvma)='tide_Cmax                                     '
      Vname(2,idTvma)='maximum tidal current, ellipse major axis     '
      Vname(3,idTvma)='meter second-1                                '
      Vname(4,idTvma)='tide_Cmax, scalar, series                     '
      Vname(5,idTvma)='tide_period                                   '

      idTvmi=127
      Fscale(idTvmi)=1.0_r8
      Iinfo(1,idTvmi)=r2dvar
      Vname(1,idTvmi)='tide_Cmin                                     '
      Vname(2,idTvmi)='minimum tidal current, ellipse minor axis     '
      Vname(3,idTvmi)='meter second-1                                '
      Vname(4,idTvmi)='tide_Cmin, scalar, series                     '
      Vname(5,idTvmi)='tide_period                                   '

      idRxpo=128
      Fscale(idRxpo)=1.0_r8
      Iinfo(1,idRxpo)=0
      Vname(1,idRxpo)='river_Xposition                               '
      Vname(2,idRxpo)='river runoff  XI-positions at RHO-points      '
      Vname(3,idRxpo)='nondimensional                                '
      Vname(4,idRxpo)='river_Xposition, scalar                       '
      Vname(5,idRxpo)='river                                         '

      idRepo=129
      Fscale(idRepo)=1.0_r8
      Iinfo(1,idRepo)=0
      Vname(1,idRepo)='river_Eposition                               '
      Vname(2,idRepo)='river runoff ETA-positions at RHO-points      '
      Vname(3,idRepo)='nondimensional                                '
      Vname(4,idRepo)='river_Eposition                               '
      Vname(5,idRepo)='river                                         '

      idRdir=130
      Fscale(idRdir)=1.0_r8
      Iinfo(1,idRdir)=0
      Vname(1,idRdir)='river_direction                               '
      Vname(2,idRdir)='river runoff direction                        '
      Vname(3,idRdir)='nondimensional                                '
      Vname(4,idRdir)='river_direction, scalar                       '
      Vname(5,idRdir)='river                                         '

      idRvsh=131
      Fscale(idRvsh)=1.0_r8
      Iinfo(1,idRvsh)=0
      Vname(1,idRvsh)='river_Vshape                                  '
      Vname(2,idRvsh)='river runoff mass transport vertical profile  '
      Vname(3,idRvsh)='nondimensional                                '
      Vname(4,idRvsh)='river_Vshape, scalar                          '
      Vname(5,idRvsh)='river                                         '

      idRtra=132
      Fscale(idRtra)=1.0_r8
      Iinfo(1,idRtra)=0
      Vname(1,idRtra)='river_transport                               '
      Vname(2,idRtra)='river runoff mass transport                   '
      Vname(3,idRtra)='meter3 second-1                               '
      Vname(4,idRtra)='river_transport, scalar, series               '
      Vname(5,idRtra)='river_time                                    '

      idRflg=133
      Fscale(idRflg)=1.0_r8
      Iinfo(1,idRflg)=0
      Vname(1,idRflg)='river_flag                                    '
      Vname(2,idRflg)='river runoff flag                             '
      Vname(3,idRflg)='nondimensional                                '
      Vname(4,idRflg)='river_flag, scalar                            '
      Vname(5,idRflg)='river                                         '

      idRtrc(itemp)=134
      ifield=idRtrc(itemp)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='river_temp                                    '
      Vname(2,ifield)='river runoff potential temperature            '
      Vname(3,ifield)='Celsius                                       '
      Vname(4,ifield)='river_temp, scalar, series                    '
      Vname(5,ifield)='river_time                                    '

      idRtrc(isalt)=135
      ifield=idRtrc(isalt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=0
      Vname(1,ifield)='river_salt                                    '
      Vname(2,ifield)='river runoff salinity                         '
      Vname(3,ifield)='PSU                                           '
      Vname(4,ifield)='river_salt, scalar, series                    '
      Vname(5,ifield)='river_time                                    '

      ilast=135

#ifdef SEDIMENT
!
!---------------------------------------------------------------------
!  Define names of variables associated with sediment module.
!---------------------------------------------------------------------
!
      do i=1,NCS
        ilast=ilast+1
        idTvar(idmud(i))=ilast
        ifield=idTvar(idmud(i))
        Fscale(ifield)=1.0_r8
        Iinfo(1,ifield)=r3dvar
        write(Vname(1,ifield),10) 'mud_', i
  10    format(a4,i2.2)
        write(Vname(2,ifield),20) i
  20    format('suspended cohesive sediment, size class ',i2.2)
        Vname(3,ifield)='milligram liter-1'
        write(Vname(4,ifield),30) 'mud_', i
  30    format(a4,i2.2,', scalar, series')
        Vname(5,ifield)='ocean_time'
      enddo

      do i=1,NNS
        ilast=ilast+1
        idTvar(isand(i))=ilast
        ifield=idTvar(isand(i))
        Fscale(ifield)=1.0_r8
        Iinfo(1,ifield)=r3dvar
        write(Vname(1,ifield),40) 'sand_', i
  40    format(a5,i2.2)
        write(Vname(2,ifield),50) i
  50    format('suspended noncohesive sediment, size class ',i2.2)
        Vname(3,ifield)='milligram liter-1'
        write(Vname(4,ifield),60) 'sand_', i
  60    format(a5,i2.2,', scalar, series')
        Vname(5,ifield)='ocean_time'
      enddo

      do i=1,NCS
        ilast=ilast+1
        idfrac(i)=ilast
        ifield=idfrac(i)
        Fscale(ifield)=1.0_r8
        Iinfo(1,ifield)=b3dvar
        write(Vname(1,ifield),70) 'mudfrac_', i
  70    format(a8,i2.2)
        write(Vname(2,ifield),80) i
  80    format('cohesive sediment fraction, size class ',i2.2)
        Vname(3,ifield)='nondimensional'
        write(Vname(4,ifield),90) 'mudfrac_', i
  90    format(a8,i2.2,', scalar, series')
        Vname(5,ifield)='ocean_time'
      enddo

      do i=1,NNS
        ilast=ilast+1
        idfrac(NCS+i)=ilast
        ifield=idfrac(NCS+i)
        Fscale(ifield)=1.0_r8
        Iinfo(1,ifield)=b3dvar
        write(Vname(1,ifield),100) 'sandfrac_', i
 100    format(a9,i2.2)
        write(Vname(2,ifield),110) i
 110    format('noncohesive sediment fraction, size class ',i2.2)
        Vname(3,ifield)='nondimensional'
        write(Vname(4,ifield),120) 'sandfrac_', i
 120    format(a9,i2.2,', scalar, series')
        Vname(5,ifield)='ocean_time'
      enddo

      idSbed(ithck)=ilast+1
      ifield=idSbed(ithck)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=b3dvar
      Vname(1,ifield)='bed_thick                                     '
      Vname(2,ifield)='sediment layer thickness                      '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='bed_thick, scalar, series                     '
      Vname(5,ifield)='ocean_time                                    '

      idSbed(iaged)=ilast+2
      ifield=idSbed(iaged)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=b3dvar
      Vname(1,ifield)='bed_age                                       '
      Vname(2,ifield)='sediment layer age                            '
      Vname(3,ifield)='day                                           '
      Vname(4,ifield)='bed_thick, scalar, series                     '
      Vname(5,ifield)='ocean_time                                    '

      idSbed(iporo)=ilast+3
      ifield=idSbed(iporo)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=b3dvar
      Vname(1,ifield)='bed_poros                                     '
      Vname(2,ifield)='sediment layer porosity                       '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='bed_poros, scalar, series                     '
      Vname(5,ifield)='ocean_time                                    '

      idSbed(idiff)=ilast+4
      ifield=idSbed(idiff)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=b3dvar
      Vname(1,ifield)='bed_biodiff                                   '
      Vname(2,ifield)='biodiffusivity at bottom of each layer        '
      Vname(3,ifield)='meter2 second-1                               '
      Vname(4,ifield)='bed_biodiff, scalar, series                   '
      Vname(5,ifield)='ocean_time                                    '

      idBott(irlen)=ilast+5
      ifield=idBott(irlen)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='ripple_length                                 '
      Vname(2,ifield)='bottom ripple length                          '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='ripple_length, scalar, series                 '
      Vname(5,ifield)='ocean_time                                    '

      idBott(irhgt)=ilast+6
      ifield=idBott(irhgt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='ripple_height                                 '
      Vname(2,ifield)='bottom ripple height                          '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='ripple_height, scalar, series                 '
      Vname(5,ifield)='ocean_time                                    '

      idBott(ishgt)=ilast+7
      ifield=idBott(ishgt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='saltation                                     '
      Vname(2,ifield)='bottom saltation height                       '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='saltation, scalar, series                     '
      Vname(5,ifield)='ocean_time                                    '

      idBott(izNik)=ilast+8
      ifield=idBott(izNik)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='Zo_Nik                                        '
      Vname(2,ifield)='Nikaradse bottom roughness                    '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='Zo_Nik, scalar, series                        '
      Vname(5,ifield)='ocean_time                                    '

      idBott(izbio)=ilast+9
      ifield=idBott(izbio)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='Zo_bio                                        '
      Vname(2,ifield)='biological bottom roughness                   '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='Zo_bio, scalar, series                        '
      Vname(5,ifield)='ocean_time                                    '

      idBott(izbld)=ilast+10
      ifield=idBott(izbld)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='Zo_bedload                                    '
      Vname(2,ifield)='bed load bottom roughness                     '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='Zo_bedload, scalar, series                    '
      Vname(5,ifield)='ocean_time                                    '

      idBott(izbfm)=ilast+11
      ifield=idBott(izbfm)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='Zo_bedform                                    '
      Vname(2,ifield)='bed form bottom roughness                     '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='Zo_bedform, scalar, series                    '
      Vname(5,ifield)='ocean_time                                    '

      idBott(izapp)=ilast+12
      ifield=idBott(izapp)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='Zo_app                                        '
      Vname(2,ifield)='apparent bottom roughness                     '
      Vname(3,ifield)='meter                                         '
      Vname(4,ifield)='Zo_app, scalar, series                        '
      Vname(5,ifield)='ocean_time                                    '

      ilast=ilast+12
#endif /* SEDIMENT */
#ifdef BIO_FASHAM
!
!---------------------------------------------------------------------
!  Define names of variables associated with Fasham biological module.
!---------------------------------------------------------------------
!
      idTvar(iNO3_)=ilast+1
      ifield=idTvar(iNO3_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='NO3                                           '
      Vname(2,ifield)='nitrate concentration                         '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='NO3, scalar, series                           '
      Vname(5,ifield)='ocean_time                                    '

      idTclm(iNO3_)=ilast+2
      ifield=idTclm(iNO3_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='NO3                                           '
      Vname(2,ifield)='nitrate concentration climatology             '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='NO3, scalar, series                           '
      Vname(5,ifield)='NO3clm_time                                   '

      idTobs(iNO3_)=ilast+3
      ifield=idTobs(iNO3_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='NO3                                           '
      Vname(2,ifield)='nitrate concentration observations            '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='NO3, scalar, series                           '
      Vname(5,ifield)='NO3obs_time                                   '

      idTerr(iNO3_)=ilast+4
      ifield=idTerr(iNO3_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='NO3_err                                       '
      Vname(2,ifield)='nitrate concentration error variance          '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='NO3_err, scalar, series                       '
      Vname(5,ifield)='NO3obs_time                                   '

      idTsur(iNO3_)=ilast+5
      ifield=idTsur(iNO3_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='NO3_sflux                                     '
      Vname(2,ifield)='surface nitrate flux                          '
      Vname(3,ifield)='millimole nitrogen meter-2 day-1              '
      Vname(4,ifield)='surface nitrate flux, scalar, series          '
      Vname(5,ifield)='NO3sflux_time                                 '

      idTbot(iNO3_)=ilast+6
      ifield=idTbot(iNO3_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='NO3_bflux                                     '
      Vname(2,ifield)='bottom nitrate flux                           '
      Vname(3,ifield)='millimole nitrogen meter-2 day-1              '
      Vname(4,ifield)='bottom nitrate flux, scalar, series           '
      Vname(5,ifield)='NO3bflux_time                                 '

      idTvar(iPhyt)=ilast+7
      ifield=idTvar(iPhyt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='phytoplankton                                 '
      Vname(2,ifield)='phytoplankton concentration                   '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='phytoplankton, scalar, series                 '
      Vname(5,ifield)='ocean_time                                    '

      idTclm(iPhyt)=ilast+8
      ifield=idTclm(iPhyt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='phytoplankton                                 '
      Vname(2,ifield)='phytoplankton concentration climatology       '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='phytoplankton, scalar, series                 '
      Vname(5,ifield)='phyclm_time                                   '

      idTobs(iPhyt)=ilast+9
      ifield=idTobs(iPhyt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='phytoplankton                                 '
      Vname(2,ifield)='phytoplankton concentration observations      '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='phytoplankton, scalar, series                 '
      Vname(5,ifield)='phyobs_time                                   '

      idTerr(iPhyt)=ilast+10
      ifield=idTerr(iPhyt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='phytoplankton_err                             '
      Vname(2,ifield)='phytoplankton concentration error variance    '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='phytoplankton_err, scalar, series             '
      Vname(5,ifield)='phyobs_time                                   '

      idTsur(iPhyt)=ilast+11
      ifield=idTsur(iPhyt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='phytoplankton_sflux                           '
      Vname(2,ifield)='surface phytoplankton flux                    '
      Vname(3,ifield)='millimole nitrogen meter-2 day-1              '
      Vname(4,ifield)='surface phytoplankton flux, scalar, series    '
      Vname(5,ifield)='physflux_time                                 '

      idTbot(iPhyt)=ilast+12
      ifield=idTbot(iPhyt)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='phytoplankton_bflux                           '
      Vname(2,ifield)='bottom phytoplankton flux                     '
      Vname(3,ifield)='millimole nitrogen meter-2 day-1              '
      Vname(4,ifield)='bottom phytoplankton flux, scalar, series     '
      Vname(5,ifield)='phybflux_time                                 '

      idTvar(iZoop)=ilast+13
      ifield=idTvar(iZoop)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='zooplankton                                   '
      Vname(2,ifield)='zooplankton concentration                     '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='zooplankton, scalar, series                   '
      Vname(5,ifield)='ocean_time                                    '

      idTclm(iZoop)=ilast+14
      ifield=idTclm(iZoop)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='zooplankton                                   '
      Vname(2,ifield)='zooplankton concentration climatology         '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='zooplankton, scalar, series                   '
      Vname(5,ifield)='zooclm_time                                   '

      idTobs(iZoop)=ilast+15
      ifield=idTobs(iZoop)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='zooplankton                                   '
      Vname(2,ifield)='zooplankton concentration observations        '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='zooplankton, scalar, series                   '
      Vname(5,ifield)='zooobs_time                                   '

      idTerr(iZoop)=ilast+16
      ifield=idTerr(iZoop)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='zooplankton_err                               '
      Vname(2,ifield)='zooplankton concentration error variance      '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='zooplankton_err, scalar, series               '
      Vname(5,ifield)='zooobs_time                                   '

      idTsur(iZoop)=ilast+17
      ifield=idTsur(iZoop)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='zooplankton_sflux                             '
      Vname(2,ifield)='surface zooplankton flux                      '
      Vname(3,ifield)='millimole nitrogen meter-2 day-1              '
      Vname(4,ifield)='surface zooplankton flux, scalar, series      '
      Vname(5,ifield)='zoosflux_time                                 '

      idTbot(iZoop)=ilast+18
      ifield=idTbot(iZoop)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='zooplankton_bflux                             '
      Vname(2,ifield)='bottom zooplankton flux                       '
      Vname(3,ifield)='millimole nitrogen meter-2 day-1              '
      Vname(4,ifield)='bottom zooplankton flux, scalar, series       '
      Vname(5,ifield)='zoobflux_time                                 '

      idTvar(iNH4_)=ilast+19
      ifield=idTvar(iNH4_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='NH4                                           '
      Vname(2,ifield)='ammonium concentration                        '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='NH4, scalar, series                           '
      Vname(5,ifield)='ocean_time                                    '

      idTclm(iNH4_)=ilast+20
      ifield=idTclm(iNH4_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='NH4                                           '
      Vname(2,ifield)='ammonium concentration climatology            '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='NH4, scalar, series                           '
      Vname(5,ifield)='NH4clm_time                                   '

      idTobs(iNH4_)=ilast+21
      ifield=idTobs(iNH4_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='NH4                                           '
      Vname(2,ifield)='ammonium concentration observations           '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='NH4, scalar, series                           '
      Vname(5,ifield)='NH4obs_time                                   '

      idTerr(iNH4_)=ilast+22
      ifield=idTerr(iNH4_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='NH4_err                                       '
      Vname(2,ifield)='ammonium concentration error variance         '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='NH4_err, scalar, series                       '
      Vname(5,ifield)='NH4obs_time                                   '

      idTsur(iNH4_)=ilast+23
      ifield=idTsur(iNH4_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='NH4_sflux                                     '
      Vname(2,ifield)='surface ammonium flux                         '
      Vname(3,ifield)='millimole nitrogen meter-2 day-1              '
      Vname(4,ifield)='surface ammonium flux, scalar, series         '
      Vname(5,ifield)='NH4sflux_time                                 '

      idTbot(iNH4_)=ilast+24
      ifield=idTbot(iNH4_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='NH4_bflux                                     '
      Vname(2,ifield)='bottom ammonium flux                          '
      Vname(3,ifield)='millimole nitrogen meter-2 day-1              '
      Vname(4,ifield)='bottom ammonium flux, scalar, series          '
      Vname(5,ifield)='NH4bflux_time                                 '

      idTvar(iLDet)=ilast+25
      ifield=idTvar(iLDet)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Ldetritus                                     '
      Vname(2,ifield)='large fraction detritus concentration         '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='Ldetritus, scalar, series                     '
      Vname(5,ifield)='ocean_time                                    '

      idTclm(iLDet)=ilast+26
      ifield=idTclm(iLDet)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Ldetritus                                     '
      Vname(2,ifield)='large fraction detritus climatology           '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='Ldetritus, scalar, series                     '
      Vname(5,ifield)='Ldetclm_time                                  '

      idTobs(iLDet)=ilast+27
      ifield=idTobs(iLDet)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Ldetritus                                     '
      Vname(2,ifield)='large fraction detritus observations          '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='Ldetritus, scalar, series                     '
      Vname(5,ifield)='Ldetobs_time                                  '

      idTerr(iLDet)=ilast+28
      ifield=idTerr(iLDet)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Ldetritus_err                                 '
      Vname(2,ifield)='large fraction detritus error variance        '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='Ldetritus_err, scalar, series                 '
      Vname(5,ifield)='Ldetobs_time                                  '

      idTsur(iLDet)=ilast+29
      ifield=idTsur(iLDet)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='Ldetritus_sflux                               '
      Vname(2,ifield)='surface large detritus fraction flux          '
      Vname(3,ifield)='millimole nitrogen meter-2 day-1              '
      Vname(4,ifield)='surface Ldetritus flux, scalar, series        '
      Vname(5,ifield)='Ldetsflux_time                                '

      idTbot(iLDet)=ilast+30
      ifield=idTbot(iLDet)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='Ldetritus_bflux                               '
      Vname(2,ifield)='bottom large detritus fraction flux           '
      Vname(3,ifield)='millimole nitrogen meter-2 day-1              '
      Vname(4,ifield)='bottom Ldetritus flux, scalar, series         '
      Vname(5,ifield)='Ldetbflux_time                                '

      idTvar(iSDet)=ilast+31
      ifield=idTvar(iSDet)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Sdetritus                                     '
      Vname(2,ifield)='small fraction detritus concentration         '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='Sdetritus, scalar, series                     '
      Vname(5,ifield)='ocean_time                                    '

      idTclm(iSDet)=ilast+32
      ifield=idTclm(iSDet)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Sdetritus                                     '
      Vname(2,ifield)='small fraction detritus climatology           '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='Sdetritus, scalar, series                     '
      Vname(5,ifield)='Sdetclm_time                                  '

      idTobs(iSDet)=ilast+33
      ifield=idTobs(iSDet)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Sdetritus                                     '
      Vname(2,ifield)='small fraction detritus observations          '
      Vname(3,ifield)='millimole nitrogen meter-3                    '
      Vname(4,ifield)='Sdetritus, scalar, series                     '
      Vname(5,ifield)='Sdetobs_time                                  '

      idTerr(iSDet)=ilast+34
      ifield=idTerr(iSDet)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Sdetritus_err                                 '
      Vname(2,ifield)='small fraction detritus error variance        '
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='Sdetritus_err, scalar, series                 '
      Vname(5,ifield)='Sdetobs_time                                  '

      idTsur(iSDet)=ilast+35
      ifield=idTsur(iSDet)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='Sdetritus_sflux                               '
      Vname(2,ifield)='surface small detritus fraction flux          '
      Vname(3,ifield)='millimole nitrogen meter-2 day-1              '
      Vname(4,ifield)='surface Sdetritus flux, scalar, series        '
      Vname(5,ifield)='Sdetsflux_time                                '

      idTbot(iSDet)=ilast+36
      ifield=idTbot(iSDet)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='Sdetritus_bflux                               '
      Vname(2,ifield)='bottom small detritus fraction flux           '
      Vname(3,ifield)='millimole nitrogen meter-2 day-1              '
      Vname(4,ifield)='bottom Sdetritus flux, scalar, series         '
      Vname(5,ifield)='Sdetbflux_time                                '

      idTvar(iChlo)=ilast+37
      ifield=idTvar(iChlo)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='CPratio                                       '
      Vname(2,ifield)='chlorophyll-phytoplankton ratio               '
      Vname(3,ifield)='milligrams chlorophill millimole-1 carbon-1   '
      Vname(4,ifield)='CPratio, scalar, series                       '
      Vname(5,ifield)='ocean_time                                    '

      idTclm(iChlo)=ilast+38
      ifield=idTclm(iChlo)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='CPratio                                       '
      Vname(2,ifield)='chlorophyll-phytoplankton ratio climatology   '
      Vname(3,ifield)='milligrams chlorophill millimole-1 carbon-1   '
      Vname(4,ifield)='CPratio, scalar, series                       '
      Vname(5,ifield)='CPrclm_time                                   '

      idTobs(iChlo)=ilast+39
      ifield=idTobs(iChlo)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='CPratio                                       '
      Vname(2,ifield)='chlorophyll-phytoplankton ratio observations  '
      Vname(3,ifield)='milligram chlorophill millimole-1 carbon-1    '
      Vname(4,ifield)='CPratio, scalar, series                       '
      Vname(5,ifield)='CProbs_time                                   '

      idTerr(iChlo)=ilast+40
      ifield=idTerr(iChlo)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='CPratio_err                                   '
      Vname(2,ifield)='chlorophyll-phytoplankton ratio error variance'
      Vname(3,ifield)='nondimensional                                '
      Vname(4,ifield)='CPratio_err, scalar, series                   '
      Vname(5,ifield)='CProbs_time                                   '

      idTsur(iChlo)=ilast+41
      ifield=idTsur(iChlo)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='CPratio_sflux                                 '
      Vname(2,ifield)='surface chlrophill-phytoplankton ratio flux   '
      Vname(3,ifield)='day-1                                         '
      Vname(4,ifield)='surface CPratio flux, scalar, series          '
      Vname(5,ifield)='CPrsflux_time                                 '

      idTbot(iChlo)=ilast+42
      ifield=idTbot(iChlo)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r2dvar
      Vname(1,ifield)='CPratio_bflux                                 '
      Vname(2,ifield)='bottom chlrophill-phytoplankton ratio flux    '
      Vname(3,ifield)='day-1                                         '
      Vname(4,ifield)='bottom CPratio flux, scalar, series           '
      Vname(5,ifield)='CPrbflux_time                                 '

      ilast=ilast+42
#elif defined ECOSIM
!
!---------------------------------------------------------------------
!  Define names of variables associated with bio-optical module.
!---------------------------------------------------------------------
!
      idTvar(iNO3_)=ilast+1
      ifield=idTvar(iNO3_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='NO3                                           '
      Vname(2,ifield)='Nitrate concentration                         '
      Vname(3,ifield)='millimole Nitrate concentration meter-3       '
      Vname(4,ifield)='Nitrate concentration, scalar, series         '

      idTvar(iNH4_)=ilast+2
      ifield=idTvar(iNH4_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='NH4                                           '
      Vname(2,ifield)='Ammonium concentration                        '
      Vname(3,ifield)='millimole Ammonium concentration meter-3      '
      Vname(4,ifield)='Ammonium concentration, scalar, series        '

      idTvar(iPO4_)=ilast+3
      ifield=idTvar(iPO4_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PO4                                           '
      Vname(2,ifield)='Phosphate concentration                       '
      Vname(3,ifield)='millimole Phosphate concentration meter-3     '
      Vname(4,ifield)='Phosphate concentration, scalar, series       '

      idTvar(iFeO_)=ilast+4
      ifield=idTvar(iFeO_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='FeO                                           '
      Vname(2,ifield)='Iron concentration                            '
      Vname(3,ifield)='millimole Iron concentration meter-3          '
      Vname(4,ifield)='Iron concentration, scalar, series            '

      idTvar(iSiO_)=ilast+5
      ifield=idTvar(iSiO_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='SiO                                           '
      Vname(2,ifield)='Silica concentration                          '
      Vname(3,ifield)='millimole Silica concentration meter-3        '
      Vname(4,ifield)='Silica concentration, scalar, series          '

      idTvar(iDIC_)=ilast+6
      ifield=idTvar(iDIC_)
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='DIC                                           '
      Vname(2,ifield)='DIC concentration                             '
      Vname(3,ifield)='millimole DIC concentration meter-3           '
      Vname(4,ifield)='DIC concentration, scalar, series             '

      idTvar(iBacC(1))=ilast+7
      ifield=idTvar(iBacC(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='BacC1                                         '
      Vname(2,ifield)='Bacteria(1) Carbon Group                      '
      Vname(3,ifield)='millimole Carbon meter-3                      '
      Vname(4,ifield)='Bacteria(1) Carbon Group, scalar, series      '

      idTvar(iBacF(1))=ilast+8
      ifield=idTvar(iBacF(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='BacF1                                         '
      Vname(2,ifield)='Bacteria(1) Iron Group                        '
      Vname(3,ifield)='millimole Iron meter-3                        '
      Vname(4,ifield)='Bacteria(1) Iron Group, scalar, series        '

      idTvar(iBacN(1))=ilast+9
      ifield=idTvar(iBacN(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='BacN1                                         '
      Vname(2,ifield)='Bacteria(1) Nitrogen Group                    '
      Vname(3,ifield)='millimole Nitrogen meter-3                    '
      Vname(4,ifield)='Bacteria(1) Nitrogen Group, scalar, series    '

      idTvar(iBacP(1))=ilast+10
      ifield=idTvar(iBacP(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='BacP1                                         '
      Vname(2,ifield)='Bacteria(1) Phosphorus Group                  '
      Vname(3,ifield)='millimole Phosphorus meter-3                  '
      Vname(4,ifield)='Bacteria(1) Phosphorus Group, scalar, series  '

      idTvar(iCDMC(1))=ilast+11
      ifield=idTvar(iCDMC(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='CDMC1                                         '
      Vname(2,ifield)='Color Degradational Matter(1)                 '
      Vname(3,ifield)='millimole CDMC meter-3                        '
      Vname(4,ifield)='Color Degradational Matter(1), scalar, series '

      idTvar(iCDMC(2))=ilast+12
      ifield=idTvar(iCDMC(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='CDMC2                                         '
      Vname(2,ifield)='Color Degradational Matter(2)                 '
      Vname(3,ifield)='millimole CDMC meter-3                        '
      Vname(4,ifield)='Color Degradational Matter(2), scalar, series '

      idTvar(iDOMC(1))=ilast+13
      ifield=idTvar(iDOMC(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='DOMC1                                         '
      Vname(2,ifield)='Dissolved Organic Matter(1) Carbon Group      '
      Vname(3,ifield)='millimole Carbon meter-3                      '
      Vname(4,ifield)='DOMC1, scalar, series                         '

      idTvar(iDOMC(2))=ilast+14
      ifield=idTvar(iDOMC(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='DOMC2                                         '
      Vname(2,ifield)='Dissolved Organic Matter(2) Carbon Group      '
      Vname(3,ifield)='millimole Carbon meter-3                      '
      Vname(4,ifield)='DOMC2, scalar, series                         '

      idTvar(iDOMN(1))=ilast+15
      ifield=idTvar(iDOMN(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='DOMN1                                         '
      Vname(2,ifield)='Dissolved Organic Matter(1) Nitrogen Group    '
      Vname(3,ifield)='millimole Nitrogen meter-3                    '
      Vname(4,ifield)='DOMN1, scalar, series                         '

      idTvar(iDOMN(2))=ilast+16
      ifield=idTvar(iDOMN(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='DOMN2                                         '
      Vname(2,ifield)='Dissolved Organic Matter(2) Nitrogen Group    '
      Vname(3,ifield)='millimole Nitrogen meter-3                    '
      Vname(4,ifield)='DOMN2, scalar, series                         '

      idTvar(iDOMP(1))=ilast+17
      ifield=idTvar(iDOMP(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='DOMP1                                         '
      Vname(2,ifield)='Dissolved Organic Matter(1) Phosphorus Group  '
      Vname(3,ifield)='millimole Phosphorus meter-3                  '
      Vname(4,ifield)='DOMP1, scalar, series                         '

      idTvar(iDOMP(2))=ilast+18
      ifield=idTvar(iDOMP(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='DOMP2                                         '
      Vname(2,ifield)='Dissolved Organic Matter(2) Phosphorus Group  '
      Vname(3,ifield)='millimole Phosphorus meter-3                  '
      Vname(4,ifield)='DOMP2, scalar, series                         '

      idTvar(iFecC(1))=ilast+19
      ifield=idTvar(iFecC(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='FecC1                                         '
      Vname(2,ifield)='Fecal Matter(1) Carbon Group                  '
      Vname(3,ifield)='millimole Carbon meter-3                      '
      Vname(4,ifield)='FecC1, scalar, series                         '

      idTvar(iFecC(2))=ilast+20
      ifield=idTvar(iFecC(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='FecC2                                         '
      Vname(2,ifield)='Fecal Matter(2) Carbon Group                  '
      Vname(3,ifield)='millimole Carbon meter-3                      '
      Vname(4,ifield)='FecC2, scalar, series                         '

      idTvar(iFecF(1))=ilast+21
      ifield=idTvar(iFecF(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='FecF1                                         '
      Vname(2,ifield)='Fecal Matter(1) Iron Group                    '
      Vname(3,ifield)='millimole Iron meter-3                        '
      Vname(4,ifield)='FecF1, scalar, series                         '

      idTvar(iFecF(2))=ilast+22
      ifield=idTvar(iFecF(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='FecF2                                         '
      Vname(2,ifield)='Fecal Matter(2) Iron Group                    '
      Vname(3,ifield)='millimole Iron meter-3                        '
      Vname(4,ifield)='FecF2, scalar, series                         '

      idTvar(iFecN(1))=ilast+23
      ifield=idTvar(iFecN(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='FecN1                                         '
      Vname(2,ifield)='Fecal Matter(1) Nitrogen Group                '
      Vname(3,ifield)='millimole Nitrogen meter-3                    '
      Vname(4,ifield)='FecN1, scalar, series                         '

      idTvar(iFecN(2))=ilast+24
      ifield=idTvar(iFecN(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='FecN2                                         '
      Vname(2,ifield)='Fecal Matter(2) Nitrogen Group                '
      Vname(3,ifield)='millimole Nitrogen meter-3                    '
      Vname(4,ifield)='FecN2, scalar, series                         '

      idTvar(iFecP(1))=ilast+25
      ifield=idTvar(iFecP(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='FecP1                                         '
      Vname(2,ifield)='Fecal Matter(1) Phosphorus Group              '
      Vname(3,ifield)='millimole Phosphorus meter-3                  '
      Vname(4,ifield)='FecP1, scalar, series                         '

      idTvar(iFecP(2))=ilast+26
      ifield=idTvar(iFecP(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='FecP2                                         '
      Vname(2,ifield)='Fecal Matter(2) Phosphorus Group              '
      Vname(3,ifield)='millimole Phosphorus meter-3                  '
      Vname(4,ifield)='FecP2, scalar, series                         '

      idTvar(iFecS(1))=ilast+27
      ifield=idTvar(iFecS(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='FecS1                                         '
      Vname(2,ifield)='Fecal Matter(1) Silica Group                  '
      Vname(3,ifield)='millimole Silica meter-3                      '
      Vname(4,ifield)='FecS1, scalar, series                         '

      idTvar(iFecS(2))=ilast+28
      ifield=idTvar(iFecS(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='FecS2                                         '
      Vname(2,ifield)='Fecal Matter(2) Silica Group                  '
      Vname(3,ifield)='millimole Silica meter-3                      '
      Vname(4,ifield)='FecS2, scalar, series                         '

      idTvar(iPhyC(1))=ilast+29
      ifield=idTvar(iPhyC(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyC1                                         '
      Vname(2,ifield)='Phytoplankton(1) Carbon Group                 '
      Vname(3,ifield)='millimole Carbon meter-3                      '
      Vname(4,ifield)='PhyC1, scalar, series                         '

      idTvar(iPhyC(2))=ilast+30
      ifield=idTvar(iPhyC(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyC2                                         '
      Vname(2,ifield)='Phytoplankton(2) Carbon Group                 '
      Vname(3,ifield)='millimole Carbon meter-3                      '
      Vname(4,ifield)='PhyC2, scalar, series                         '

      idTvar(iPhyC(3))=ilast+31
      ifield=idTvar(iPhyC(3))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyC3                                         '
      Vname(2,ifield)='Phytoplankton(3) Carbon Group                 '
      Vname(3,ifield)='millimole Carbon meter-3                      '
      Vname(4,ifield)='PhyC3, scalar, series                         '

      idTvar(iPhyC(4))=ilast+32
      ifield=idTvar(iPhyC(4))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyC4                                         '
      Vname(2,ifield)='Phytoplankton(4) Carbon Group                 '
      Vname(3,ifield)='millimole Carbon meter-3                      '
      Vname(4,ifield)='PhyC4, scalar, series                         '

      idTvar(iPhyF(1))=ilast+33
      ifield=idTvar(iPhyF(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyF1                                         '
      Vname(2,ifield)='Phytoplankton(1) Iron Group                   '
      Vname(3,ifield)='millimole Iron meter-3                        '
      Vname(4,ifield)='PhyF1, scalar, series                         '

      idTvar(iPhyF(2))=ilast+34
      ifield=idTvar(iPhyF(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyF2                                         '
      Vname(2,ifield)='Phytoplankton(2) Iron Group                   '
      Vname(3,ifield)='millimole Iron meter-3                        '
      Vname(4,ifield)='PhyF2, scalar, series                         '

      idTvar(iPhyF(3))=ilast+35
      ifield=idTvar(iPhyF(3))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyF3                                         '
      Vname(2,ifield)='Phytoplankton(3) Iron Group                   '
      Vname(3,ifield)='millimole Iron meter-3                        '
      Vname(4,ifield)='PhyF3, scalar, series                         '

      idTvar(iPhyF(4))=ilast+36
      ifield=idTvar(iPhyF(4))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyF4                                         '
      Vname(2,ifield)='Phytoplankton(4) Iron Group                   '
      Vname(3,ifield)='millimole Iron meter-3                        '
      Vname(4,ifield)='PhyF4, scalar, series                         '

      idTvar(iPhyN(1))=ilast+37
      ifield=idTvar(iPhyN(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyN1                                         '
      Vname(2,ifield)='Phytoplankton(1) Nitrogen Group               '
      Vname(3,ifield)='millimole Nitrogen meter-3                    '
      Vname(4,ifield)='PhyN1, scalar, series                         '

      idTvar(iPhyN(2))=ilast+38
      ifield=idTvar(iPhyN(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyN2                                         '
      Vname(2,ifield)='Phytoplankton(2) Nitrogen Group               '
      Vname(3,ifield)='millimole Nitrogen meter-3                    '
      Vname(4,ifield)='PhyN2, scalar, series                         '

      idTvar(iPhyN(3))=ilast+39
      ifield=idTvar(iPhyN(3))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyN3                                         '
      Vname(2,ifield)='Phytoplankton(3) Nitrogen Group               '
      Vname(3,ifield)='millimole Nitrogen meter-3                    '
      Vname(4,ifield)='PhyN3, scalar, series                         '

      idTvar(iPhyN(4))=ilast+40
      ifield=idTvar(iPhyN(4))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyN4                                         '
      Vname(2,ifield)='Phytoplankton(4) Nitrogen Group               '
      Vname(3,ifield)='millimole Nitrogen meter-3                    '
      Vname(4,ifield)='PhyN4, scalar, series                         '

      idTvar(iPhyP(1))=ilast+41
      ifield=idTvar(iPhyP(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyP1                                         '
      Vname(2,ifield)='Phytoplankton(1) Phosphorus Group             '
      Vname(3,ifield)='millimole Phosphorus meter-3                  '
      Vname(4,ifield)='PhyP1, scalar, series                         '

      idTvar(iPhyP(2))=ilast+42
      ifield=idTvar(iPhyP(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyP2                                         '
      Vname(2,ifield)='Phytoplankton(2) Phosphorus Group             '
      Vname(3,ifield)='millimole Phosphorus meter-3                  '
      Vname(4,ifield)='PhyP2, scalar, series                         '

      idTvar(iPhyP(3))=ilast+43
      ifield=idTvar(iPhyP(3))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyP3                                         '
      Vname(2,ifield)='Phytoplankton(3) Phosphorus Group             '
      Vname(3,ifield)='millimole Phosphorus meter-3                  '
      Vname(4,ifield)='PhyP3, scalar, series                         '

      idTvar(iPhyP(4))=ilast+44
      ifield=idTvar(iPhyP(4))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyP4                                         '
      Vname(2,ifield)='Phytoplankton(4) Phosphorus Group             '
      Vname(3,ifield)='millimole Phosphorus meter-3                  '
      Vname(4,ifield)='PhyP4, scalar, series                         '

      idTvar(iPhyS(1))=ilast+45
      ifield=idTvar(iPhyS(1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyS1                                         '
      Vname(2,ifield)='Phytoplankton(1) Silica Group                 '
      Vname(3,ifield)='millimole Silica meter-3                      '
      Vname(4,ifield)='PhyS1, scalar, series                         '

      idTvar(iPhyS(2))=ilast+46
      ifield=idTvar(iPhyS(2))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='PhyS2                                         '
      Vname(2,ifield)='Phytoplankton(2) Silica Group                 '
      Vname(3,ifield)='millimole Silica meter-3                      '
      Vname(4,ifield)='PhyS2, scalar, series                         '

      idTvar(iPigs(1,1))=ilast+47
      ifield=idTvar(iPigs(1,1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs11                                        '
      Vname(2,ifield)='Phytoplankton(1) Pigment(1)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs11, scalar, series                        '

      idTvar(iPigs(2,1))=ilast+48
      ifield=idTvar(iPigs(2,1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs21                                        '
      Vname(2,ifield)='Phytoplankton(2) Pigment(1)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs21, scalar, series                        '

      idTvar(iPigs(3,1))=ilast+49
      ifield=idTvar(iPigs(3,1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs31                                        '
      Vname(2,ifield)='Phytoplankton(3) Pigment(1)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs31, scalar, series                        '

      idTvar(iPigs(4,1))=ilast+50
      ifield=idTvar(iPigs(4,1))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs41                                        '
      Vname(2,ifield)='Phytoplankton(4) Pigment(1)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs41, scalar, series                        '

      idTvar(iPigs(1,3))=ilast+51
      ifield=idTvar(iPigs(1,3))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs13                                        '
      Vname(2,ifield)='Phytoplankton(1) Pigment(3)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs13, scalar, series                        '

      idTvar(iPigs(2,3))=ilast+52
      ifield=idTvar(iPigs(2,3))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs23                                        '
      Vname(2,ifield)='Phytoplankton(2) Pigment(3)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs23, scalar, series                        '

      idTvar(iPigs(3,3))=ilast+53
      ifield=idTvar(iPigs(3,3))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs33                                        '
      Vname(2,ifield)='Phytoplankton(3) Pigment(3)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs33, scalar, series                        '

      idTvar(iPigs(1,4))=ilast+54
      ifield=idTvar(iPigs(1,4))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs14                                        '
      Vname(2,ifield)='Phytoplankton(1) Pigment(4)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs14, scalar, series                        '

      idTvar(iPigs(2,4))=ilast+55
      ifield=idTvar(iPigs(2,4))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs24                                        '
      Vname(2,ifield)='Phytoplankton(2) Pigment(4)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs24, scalar, series                        '

      idTvar(iPigs(3,4))=ilast+56
      ifield=idTvar(iPigs(3,4))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs34                                        '
      Vname(2,ifield)='Phytoplankton(3) Pigment(4)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs34, scalar, series                        '

      idTvar(iPigs(1,5))=ilast+57
      ifield=idTvar(iPigs(1,5))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs15                                        '
      Vname(2,ifield)='Phytoplankton(1) Pigment(5)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs15, scalar, series                        '

      idTvar(iPigs(2,5))=ilast+58
      ifield=idTvar(iPigs(2,5))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs25                                        '
      Vname(2,ifield)='Phytoplankton(2) Pigment(5)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs25, scalar, series                        '

      idTvar(iPigs(3,5))=ilast+59
      ifield=idTvar(iPigs(3,5))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs35                                        '
      Vname(2,ifield)='Phytoplankton(3) Pigment(5)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs35, scalar, series                        '

      idTvar(iPigs(4,5))=ilast+60
      ifield=idTvar(iPigs(4,5))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs45                                        '
      Vname(2,ifield)='Phytoplankton(4) Pigment(5)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs45, scalar, series                        '

      idTvar(iPigs(4,7))=ilast+61
      ifield=idTvar(iPigs(4,7))
      Fscale(ifield)=1.0_r8
      Iinfo(1,ifield)=r3dvar
      Vname(1,ifield)='Pigs47                                        '
      Vname(2,ifield)='Phytoplankton(4) Pigment(7)                   '
      Vname(3,ifield)='milligrams meter-3                            '
      Vname(4,ifield)='Pigs47, scalar, series                        '

      ilast=ilast+61
#endif
      if (ilast.gt.MV) then
        write(stdout,130) MV, ilast
 130    format(/,' INIT_SCALARS - too small dimension parameter,',
     &           ' MV = ',2i5,/,11x,
     &           'change file  ncparam.h  and recompile.')
      endif
      return
      end

