#include "cppdefs.h"
       subroutine init_floats
#ifdef FLOATS
!
!================================================== John M. Klinck ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine reads in and process initial float locations from    !
!  input floats script.                                              !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "floats.h"
# include "grid.h"
# include "iounits.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Ncount, i, icard, iunit, j, k, lstr, mc, nc
      INTEGER_TYPE
     &        Fcoor(Mfloats), Ftype(Mfloats), Fcount(Mfloats),
     &        index(Mfloats)
      INTEGER_TYPE
     &        lenstr
      REAL_TYPE
     &        xfloat, yfloat, zfloat
      REAL_TYPE
     &        Ft0(Mfloats), Fx0(Mfloats), Fy0(Mfloats), Fz0(Mfloats),
     &        Fdt(Mfloats), Fdx(Mfloats), Fdy(Mfloats), Fdz(Mfloats),
     &        Ip0(Mfloats), Jp0(Mfloats), lat(Mfloats), lon(Mfloats)
      character*35 frmt
      parameter (iunit=50)
!
      k=0
!
!---------------------------------------------------------------------
!  Read in initial float locations.
!---------------------------------------------------------------------
!
      lstr=lenstr(fposnam)
      open(iunit,file=fposnam(1:lstr),form='formatted',status='old')
      write(stdout,10)
  10  format(/,' FLOATS processing parameters:',/)
!
!  Read input parameters according to their input card number.
!
      icard=0
      do while (icard.lt.99)
!
!  Read in floats identification title.
!
        if (icard.eq.1) then
          read(iunit,'(a)',err=70) Ftitle
          lstr=lenstr(Ftitle)
          write(stdout,20) Ftitle(1:lstr)
  20      format(1x,'(',a,')',/)
!
!  Read in restart switch.
!
        elseif (icard.eq.2) then
          read(iunit,*) frrec
!
!  Read in initial floats location.
!
        elseif (icard.eq.3) then
          i=0
          nfloats=0
          write(stdout,30)
 30       format(15x,'Ft0',5x,'Fx0',5x,'Fy0',5x,'Fz0',
     &            6x,'Fdt',6x,'Fdx',6x,'Fdy',6x,'Fdz',/)
          do while (.true.)
            i=i+1
            read(iunit,*,err=40) Ft0(i), Fx0(i), Fy0(i), Fz0(i),
     &                           Fcoor(i), Ftype(i), Fcount(i),
     &                           Fdt(i), Fdx(i), Fdy(i), Fdz(i)
            nfloats=nfloats+Fcount(i)
            if (.not.spherical.and.(Fcoor(i).eq.1)) then
              frmt='(i1,i2,i5,f10.4,2f8.0,f8.2,4f9.3)'
            else
              frmt='(i1,i2,i5,f10.4,3f8.2,4f9.3)'
            endif
            write(stdout,frmt) Fcoor(i), Ftype(i), Fcount(i),
     &                         Ft0(i), Fx0(i), Fy0(i), Fz0(i),
     &                         Fdt(i), Fdx(i), Fdy(i), Fdz(i)
          enddo
  40      if (Ft0(i).ne.99.0_r8) then
            write(stdout,50) icard, i, fposnam
  50        format(/,' INIT_FLOATS - error while reading input card: ',
     &             i2, ', floats location entry: ',i3,/,15x,
     &             'in input script: ',a)
            stop
          else
            Ncount=i-1
            goto 90
          endif
          if (Mfloats.lt.nfloats) then
            write(stdout,60) Mfloats, nfloats
  60        format(/,' INIT_FLOATS - too small dimension parameter,',
     &             ' Mfloats',2i6,/,15x,'change file  param.h  and',
     &             ' recompile.')
            stop
          endif
        endif
!
!  Read next input card ID.
!
        read(iunit,*,err=70) icard
      enddo
      goto 90
!
!  Error while reading input parameters.
!
  70  write(stdout,80) icard, fposnam
  80  format(/,' INIT_FLOATS - error while reading input card: ',
     &       i2,15x,'in input script: ',a)
  90  close(iunit)
      write(stdout,100) nfloats
 100  format(/,2x,i6,4x,'nfloats',t26,
     &       'Number of float trajectories to compute.',/)
!
!---------------------------------------------------------------------
!  Set initial float location.
!---------------------------------------------------------------------
!
!  Set time of float release (seconds after model initialization) and
!  initial float horizontal positions (grid units).  Fill the initial
!  vertical level or depth position.
!
      mc=0
      nc=0
      do i=1,Ncount
        if (Fcount(i).eq.1) then
          nc=nc+1
          Tinfo(itstr,nc)=(dstart+Ft0(i))*day2sec
          Tinfo(izgrd,nc)=Fz0(i)
          if (Fcoor(i).eq.0) then
            Tinfo(ixgrd,nc)=MIN(MAX(0.5_r8,Fx0(i)),FLOAT(Lm)+0.5_r8)
            Tinfo(iygrd,nc)=MIN(MAX(0.5_r8,Fy0(i)),FLOAT(Mm)+0.5_r8)
          else
            mc=mc+1
            lon(mc)=Fx0(i)
            lat(mc)=Fy0(i)
            index(mc)=nc
          endif
        elseif (Fcount(i).gt.1) then
          do j=1,Fcount(i)
            nc=nc+1
            if (Fdt(i).gt.0.0_r8) then
              Tinfo(itstr,nc)=(dstart+Ft0(i)+FLOAT(j-1)*Fdt(i))*
     &                        day2sec
              Tinfo(izgrd,nc)=Fz0(i)
              if (Fcoor(i).eq.0) then
                Tinfo(ixgrd,nc)=MIN(MAX(0.5_r8,Fx0(i)),FLOAT(Lm)+0.5_r8)
                Tinfo(iygrd,nc)=MIN(MAX(0.5_r8,Fy0(i)),FLOAT(Mm)+0.5_r8)
              else
                mc=mc+1
                lon(mc)=Fx0(i)
                lat(mc)=Fy0(i)
                index(mc)=nc
              endif
            else
              Tinfo(itstr,nc)=(dstart+Ft0(i))*day2sec
              if (Fdz(i).eq.0.0_r8) then
                Tinfo(izgrd,nc)=Fz0(i)
              else
                if (Fz0(i).gt.0.0_r8) then
                  zfloat=Fz0(i)+FLOAT(j-1)*Fdz(i)
                  Tinfo(izgrd,nc)=MIN(MAX(0.0_r8,zfloat),FLOAT(N))
                else
                  Tinfo(izgrd,nc)=Fz0(i)+FLOAT(j-1)*Fdz(i)
                endif
              endif
              if (Fcoor(i).eq.0) then
                  xfloat=Fx0(i)+FLOAT(j-1)*Fdx(i)
                  Tinfo(ixgrd,nc)=MIN(MAX(0.5_r8,xfloat),
     &                                FLOAT(Lm)+0.5_r8)
                  yfloat=Fy0(i)+FLOAT(j-1)*Fdy(i)
                  Tinfo(iygrd,nc)=MIN(MAX(0.5_r8,yfloat),
     &                                FLOAT(Mm)+0.5_r8)
              else
                mc=mc+1
                index(mc)=nc
                lon(mc)=Fx0(i)+FLOAT(j-1)*Fdx(i)
                lat(mc)=Fy0(i)+FLOAT(j-1)*Fdy(i)
              endif
            endif
          enddo
        endif
      enddo
!
!  Set number of floats trajectories to compute.
!
      nfloats=nc
!
!  If applicable, convert floats initial (lon,lat) positions to grid
!  units.
!
      if (mc.gt.0) then
        if (spherical) then
          call hindices (Ip0,Jp0,lon,lat,mc,lonr,latr)
        else
          call hindices (Ip0,Jp0,lon,lat,mc,xr,yr)
        endif
        do i=1,mc
          nc=index(i)
          Tinfo(ixgrd,nc)=MIN(MAX(0.5_r8,Ip0(i)),FLOAT(Lm)+0.5_r8)
          Tinfo(iygrd,nc)=MIN(MAX(0.5_r8,Jp0(i)),FLOAT(Mm)+0.5_r8)
        enddo
      endif
!
!  Set float initial vertical level position.  If the initial float
!  depth (in meters) is not found, release float at the surface model
!  level.
!
      do nc=1,nfloats
# ifdef SOLVE3D
        zfloat=Tinfo(izgrd,nc)
        if (zfloat.le.0.0_r8) then
          i=INT(Tinfo(ixgrd,nc))
          j=INT(Tinfo(iygrd,nc))
          Tinfo(izgrd,nc)=FLOAT(N)
          do k=N,1,-1
            if ((z_w(i,j,k)-zfloat)*
     &          (zfloat-z_w(i,j,k-1)).ge.0.0_r8) then
              Tinfo(izgrd,nc)=FLOAT(k-1)+
     &                        (zfloat-z_w(i,j,k-1))/Hz(i,j,k)
            endif
          enddo
        endif
# else
        Tinfo(izgrd,nc)=0.0_r8
# endif
      enddo
#endif /* FLOATS */
      return
      end
#ifdef FLOATS
      subroutine hindices (Ipos,Jpos,Xpos,Ypos,Npos,Xgrd,Ygrd)
!
!================================================ Hernan G. Arango ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!======================================== Alexander F. Shchepetkin ===
!                                                                    !
!  Given position vectors Xpos and Ypos of size Npos,  this routine  !
!  finds the corresponding indices Ipos and Jpos of the  model grid  !
!  (Xgrd,Ygrd) cell containing each requested position.              !
!                                                                    !
!  Calls:    Try_Range                                               !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "grid.h"      
# include "scalars.h"      
!
      logical found
      logical Try_Range
      INTEGER_TYPE
     &        Imax, Imin, Jmax, Jmin, Npos, i0, j0, k
      REAL_TYPE
     &        Ipos(Npos), Jpos(Npos), Xpos(Npos), Ypos(Npos), ang,
     &        aa2, bb2, diag2, dx, dy, fac, phi, xpp, ypp
      REAL_TYPE
     &        Xgrd(GLOBAL_2D_ARRAY),
     &        Ygrd(GLOBAL_2D_ARRAY)
!
!---------------------------------------------------------------------
!  Determine grid cell indices containing requested position points.
!  Then, interpolate to fractional cell position.
!---------------------------------------------------------------------
!
!  Initialize all indices.
!
      do k=1,Npos
        Ipos(k)=0.0_r8
        Jpos(k)=0.0_r8
      enddo
!
!  Check each position to find if it falls inside the whole domain.
!  Once it is stablished that it inside, find the exact cell to which
!  it belongs by successively dividing the domain by a half (binary
!  search).
!
      do k=1,Npos
	found=Try_Range(0,L,0,M,Xpos(k),Ypos(k),Xgrd,Ygrd)
	if (found) then
          Imin=0
          Imax=L
          Jmin=0
          Jmax=M
          do while (((Imax-Imin).gt.1).or.((Jmax-Jmin).gt.1))
            if ((Imax-Imin).gt.1) then
              i0=(Imin+Imax)/2
              found=Try_Range(Imin,i0,Jmin,Jmax,Xpos(k),Ypos(k),
     &                        Xgrd,Ygrd)
              if (found) then
                Imax=i0
              else
                Imin=i0
              endif
            endif
            if ((Jmax-Jmin).gt.1) then
              j0=(Jmin+Jmax)/2
              found=Try_Range(Imin,Imax,Jmin,j0,Xpos(k),Ypos(k),
     &                        Xgrd,Ygrd)
              if (found) then
                Jmax=j0
              else
                Jmin=j0
              endif
            endif
          enddo
!
!  Knowing the correct cell, calculate the exact indices, accounting
!  for a possibly rotated grid.  If spherical, convert all positions
!  to meters first. 
!
          if (spherical) then
            fac=Eradius*deg2rad
            xpp=(Xpos(k)-Xgrd(Imin,Jmin))*fac*COS(Ypos(k)*deg2rad)
            ypp=(Ypos(k)-Ygrd(Imin,Jmin))*fac
          else
            xpp=Xpos(k)-Xgrd(Imin,Jmin)
            ypp=Ypos(k)-Ygrd(Imin,Jmin)
          endif
!
!  Use Law of Cosines to get cell parallelogram "shear" angle.
!
          diag2=(Xgrd(Imin+1,Jmin)-Xgrd(Imin,Jmin+1))**2+
     &          (Ygrd(Imin+1,Jmin)-Ygrd(Imin,Jmin+1))**2
          aa2=(Xgrd(Imin,Jmin)-Xgrd(Imin+1,Jmin))**2+
     &        (Ygrd(Imin,Jmin)-Ygrd(Imin+1,Jmin))**2
          bb2=(Xgrd(Imin,Jmin)-Xgrd(Imin,Jmin+1))**2+
     &        (Ygrd(Imin,Jmin)-Ygrd(Imin,Jmin+1))**2
          phi=ASIN((diag2-aa2-bb2)/(2.0_r8*SQRT(aa2*bb2)))
!
!  Transform float position into curvilinear coordinates. Assume the
!  cell is rectanglar, for now.
!
          ang=angler(Imin,Jmin)
          dx=xpp*COS(ang)+ypp*SIN(ang)
          dy=ypp*COS(ang)-xpp*SIN(ang) 
!
!  Correct for parallelogram.
!
          dx=dx+dy*TAN(phi)
          dy=dy/COS(phi)
!
!  Scale with cell side lengths to translate into cell indices.
!
          dx=dx/SQRT(aa2)
          dy=dy/SQRT(bb2)
          Ipos(k)=FLOAT(Imin)+MIN(MAX(0.0_r8,dx),1.0_r8)
          Jpos(k)=FLOAT(Jmin)+MIN(MAX(0.0_r8,dy),1.0_r8)
        endif
      enddo
      return
      end
      function Try_Range (Imin,Imax,Jmin,Jmax,Xo,Yo,Xgrd,Ygrd)
!
!================================================ Hernan G. Arango ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!======================================== Alexander F. Shchepetkin ===
!                                                                    !
!  Given a grided domain with matrix coordinates Xgrd and Ygrd, this !
!  function finds if the point (Xo,Yo)  is inside the box defined by !
!  the requested corners (Imin,Jmin) and (Imax,Jmax). It will return !
!  logical switch  Try_Range=.true.  if (Xo,Yo) is inside, otherwise !
!  it will return false.                                             !
!                                                                    !
!  Calls:   inside                                                   !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
!
      logical Try_Range, inside
      INTEGER_TYPE
     &        Imax, Imin, Jmax, Jmin, Nb, NX, i, j, shft
      parameter (NX=2*Lp+2*Mp+1)
      REAL_TYPE
     &        Xb(NX), Yb(NX), Xo, Yo
      REAL_TYPE
     &        Xgrd(GLOBAL_2D_ARRAY),
     &        Ygrd(GLOBAL_2D_ARRAY)
!
!---------------------------------------------------------------------
!  Define closed polygon.
!---------------------------------------------------------------------
!
!  Note that the last point (Xb(Nb),Yb(Nb)) does not repeat first
!  point (Xb(1),Yb(1)).  Instead, in function inside, it is implied
!  that the closing segment is (Xb(Nb),Yb(Nb))-->(Xb(1),Yb(1)). In
!  fact, function inside sets Xb(Nb+1)=Xb(1) and Yb(Nb+1)=Yb(1).
!
      Nb=2*(Jmax-Jmin+Imax-Imin)
      shft=1-Imin
      do i=Imin,Imax-1
        Xb(i+shft)=Xgrd(i,Jmin)
        Yb(i+shft)=Ygrd(i,Jmin)
      enddo
      shft=1-Jmin+Imax-Imin
      do j=Jmin,Jmax-1
        Xb(j+shft)=Xgrd(Imax,j)
        Yb(j+shft)=Ygrd(Imax,j)
      enddo
      shft=1+Jmax-Jmin+2*Imax-Imin
      do i=Imax,Imin+1,-1
        Xb(shft-i)=Xgrd(i,Jmax)
        Yb(shft-i)=Ygrd(i,Jmax)
      enddo
      shft=1+2*Jmax-Jmin+2*(Imax-Imin)
      do j=Jmax,Jmin+1,-1
        Xb(shft-j)=Xgrd(Imin,j)
        Yb(shft-j)=Ygrd(Imin,j)
      enddo
!
!---------------------------------------------------------------------
!  Check if point (Xo,Yo) is inside of the defined polygon.
!---------------------------------------------------------------------
!
      Try_Range=inside(Xo,Yo,Xb,Yb,Nb)
      return
      end
      function inside (Xo,Yo,Xb,Yb,Nb)
!
!================================================ Hernan G. Arango ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!======================================== Alexander F. Shchepetkin ===
!                                                                    !
!  Given the vectors Xb and Yb of size Nb, defining the coordinates  !
!  of a closed polygon,  this function find if the point (Xo,Yo) is  !
!  inside the polygon.  If the point  (Xo,Yo)  falls exactly on the  !
!  boundary of the polygon, it still considered inside.              !
!                                                                    !
!  This algorithm does not rely on the setting of  Xb(Nb)=Xb(1) and  !
!  Yb(Nb)=Yb(1).  Instead, it assumes that the last closing segment  !
!  is (Xb(Nb),Yb(Nb)) --> (Xb(1),Yb(1)).                             !
!                                                                    !
!  Reference:                                                        !
!                                                                    !
!    Reid, C., 1969: A long way from Euclid. Oceanography EMR,       !
!      page 174.                                                     !
!                                                                    !
!  Algorithm:                                                        !
!                                                                    !
!  The decision whether the point is  inside or outside the polygon  !
!  is done by counting the number of crossings from the ray (Xo,Yo)  !
!  to (Xo,-infinity), hereafter called meridian, by the boundary of  !
!  the polygon.  In this counting procedure,  a crossing is counted  !
!  as +2 if the crossing happens from "left to right" or -2 if from  !
!  "right to left". If the counting adds up to zero, then the point  !
!  is outside.  Otherwise,  it is either inside or on the boundary.  !
!                                                                    !
!  This routine is a modified version of the Reid (1969) algorithm,  !
!  where all crossings were counted as positive and the decision is  !
!  made  based on  whether the  number of crossings is even or odd.  !
!  This new algorithm may produce different results  in cases where  !
!  Xo accidentally coinsides with one of the (Xb(k),k=1:Nb) points.  !
!  In this case, the crossing is counted here as +1 or -1 depending  !
!  of the sign of (Xb(k+1)-Xb(k)).  Crossings  are  not  counted if  !
!  Xo=Xb(k)=Xb(k+1).  Therefore, if Xo=Xb(k0) and Yo>Yb(k0), and if  !
!  Xb(k0-1) < Xb(k0) < Xb(k0+1),  the crossing is counted twice but  !
!  with weight +1 (for segments with k=k0-1 and k=k0). Similarly if  !
!  Xb(k0-1) > Xb(k0) > Xb(k0+1), the crossing is counted twice with  !
!  weight -1 each time.  If,  on the other hand,  the meridian only  !
!  touches the boundary, that is, for example, Xb(k0-1) < Xb(k0)=Xo  !
!  and Xb(k0+1) < Xb(k0)=Xo, then the crossing is counted as +1 for  !
!  segment k=k0-1 and -1 for segment k=k0, resulting in no crossing. !
!                                                                    !
!  Note 1: (Explanation of the logical condition)                    !
!                                                                    !
!  Suppose  that there exist two points  (x1,y1)=(Xb(k),Yb(k))  and  !
!  (x2,y2)=(Xb(k+1),Yb(k+1)),  such that,  either (x1 < Xo < x2) or  !
!  (x1 > Xo > x2).  Therefore, meridian x=Xo intersects the segment  !
!  (x1,y1) -> (x2,x2) and the ordinate of the point of intersection  !
!  is:                                                               !
!                                                                    !
!                 y1*(x2-Xo) + y2*(Xo-x1)                            !
!             y = -----------------------                            !
!                          x2-x1                                     !
!                                                                    !
!  The mathematical statement that point  (Xo,Yo)  either coinsides  !
!  with the point of intersection or lies to the north (Yo>=y) from  !
!  it is, therefore, equivalent to the statement:                    !
!                                                                    !
!         Yo*(x2-x1) >= y1*(x2-Xo) + y2*(Xo-x1),   if   x2-x1 > 0    !
!  or                                                                !
!         Yo*(x2-x1) <= y1*(x2-Xo) + y2*(Xo-x1),   if   x2-x1 < 0    !
!                                                                    !
!  which, after noting that  Yo*(x2-x1) = Yo*(x2-Xo + Xo-x1) may be  !
!  rewritten as:                                                     !
!                                                                    !
!        (Yo-y1)*(x2-Xo) + (Yo-y2)*(Xo-x1) >= 0,   if   x2-x1 > 0    !
!  or                                                                !
!        (Yo-y1)*(x2-Xo) + (Yo-y2)*(Xo-x1) <= 0,   if   x2-x1 < 0    !
!                                                                    !
!  and both versions can be merged into  essentially  the condition  !
!  that (Yo-y1)*(x2-Xo)+(Yo-y2)*(Xo-x1) has the same sign as x2-x1.  !
!  That is, the product of these two must be positive or zero.       !
!                                                                    !
!=====================================================================
!
      implicit none
!
      logical inside
      INTEGER_TYPE
     &        Nb, Nstep, crossings, i, inc, k, kk, nc
      parameter (Nstep=128)
      INTEGER_TYPE
     &        index(Nstep)
      REAL_TYPE
     &        Xb(Nb+1), Yb(Nb+1), Xo, Yo, dx1, dx2, dxy
!
!---------------------------------------------------------------------
!  Find intersections.
!---------------------------------------------------------------------
!
!  Set crossings counter and close the contour of the polygon.
!
      crossings=0
      Xb(Nb+1)=Xb(1)
      Yb(Nb+1)=Yb(1)
!
!  The search is optimized.  First select the indices of segments
!  where Xb(k) is different from Xb(k+1) and Xo falls between them.
!  Then, further investigate these segments in a separate loop.
!  Doing it in two stages takes less time because the first loop is
!  pipelined.
!
      do kk=0,Nb-1,Nstep
        nc=0
        do k=kk+1,MIN(kk+Nstep,Nb)
          if (((Xb(k+1)-Xo)*(Xo-Xb(k)).ge.0.0_r8).and.
     &        (Xb(k).ne.Xb(k+1))) then
            nc=nc+1
            index(nc)=k
          endif
        enddo
        do i=1,nc
          k=index(i)
          if (Xb(k).ne.Xb(k+1)) then
            dx1=Xo-Xb(k)
            dx2=Xb(k+1)-Xo
            dxy=dx2*(Yo-Yb(k))-dx1*(Yb(k+1)-Yo)
            inc=0
            if ((Xb(k).eq.Xo).and.(Yb(k).eq.Yo)) then
              crossings=1
              goto 10
            elseif (((dx1.eq.0.0_r8).and.(Yo.ge.Yb(k  ))).or.
     &              ((dx2.eq.0.0_r8).and.(Yo.ge.Yb(k+1)))) then
              inc=1
            elseif ((dx1*dx2.gt.0.0_r8).and.             ! See Note 1
     &              ((Xb(k+1)-Xb(k))*dxy.ge.0.0_r8)) then
              inc=2
            endif
            if (Xb(k+1).gt.Xb(k)) then
              crossings=crossings+inc
            else
              crossings=crossings-inc
            endif
          endif
        enddo
      enddo
!
!  Determine if point (Xo,Yo) is inside of closed polygon.
!
  10  if (crossings.eq.0) then
        inside=.false.
      else
        inside=.true.
      endif
      return
      end
#endif /* FLOATS */
