#include "cppdefs.h"
      subroutine init_arrays (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine initializes globally accessable model arrays.  Most  !
!  of them are set to zero, vertical mixing coefficients are set to  !
!  their background values and will remain unchenged if no vertical  !
!  mixing scheme is used.                                            !
!                                                                    !
!  Because of the  "first touch"  default distribution policy, this  !
!  operation  actually performs propagation of the  "shared arrays"  !
!  accross the cluster,  unless  another  policy  is  specified  to  !
!  override the default.                                             !
!                                                                    !
!====================================================================!
!
      implicit none
      INTEGER_TYPE
     &        tile
#include "param.h"
#include "tile.h"
!
      call init_arrays_tile (Istr,Iend,Jstr,Jend)
      return
      end
!
!*********************************************************************
      subroutine init_arrays_tile (Istr,Iend,Jstr,Jend)
!*********************************************************************
!
      implicit none
#include "param.h"
#include "averages.h"
#include "boundary.h"
#include "bbl.h"
#include "clima.h"
#include "coupling.h"
#include "floats.h"
#include "forces.h"
#include "grid.h"
#include "mixing.h"
#include "ncparam.h"
#include "obs.h"
#include "ocean.h"
#include "scalars.h"
#include "scratch.h"
#include "sediment.h"
#include "tides.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
#ifdef SOLVE3D
      INTEGER_TYPE
     &        itrc, k
#endif
#ifdef FLOATS
      INTEGER_TYPE
     &        iflt
#endif
#if defined SSH_TIDES || defined UV_TIDES
      INTEGER_TYPE
     &        itide
#endif
      REAL_TYPE
     &        IniVal
      parameter (IniVal=0.0_r8)
!
#include "set_bounds.h"
!
!  Initialize 2-D primitive variables.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          angler(i,j)=IniVal
          zeta(i,j,1)=IniVal
          zeta(i,j,2)=IniVal
          zeta(i,j,3)=IniVal
          ubar(i,j,1)=IniVal
          ubar(i,j,2)=IniVal
          ubar(i,j,3)=IniVal
          vbar(i,j,1)=IniVal
          vbar(i,j,2)=IniVal
          vbar(i,j,3)=IniVal
          rzeta(i,j,1)=IniVal
          rzeta(i,j,2)=IniVal
          rubar(i,j,1)=IniVal
          rubar(i,j,2)=IniVal
          rvbar(i,j,1)=IniVal
          rvbar(i,j,2)=IniVal
#ifdef SOLVE3D
          rufrc(i,j)=IniVal
          rvfrc(i,j)=IniVal
          Zt_avg1(i,j)=IniVal
          DU_avg1(i,j)=IniVal
          DV_avg1(i,j)=IniVal
          DU_avg2(i,j)=IniVal
          DV_avg2(i,j)=IniVal
#endif
#ifdef AVERAGES
          avgu2d(i,j)=IniVal
          avgv2d(i,j)=IniVal
          avgzeta(i,j)=IniVal
#endif
        enddo
      enddo
#ifdef SOLVE3D
!
!  Initialize 3-D primitive variables.
!
      do k=1,N
        do j=JstrR,JendR
          do i=IstrR,IendR
            u(i,j,k,1)=IniVal
            u(i,j,k,2)=IniVal
            ru(i,j,k,1)=IniVal
            ru(i,j,k,2)=IniVal
            v(i,j,k,1)=IniVal
            v(i,j,k,2)=IniVal
            rv(i,j,k,1)=IniVal
            rv(i,j,k,2)=IniVal
            rho(i,j,k)=IniVal
# ifdef LMD_SKPP
            pden(i,j,k)=IniVal
# endif
# ifdef AVERAGES
            avgrho(i,j,k)=IniVal
            avgu3d(i,j,k)=IniVal
            avgv3d(i,j,k)=IniVal
            avgw3d(i,j,k)=IniVal
# endif
          enddo
        enddo
      enddo
      do k=0,N
        do j=JstrR,JendR
          do i=IstrR,IendR
            W(i,j,k)=IniVal
# ifdef BV_FREQUENCY
            bvf(i,j,k)=IniVal
# endif
# if defined MIX_ISO_TS || defined GENT_McWILLIAMS
            neutral(i,j,k)=IniVal
# endif
# if defined LMD_SKPP && defined LMD_NONLOCAL
            ghats(i,j,k,itemp)=IniVal
#  ifdef SALINITY
            ghats(i,j,k,isalt)=IniVal
#  endif
# endif
# if defined LMD_MIXING && defined LMD_DDMIX
            alfaobeta(i,j,k)=IniVal
# endif
# if defined GLS_MIXING || defined MY25_MIXING
            Lscale(i,j,k)=1.0_r8
            tke(i,j,k,1)=gls_Kmin
            tke(i,j,k,2)=gls_Kmin
            tke(i,j,k,3)=gls_Kmin
            gls(i,j,k,1)=gls_Pmin
            gls(i,j,k,2)=gls_Pmin
            gls(i,j,k,3)=gls_Pmin
# endif
# ifdef AVERAGES
#  ifdef AVERAGES_AKV
            avgAKv(i,j,k)=IniVal
#  endif
#  ifdef AVERAGES_AKT
            avgAKt(i,j,k)=IniVal
#  endif
#  ifdef AVERAGES_AKS
            avgAKs(i,j,k)=IniVal
#  endif
# endif
          enddo
        enddo
      enddo
      do itrc=1,NT
        do k=1,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              t(i,j,k,1,itrc)=IniVal
              t(i,j,k,2,itrc)=IniVal
# ifdef AVERAGES
              avgt(i,j,k,itrc)=IniVal
# endif
            enddo
          enddo
        enddo
      enddo
# ifdef SEDIMENT
!
!  Initialize sediment module arrays.
!
      do itrc=1,MBEDP
        do k=1,Nbed
          do j=JstrR,JendR          
            do i=IstrR,IendR
              bed(i,j,k,itrc)=IniVal
            enddo
          enddo
        enddo
      enddo
      do itrc=1,NST
        do k=1,Nbed
          do j=JstrR,JendR          
            do i=IstrR,IendR
              bed_frac(i,j,k,itrc)=IniVal
            enddo
          enddo
        enddo
      enddo
      do itrc=1,MBOTP
        do j=JstrR,JendR          
          do i=IstrR,IendR
            bottom(i,j,itrc)=IniVal
          enddo
        enddo
      enddo
# endif /* SEDIMENT */
#endif /* SOLVE3D */
!
!  Initialize forcing arrays.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          sustr(i,j)=IniVal
          svstr(i,j)=IniVal
#if !defined ANA_SMFLUX && !defined BULK_FLUXES
          sustrG(i,j,1)=IniVal
          svstrG(i,j,1)=IniVal
          sustrG(i,j,2)=IniVal
          svstrG(i,j,2)=IniVal
#endif
          bustr(i,j)=IniVal
          bvstr(i,j)=IniVal
        enddo
      enddo
#ifdef SOLVE3D
      do itrc=1,NT
        do j=JstrR,JendR
          do i=IstrR,IendR
            stflx(i,j,itrc)=IniVal
            btflx(i,j,itrc)=IniVal
# if !defined BULK_FLUXES && \
     (!defined ANA_STFLUX || !defined ANA_SSFLUX)
            stflxG(i,j,1,itrc)=IniVal
            stflxG(i,j,2,itrc)=IniVal
# endif
# ifndef ANA_BTFLUX
            btflxG(i,j,1,itrc)=IniVal
            btflxG(i,j,2,itrc)=IniVal
# endif
          enddo
        enddo
      enddo
# ifdef SHORTWAVE
      do j=JstrR,JendR
        do i=IstrR,IendR
          srflx(i,j)=IniVal
#  ifndef ANA_SRFLUX
          srflxG(i,j,1)=IniVal
          srflxG(i,j,2)=IniVal
#  endif
        enddo
      enddo
# endif /* SHORTWAVE */
# ifdef CLOUDS
      do j=JstrR,JendR
        do i=IstrR,IendR
          cloud(i,j)=IniVal
#  ifndef ANA_CLOUD
          cloudG(i,j,1)=IniVal
          cloudG(i,j,2)=IniVal
#  endif
        enddo
      enddo
# endif /* CLOUDS */
# ifdef QCORRECTION

!
!  Initialize arrays for surface heat flux correction.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          dqdt(i,j)=IniVal
          sst (i,j)=IniVal
#  ifndef ANA_SST
          dqdtG(i,j,1)=IniVal
          sstG (i,j,1)=IniVal
          dqdtG(i,j,2)=IniVal
          sstG (i,j,2)=IniVal
#  endif
        enddo
      enddo
# endif /* QCORRECTION */
# ifdef SCORRECTION
!
!  Initialize arrays for surface freshwater flux correction.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          sss(i,j)=IniVal
#  ifndef ANA_SSS
          sssG(i,j,1)=IniVal
          sssG(i,j,2)=IniVal
#  endif
        enddo
      enddo
# endif /* SCORRECTION */
# ifdef BULK_FLUXES
!
!  Initialize arrays for surface fluxes bulk parameterization.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          lhflx(i,j)=IniVal
          lrflx(i,j)=IniVal
          shflx(i,j)=IniVal
          Hair(i,j)=IniVal
          Pair(i,j)=IniVal
          Tair(i,j)=IniVal
          Uwind(i,j)=IniVal
          Vwind(i,j)=IniVal
          rain(i,j)=IniVal
#  ifndef LONGWAVE
          lrflxG(i,j,1)=IniVal
          lrflxG(i,j,2)=IniVal
#  endif
#  ifndef ANA_HUMIDITY
          HairG(i,j,1)=IniVal
          HairG(i,j,2)=IniVal
#  endif
#  ifndef ANA_PAIR
          PairG(i,j,1)=IniVal
          PairG(i,j,2)=IniVal
#  endif
#  ifndef ANA_TAIR
          TairG(i,j,1)=IniVal
          TairG(i,j,2)=IniVal
#  endif
#  ifndef ANA_WINDS
          UwindG(i,j,1)=IniVal
          UwindG(i,j,2)=IniVal
          VwindG(i,j,1)=IniVal
          VwindG(i,j,2)=IniVal
#  endif
#  ifndef ANA_CLOUD
          cloudG(i,j,1)=IniVal
          cloudG(i,j,2)=IniVal
#  endif
#  ifndef ANA_RAIN
          rainG(i,j,1)=IniVal
          rainG(i,j,2)=IniVal
#  endif
        enddo
      enddo
# endif /* BULK_FLUXES */
# if defined BBL
!
!  Initialize arrays for bottom boundary layer formulation.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          bustrw(i,j)=IniVal
          bvstrw(i,j)=IniVal
          Abed(i,j)=IniVal
          Ubed(i,j)=IniVal
          Vbed(i,j)=IniVal
          Ubot(i,j)=IniVal
          Vbot(i,j)=IniVal
          Hripple(i,j)=IniVal
          Lripple(i,j)=IniVal
          Zbnot(i,j)=IniVal
          Zbnotc(i,j)=IniVal
          Sdens(i,j)=IniVal
          Ssize(i,j)=IniVal
          Awave(i,j)=IniVal
          Dwave(i,j)=IniVal
          Pwave(i,j)=IniVal
#  ifndef ANA_WWAVE
          AwaveG(i,j,1)=IniVal
          DwaveG(i,j,1)=IniVal
          PwaveG(i,j,1)=IniVal
          AwaveG(i,j,2)=IniVal
          DwaveG(i,j,2)=IniVal
          PwaveG(i,j,2)=IniVal
#  endif
        enddo
      enddo
# endif /* BBL */
#endif /* SOLVE3D */
#if defined SSH_TIDES || defined UV_TIDES
!
! Initialize array for tidal elevation forcing.
!
      do itide=1,MTC
        Tperiod(itide)=IniVal
        do j=JstrR,JendR
          do i=IstrR,IendR
# ifdef SSH_TIDES
            SSH_Tamp(i,j,itide)=IniVal
            SSH_Tphase(i,j,itide)=IniVal
# endif
# ifdef UV_TIDES
            UV_Tangle(i,j,itide)=IniVal
            UV_Tphase(i,j,itide)=IniVal
            UV_Tmajor(i,j,itide)=IniVal
            UV_Tminor(i,j,itide)=IniVal
# endif
          enddo
        enddo
      enddo
#endif
!
! Initialize nudging and climatology arrays.
!
#ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=IniVal
        enddo
      enddo
#endif
#ifdef ZCLIMATOLOGY
      do j=JstrR,JendR
        do i=IstrR,IendR
          ssh(i,j)=IniVal
# ifndef ANA_SSH
          sshG(i,j,1)=IniVal
          sshG(i,j,2)=IniVal
# endif
        enddo
      enddo
#endif
#ifdef M2CLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          M2nudgcof(i,j)=IniVal
        enddo
      enddo
#endif
#ifdef M2CLIMATOLOGY
      do j=JstrR,JendR
        do i=IstrR,IendR
          ubarclm(i,j)=IniVal
          vbarclm(i,j)=IniVal
# ifndef ANA_M2CLIMA
          ubarclmG(i,j,1)=IniVal
          ubarclmG(i,j,2)=IniVal
          vbarclmG(i,j,1)=IniVal
          vbarclmG(i,j,2)=IniVal
# endif
        enddo
      enddo
#endif
#ifdef SOLVE3D
# if defined TCLM_NUDGING
      do itrc=1,NT
        do j=JstrR,JendR
          do i=IstrR,IendR
            Tnudgcof(i,j,itrc)=IniVal
          enddo
        enddo
      enddo
# endif
# ifdef TCLIMATOLOGY
      do itrc=1,NT
        do k=1,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              tclm(i,j,k,itrc)=IniVal
#  ifndef ANA_TCLIMA
              tclmG(i,j,k,1,itrc)=IniVal
              tclmG(i,j,k,2,itrc)=IniVal
#  endif
            enddo
          enddo
        enddo
      enddo
# endif
# if defined M3CLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          M3nudgcof(i,j)=IniVal
        enddo
      enddo
# endif
# ifdef M3CLIMATOLOGY
      do k=1,N
        do j=JstrR,JendR
          do i=IstrR,IendR
            uclm(i,j,k)=IniVal
            vclm(i,j,k)=IniVal
#  ifndef ANA_M3CLIMA
            uclmG(i,j,k,1)=IniVal
            uclmG(i,j,k,2)=IniVal
#  endif
          enddo
        enddo
      enddo
# endif
#endif
#if defined ASSIMILATION_SSH || defined NUDGING_SSH
!
!  Initialize arrays for assimilation of sea surface height.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
# ifdef ASSIMILATION_SSH
          EmodSSH(i,j)=IniVal
# endif
          EobsSSH(i,j)=IniVal
          SSHobs(i,j)=IniVal
# ifdef NUDGING_SSH
          EdatSSH(i,j,1)=IniVal
          EdatSSH(i,j,2)=IniVal
          SSHdat(i,j,1)=IniVal
          SSHdat(i,j,2)=IniVal
# endif
        enddo
      enddo
#endif
#if defined ASSIMILATION_SST || defined NUDGING_SST
!
!  Initialize arrays for assimilation of sea surface temperature.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
# ifdef ASSIMILATION_SST
          EmodSST(i,j)=IniVal
# endif
          EobsSST(i,j)=IniVal
          SSTobs(i,j)=IniVal
# ifdef NUDGING_SST
          EdatSST(i,j,1)=IniVal
          EdatSST(i,j,2)=IniVal
          SSTdat(i,j,1)=IniVal
          SSTdat(i,j,2)=IniVal
# endif
        enddo
      enddo
#endif
#if defined ASSIMILATION_T   || defined NUDGING_T   || \
    defined ASSIMILATION_SST || defined NUDGING_SST
!
!  Initialize arrays for assimilation of tracers.
!
      do itrc=1,NT
        do k=1,N
          do j=JstrR,JendR
            do i=IstrR,IendR
# if defined ASSIMILATION_T || defined ASSIMILATION_SST
              EmodT(i,j,k,itrc)=IniVal
# endif
              EobsT(i,j,k,itrc)=IniVal
              Tobs(i,j,k,itrc)=IniVal
# ifdef NUDGING_T
              EdatT(i,j,k,1,itrc)=IniVal
              EdatT(i,j,k,2,itrc)=IniVal
              Tdat(i,j,k,1,itrc)=IniVal
              Tdat(i,j,k,2,itrc)=IniVal
# endif
            enddo
          enddo
        enddo
      enddo
#endif
#if defined ASSIMILATION_UVsur || defined NUDGING_UVsur || \
    defined ASSIMILATION_UV    || defined NUDGING_UV
!
!  Initialize arrays for assimilation of horizontal currents.
!
      do k=1,N
        do j=JstrR,JendR
          do i=IstrR,IendR
# if defined ASSIMILATION_UV || defined ASSIMILATION_UVsur
            EmodU(i,j,k)=IniVal
            EmodV(i,j,k)=IniVal
# endif
            EobsUV(i,j,k)=IniVal
            Uobs(i,j,k)=IniVal
            Vobs(i,j,k)=IniVal
# ifdef NUDGING_UV
            EdatUV(i,j,k,1)=IniVal
            EdatUV(i,j,k,2)=IniVal
            Udat(i,j,k,1)=IniVal
            Udat(i,j,k,2)=IniVal
            Vdat(i,j,k,1)=IniVal
            Vdat(i,j,k,2)=IniVal
# endif
          enddo
        enddo
      enddo
# ifdef ASSIMILATION_UVsur
      do j=JstrR,JendR
        do i=IstrR,IendR
          EobsVsur(i,j)=IniVal
          Usur(i,j)=IniVal
          Vsur(i,j)=IniVal
        enddo
      enddo
# endif
# ifdef NUDGING_UVsur
      do j=JstrR,JendR
        do i=IstrR,IendR
          EdatVsur(i,j,1)=IniVal
          EdatVsur(i,j,2)=IniVal
          Usurdat(i,j,1)=IniVal
          Usurdat(i,j,2)=IniVal
          Vsurdat(i,j,1)=IniVal
          Vsurdat(i,j,2)=IniVal
        enddo
      enddo
# endif
#endif
!
! If appropriate, set variable horizontal viscosities and tracer
! diffusion coefficients to their background values.
!
#ifdef UV_VIS2
        do j=JstrR,JendR
          do i=IstrR,IendR
            visc2_r(i,j)=visc2
            visc2_p(i,j)=visc2
          enddo
        enddo
#endif
#ifdef UV_VIS4
        do j=JstrR,JendR
          do i=IstrR,IendR
            visc4_r(i,j)=visc4
            visc4_p(i,j)=visc4
          enddo
        enddo
#endif
#ifdef SOLVE3D
# ifdef TS_DIF2
        do itrc=1,NT
          do j=JstrR,JendR
            do i=IstrR,IendR
              diff2(i,j,itrc)=tnu2(itrc)
            enddo
          enddo
        enddo
# endif
# ifdef TS_DIF4
        do itrc=1,NT
          do j=JstrR,JendR
            do i=IstrR,IendR
              diff4(i,j,itrc)=tnu4(itrc)
            enddo
          enddo
        enddo
# endif
!
!  Initialize vertical mixing coefficients to their background values.
!  If no vertical closure scheme is selected,  the vertical mixing
!  coefficients are those specified by the background values.  Set
!  surface and bottom boundary conditions to zero.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          Akv(i,j,0)=IniVal
          do k=1,Nm
            Akv(i,j,k)=Akv_bak
          enddo
          Akv(i,j,N)=IniVal
          do itrc=1,NT
            Akt(i,j,0,itrc)=IniVal
            do k=1,Nm
              Akt(i,j,k,itrc)=Akt_bak(itrc)
            enddo
            Akt(i,j,N,itrc)=IniVal
          enddo
# if defined GLS_MIXING || defined MY25_MIXING
          Akk(i,j,0)=IniVal
          do k=1,Nm
            Akk(i,j,k)=Akk_bak
          enddo
          Akk(i,j,N)=IniVal
# endif
# ifdef GLS_MIXING
          Akp(i,j,0)=IniVal
          do k=1,Nm
            Akp(i,j,k)=Akp_bak
          enddo
          Akp(i,j,N)=IniVal
# endif
        enddo
      enddo
# if defined LMD_SKPP || defined LMD_BKPP
!
!  Initialize KPP 2D-variables.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          alpha(i,j)=IniVal
          beta(i,j)=IniVal
#  ifdef LMD_BKPP
          hbbl(i,j)=IniVal
          kbbl(i,j)=IniVal
#  endif
#  ifdef LMD_SKPP
          hsbl(i,j)=IniVal
          ksbl(i,j)=IniVal
#  endif
#  ifdef AVERAGES
#   ifdef LMD_BKPP
          avghbbl(i,j)=IniVal
#   endif
#   ifdef LMD_SKPP
          avghsbl(i,j)=IniVal
#   endif
#  endif
        enddo
      enddo
# endif
      do j=JstrR,JendR
        do i=IstrR,IendR
# if defined LMD_SKPP || defined SOLAR_SOURCE
          Jwtype(i,j)=lmd_Jwt
# endif
        enddo
      enddo
#endif /* SOLVE3D */
#ifdef FLOATS
!
!  Initialize floats trajectory array.
!
      do iflt=1,Mfloats
        bounded(iflt)=.false.
        do j=0,NFT
          do i=1,NFV
            track(i,j,iflt)=spval
          enddo
        enddo
      enddo
#endif /* FLOATS */
#ifdef OBC
!
!  Open Boundaries arrays.
!
      if (WESTERN_EDGE) then
# if defined WEST_FSOBC || defined WEST_M2OBC
        do j=JstrR,JendR
          zeta_west(j)=IniVal
#  ifndef ANA_FSOBC
          zetaG_west(j,1)=IniVal
          zetaG_west(j,2)=IniVal
#  endif
        enddo
# endif
# ifdef WEST_M2OBC
        do j=JstrR,JendR
          ubar_west(j)=IniVal
#  ifndef ANA_M2OBC
          ubarG_west(j,1)=IniVal
          ubarG_west(j,2)=IniVal
#  endif
        enddo
        do j=Jstr,JendR
          vbar_west(j)=IniVal
#  ifndef ANA_M2OBC
          vbarG_west(j,1)=IniVal
          vbarG_west(j,2)=IniVal
#  endif
        enddo
# endif
# ifdef SOLVE3D
#  ifdef WEST_M3OBC
        do k=1,N
          do j=JstrR,JendR
            u_west(j,k)=IniVal
#   ifndef ANA_M2OBC
            uG_west(j,k,1)=IniVal
            uG_west(j,k,2)=IniVal
#   endif
          enddo
          do j=Jstr,JendR
            v_west(j,k)=IniVal
#   ifndef ANA_M2OBC
            vG_west(j,k,1)=IniVal
            vG_west(j,k,2)=IniVal
#   endif
          enddo
        enddo
#  endif
#  ifdef WEST_TOBC
        do itrc=1,NT
          do k=1,N
            do j=JstrR,JendR
              t_west(j,k,itrc)=IniVal
#   ifndef ANA_TOBC
              tG_west(j,k,1,itrc)=IniVal
              tG_west(j,k,2,itrc)=IniVal
#   endif
            enddo
          enddo
        enddo
#  endif
# endif
      endif
      if (EASTERN_EDGE) then
# if defined EAST_FSOBC || defined EAST_M2OBC
        do j=JstrR,JendR
          zeta_east(j)=IniVal
#  ifndef ANA_FSOBC
          zetaG_east(j,1)=IniVal
          zetaG_east(j,2)=IniVal
#  endif
        enddo
# endif
# ifdef EAST_M2OBC
        do j=JstrR,JendR
          ubar_east(j)=IniVal
#  ifndef ANA_M2OBC
          ubarG_east(j,1)=IniVal
          ubarG_east(j,2)=IniVal
#  endif
        enddo
        do j=Jstr,JendR
          vbar_east(j)=IniVal
#  ifndef ANA_M2OBC
          vbarG_east(j,1)=IniVal
          vbarG_east(j,2)=IniVal
#  endif
        enddo
# endif
# ifdef SOLVE3D
#  ifdef EAST_M3OBC
        do k=1,N
          do j=JstrR,JendR
            u_east(j,k)=IniVal
#   ifndef ANA_M2OBC
            uG_east(j,k,1)=IniVal
            uG_east(j,k,2)=IniVal
#   endif
          enddo
          do j=Jstr,JendR
            v_east(j,k)=IniVal
#   ifndef ANA_M2OBC
            vG_east(j,k,1)=IniVal
            vG_east(j,k,2)=IniVal
#   endif
          enddo
        enddo
#  endif
#  ifdef EAST_TOBC
        do itrc=1,NT
          do k=1,N
            do j=JstrR,JendR
              t_east(j,k,itrc)=IniVal
#   ifndef ANA_TOBC
              tG_east(j,k,1,itrc)=IniVal
              tG_east(j,k,2,itrc)=IniVal
#   endif
            enddo
          enddo
        enddo
#  endif
# endif
      endif
      if (SOUTHERN_EDGE) then
# if defined SOUTH_FSOBC || defined SOUTH_M2OBC
        do i=IstrR,IendR
          zeta_south(i)=IniVal
#  ifndef ANA_FSOBC
          zetaG_south(i,1)=IniVal
          zetaG_south(i,2)=IniVal
#  endif
        enddo
# endif
# ifdef SOUTH_M2OBC
        do i=Istr,IendR
          ubar_south(i)=IniVal
#  ifndef ANA_M2OBC
          ubarG_south(i,1)=IniVal
          ubarG_south(i,2)=IniVal
#  endif
        enddo
        do i=IstrR,IendR
          vbar_south(i)=IniVal
#  ifndef ANA_M2OBC
          vbarG_south(i,1)=IniVal
          vbarG_south(i,2)=IniVal
#  endif
        enddo
# endif
# ifdef SOLVE3D
#  ifdef SOUTH_M3OBC
        do k=1,N
          do i=Istr,IendR
            u_south(i,k)=IniVal
#   ifndef ANA_M3OBC
            uG_south(i,k,1)=IniVal
            uG_south(i,k,2)=IniVal
#   endif
          enddo
          do i=IstrR,IendR
            v_south(i,k)=IniVal
#   ifndef ANA_M3OBC
            vG_south(i,k,1)=IniVal
            vG_south(i,k,2)=IniVal
#   endif
          enddo
        enddo
#  endif
#  ifdef SOUTH_TOBC
        do itrc=1,NT
          do k=1,N
            do i=IstrR,IendR
              t_south(i,k,itrc)=IniVal
#   ifndef ANA_TOBC
              tG_south(i,k,1,itrc)=IniVal
              tG_south(i,k,2,itrc)=IniVal
#   endif
            enddo
          enddo
        enddo
#  endif
# endif
      endif
      if (NORTHERN_EDGE) then
# if defined NORTH_FSOBC || defined NORTH_M2OBC
        do i=IstrR,IendR
          zeta_north(i)=IniVal
#  ifndef ANA_FSOBC
          zetaG_north(i,1)=IniVal
          zetaG_north(i,2)=IniVal
#  endif
        enddo
# endif
# ifdef NORTH_M2OBC
        do i=Istr,IendR
          ubar_north(i)=IniVal
#  ifndef ANA_M2OBC
          ubarG_north(i,1)=IniVal
          ubarG_north(i,2)=IniVal
#  endif
        enddo
        do i=IstrR,IendR
          vbar_north(i)=IniVal
#  ifndef ANA_M2OBC
          vbarG_north(i,1)=IniVal
          vbarG_north(i,2)=IniVal
#  endif
        enddo
# endif
# ifdef SOLVE3D
#  ifdef NORTH_M3OBC
        do k=1,N
          do i=Istr,IendR
            u_north(i,k)=IniVal
#   ifndef ANA_M3OBC
            uG_north(i,k,1)=IniVal
            uG_north(i,k,2)=IniVal
#   endif
          enddo
          do i=IstrR,IendR
            v_north(i,k)=IniVal
#   ifndef ANA_M3OBC
            vG_north(i,k,1)=IniVal
            vG_north(i,k,2)=IniVal
#   endif
          enddo
        enddo
#  endif
#  ifdef NORTH_TOBC
        do itrc=1,NT
          do k=1,N
            do i=IstrR,IendR
              t_north(i,k,itrc)=IniVal
#   ifndef ANA_TOBC
              tG_north(i,k,1,itrc)=IniVal
              tG_north(i,k,2,itrc)=IniVal
#   endif
            enddo
          enddo
        enddo
#  endif
# endif
      endif
#endif /* OBC */
!
!  Initialize scratch arrays.
!
      do j=1,NSA2
        do i=1,N2d
          A2d(i,j)=IniVal
        enddo
      enddo
#ifdef SOLVE3D
      do j=1,NSA3
        do i=1,N3d
          A3d(i,j)=IniVal
        enddo
      enddo
#endif
      return
      end
