#include "cppdefs.h"
      subroutine horz_mix (tile)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine rescales horizontal mixing coefficients according    !
!  to the grid size.  Also,  if applicable,  increases horizontal    !
!  in sponge areas.                                                  !
!                                                                    !
!  WARNING:   All biharmonic coefficients are assumed to have the    !
!             square root taken and have  m^2 s^-1/2 units.  This    !
!             will allow multiplying the  biharmonic  coefficient    !
!             to harmonic operator.                                  !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
#include "param.h"
#include "scratch.h"
#include "tile.h"
!
      call horz_mix_tile (Istr,Iend,Jstr,Jend)
      return
      end
!
!*********************************************************************
      subroutine horz_mix_tile (Istr,Iend,Jstr,Jend)
!*********************************************************************
!
      implicit none
#include "param.h"
#include "grid.h"
#include "mixing.h"
#include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Iwrk, Jend, Jstr, i, j, itrc
      REAL_TYPE
     &        cff, cff1, cff2, fac
!
#include "set_bounds.h"
!
      i=0
      j=0
      itrc=0
      Iwrk=0
      cff=0.0_r8
      cff1=0.0_r8
      cff2=0.0_r8
      fac=0.0_r8
!
#ifdef VISC_GRID
!---------------------------------------------------------------------
!  Scale horizontal viscosity according to the grid size.
!---------------------------------------------------------------------
!
# ifdef UV_VIS2
      cff=visc2/grdmax
      do j=JstrR,JendR
        do i=IstrR,IendR
          visc2_r(i,j)=cff*grdscl(i,j)
        enddo
      enddo
      cff=0.25_r8*cff
      do j=Jstr,JendR
        do i=Istr,IendR
          visc2_p(i,j)=cff*(grdscl(i,j  )+grdscl(i-1,j  )+
     &                      grdscl(i,j-1)+grdscl(i-1,j-1))
        enddo
      enddo
# endif
# ifdef UV_VIS4
      cff=visc4/(grdmax**3)
      do j=JstrR,JendR
        do i=IstrR,IendR
          visc4_r(i,j)=cff*grdscl(i,j)**3
        enddo
      enddo
      cff=0.25_r8*cff
      do j=Jstr,JendR
        do i=Istr,IendR
          visc4_p(i,j)=cff*(grdscl(i,j  )**3+grdscl(i-1,j  )**3+
     &                      grdscl(i,j-1)**3+grdscl(i-1,j-1)**3)
        enddo
      enddo
# endif
#endif
#ifdef DIFF_GRID
!
!---------------------------------------------------------------------
!  Scale horizontal diffusion according to the grid size.
!---------------------------------------------------------------------
!
# ifdef TS_DIF2
      do itrc=1,NT
        cff=tnu2(itrc)/grdmax
        do j=JstrR,JendR
          do i=IstrR,IendR
            diff2(i,j,itrc)=cff*grdscl(i,j)
          enddo
        enddo
      enddo
# endif
# ifdef TS_DIF4
      do itrc=1,NT
        cff=tnu4(itrc)/(grdmax**3)
        do j=JstrR,JendR
          do i=IstrR,IendR
            diff4(i,j,itrc)=cff*grdscl(i,j)**3
          enddo
        enddo
      enddo
# endif
#endif
#ifdef SPONGE
!
!---------------------------------------------------------------------
!  Increase horizontal mixing in the sponge areas.
!---------------------------------------------------------------------
!
# if defined ADRIATIC1 || defined ADRIATIC2
!
!  Adriatic Sea southern sponge areas.
!
      fac=4.0_r8
#  if defined UV_VIS2
      do i=IstrR,IendR
        do j=JstrR,MIN(6,JendR)
          cff=visc2+FLOAT(6-j)*(fac*visc2-visc2)/6.0_r8
          visc2_r(i,j)=cff
          visc2_p(i,j)=cff
        enddo
        do j=MAX(JstrR,7),JendR
          visc2_r(i,j)=0.0_r8
          visc2_p(i,j)=0.0_r8
        enddo
      enddo
#  endif
#  if defined TS_DIF2
      do i=IstrR,IendR
        do j=JstrR,MIN(6,JendR)
          cff1=tnu2(itemp)+
     &         FLOAT(6-j)*(fac*tnu2(itemp)-tnu2(itemp))/6.0_r8
          cff2=tnu2(isalt)+
     &         FLOAT(6-j)*(fac*tnu2(isalt)-tnu2(isalt))/6.0_r8
          diff2(i,j,itemp)=cff1
          diff2(i,j,isalt)=cff2
        enddo
        do j=MAX(JstrR,7),JendR
          diff2(i,j,itemp)=0.0_r8
          diff2(i,j,isalt)=0.0_r8
        enddo
      enddo
#  endif
# elif defined CALCOFI
!
!  Southern California Bight sponge areas.
!
      fac=4.0_r8
#  if defined UV_VIS2
      do j=JstrR,MIN(6,JendR)
        cff=visc2+FLOAT(6-j)*(fac*visc2-visc2)/6.0_r8
        do i=IstrR,IendR
          visc2_r(i,j)=cff
          visc2_p(i,j)=cff
        enddo
      enddo
      do j=MAX(JstrR,M-6),JendR
        cff=fac*visc2+FLOAT(M-j)*(visc2-fac*visc2)/6.0_r8
        do i=IstrR,IendR
          visc2_r(i,j)=cff
          visc2_p(i,j)=cff
        enddo
      enddo
      do i=IstrR,MIN(6,IendR)
        do j=MAX(JstrR,i),MIN(M-i,JendR)
          cff=visc2+FLOAT(6-i)*(fac*visc2-visc2)/6.0_r8
          visc2_r(i,j)=cff
          visc2_p(i,j)=cff
        enddo
      enddo
#  endif
#  if defined TS_DIF2
      do j=JstrR,MIN(6,JendR)
        cff1=tnu2(itemp)+
     &       FLOAT(6-j)*(fac*tnu2(itemp)-tnu2(itemp))/6.0_r8
        cff2=tnu2(isalt)+
     &       FLOAT(6-j)*(fac*tnu2(isalt)-tnu2(isalt))/6.0_r8
        do i=IstrR,IendR
          diff2(i,j,itemp)=cff1
          diff2(i,j,isalt)=cff2
        enddo
      enddo
      do j=MAX(JstrR,M-6),JendR
        cff1=fac*tnu2(itemp)+
     &       FLOAT(M-j)*(tnu2(itemp)-fac*tnu2(itemp))/6.0_r8
        cff2=fac*tnu2(isalt)+
     &       FLOAT(M-j)*(tnu2(isalt)-fac*tnu2(isalt))/6.0_r8
        do i=IstrR,IendR
          diff2(i,j,itemp)=cff1
          diff2(i,j,isalt)=cff2
        enddo
      enddo
      do i=IstrR,MIN(6,IendR)
        do j=MAX(JstrR,i),MIN(M-i,JendR)
          cff1=tnu2(itemp)+
     &         FLOAT(6-i)*(fac*tnu2(itemp)-tnu2(itemp))/6.0_r8
          cff2=tnu2(isalt)+
     &         FLOAT(6-i)*(fac*tnu2(isalt)-tnu2(isalt))/6.0_r8
          diff2(i,j,itemp)=cff1
          diff2(i,j,isalt)=cff2
        enddo
      enddo
#  endif
# elif defined BISCAY
!
!  Bay of Biscay sponge areas.
!
      fac=8.0_r8
#  if defined UV_VIS2
      do j=JstrR,MIN(6,JendR)
        cff=visc2+FLOAT(6-j)*(fac*visc2-visc2)/6.0_r8
        do i=IstrR,IendR
          visc2_r(i,j)=cff
          visc2_p(i,j)=cff
        enddo
      enddo
      do j=MAX(JstrR,M-6),JendR
        cff=fac*visc2+FLOAT(M-j)*(visc2-fac*visc2)/6.0_r8
        do i=IstrR,IendR
          visc2_r(i,j)=cff
          visc2_p(i,j)=cff
        enddo
      enddo
      do i=IstrR,MIN(6,IendR)
        do j=MAX(JstrR,i),MIN(M-i,JendR)
          cff=visc2+FLOAT(6-i)*(fac*visc2-visc2)/6.0_r8
          visc2_r(i,j)=cff
          visc2_p(i,j)=cff
        enddo
      enddo
#  endif
#  if defined TS_DIF2
      do j=JstrR,MIN(6,JendR)
        cff1=tnu2(itemp)+
     &       FLOAT(6-j)*(fac*tnu2(itemp)-tnu2(itemp))/6.0_r8
        cff2=tnu2(isalt)+
     &       FLOAT(6-j)*(fac*tnu2(isalt)-tnu2(isalt))/6.0_r8
        do i=IstrR,IendR
          diff2(i,j,itemp)=cff1
          diff2(i,j,isalt)=cff2
        enddo
      enddo
      do j=MAX(JstrR,M-6),JendR
        cff1=8.0_r8*tnu2(itemp)+
     &       FLOAT(M-j)*(tnu2(itemp)-fac*tnu2(itemp))/6.0_r8
        cff2=8.0_r8*tnu2(isalt)+
     &       FLOAT(M-j)*(tnu2(isalt)-fac*tnu2(isalt))/6.0_r8
        do i=IstrR,IendR
          diff2(i,j,itemp)=cff1
          diff2(i,j,isalt)=cff2
        enddo
      enddo
      do i=IstrR,MIN(6,IendR)
        do j=MAX(JstrR,i),MIN(M-i,JendR)
          cff1=tnu2(itemp)+
     &         FLOAT(6-j)*(fac*tnu2(itemp)-tnu2(itemp))/6.0_r8
          cff2=tnu2(isalt)+
     &         FLOAT(6-j)*(fac*tnu2(isalt)-tnu2(isalt))/6.0_r8
          diff2(i,j,itemp)=cff1
          diff2(i,j,isalt)=cff2
        enddo
      enddo
#  endif
# elif defined DAMEE_6
!
!  North Atlantic sponge areas.
!
       fac=8.0_r8
#  ifdef UV_VIS2
       do j=MAX(JstrR,M-20),JendR
         cff=fac*visc2+FLOAT(M-j)*(visc2-fac*visc2)/20.0_r8
         do i=IstrR,IendR
           visc2_r(i,j)=cff
           visc2_p(i,j)=cff
         enddo
       enddo
#  endif
# elif defined USWEST
!
!  US West Coast sponge areas.
!
      cff1=150.0_e8+3                    ! width (m) of sponge layer
      Iwrk=INT(cff1*FLOAT(Lm)/
     &         (xr(L,INT(0.5_r8*FLOAT(Mm)))-
     &          xr(1,INT(0.5_r8*FLOAT(Mm)))))
#  if defined UV_VIS2
      do j=JstrR,JendR
        do i=IstrR,MIN(Iwrk,IendR)
          cff=visc2*0.5_r8*(1.0_r8+COS(pi*FLOAT(i)/FLOAT(Iwrk)))
          visc2_r(i,j)=cff
          visc2_p(i,j)=cff
        enddo
        do i=MAX(IstrR,L-Iwrk),IendR
          cff=visc2*0.5_r8*(1.0_r8+COS(pi*FLOAT(L-i)/FLOAT(Iwrk)))
          visc2_r(i,j)=cff
          visc2_p(i,j)=cff
        enddo
      enddo
      do j=MAX(JstrR,M-Iwrk),MIN(M,JendR)
        do i=MAX(IstrR,M-j),MIN(L-M+j,IendR)
          cff=visc2*0.5_r8*(1.0_r8+COS(pi*FLOAT(M-j)/FLOAT(Iwrk)))
          visc2_r(i,j)=cff
          visc2_p(i,j)=cff
        enddo
      enddo
!!    do j=JstrR,MIN(Iwrk,JendR)
!!      do i=MAX(IstrR,j),MIN(L-j,IendR)
!!        cff=visc2*0.5_r8*(1.0_r8+COS(pi*FLOAT(j)/FLOAT(Iwrk)))
!!        visc2_r(i,j)=cff
!!        visc2_p(i,j)=cff
!!      enddo
!!    enddo
#  endif
#  if defined TS_DIF2
      do itrc=1,NT
        cff=tnu2(itrc)*0.5_r8
        do j=JstrR,JendR
          do i=IstrR,MIN(Iwrk,IendR)
            diff2(i,j,itrc)=cff*
     &                      (1.0_r8+COS(pi*FLOAT(i)/FLOAT(Iwrk)))
          enddo
          do i=MAX(IstrR,L-Iwrk),IendR
            diff2(i,j,itrc)=cff*
     &                      (1.0_r8+COS(pi*FLOAT(L-i)/FLOAT(Iwrk)))
          enddo
        enddo
        do j=MAX(JstrR,M-Iwrk),MIN(M,JendR)
          do i=MAX(IstrR,M-j),MIN(L-M+j,IendR)
            diff2(i,j,itrc)=cff*
     &                      (1.0_r8+COS(pi*FLOAT(M-j)/FLOAT(Iwrk)))
          enddo
        enddo
!!      do j=JstrR,MIN(Iwrk,JendR)
!!        do i=MAX(IstrR,j),MIN(L-j,IendR)
!!          diff2(i,j,itrc)=cff*
!!   &                      (1.0_r8+COS(pi*FLOAT(j)/FLOAT(Iwrk)))
!!        enddo
!!      enddo
      enddo
#  endif
# endif
#endif
      return
      end
