/*
** Include file "grid.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Cd_r       First derivative of the Cs curves (dCs_r/ds) at       **
**              vertical RHO-points.                                **
** Cd_w       First derivative of the Cs curves (dCs_w/ds) at       **
**              vertical W-points.                                  **
** Cs_r       Set of S-curves used to stretch the vertical grid     **
**              that follows the bathymetry at vertical RHO-points. **
** Cs_w       Set of S-curves used to stretch the vertical grid     **
**              that follows the bathymetry at vertical W-points.   **
** Hz         Thicknesses (m) of vertical RHO-points.               **
** Huon       Compound term, Hz*u/pn at U-points.                   **
** Hvom       Compound term, Hz*v/pm at V-points.                   **
** Tcline     Width (m) of surface or bottom boundary layer where   **
**              higher vertical resolution is required during       **
**              stretching.                                         **
** angler     Angle (radians) between XI-axis and true EAST at      **
**              RHO-points.                                         **
** dmde       ETA-derivative of inverse metric factor pm,           **
**              d(1/pm)/d(ETA).                                     **
** dndx       XI-derivative  of inverse metric factor pn,           **
**              d(1/pn)/d(XI).                                      **
** el         Length (m) of domain box in the ETA-direction.        **
** f          Coriolis parameter (1/s).                             **
** fomn       Compound term, f/(pm*pn) at RHO points.               **
** grdscl     Grid scale used to adjust horizontal mixing according **
**              to grid area.                                       **
** h          Bottom depth (m) at RHO-points.                       **
** hc         S-coordinate parameter, hc=min(hmin,Tcline).          **
** hinv       Inverse of Bottom depth (1/m) at RHO-points.          **
** hmax       Maximum depth (m) of bathymetry.                      **
** hmin       Minimum depth (m) of bathymetry.                      **
** latr       Latitude (degrees_north) at RHO-points.               **
** lonr       Longitude (degrees_east) at RHO-points.               **
** omm        RHO-grid area (meters2).                              **
** om_p       PSI-grid spacing (meters) in the XI-direction.        **
** om_r       RHO-grid spacing (meters) in the XI-direction.        **
** om_u       U-grid spacing (meters) in the XI-direction.          **
** om_v       V-grid spacing (meters) in the XI-direction.          **
** on_p       PSI-grid spacing (meters) in the ETA-direction.       **
** on_r       RHO-grid spacing (meters) in the ETA-direction.       **
** on_u       U-grid spacing (meters) in the ETA-direction.         **
** on_v       V-grid spacing (meters) in the ETA-direction.         **
** pm         Coordinate transformation metric "m" (1/meters)       **
**              associated with the differential distances in XI.   **
** pmon_p     Compound term, pm/pn at PSI-points.                   **
** pmon_r     Compound term, pm/pn at RHO-points.                   **
** pmon_u     Compound term, pm/pn at U-points.                     **
** pmon_v     Compound term, pm/pn at V-points.                     **
** pn         Coordinate transformation metric "n" (1/meters)       **
**              associated with the differential distances in ETA.  **
** pnom_p     Compound term, pn/pm at PSI-points.                   **
** pnom_r     Compound term, pn/pm at RHO-points.                   **
** pnom_u     Compound term, pn/pm at U-points.                     **
** pnom_v     Compound term, pn/pm at V-points.                     **
** sc_r       S-coordinate independent variable, [-1 < sc < 0] at   **
**              vertical RHO-points.                                **
** sc_w       S-coordinate independent variable, [-1 < sc < 0] at   **
**              vertical W-points.                                  **
** spherical  Switch indicating spherical grid configuration.       **
** theta_s    S-coordinate surface control parameter,               **
**              [0 < theta_s < 20].                                 **
** theta_b    S-coordinate bottom control parameter,                **
**              [0 < theta_b < 1].                                  **
** xl         Length (m) of domain box in the XI-direction.         **
** xp         XI-coordinates (m) at PSI-points.                     **
** xr         XI-coordinates (m) at RHO-points.                     **
** yp         ETA-coordinates (m) at PSI-points.                    **
** yr         ETA-coordinates (m) at RHO-points.                    **
** zice       Depth of ice shelf cavity (m, negative) at            **
**              RHO-points.                                         **
** z_r        Actual depths (m) at horizontal RHO-points and        **
**              vertical RHO-points.                                **
** z_w        Actual depths (m) at horizontal RHO-points and        **
**              vertical W-points.                                  **
**                                                                  **
**********************************************************************
*/

      common /lgrid/ spherical
      logical spherical

      common /sgrid/
     &        Tcline,            el,                 hc,
     &        hmax,              hmin,               theta_b,
     &        theta_s,           xl
      REAL_TYPE
     &        Tcline,            el,                 hc,
     &        hmax,              hmin,               theta_b,
     &        theta_s,           xl

      common /vgrid/
     &        Cs_r,              Cs_w,               sc_r,
     &        sc_w
      REAL_TYPE
     &        Cs_r(N),           Cs_w(0:N),          sc_r(N),
     &        sc_w(0:N)

      common /grid_angler/ angler
      REAL_TYPE angler(GLOBAL_2D_ARRAY)

#if defined CURVGRID && defined UV_ADV

      common /grid_dmde/ dmde
      REAL_TYPE dmde(GLOBAL_2D_ARRAY)

      common /grid_dndx/ dndx
      REAL_TYPE dndx(GLOBAL_2D_ARRAY)

#endif /* CURVGRID && UV_ADV */

      common /grid_f/ f
      REAL_TYPE f(GLOBAL_2D_ARRAY)

      common /grid_fomn/ fomn
      REAL_TYPE fomn(GLOBAL_2D_ARRAY)

      common /grid_grdscl/ grdscl
      REAL_TYPE grdscl(GLOBAL_2D_ARRAY)

      common /grid_h/ h
      REAL_TYPE h(GLOBAL_2D_ARRAY)

      common /grid_hinv/ hinv
      REAL_TYPE hinv(GLOBAL_2D_ARRAY)

      common /grid_latr/ latr
      REAL_TYPE latr(GLOBAL_2D_ARRAY)

      common /grid_lonr/ lonr
      REAL_TYPE lonr(GLOBAL_2D_ARRAY)

      common /grid_omn/ omn
      REAL_TYPE omn(GLOBAL_2D_ARRAY)

      common /grid_omp/ om_p
      REAL_TYPE om_p(GLOBAL_2D_ARRAY)

      common /grid_omr/ om_r
      REAL_TYPE om_r(GLOBAL_2D_ARRAY)

      common /grid_omu/ om_u
      REAL_TYPE om_u(GLOBAL_2D_ARRAY)

      common /grid_omv/ om_v
      REAL_TYPE om_v(GLOBAL_2D_ARRAY)

      common /grid_onp/ on_p
      REAL_TYPE on_p(GLOBAL_2D_ARRAY)

      common /grid_onr/ on_r
      REAL_TYPE on_r(GLOBAL_2D_ARRAY)

      common /grid_onu/ on_u
      REAL_TYPE on_u(GLOBAL_2D_ARRAY)

      common /grid_onv/ on_v
      REAL_TYPE on_v(GLOBAL_2D_ARRAY)

      common /grid_pm/ pm
      REAL_TYPE pm(GLOBAL_2D_ARRAY)

      common /grid_pn/ pn
      REAL_TYPE pn(GLOBAL_2D_ARRAY)

      common /grid_pmon_p/ pmon_p
      REAL_TYPE pmon_p(GLOBAL_2D_ARRAY)

      common /grid_pmon_r/ pmon_r
      REAL_TYPE pmon_r(GLOBAL_2D_ARRAY)

      common /grid_pmon_u/ pmon_u
      REAL_TYPE pmon_u(GLOBAL_2D_ARRAY)

      common /grid_pmon_v/ pmon_v
      REAL_TYPE pmon_v(GLOBAL_2D_ARRAY)

      common /grid_pnom_p/ pnom_p
      REAL_TYPE pnom_p(GLOBAL_2D_ARRAY)

      common /grid_pnom_r/ pnom_r
      REAL_TYPE pnom_r(GLOBAL_2D_ARRAY)

      common /grid_pnom_u/ pnom_u
      REAL_TYPE pnom_u(GLOBAL_2D_ARRAY)

      common /grid_pnom_v/ pnom_v
      REAL_TYPE pnom_v(GLOBAL_2D_ARRAY)

      common /grid_xp/ xp
      REAL_TYPE xp(GLOBAL_2D_ARRAY)

      common /grid_xr/ xr
      REAL_TYPE xr(GLOBAL_2D_ARRAY)

      common /grid_yp/ yp
      REAL_TYPE yp(GLOBAL_2D_ARRAY)

      common /grid_yr/ yr
      REAL_TYPE yr(GLOBAL_2D_ARRAY)

#ifdef SOLVE3D

      common /grid_Hz/ Hz
      REAL_TYPE Hz(GLOBAL_2D_ARRAY,N)

      common /grid_Huon/ Huon
      REAL_TYPE Huon(GLOBAL_2D_ARRAY,N)

      common /grid_Hvom/ Hvom
      REAL_TYPE Hvom(GLOBAL_2D_ARRAY,N)

      common /grid_zr/ z_r
      REAL_TYPE z_r(GLOBAL_2D_ARRAY,N)

      common /grid_zw/ z_w
      REAL_TYPE z_w(GLOBAL_2D_ARRAY,0:N)

# ifdef ICESHELF
      common /grid_zice/  zice
      REAL_TYPE  zice(GLOBAL_2D_ARRAY)
# endif /* ICESHELF */

#endif
