/*
** Include file "globaldef.h"
***************************************** Alexander F. Shchepetkin ***
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** WARNING: This  file  contains  a set of  predetermined           **
**          macro definitions which are inserted into the           **
** individual files by the C-preprocessor. It is strongly           **
** recommended to NOT modify any of the definitions below.          **
**                                                                  **
**********************************************************************
*/

/*
** Turn ON/OFF time profiling.
*/

#define PROFILE

/*
** Turn ON/OFF switch to include/disregard the difference between
** rho0 and surface density in the computation of baroclinic pressure
** term.
*/

#define RHO_SURF

/*
** Set default time-averaging filter for barotropic fields.
*/

#ifdef SOLVE3D
# undef  COSINE2
# define POWER_LAW
#endif

/*
** Activate bacroclinic pressure gradient response due to the
** perturbation of free-surface in the presence of stratification
** and bathymetry.
*/

#ifdef SOLVE3D
# define VAR_RHO_2D
#endif

/*
** Turn ON/OFF double precision for real type variables and
** associated intrinsic functions.
*/

#define DOUBLE_PRECISION

/*
**  Define macro for the first 2D time-step.
*/

#ifdef SOLVE3D
# define FIRST_2D_STEP iif.eq.1
#else
# define FIRST_2D_STEP iic.eq.ntstart
#endif

/*
** Define standard dimensions for the model arrays (vertical
** dimensions are inserted explicitly in the code, when needed).
*/

#ifdef EW_PERIODIC
# ifdef NS_PERIODIC
#  define XI_DIM -2:Lm+2+padd_X
#  define ETA_DIM -2:Mm+2+padd_E
#  define GLOBAL_2D_ARRAY XI_DIM,ETA_DIM
#  define START_2D_ARRAY -2,-2
# else
#  define XI_DIM -2:Lm+2+padd_X
#  define ETA_DIM 0:Mm+1+padd_E
#  define GLOBAL_2D_ARRAY XI_DIM,ETA_DIM
#  define START_2D_ARRAY -2,0
# endif
#else
# ifdef NS_PERIODIC
#  define XI_DIM 0:Lm+1+padd_X
#  define ETA_DIM -2:Mm+2+padd_E
#  define GLOBAL_2D_ARRAY XI_DIM,ETA_DIM
#  define START_2D_ARRAY 0,-2
# else
#  define XI_DIM 0:Lm+1+padd_X
#  define ETA_DIM 0:Mm+1+padd_E
#  define GLOBAL_2D_ARRAY XI_DIM,ETA_DIM
#  define START_2D_ARRAY 0,0
# endif
#endif
#define PRIVATE_1D_SCRATCH_ARRAY Istr-3:Iend+3
#define PRIVATE_2D_SCRATCH_ARRAY Istr-3:Iend+3,Jstr-3:Jend+3

/*
** The following definitions contain fortran logical expressions
** equivalent to the question: ''Am I the thread working on subdomain
** [tile] which is adjacent to the WESTERN [EASTERN/SOUTHERN/NORTHERN]
** edge of the model domain?'' These logical expressions are used to
** control loop bounds over a subdomain [tile], so that boundary points
** are included, if needed and if the subdomain is adjacent to the
** boundary. They are also used to decide which thread is updating the
** segment of the boundary to avoid mutual overlap.  In the case when
** there is only one subdomain all four of these logical expressions
** have value .TRUE.
*/

#define WESTERN_EDGE Istr.eq.1
#define EASTERN_EDGE Iend.eq.Lm
#define SOUTHERN_EDGE Jstr.eq.1
#define NORTHERN_EDGE Jend.eq.Mm
#define SOUTH_WEST_CORNER (Istr.eq.1).and.(Jstr.eq.1)
#define NORTH_WEST_CORNER (Istr.eq.1).and.(Jend.eq.Mm)
#define SOUTH_EAST_CORNER (Iend.eq.Lm).and.(Jstr.eq.1)
#define NORTH_EAST_CORNER (Iend.eq.Lm).and.(Jend.eq.Mm)

/*
** Choice of double/single precision for real type variables and
** associated intrinsic functions.
*/

#if defined CRAY || defined CRAYT3E
# ifdef  DOUBLE_PRECISION
#  undef  DOUBLE_PRECISION
# endif
#endif

#ifdef DOUBLE_PRECISION
# define _e8 d
# define _r8 d0
# define POINTER_TYPE integer*8
# define INTEGER_TYPE integer
# define REAL_TYPE real*8
# define COMPLEX_TYPE complex
# define ATAN DATAN
# define FLOAT DFLOAT
# define SIGN DSIGN
# define SQRT DSQRT
# define COS DCOS
# define SIN DSIN
# define EXP DEXP
# define TAN DTAN
# define TANH DTANH
# define LOG DLOG
# define NF_FTYPE nf_double
# define nf_get_att_FTYPE nf_get_att_double
# define nf_put_att_FTYPE nf_put_att_double
# define nf_get_var1_FTYPE nf_get_var1_double
# define nf_put_var1_FTYPE nf_put_var1_double
# define nf_get_vara_FTYPE nf_get_vara_double
# define nf_put_vara_FTYPE nf_put_vara_double
#else
# define _e8 e
# define _r8
# define POINTER_TYPE integer*8
# define INTEGER_TYPE integer
# define REAL_TYPE real
# define COMPLEX_TYPE complex
# define NF_FTYPE nf_real
# define nf_get_att_FTYPE nf_get_att_real
# define nf_put_att_FTYPE nf_put_att_real
# define nf_get_var1_FTYPE nf_get_var1_real
# define nf_put_var1_FTYPE nf_put_var1_real
# define nf_get_vara_FTYPE nf_get_vara_real
# define nf_put_vara_FTYPE nf_put_vara_real
#endif
#ifdef OUT_DOUBLE
# define NF_FOUT nf_double
#else
# define NF_FOUT nf_real
#endif
#ifdef RST_SINGLE
# define NF_FRST nf_real
#else
# define NF_FRST nf_double
#endif

/*
** Set output index for multi-time levels variables.
*/

#ifdef SOLVE3D
# define KOUT kstp
# define NOUT nrhs
#else
# define KOUT knew
#endif

/*
** If splines, deactivate horizontal and vertical smoothing of
** Richardson number horizontally and/or vertically.
*/

#ifdef SPLINES
# if defined LMD_MIXING
#  undef RI_HORAVG
#  undef RI_VERAVG
# endif
#endif

/*
** Activate internal switch for the computation of the Brunt-Vaisala
** frequency.
*/

#if defined BVF_MIXING || defined LMD_MIXING  || defined LMD_SKPP    || \
    defined LMD_BKPP   || defined GLS_MIXING  || defined MY25_MIXING
# define BV_FREQUENCY
#endif


/*
** Activate internal switch for bottom boundary layer closure.
*/

#if defined CS_BBL || defined MB_BBL || defined SG_BBL
# define BBL
#endif

/*
** Activate internal switch to set-up nudging coefficients.
*/

#if defined ZCLM_NUDGING    || defined M2CLM_NUDGING   || \
    defined TCLM_NUDGING    || defined M3CLM_NUDGING   || \
    defined WEST_FSNUDGING  || defined EAST_FSNUDGING  || \
    defined SOUTH_FSNUDGING || defined NORTH_FSNUDGING || \
    defined WEST_M2NUDGING  || defined EAST_M2NUDGING  || \
    defined SOUTH_M2NUDGING || defined NORTH_M2NUDGING || \
    defined WEST_TNUDGING   || defined EAST_TNUDGING   || \
    defined SOUTH_TNUDGING  || defined NORTH_TNUDGING  || \
    defined WEST_M3NUDGING  || defined EAST_M3NUDGING  || \
    defined SOUTH_M3NUDGING || defined NORTH_M3NUDGING
# define NUDGING_COFF
#endif

/*
** Activate internal switches requiring open boundary data.
*/

#if (defined WEST_M2RADIATION  && defined WEST_M2NUDGING)  || \
     defined WEST_M2FLATHER    || defined WEST_M2CLAMPED
# define WEST_M2OBC
#endif
#if (defined EAST_M2RADIATION  && defined EAST_M2NUDGING)  || \
     defined EAST_M2FLATHER    || defined EAST_M2CLAMPED
# define EAST_M2OBC
#endif
#if (defined SOUTH_M2RADIATION && defined SOUTH_M2NUDGING) || \
     defined SOUTH_M2FLATHER   || defined SOUTH_M2CLAMPED
# define SOUTH_M2OBC
#endif
#if (defined NORTH_M2RADIATION && defined NORTH_M2NUDGING) || \
     defined NORTH_M2FLATHER   || defined NORTH_M2CLAMPED
# define NORTH_M2OBC
#endif

#if (defined WEST_FSRADIATION  && defined WEST_FSNUDGING)  || \
     defined WEST_M2FLATHER    || defined WEST_FSCLAMPED
# define WEST_FSOBC
#endif
#if (defined EAST_FSRADIATION  && defined EAST_FSNUDGING)  || \
     defined EAST_M2FLATHER    || defined EAST_FSCLAMPED
# define EAST_FSOBC
#endif
#if (defined SOUTH_FSRADIATION && defined SOUTH_FSNUDGING) || \
     defined SOUTH_M2FLATHER   || defined SOUTH_FSCLAMPED
# define SOUTH_FSOBC
#endif
#if (defined NORTH_FSRADIATION && defined NORTH_FSNUDGING) || \
     defined NORTH_M2FLATHER   || defined NORTH_FSCLAMPED
# define NORTH_FSOBC
#endif

#if (defined WEST_M3RADIATION  && defined WEST_M3NUDGING)  || \
     defined WEST_M3CLAMPED
# define WEST_M3OBC
#endif
#if (defined EAST_M3RADIATION  && defined EAST_M3NUDGING)  || \
     defined EAST_M3CLAMPED
# define EAST_M3OBC
#endif
#if (defined SOUTH_M3RADIATION && defined SOUTH_M3NUDGING) || \
     defined SOUTH_M3CLAMPED
# define SOUTH_M3OBC
#endif
#if (defined NORTH_M3RADIATION && defined NORTH_M3NUDGING) || \
     defined NORTH_M3CLAMPED
# define NORTH_M3OBC
#endif

#if (defined WEST_TRADIATION   && defined WEST_TNUDGING)   || \
     defined WEST_TCLAMPED
# define WEST_TOBC
#endif
#if (defined EAST_TRADIATION   && defined EAST_TNUDGING)   || \
     defined EAST_TCLAMPED
# define EAST_TOBC
#endif
#if (defined SOUTH_TRADIATION  && defined SOUTH_TNUDGING)  || \
     defined SOUTH_TCLAMPED
# define SOUTH_TOBC
#endif
#if (defined NORTH_TRADIATION  && defined NORTH_TNUDGING)  || \
     defined NORTH_TCLAMPED
# define NORTH_TOBC
#endif

#ifdef SOLVE3D
# if defined WEST_FSOBC  || defined EAST_FSOBC  || \
     defined SOUTH_FSOBC || defined NORTH_FSOBC || \
     defined WEST_M2OBC  || defined EAST_M2OBC  || \
     defined SOUTH_M2OBC || defined NORTH_M2OBC || \
     defined WEST_M3OBC  || defined EAST_M3OBC  || \
     defined SOUTH_M3OBC || defined NORTH_M3OBC || \
     defined WEST_TOBC   || defined EAST_TOBC   || \
     defined SOUTH_TOBC  || defined NORTH_TOBC
#  define OBC
# endif
#else
# if defined WEST_FSOBC  || defined EAST_FSOBC  || \
     defined SOUTH_FSOBC || defined NORTH_FSOBC || \
     defined WEST_M2OBC  || defined EAST_M2OBC  || \
     defined SOUTH_M2OBC || defined NORTH_M2OBC
#  define OBC
# endif
#endif

/*
** Define internal flag indicating processing of input boundary
** NetCDF file.
*/

#if (!defined ANA_FSOBC && \
     (defined WEST_FSOBC  || defined EAST_FSOBC    || \
      defined SOUTH_FSOBC || defined NORTH_FSOBC)) || \
    (!defined ANA_M2OBC && \
     (defined WEST_M2OBC  || defined EAST_M2OBC    || \
      defined SOUTH_M2OBC || defined NORTH_M2OBC)) || \
    (!defined ANA_M3OBC && \
     (defined WEST_M3OBC  || defined EAST_M3OBC    || \
      defined SOUTH_M3OBC || defined NORTH_M3OBC)) || \
    (!defined ANA_TOBC && \
     (defined WEST_TOBC   || defined EAST_TOBC    || \
      defined SOUTH_TOBC  || defined NORTH_TOBC))
# define OBC_DATA
#endif

/*
** Activate internal switches for volume conservation at open boundary.
*/

#if defined WEST_M2OBC  || defined WEST_M2RADIATION
# define WEST_VOLCONS
#endif
#if defined EAST_M2OBC  || defined EAST_M2RADIATION
# define EAST_VOLCONS
#endif
#if defined SOUTH_M2OBC || defined SOUTH_M2RADIATION
# define SOUTH_VOLCONS
#endif
#if defined NORTH_M2OBC || defined NORTH_M2RADIATION
# define NORTH_VOLCONS
#endif

/*
** Activate assimilation switches.
*/

#if defined RANDOM_ESPERT
# define PERTURBATION
# define ESSE
#endif

#if defined ASSIMILATION_SSH || defined ASSIMILATION_SST   || \
    defined ASSIMILATION_T   || defined ASSIMILATION_UVsur || \
    defined ASSIMILATION_UV
# define ASSIMILATION
#endif
#if defined NUDGING_SSH || defined NUDGING_SST   || \
    defined NUDGING_T   || defined NUDGING_UVsur || \
    defined NUDGING_UV
# define NUDGING
#endif

/*
** Check if it is meaningful to write out time-averaged vertical
** mixing coefficients.
*/

#if !defined LMD_MIXING && !defined MY25_MIXING
# if defined AVERAGES
#  if defined AVERAGES_AKV
#    undef AVERAGES_AKV
#  endif
#  if defined AVERAGES_AKT
#    undef AVERAGES_AKT
#  endif
#  if defined AVERAGES_AKS && !defined SALINITY
#    undef AVERAGES_AKS
#  endif
# endif
#endif

/*
** Define internal flag indicating processing of input forcing
** NetCDF file.
*/

#ifdef SOLVE3D
# ifdef BULK_FLUXES
#  ifdef ANA_SMFLUX
#   undef ANA_SMFLUX
#  endif
#  ifdef ANA_STFLUX
#   undef ANA_STFLUX
#  endif
# endif
# if !defined ANA_BTFLUX   || \
    (!defined BULK_FLUXES  && !defined ANA_SMFLUX)   || \
    (!defined BULK_FLUXES  && !defined ANA_STFLUX)   || \
    ( defined SALINITY     && !defined ANA_SSFLUX)   || \
    ( defined BULK_FLUXES  && !defined LONGWAVE)     || \
    ( defined BULK_FLUXES  && !defined ANA_PAIR)     || \
    ( defined BULK_FLUXES  && !defined ANA_TAIR)     || \
    ( defined BULK_FLUXES  && !defined ANA_HUMIDITY) || \
    ( defined BULK_FLUXES  && !defined ANA_CLOUD)    || \
    ( defined BULK_FLUXES  && !defined ANA_RAIN)     || \
    ( defined BULK_FLUXES  && !defined ANA_SRFLUX)   || \
    ( defined LMD_SKPP     && !defined ANA_SRFLUX)   || \
    ( defined SOLAR_SOURCE && !defined ANA_SRFLUX)   || \
    ( defined BBL          && !defined ANA_BSEDIM)   || \
    ( defined BBL          && !defined ANA_WWAVE)    || \
    ( defined BIOLOGY      && !defined ANA_SPFLUX)   || \
    ( defined BIOLOGY      && !defined ANA_BPFLUX)   || \
    ( defined SEDIMENT     && !defined ANA_SPFLUX)   || \
    ( defined SEDIMENT     && !defined ANA_BPFLUX)
#  define FRC_FILE
# endif
#else
# if !defined ANA_SMFLUX
#  define FRC_FILE
# endif
#endif

/*
** Activate internal biology option when using any type of biological
** module.
*/

#ifdef BIO_FASHAM
# define BIOLOGY
#endif

/*
** Define internal shortwave radiation option.  Undefine analytical
** shortwave option if not needed.
*/

#if defined LMD_SKPP     || defined SOLAR_SOURCE   || \
    defined BULK_FLUXES  || defined BIOLOGY
# define SHORTWAVE
#endif
#if !defined SHORTWAVE   && defined ANA_SRFLUX
# undef ANA_SRFLUX
#endif

/*
** Define internal clouds option.  Undefine analytical
** shortwave option if not needed.
*/

#if (defined BULK_FLUXES && defined LONGWAVE) || \
     defined BIO_FASHAM  || defined ALBEDO
# define CLOUDS
#endif
#if !defined CLOUDS && defined ANA_CLOUD
# undef ANA_CLOUD
#endif
