#include "cppdefs.h"
      subroutine get_ngfld (Fout,Io,Im,Jm,Iout,Irec,Jrec,ifield,ncid,
     &                      ncfile,update)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine reads in requested non-grided field from specified   !
!  NetCDF file.  A non-grided field has different dimensions  than   !
!  model spatial dimensions.                                         !
!                                                                    !
!  On Input/Output:                                                  !
!                                                                    !
!     Fout       Read field (real).                                  !
!     Io         "Fout" 1st dimension lower-specifier in calling     !
!                  program.                                          !
!     Im         "Fout" 1st dimension upper-specifier in calling     !
!                  program.                                          !
!     Jm         Size of "Fout" 2nd dimension in calling program,    !
!                  if any.  Otherwise, a one is expected.            !
!     Iout       Size of "Fout" time dimension in calling program,   !
!                  if any.  Otherwise, a one is expected.            !
!     Irec       Number read records in the 1st dimension.           !
!     Jrec       Number read records in the 2st dimension.           !
!     ifield     Field ID (integer).                                 !
!     ncid       NetCDF file ID (integer).                           !
!     ncfile     NetCDF file name (string).                          !
!     update     Switch indicating reading of the requested field    !
!                  the current time step.                            !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "iounits.h"
# include "ncparam.h"
# include "netcdf.inc"
# include "scalars.h"
!
      logical Liocycle, Lgrided, Lonerec, got_var, got_time, update
      INTEGER_TYPE
     &        Im, Io, Iout, Irec, Jm, Jrec, Nrec, Tid, Tindex, Trec,
     &        Vid, Vtype, i, ii, j, ifield, lstr, lfvar, ltvar, lvar,
     &        npts, ncid, status
      INTEGER_TYPE
     &        count(3), start(3)
      INTEGER_TYPE
     &        lenstr
      REAL_TYPE
     &        Aval, Clength, Fmax, Fmin, Tdelta, Tend, Tscale, Tstart,
     &        Tstr, Tval
      REAL_TYPE
     &        A(Lp*Mp*N), Fout(Io:Im,Jm,Iout)
      character*(*) ncfile
!
!---------------------------------------------------------------------
!  On first call, inquire about the contents of input NetCDF file.
!---------------------------------------------------------------------
!
      if (exit_flag.ne.0) return
!
      if (iic.eq.0) then
!
!  Intialize local variables.
!
        Liocycle=.false.
        Lgrided=.false.
        Lonerec=.false.
        got_var=.false.
        got_time=.false.
        Vid=-1
        Tid=-1
        Vtype=Iinfo(1,ifield)
!
!  Inquire about the dimensions and variables. Check for consistency.
!
        lstr=lenstr(ncfile)
        lfvar=lenstr(Vname(1,ifield))
        ltvar=lenstr(Tname(ifield))
        call opencdf (ncfile,N,ifield,Nrec)
        if (Irec.eq.0) Irec=Nrec
        if (exit_flag.ne.0) return
        if ((Iout.eq.1).and.(Irec.gt.Im)) then
          write(stdout,10) Vname(1,ifield)(1:lfvar), Im, Irec
          exit_flag=4
          return
        endif
!
!  Scan variable list from input NetCDF and check for requested
!  variables.
!
        do i=1,nvars
          lvar=lenstr(varnam(i))
          if (lfvar.gt.0) then
            if (varnam(i)(1:lvar).eq.Vname(1,ifield)(1:lfvar)) then
              Vid=i
              got_var=.true.
            endif
          endif
          if (ltvar.gt.0) then
            if (varnam(i)(1:lvar).eq.Tname(ifield)(1:ltvar)) then
              Tid=i
              got_time=.true.
            endif
          endif
        enddo
        Linfo(1,ifield)=Lgrided
        Iinfo(2,ifield)=Vid
        Iinfo(3,ifield)=Tid
        Iinfo(4,ifield)=Nrec
!
!  Terminate execution requested variables are not found.
!
        if (.not.got_var) then
          write(stdout,20) Vname(1,ifield)(1:lfvar), ncfile(1:lstr)
          exit_flag=2
          return
        endif
        if (.not.got_time) then
          write(stdout,20) Tname(ifield)(1:ltvar), ncfile(1:lstr)
          exit_flag=2
          return
        endif
!
!  If appropriate, open input NetCDF file for reading.
!
        if (ncid.eq.-1) then
          status=nf_open(ncfile(1:lstr),nf_nowrite,ncid)
          if (status.ne.nf_noerr) then
            write(stdout,30) ncfile(1:lstr)
            exit_flag=2
            return
          endif
        endif
!
!  Determine initial time record to read and cycling switch.
!
        if (Iout.eq.1) then
          Tstart=1
          Tend=1
          Trec=1
          Clength=0.0_r8
          Tscale=1.0_r8
        else
          call get_cycle (ncid,Tid,Nrec,tdays,Liocycle,Clength,Trec,
     &                    Tstart,Tstr,Tend,Tscale)
          if (exit_flag.ne.0) return
        endif
        Linfo(2,ifield)=Liocycle
        Finfo(1,ifield)=Tstart
        Finfo(2,ifield)=Tend
        Finfo(3,ifield)=Clength
        Finfo(6,ifield)=Tscale
!
!  The strategy here is to create a local, monotonically increasing
!  time variable so the interpolation between snapshots is trivial
!  when cycling forcing fields. Subtract one to time record counter
!  "Trec" to avoid doing special case at initialization.
!
        if (Irec.eq.1) then
          Tindex=Iout
        else
          Tindex=1
        endif
        Vtime(Tindex,ifield)=Tstart
        if (Liocycle) then
          if (Trec.eq.Nrec) then
            if (tdays.lt.Tend) then
              Tmono(ifield)=Tstart-Clength
            else
              Tmono(ifield)=tdays+(Tstart-Clength)
              Tmono(ifield)=Tmono(ifield)+
     &                      (Tstart-MOD(tdays+Tstart,Clength))
            endif
            Tmono(ifield)=Tmono(ifield)*day2sec
          else
            if (tdays.gt.Clength) then
              Tmono(ifield)=time-MOD(tdays-Tstart,Clength)*day2sec
            else
              Tmono(ifield)=Tstart*day2sec
            endif
          endif
        else
          Tmono(ifield)=time
        endif
        Trec=Trec-1
!
!  Set switch for one time record dataset. In this case, the input
!  data is always the same and time interpolation is not performed.
!
        if (Nrec.eq.1) Lonerec=.true.
        Linfo(3,ifield)=Lonerec
!
!---------------------------------------------------------------------
!  Else, get requested field information from global storage.
!---------------------------------------------------------------------
!
      else
        Liocycle=Linfo(2,ifield)
        Lonerec =Linfo(3,ifield)
        Vtype   =Iinfo(1,ifield)
        Vid     =Iinfo(2,ifield)
        Tid     =Iinfo(3,ifield)
        Nrec    =Iinfo(4,ifield)
        Tindex  =Iinfo(5,ifield)
        Trec    =Iinfo(6,ifield)
        Clength =Finfo(3,ifield)
        Tscale  =Finfo(6,ifield)
      endif
!
!---------------------------------------------------------------------
!  If appropriate, read in new data.
!---------------------------------------------------------------------
!
      update=.false.
      if ((Tmono(ifield).lt.time).or.(iic.eq.0).or.
     &    (iic.eq.ntstart)) then
        if (Liocycle) then
          Trec=MOD(Trec,Nrec)+1
        else
          Trec=Trec+1
        endif
        Iinfo(6,ifield)=Trec
        if (Trec.le.Nrec) then
!
!  Set rolling index for two-time record storage of input data.  If
!  "Iout" is unity, input data is stored in recordless array by the
!  calling program.
!
         if (Iout.eq.1) then
           Tindex=1
         else
           Tindex=3-Tindex
         endif
         Iinfo(5,ifield)=Tindex
!
!  Read in time coordinate.
!
          if ((Tid.ge.0).and.(Tid.ne.Vid)) then
            status=nf_get_var1_FTYPE(ncid,Tid,Trec,Tval)
            Vtime(Tindex,ifield)=Tval*Tscale
            if (status.ne.nf_noerr) then
              ltvar=lenstr(Tname(ifield))
              write(stdout,40) Tname(ifield)(1:ltvar), Trec
              exit_flag=2
              return
            endif
          endif
!
!  Read in non-grided data.
!
          if (Vid.ge.0) then
            Fmin=0.0_r8
            Fmax=0.0_r8
            if (Jrec.gt.1) then
              start(1)=1
              count(1)=(Irec-Io)+1
              start(2)=1
              count(2)=Jrec
              start(3)=Trec
              count(3)=1
              npts=count(1)*count(2)*count(3)
            else
              start(1)=1
              count(1)=(Irec-Io)+1
              start(2)=Trec
              count(2)=1
              npts=count(1)*count(2)
            endif
            status=nf_get_vara_FTYPE(ncid,Vid,start,count,A)
            if (status.ne.nf_noerr) then
              lfvar=lenstr(Vname(1,ifield))
              write(stdout,40) Vname(1,ifield)(1:lfvar), Trec
              exit_flag=2
              return
            endif
            Fmin=A(1)*Fscale(ifield)
            Fmax=A(1)*Fscale(ifield)
            ii=0
            do j=1,Jrec
              do i=Io,Irec
                ii=ii+1
                Aval=A(ii)*Fscale(ifield)
                Fmin=MIN(Fmin,Aval)
                Fmax=MAX(Fmax,Aval)
                Fout(i,j,Tindex)=Aval
              enddo
            enddo
            Finfo(4,ifield)=Fmin
            Finfo(5,ifield)=Fmax
            lfvar=lenstr(Vname(2,ifield))
            if (Iout.eq.1) then
              write(stdout,50) Vname(2,ifield)(1:lfvar), Fmin, Fmax
            else
              write(stdout,60) Vname(2,ifield)(1:lfvar), Tval*Tscale,
     &                         Fmin, Fmax
            endif
            update=.true.
          endif
        endif
!
!  Increment the local time variable "Tmono" by the interval between
!  snapshots. If the interval is negative, indicating cycling, add in
!  a cycle length.  Load time value (sec) into "Tintrp" which used
!  during interpolation between snapshots.
!
        if (.not.Lonerec) then
          Tdelta=Vtime(Tindex,ifield)-Vtime(3-Tindex,ifield)
          if (Liocycle.and.(Tdelta.lt.0.0_r8)) then
            Tdelta=Tdelta+Clength
          endif
          Tmono(ifield)=Tmono(ifield)+Tdelta*day2sec
          Tintrp(Tindex,ifield)=Tmono(ifield)
        endif
      endif
!
  10  format(/,' GET_NGFLD   - too small dimension for variable ',a,
     &       ': ',2i5)
  20  format(/,' GET_NGFLD   - unable to find requested variable: ',a,
     &       /,15x,'in input NetCDF file: ',a)
  30  format(/,' GET_NGFLD   - unable to open input NetCDF file: ',a)
  40  format(/,' GET_NGFLD   - error while reading variable: ',a,2x,
     &       ' at TIME index = ',i4)
  50  format(' GET_NGFLD   - ',a,/,17x,'(Min = ',1pe15.8,' Max = ',
     &       1pe15.8,')')
  60  format(' GET_NGFLD   - ',a,',',t64,'t = ',f12.4,/,17x,'(Min = ',
     &       1pe15.8,' Max = ',1pe15.8,')')
      return
      end
