#include "cppdefs.h"
      subroutine get_mask
#ifdef MASKING
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine read in Land/Sea mask from GRID NetCDF file.         !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "iounits.h"
# include "mask.h"
# include "ncparam.h"
# include "netcdf.inc"
# include "scalars.h"
!
      logical gotmskp, gotmskr, gotmsku, gotmskv
      INTEGER_TYPE
     &        gtype, i, ifield, j, lstr, lvar, mskpid, mskrid, mskuid,
     &        mskvid, nrec, status
      INTEGER_TYPE lenstr, nf_fread
      REAL_TYPE
     &        Fmax, Fmin, Fscl
      parameter (Fscl=1.0_r8)
!
!---------------------------------------------------------------------
!  Inquire about the contents of grid NetCDF file:  Inquire about
!  the dimensions and variables.  Check for consistency.
!---------------------------------------------------------------------
!
      if (exit_flag.ne.0) return
      ifield=0
      call opencdf (grdname,N,ifield,nrec)
      if (exit_flag.ne.0) return
!
!  Scan variable list from input NetCDF and check for grid variables.
!
      gotmskp=.false.
      gotmskr=.false.
      gotmsku=.false.
      gotmskv=.false.
      do i=1,nvars
        lvar=lenstr(varnam(i))
        if (varnam(i)(1:lvar).eq.'mask_rho') then
          mskrid=i
          gotmskr=.true.
        elseif (varnam(i)(1:lvar).eq.'mask_u') then
          mskuid=i
          gotmsku=.true.
        elseif (varnam(i)(1:lvar).eq.'mask_v') then
          mskvid=i
          gotmskv=.true.
        elseif (varnam(i)(1:lvar).eq.'mask_psi') then
          mskpid=i
          gotmskp=.true.
        endif
      enddo
!
!  Terminate execution if essential grid variables are not found.
!
      lstr=lenstr(grdname)
      if (.not.gotmskr) then
        write(stdout,10) 'mask_rho', grdname(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.gotmsku) then
        write(stdout,10) 'mask_u', grdname(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.gotmskv) then
        write(stdout,10) 'mask_v', grdname(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.gotmskp) then
        write(stdout,10) 'mask_psi', grdname(1:lstr)
        exit_flag=2
        return
      endif
!
!  Open grid NetCDF file for reading.
!
      if (ncgrdid.eq.-1) then
        status=nf_open(grdname(1:lstr),nf_nowrite,ncgrdid)
        if (status.ne.nf_noerr) then
          write(stdout,20) grdname(1:lstr)
          exit_flag=2
          return
        endif
      endif
!
!---------------------------------------------------------------------
!  Read in mask variables.
!---------------------------------------------------------------------
!
!  Read in mask at RHO-points.
!
      gtype=vflag(mskrid)*r2dvar
      status=nf_fread(rmask(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                ncgrdid,mskrid,0,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'mask_rho', grdname(1:lstr)
        exit_flag=2
        return
      endif
!
!  Read in mask at U-points.
!
      gtype=vflag(mskuid)*u2dvar
      status=nf_fread(umask(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                ncgrdid,mskuid,0,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'mask_u', grdname(1:lstr)
        exit_flag=2
        return
      endif
!
!  Read in mask at V-points.
!
      gtype=vflag(mskvid)*v2dvar
      status=nf_fread(vmask(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                ncgrdid,mskvid,0,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'mask_v', grdname(1:lstr)
        exit_flag=2
        return
      endif
!
!  Read in mask at PSI-points.
!
      gtype=vflag(mskpid)*p2dvar
      status=nf_fread(pmask(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                ncgrdid,mskpid,0,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'mask_psi', grdname(1:lstr)
        exit_flag=2
        return
      endif
# ifdef WRITE_WATER
!
!---------------------------------------------------------------------
!  Determine number of water points. 
!---------------------------------------------------------------------
!
      Nxyr=0
      Nxyp=0
      Nxyu=0
      Nxyv=0
      do j=0,M
        do i=0,L
          if (rmask(i,j).gt.0.0_r8) then
            Nxyr=Nxyr+1
          endif
        enddo
        do i=1,L
          if (umask(i,j).gt.0.0_r8) then
            Nxyu=Nxyu+1
          endif
        enddo
      enddo
      do j=1,M 
        do i=1,L
          if (pmask(i,j).gt.0.0_r8) then
            Nxyp=Nxyp+1
          endif
        enddo
        do i=0,L
          if (vmask(i,j).gt.0.0_r8) then
            Nxyv=Nxyv+1
          endif
        enddo
      enddo
# endif
!
!---------------------------------------------------------------------
!  Set slipperiness (no-slip) mask at PSI-points.
!---------------------------------------------------------------------
!
!  The slipperiness mask is Sea=1, Land=0, and boundary=1-gamma2.
!
      if (gamma2.lt.0.0_r8) then
        do j=1,M
          do i=1,L
            pmask(i,j)=2.0_r8-pmask(i,j)
          enddo
        enddo
      endif
!
  10  format(/,' GET_MASK - unable to find grid variable: ',a,
     &       /,12x,'in grid NetCDF file: ',a)
  20  format(/,' GET_MASK - unable to open grid NetCDF file: ',a)
  30  format(/,' GET_MASK - error while reading variable: ',a,
     &       /,12x,'in grid NetCDF file: ',a)
#endif  /* MASKING */
      return
      end
