#include "cppdefs.h"
      subroutine get_initial
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine reads in primitive variables initial conditions   !
!  from an initial, restart, or history NetCDF file.                 !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "ncparam.h"
#include "netcdf.inc"
#include "ocean.h"
#include "scalars.h"
#include "sediment.h"
!
      logical got_var(NV)
      INTEGER_TYPE
     &        gtype, i, ifield, latt, lstr, lsvar, lvar, ncinpid,
     &        nvatts, nrec, status, tindx, varid, vartype
      INTEGER_TYPE
     &        lenstr, nf_fread
#ifdef SOLVE3D
      logical got_trc(NT)
      INTEGER_TYPE
     &        itrc
#endif /* SOLVE3D */
      REAL_TYPE
     &        Fmax, Fmin, Fscl, Tmax, time_scale
      character*15 attnam, tvarnam
      character*40 tunits
      parameter (Fscl=1.0_r8)
!
!---------------------------------------------------------------------
!  Inquire about the contents of input NetCDF file:  Inquire about
!  the dimensions and variables.  Check for consistency.
!---------------------------------------------------------------------
!
      if (exit_flag.ne.0) return
      ifield=0
      call opencdf (ininame,N,ifield,nrec)
      if (exit_flag.ne.0) return
!
!  Initialize logical switches.
!
        do i=1,NV
          got_var(i)=.false.
        enddo
#ifdef SOLVE3D
        do itrc=1,NT
          got_trc(itrc)=.false.
        enddo
#endif /* SOLVE3D */
!
!  Scan variable list from input NetCDF and activate switches for
!  model initialization variables.
!
      lstr=lenstr(ininame)
      do i=1,nvars
        lvar=lenstr(varnam(i))
        lsvar=lenstr(Vname(1,idtime))
        if ((varnam(i)(1:lvar).eq.Vname(1,idtime)(1:lsvar)).or.
     &      (varnam(i)(1:lvar).eq.'scrum_time')) then
          tvarnam=varnam(i)(1:lvar)
          got_var(idtime)=.true.
        endif
        lsvar=lenstr(Vname(1,idFsur))
        if (varnam(i)(1:lvar).eq.Vname(1,idFsur)(1:lsvar)) then
          got_var(idFsur)=.true.
        endif
        lsvar=lenstr(Vname(1,idUbar))
        if (varnam(i)(1:lvar).eq.Vname(1,idUbar)(1:lsvar)) then
          got_var(idUbar)=.true.
        endif
        lsvar=lenstr(Vname(1,idVbar))
        if (varnam(i)(1:lvar).eq.Vname(1,idVbar)(1:lsvar)) then
          got_var(idVbar)=.true.
        endif
#ifdef SOLVE3D
        lsvar=lenstr(Vname(1,idUvel))
        if (varnam(i)(1:lvar).eq.Vname(1,idUvel)(1:lsvar)) then
          got_var(idUvel)=.true.
        endif
        lsvar=lenstr(Vname(1,idVvel))
        if (varnam(i)(1:lvar).eq.Vname(1,idVvel)(1:lsvar)) then
          got_var(idVvel)=.true.
        endif
        do itrc=1,NT
          lsvar=lenstr(Vname(1,idTvar(itrc)))
          if (varnam(i)(1:lvar).eq.Vname(1,idTvar(itrc))(1:lsvar))
     &      got_trc(itrc)=.true.
        enddo
#endif /* SOLVE3D */
      enddo
!
!  Check if model initialization variables are available in input
!  NetCDF file.
!
      if (.not.got_var(idtime)) then
        lsvar=lenstr(tvarnam)
        write(stdout,10) tvarnam(1:lsvar), ininame(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.got_var(idFsur)) then
        lsvar=lenstr(Vname(1,idFsur))
        write(stdout,10) Vname(1,idFsur)(1:lsvar), ininame(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.got_var(idUbar)) then
        lsvar=lenstr(Vname(1,idUbar))
        write(stdout,10) Vname(1,idUbar)(1:lsvar), ininame(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.got_var(idVbar)) then
        lsvar=lenstr(Vname(1,idVbar))
        write(stdout,10) Vname(1,idVbar)(1:lsvar), ininame(1:lstr)
        exit_flag=2
        return
      endif
#ifdef SOLVE3D
      if (.not.got_var(idUvel)) then
        lsvar=lenstr(Vname(1,idUvel))
        write(stdout,10) Vname(1,idUvel)(1:lsvar), ininame(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.got_var(idVvel)) then
        lsvar=lenstr(Vname(1,idVvel))
        write(stdout,10) Vname(1,idVvel)(1:lsvar), ininame(1:lstr)
        exit_flag=2
        return
      endif
# ifdef ANA_BIOLOGY
      do itrc=1,NAT
# else
      do itrc=1,NT
# endif
        if (.not.got_trc(itrc)) then
          lsvar=lenstr(Vname(1,idTvar(itrc)))
          write(stdout,10) Vname(1,idTvar(itrc))(1:lsvar),
     &                     ininame(1:lstr)
          exit_flag=2
          return
        endif
      enddo
#endif /* SOLVE3D */
!
!---------------------------------------------------------------------
!  Read initial conditions from input NetCDF file.
!---------------------------------------------------------------------
!
!  Open input NetCDF file.
!
      lstr=lenstr(ininame)
      status=nf_open(ininame(1:lstr),nf_nowrite,ncinpid)
      if (status.ne.nf_noerr) then
        write(stdout,20) ininame(1:lstr)
        exit_flag=2
        return
      endif
!
!  If using the latest time record from initial NetCDF file, set
!  initialization record. Set time record index to read.  Read in
!  model time.
!
      lsvar=lenstr(tvarnam)
      status=nf_inq_varid(ncinpid,tvarnam(1:lsvar),varid)
      if (LastRec) then
        Tmax=-1.0_r8
        do i=1,tsize
          status=nf_get_var1_FTYPE(ncinpid,varid,i,time)
          if (status.ne.nf_noerr) then
            write(stdout,30) tvarnam(1:lsvar), i,
     &                       ininame(1:lstr)
            exit_flag=2
            return
          endif
          if (time.gt.Tmax) then
            Tmax=time
            nrrec=i
          endif
        enddo
        time=Tmax
        tindx=nrrec
      else
        if ((nrrec.ne.0).and.(nrrec.gt.tsize)) then
          write(stdout,40) tsize, nrrec
          exit_flag=2
          return
        endif
        if (nrrec.ne.0) then
          tindx=nrrec
        else
          tindx=1
        endif
        status=nf_get_var1_FTYPE(ncinpid,varid,tindx,time)
        if (status.ne.nf_noerr) then
          write(stdout,30) tvarnam(1:lsvar), tindx,
     &                     ininame(1:lstr)
          exit_flag=2
          return
        endif
      endif
!
!  Inquire time units. Set local time scale.
!
      time_scale=0.0_r8
      status=nf_inq_var(ncinpid,varid,tvarnam,vartype,nvdims,
     &                  vdims(1,varid),nvatts)
      if (status.eq.nf_noerr) then
        do i=1,nvatts
          status=nf_inq_attname(ncinpid,varid,i,attnam)
          if (status.eq.nf_noerr) then
            latt=lenstr(attnam)
            if (attnam(1:latt).eq.'units') then
              status=nf_get_att_text(ncinpid,varid,attnam(1:latt),
     &                               tunits)
              if (status.eq.nf_noerr) then
                if (tunits(1:3).eq.'day') then
                  time_scale=day2sec
                elseif (tunits(1:6).eq.'second') then
                 time_scale=1.0_r8
                endif
              else
                write (stdout,50) attnam(1:latt)
                exit_flag=2
                return
              endif
            endif
          else
            write(stdout,60) tvarnam
            exit_flag=2
            return
          endif
        enddo
      else
        write(stdout,70) ininame(1:lstr)
        exit_flag=2
        return
      endif
!
!  Set starting time index and time clock in days.
!
      time=time*time_scale
      tdays=time*sec2day
      ntstart=INT((time-dstart*day2sec)/dt)+1
      if (ntstart.lt.1) ntstart=1
!     if (ntstart.gt.1) ntimes=ntstart+ntimes
      ntfirst=ntstart
      if (ndefhis.gt.0) then
        if (nrrec.gt.0) then
          if (nhis.eq.ndefhis) then
            idefhis=nhis+(ntstart-1)
          else        
            idefhis=ntstart-1
          endif
        else
          idefhis=ntstart-1
        endif
      endif
      if (ndefavg.gt.0) then
        if (nrrec.gt.0) then
          if (navg.eq.ndefavg) then
            idefavg=navg+(ntstart-1)
          else        
            idefavg=ntstart-1
          endif
        else
          idefavg=ntstart-1
        endif
      endif
!
!  Read in free-surface (m).
!
      lsvar=lenstr(Vname(1,idFsur))
      status=nf_inq_varid(ncinpid,Vname(1,idFsur)(1:lsvar),varid)
      gtype=vflag(varid)*r2dvar        
      status=nf_fread(zeta(START_2D_ARRAY,1),Fmin,Fmax,Fscl,
     &                ncinpid,varid,tindx,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,40) Vname(1,idFsur)(1:lsvar), tindx,
     &                   ininame(1:lstr)
        exit_flag=2
        return
      endif
!
!  Read in 2D momentum component (m/s) in the XI-direction.
!
      lsvar=lenstr(Vname(1,idUbar))
      status=nf_inq_varid(ncinpid,Vname(1,idUbar)(1:lsvar),varid)
      gtype=vflag(varid)*u2dvar
      status=nf_fread(ubar(START_2D_ARRAY,1),Fmin,Fmax,Fscl,
     &                ncinpid,varid,tindx,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,40) Vname(1,idUbar)(1:lsvar), tindx,
     &                   ininame(1:lstr)
        exit_flag=2
        return
      endif
!
!  Read in 2D momentum component (m/s) in the ETA-direction.
!
      lsvar=lenstr(Vname(1,idVbar))
      status=nf_inq_varid(ncinpid,Vname(1,idVbar)(1:lsvar),varid)
      gtype=vflag(varid)*v2dvar
      status=nf_fread(vbar(START_2D_ARRAY,1),Fmin,Fmax,Fscl,
     &                ncinpid,varid,tindx,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,40) Vname(1,idVbar)(1:lsvar), tindx,
     &                   ininame(1:lstr)
        exit_flag=2
        return
      endif
#ifdef SOLVE3D
!
!  Read in 3D momentum component (m/s) in the XI-direction.
!
      lsvar=lenstr(Vname(1,idUvel))
      status=nf_inq_varid(ncinpid,Vname(1,idUvel)(1:lsvar),varid)
      gtype=vflag(varid)*u3dvar
      status=nf_fread(u(START_2D_ARRAY,1,1),Fmin,Fmax,Fscl,
     &                ncinpid,varid,tindx,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,40) Vname(1,idUvel)(1:lsvar), tindx,
     &                   ininame(1:lstr)
        exit_flag=2
        return
      endif
!
!  Read in 3D momentum component (m/s) in the ETA-direction.
!
      lsvar=lenstr(Vname(1,idVvel))
      status=nf_inq_varid(ncinpid,Vname(1,idVvel)(1:lsvar),varid)
      gtype=vflag(varid)*v3dvar
      status=nf_fread(v(START_2D_ARRAY,1,1),Fmin,Fmax,Fscl,
     &                ncinpid,varid,tindx,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,40) Vname(1,idVvel)(1:lsvar), tindx,
     &                   ininame(1:lstr)
        exit_flag=2
        return
      endif
!
!  Read in tracer type variables.
!
# ifdef ANA_BIOLOGY
      do itrc=1,NAT
# else
      do itrc=1,NT
# endif
        lsvar=lenstr(Vname(1,idTvar(itrc)))
        status=nf_inq_varid(ncinpid,Vname(1,idTvar(itrc))(1:lsvar),
     &                      varid)
        gtype=vflag(varid)*r3dvar
        status=nf_fread(t(START_2D_ARRAY,1,1,itrc),Fmin,Fmax,Fscl,
     &                  ncinpid,varid,tindx,gtype)
        if (status.ne.nf_noerr) then
          write(stdout,40) Vname(1,idTvar(itrc))(1:lsvar), tindx,
     &                     ininame(1:lstr)
          exit_flag=2
          return
        endif
      enddo
# ifdef SEDIMENT
      do i=1,NST
        lsvar=lenstr(Vname(1,idfrac(i)))
        status=nf_inq_varid(ncinpid,Vname(1,idfrac(i))(1:lsvar),
     &                      varid)
        gtype=vflag(varid)*b3dvar
        status=nf_fread(bed_frac(START_2D_ARRAY,1,i),Fmin,Fmax,Fscl,
     &                  ncinpid,varid,tindx,gtype)
        if (status.ne.nf_noerr) then
          write(stdout,40) Vname(1,idfrac(i))(1:lsvar), tindx,
     &                     ininame(1:lstr)
          exit_flag=2
          return
        endif
      enddo
      do i=1,MBEDP
        lsvar=lenstr(Vname(1,idSbed(i)))
        status=nf_inq_varid(ncinpid,Vname(1,idSbed(i))(1:lsvar),
     &                      varid)
        gtype=vflag(varid)*b3dvar
        status=nf_fread(bed(START_2D_ARRAY,1,i),Fmin,Fmax,Fscl,
     &                  ncinpid,varid,tindx,gtype)
        if (status.ne.nf_noerr) then
          write(stdout,40) Vname(1,idSbed(i))(1:lsvar), tindx,
     &                     ininame(1:lstr)
          exit_flag=2
          return
        endif
      enddo
# endif
#endif /* SOLVE3D */
#if defined EW_PERIODIC || defined NS_PERIODIC
!
!  Set periodic boundary conditions.
!
      call exchange_r2d_tile (1,Lm,1,Mm,zeta(START_2D_ARRAY,1))
      call exchange_u2d_tile (1,Lm,1,Mm,ubar(START_2D_ARRAY,1))
      call exchange_v2d_tile (1,Lm,1,Mm,vbar(START_2D_ARRAY,1))
# ifdef SOLVE3D
      call exchange_u3d_tile (1,Lm,1,Mm,u(START_2D_ARRAY,1,1))
      call exchange_v3d_tile (1,Lm,1,Mm,v(START_2D_ARRAY,1,1))
#  ifdef ANA_BIOL0GY
      do itrc=1,NAT
#  else
      do itrc=1,NT
#  endif
        call exchange_r3d_tile (1,Lm,1,Mm,t(START_2D_ARRAY,1,1,itrc))
      enddo
#  ifdef SEDIMENT
      do i=1,NST
        call exchange_r3d_tile (1,Lm,1,Mm,bed_frac(START_2D_ARRAY,1,i))
      enddo
      do i=1,MBEDP
        call exchange_r3d_tile (1,Lm,1,Mm,bed(START_2D_ARRAY,1,i))
      enddo
#  endif
# endif
#endif /* EW_PERIODIC || NS_PERIODIC */
!
!  Close input NetCDF file.
!
      status=nf_close(ncinpid)
      write(stdout,80) tdays
!
  10  format(/,' GET_INITIAL - unable to find model variable: ',a,
     &       /,15x,'in input NetCDF file: ',a)
  20  format(/,' GET_INITIAL - unable to open input NetCDF file: ',a)
  30  format(/,' GET_INITIAL - error while reading variable: ',a,2x,
     &       'at time record = ',i3,/,15x,'in input NetCDF file: ',a)
  40  format(/,' GET_INITIAL - requested restart time record = ',i3,/,
     &       15x,'not found in input NetCDF: ',a,/,
     &       15x,'number of available records = ',i3)
  50  format(/,' GET_INITIAL - error while reading attribute: ',a)
  60  format(/,' GET_INITIAL - error while inquiring attributes for',
     &       ' variable: ',a)
  70  format(/,' GET_INITIAL - cannot inquire about time variable in',
     &       ' input NetCDF file: ',a)
  80  format(/,' GET_INITIAL - Processed initial conditions,',
     &       t64,'t = ',f12.4)
      return
      end
