#include "cppdefs.h"
      subroutine get_grid
#ifndef ANA_GRID
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine reads grid information from GRID NetCDF file.     !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "grid.h"
# include "iounits.h"
# include "ncparam.h"
# include "netcdf.inc"
# include "scalars.h"
!
      logical gotang, gotel, gotf, gotdm, gotdn, goth, gotlatr,
     &        gotlonr, gotpm, gotpn, gotsph, gotxl, gotxr, gotyr
# ifdef ICESHELF
      logical gotzice
      INTEGER_TYPE
     &        grdziceid
# endif /* ICESHELF */
      INTEGER_TYPE
     &        grdangid, grdelid, grdfid, grddmid, grddnid, grdhid,
     &        grdlatrid, grdlonrid, grdpmid, grdpnid, grdsphid,
     &        grdxlid, grdxrid, grdyrid, gtype, i, ifield, lstr,
     &        lvar, nrec, status
      INTEGER_TYPE
     &        lenstr, nf_fread
      REAL_TYPE
     &        Fmax, Fmin, Fscl
      character*1 char1
      parameter (Fscl=1.0_r8)
!
!---------------------------------------------------------------------
!  Inquire about the contents of grid NetCDF file:  Inquire about
!  the dimensions and variables.  Check for consistency.
!---------------------------------------------------------------------
!
      if (exit_flag.ne.0) return
      ifield=0
      call opencdf (grdname,N,ifield,nrec)
      if (exit_flag.ne.0) return
!
!  Scan variable list from input NetCDF and check for grid variables.
!
      lstr=lenstr(grdname)
      do i=1,nvars
        lvar=lenstr(varnam(i))
        if (varnam(i)(1:lvar).eq.'xl') then
          grdxlid=i
          gotxl=.true.
        elseif (varnam(i)(1:lvar).eq.'el') then
          grdelid=i
          gotel=.true.
        elseif (varnam(i)(1:lvar).eq.'spherical') then
          grdsphid=i
          gotsph=.true.
        elseif (varnam(i)(1:lvar).eq.'h') then
          grdhid=i
          goth=.true.
# ifdef ICESHELF
        elseif (varnam(i)(1:lvar).eq.'zice') then
          grdziceid=i
          gotzice=.true.
# endif /* ICESHELF */
        elseif (varnam(i)(1:lvar).eq.'f') then
          grdfid=i
          gotf=.true.
        elseif (varnam(i)(1:lvar).eq.'pm') then
          grdpmid=i
          gotpm=.true.
        elseif (varnam(i)(1:lvar).eq.'pn') then
          grdpnid=i
          gotpn=.true.
        elseif (varnam(i)(1:lvar).eq.'dndx') then
          grddnid=i
          gotdn=.true.
        elseif (varnam(i)(1:lvar).eq.'dmde') then
          grddmid=i
          gotdm=.true.
        elseif (varnam(i)(1:lvar).eq.'x_rho') then
          grdxrid=i
          gotxr=.true.
        elseif (varnam(i)(1:lvar).eq.'y_rho') then
          grdyrid=i
          gotyr=.true.
        elseif (varnam(i)(1:lvar).eq.'lon_rho') then
          grdlonrid=i
          gotlonr=.true.
        elseif (varnam(i)(1:lvar).eq.'lat_rho') then
          grdlatrid=i
          gotlatr=.true.
        elseif (varnam(i)(1:lvar).eq.'angle') then
          grdangid=i
          gotang=.true.
        endif
      enddo
!
!  Terminate execution if essential grid variables are not found.
!
      if (.not.gotxl) then
        write(stdout,10) 'xl', grdname(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.gotel) then
        write(stdout,10) 'el', grdname(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.gotsph) then
        write(stdout,10) 'spherical', grdname(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.goth) then
        write(stdout,10) 'h', grdname(1:lstr)
        exit_flag=2
        return
      endif
# ifdef ICESHELF
      if (.not.gotzice) then
        write(stdout,10) 'zice', grdname(1:lstr)
        exit_flag=2
        return
      endif
# endif /* ICESHELF */
      if (.not.gotf) then
        write(stdout,10) 'f', grdname(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.gotpm) then
        write(stdout,10) 'pm', grdname(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.gotpn) then
        write(stdout,10) 'pn', grdname(1:lstr)
        exit_flag=2
        return
      endif
# if (defined CURVGRID && defined UV_ADV)
      if (.not.gotdn) then
        write(stdout,10) 'dndx', grdname(1:lstr)
        exit_flag=2
        return
      endif
      if (.not.gotdm) then
        write(stdout,10) 'dmde', grdname(1:lstr)
        exit_flag=2
        return
      endif
# endif /* CURVGRID && UV_ADV */
# ifdef CURVGRID
      if (.not.gotang) then
        write(stdout,10) 'angle', grdname(1:lstr)
        exit_flag=2
        return
      endif
# endif /* CURVGRID */
!
!  Open grid NetCDF file for reading.
!
      if (ncgrdid.eq.-1) then
        status=nf_open(grdname(1:lstr),nf_nowrite,ncgrdid)
        if (status.ne.nf_noerr) then
          write(stdout,20) grdname(1:lstr)
          exit_flag=2
          return
        endif
      endif
!
!---------------------------------------------------------------------
!  Read in grid parameters.
!---------------------------------------------------------------------
!
!  Read in basin lengths.
!
      status=nf_get_var1_FTYPE(ncgrdid,grdxlid,1,xl)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'xl', grdname(1:lstr)
        exit_flag=2
        return
      endif
      status=nf_get_var1_FTYPE(ncgrdid,grdelid,1,el)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'el', grdname(1:lstr)
        exit_flag=2
        return
      endif
!
!  Read in logical switch for spherical grid configuration.
!
      status=nf_get_var1_text(ncgrdid,grdsphid,1,char1)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'spherical', grdname(1:lstr)
        exit_flag=2
        return
      endif
      if ((char1.eq.'t').or.(char1.eq.'T')) then
        spherical=.true.
      else
        spherical=.false.
      endif
!
!---------------------------------------------------------------------
!  Read in grid arrays.
!---------------------------------------------------------------------
!
!  Read in bathymetry.
!
      gtype=vflag(grdhid)*r2dvar
      status=nf_fread(h(START_2D_ARRAY),hmin,hmax,Fscl,
     &                ncgrdid,grdhid,0,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'h', grdname(1:lstr)
        exit_flag=2
        return
      endif
# if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_r2d_tile (1,Lm,1,Mm,h)
# endif /* EW_PERIODIC || NS_PERIODIC */
# ifdef ICESHELF
!
!  Read in ice shelf thicknesses.
!
      gtype=vflag(grdziceid)*r2dvar
      status=nf_fread(zice(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                ncgrdid,grdziceid,0,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'zice', grdname(1:lstr)
        exit_flag=2
        return
      endif
#  if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_r2d_tile (1,Lm,1,Mm,zice)
#  endif /* EW_PERIODIC || NS_PERIODIC */
# endif /* ICESHELF */
!
!  Read in Coriolis parameter.
!
      gtype=vflag(grdfid)*r2dvar
      status=nf_fread(f(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                ncgrdid,grdfid,0,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'f', grdname(1:lstr)
        exit_flag=2
        return
      endif
# if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_r2d_tile (1,Lm,1,Mm,f)
# endif /* EW_PERIODIC || NS_PERIODIC */
!
!  Read in coordinate transfomation metrics (m,n) associated with the
!  differential distances in XI and ETA.
!
      gtype=vflag(grdpmid)*r2dvar
      status=nf_fread(pm(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                ncgrdid,grdpmid,0,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'pm', grdname(1:lstr)
        exit_flag=2
        return
      endif
      gtype=vflag(grdpnid)*r2dvar
      status=nf_fread(pn(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                ncgrdid,grdpnid,0,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'pn', grdname(1:lstr)
        exit_flag=2
        return
      endif
# if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_r2d_tile (1,Lm,1,Mm,pm)
      call exchange_r2d_tile (1,Lm,1,Mm,pn)
# endif /* EW_PERIODIC || NS_PERIODIC */
# if (defined CURVGRID && defined UV_ADV)
!
!  Read in derivatives of inverse metrics factors: rotational factors.
!
      gtype=vflag(grddmid)*r2dvar
      status=nf_fread(dmde(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                ncgrdid,grddmid,0,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'dmde', grdname(1:lstr)
        exit_flag=2
        return
      endif
      gtype=vflag(grddnid)*r2dvar
      status=nf_fread(dndx(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                ncgrdid,grddnid,0,gtype)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'dndx', grdname(1:lstr)
        exit_flag=2
        return
      endif
#  if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_r2d_tile (1,Lm,1,Mm,dmde)
      call exchange_r2d_tile (1,Lm,1,Mm,dndx)
#  endif /* EW_PERIODIC || NS_PERIODIC */
# endif /* UV_ADV && CURVGRID */
!
!  Read in (x,y) coordinates at RHO-points.
!
      if (gotxr) then
        gtype=vflag(grdxrid)*r2dvar
        status=nf_fread(xr(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                  ncgrdid,grdxrid,0,gtype)
        if (status.ne.nf_noerr) then
          write(stdout,30) 'x_rho', grdname(1:lstr)
          exit_flag=2
          return
        endif
      endif
      if (gotyr) then
        gtype=vflag(grdyrid)*r2dvar
        status=nf_fread(yr(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                  ncgrdid,grdyrid,0,gtype)
        if (status.ne.nf_noerr) then
          write(stdout,30) 'y_rho', grdname(1:lstr)
          exit_flag=2
          return
        endif
      endif
!
!  Read in (lon,lat) coordinates at RHO-points.
!
      if (spherical) then
        if (gotlonr) then
          gtype=vflag(grdlonrid)*r2dvar
          status=nf_fread(lonr(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                    ncgrdid,grdlonrid,0,gtype)
          if (status.ne.nf_noerr) then
            write(stdout,30) 'lon_rho', grdname(1:lstr)
            exit_flag=2
            return
          endif
        endif
        if (gotlatr) then
          gtype=vflag(grdlatrid)*r2dvar
          status=nf_fread(latr(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                    ncgrdid,grdlatrid,0,gtype)
          if (status.ne.nf_noerr) then
            write(stdout,30) 'lat_rho', grdname(1:lstr)
            exit_flag=2
            return
          endif
        endif
      endif
# ifdef CURVGRID
!
!  Read in angle (radians) between XI-axis and EAST at RHO-points.
!
      if (gotang) then
        gtype=vflag(grdangid)*r2dvar
        status=nf_fread(angler(START_2D_ARRAY),Fmin,Fmax,Fscl,
     &                  ncgrdid,grdangid,0,gtype)
        if (status.ne.nf_noerr) then
          write(stdout,30) 'angle', grdname(1:lstr)
          exit_flag=2
          return
        endif
#  if defined EW_PERIODIC || defined NS_PERIODIC
        call exchange_r2d_tile (1,Lm,1,Mm,angler)
#  endif /* EW_PERIODIC || NS_PERIODIC */
      endif
# endif /* CURVGRID */
!
  10  format(/,' GET_GRID - unable to find grid variable: ',a,
     &       /,12x,'in grid NetCDF file: ',a)
  20  format(/,' GET_GRID - unable to open grid NetCDF file: ',a)
  30  format(/,' GET_GRID - error while reading variable: ',a,
     &       /,12x,'in grid NetCDF file: ',a)
#endif /* !ANA_GRID */
      return
      end
