#include "cppdefs.h"
      subroutine get_date (date_str)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!   This routine gets todays date, day of the week and time called   !
!  (default month & weekday are December & Saturday respectively).   !
!  It uses SUN intrinsic date routine by default.                    !
!                                                                    !
!  On Output:                                                        !
!                                                                    !
!     date_str   Concatenated string for the day of the week, date   !
!                (month,day,year), and time (12hr clock) of day      !
!                (hour:min:sec).                                     !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        dstat, half, hour, iday, imon, len1, len2, len3, min,
     &        nday, sec, tstat, year
      INTEGER_TYPE
     &        lday(31), lmonth(12)
      INTEGER_TYPE
     &        lenstr
#if defined cray
      INTEGER_TYPE
     &        century
      parameter (century=2000)
      character*8  tstring
#elif defined sun || defined sgi
      character*3  day3, mon
      character*24 tmpday
#elif defined AIX
      character*3  day3, mon
      character*28 tmpday
#endif
      character*3  ampm(0:1)
      character*9  day(0:6), month(12)
      character*11 ctime
      character*18 today
      character*20 fmt
      character*44 wkday
      character*(*) date_str
      data ampm /' AM',' PM'/
      data day /'Sunday','Monday','Tuesday','Wednesday','Thursday',
     &          'Friday','Saturday'/
      data lmonth, lday /7,8,5,5,3,4,4,6,9,7,8,8,9*1,22*2/
      data month /'January','February','March','April','May','June',
     &            'July','August','September','October','November',
     &            'December'/
!
!---------------------------------------------------------------------
!  Get weekday, date and time in short format, then extract its
!  information.
!---------------------------------------------------------------------
!
#if defined vax
      dstat=0
      call idate (imon,nday,year)
      year=year+century
      call time (tstring)
      read(tstring,'(i2,1x,i2,1x,i2)',iostat=tstat) hour, min, sec
      if(tstat.ne.0) ctime=tstring
#elif defined cray
      write(tstring,'(a8)') date()
      read(tstring,'(i2,1x,i2,1x,i2)',iostat=dstat) imon, nday, year
      year=year+century
      if(dstat.ne.0) then
        wkday=tstring
        today=' '
      endif
      write(tstring,'(a8)') clock()
      read(tstring,'(i2,1x,i2,1x,i2)',iostat=tstat) hour, min, sec
      if(tstat.ne.0) ctime=tstring
#elif defined sun || defined sgi
      call fdate (tmpday)
      read(tmpday,'(a3,1x,a3,1x,i2)',iostat=dstat) day3, mon, nday
      read(tmpday,'(11x,i2,1x,i2,1x,i2)',iostat=tstat) hour, min, sec
      tstat=MAX(ABS(dstat),ABS(tstat))
      read(tmpday,'(20x,i4)',iostat=dstat) year
      if((dstat.ne.0).or.(tstat.ne.0)) then
        dstat=1
        tstat=1
        wkday=tmpday
        today=' '
        ctime=' '
      endif
#elif defined AIX
      call fdate_(tmpday)
      read(tmpday,'(a3,1x,a3,1x,i2)',iostat=dstat) day3, mon, nday
      read(tmpday,'(11x,i2,1x,i2,1x,i2)',iostat=tstat) hour, min, sec
      tstat=MAX(abs(dstat),ABS(tstat))
      read(tmpday,'(20x,i4)',iostat=dstat) year
      if((dstat.ne.0).or.(tstat.ne.0)) then
        dstat=1
        tstat=1
        wkday=tmpday
        today=' '
        ctime=' '
      endif
#else
      dstat=1
      tstat=1
      wkday=' '
      today=' '
      ctime=' '
#endif
!
!---------------------------------------------------------------------
!  Convert from 24 hour clock to 12 hour AM/PM clock.
!---------------------------------------------------------------------
!
      if (tstat.eq.0) then
        half=hour/12
        hour=hour-half*12
        if (hour.eq.0) hour=12
        if (half.eq.2) half=0
      endif
!
      if (dstat.eq.0) then
#if defined vax || defined cray
!
!---------------------------------------------------------------------
!  Get index for the day of the week.
!---------------------------------------------------------------------
!
        call day_code (imon,nday,year,iday)
#elif defined sun || defined sgi || defined AIX
!
!---------------------------------------------------------------------
!  Loop to find full day name by comparing DAY3 with the first three
!  letters of day.
!---------------------------------------------------------------------
!
        iday=0
        do while ((day3.ne.day(iday)(1:3)).and.(iday.lt.6))
          iday=iday+1
        enddo
!
!---------------------------------------------------------------------
!  Loop to find full month name by comparing MON with first three
!  letters of month.
!---------------------------------------------------------------------
!
        imon=1
        do while ((mon.ne.month(imon)(1:3)).and.(imon.lt.12))
          imon=imon+1
        enddo
#endif
!
!---------------------------------------------------------------------
!  Construct date, time and day of the week output string.
!---------------------------------------------------------------------
!
        write(fmt,10) lmonth(imon), lday(nday)
  10    format('(a',i1,',1x,i',i1,',1h,,1x,i4)')
        write(today,fmt) month(imon),nday,year
        wkday=day(iday)
      endif
      if (tstat.eq.0) then
        write(ctime,20) hour, min, sec, ampm(half)
  20    format(i2,':',i2.2,':',i2.2,a3)
      endif
!
!  Concatenate date string.
!
      len1=lenstr(wkday)
      len2=lenstr(today)
      len3=lenstr(ctime)
      date_str=wkday(1:len1)
      if (len2.gt.0) then
        len1=lenstr(date_str)
        date_str=date_str(1:len1)/ /' - '/ /today(1:len2)
      endif
      if (len3.gt.0) then
        len1=lenstr(date_str)
        date_str=date_str(1:len1)/ /' - '/ /ctime(1:len3)
      endif
      return
      end
      subroutine day_code (month,day,year,code)
!
!=====================================================================
!                                                                    !
!  This subroutine computes a code for the day of the week, given    !
!  the date. This code is good for date after:                       !
!                                                                    !
!                              January 1, 1752 AD                    !
!                                                                    !
!  the year the Gregorian calander was adopted in Britian and the    !
!  American colonies.                                                !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     month     The month, 1=January, 2=February, ... (integer).     !
!     day       The day of the month (integer).                      !
!     year      The year, including the century (integer).           !
!                                                                    !
!  On Output:                                                        !
!                                                                    !
!     code      A code for the corresponding day of the week         !
!                 (integer):                                         !
!                 code = 0  =>  Sunday                               !
!                 code = 1  =>  Monday                               !
!                 code = 2  =>  Tuesday                              !
!                 code = 3  =>  Wednesday                            !
!                 code = 4  =>  Thursday                             !
!                 code = 5  =>  Friday                               !
!                 code = 6  =>  Saturday                             !
!                                                                    !
!=====================================================================
!
      implicit none
      logical leap_flag
      INTEGER_TYPE
     &        base_cen, base_qcen, base_qyear, base_year, bym1_dec31,
     &        code, day,feb_end, i, leap, month, no_day, no_yr, nqy,
     &        nyc, nyqc, year
      INTEGER_TYPE
     &        month_day(12)
      parameter (base_cen=1700, base_qcen=1600, base_qyear=1748,
     &           base_year=1752, bym1_dec31=5, feb_end=59)
      data month_day /31,28,31,30,31,30,31,31,30,31,30,31/
!
!---------------------------------------------------------------------
!  Compute the number of years since the base year, the number of
!  years since the beginning of the base century and the number of
!  years since the beginning of the base 400 year.
!---------------------------------------------------------------------
!
      no_yr=year-base_year
      nqy=year-base_qyear
      nyc=year-base_cen
      nyqc=year-base_qcen
!
!---------------------------------------------------------------------
!  Compute the number of leapdays in that time.  Determine if this
!  is a leap year.
!---------------------------------------------------------------------
!
      leap=nqy/4-nyc/100+nyqc/400
      leap_flag=((MOD(nqy,4).eq.0).and.(MOD(nyc,100).ne.0)).or.
     &           (MOD(nyqc,400).eq.0)
!
!---------------------------------------------------------------------
!  Compute the number of days this year.  The leap year corrections
!  are:
!        Jan. 1 - Feb. 28   Have not had the leap day counted above.
!        Feb.29             Counting leap day twice.
!---------------------------------------------------------------------
!
      no_day=day
      do i=1,month-1
        no_day=no_day+month_day(i)
      enddo
      if (leap_flag.and.(no_day.le.feb_end))  no_day=no_day-1
      if (leap_flag.and.(month.eq.2).and.(day.eq.29)) no_day=no_day-1
!
!---------------------------------------------------------------------
!  Compute the total number of days since Jan. 1 of the base year,
!  exclusive of the 364 day per year which represent an even 52
!  weeks.  Actually, only need to do the addition mod 7.
!---------------------------------------------------------------------
!
      no_day=MOD(no_day,7)+MOD(leap,7)+MOD(no_yr,7)+bym1_dec31
!
!---------------------------------------------------------------------
!  Get the day of the week code.
!---------------------------------------------------------------------
!
      code=MOD(no_day,7)
      return
      end
      subroutine caldate (r_date,time,year,yday,month,day,hour)
!
!=====================================================================
!                                                                    !
!  This routine converts Julian day to calendar date.                !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     r_date     Model initialization reference date (vector):       !
!                  r_date(1) => reference date (yyyymmdd.f).         !
!                  r_date(2) => year.                                !
!                  r_date(3) => year day.                            !
!                  r_date(4) => month.                               !
!                  r_date(5) => day.                                 !
!                  r_date(6) => hour.                                !
!                  r_date(7) => minute.                              !
!                  r_date(8) => second.                              !
!     time       Model day (real; days).                             !
!                                                                    !
!  On Output:                                                        !
!                                                                    !
!     year      The year, including the century (integer).           !
!     yday      The year day, 1 - 366 (real).                        !
!     month     The month, 1=January, 2=February, ... (integer).     !
!     day       The day of the month (integer).                      !
!     hour      The hour, 1 - 24 (real).                             !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        day, gregorian, leap, year, ja, jalpha, jb, jc, jd,
     &        jday, je, month
      INTEGER_TYPE
     &        iyd(13), iydl(13)
      REAL_TYPE
     &        hour, time, yday
      REAL_TYPE
     &        r_date(8)
      parameter (gregorian=2299161)
      data iyd  /1,32,60,91,121,152,182,213,244,274,305,335,366/
      data iydl /1,32,61,92,122,153,183,214,245,275,306,336,367/
!
!---------------------------------------------------------------------
!  Get calendar day from model time.
!---------------------------------------------------------------------
!
!  The reference time is a positve date specified at initialization.
!
      if (INT(r_date(1)).gt.0) then
        year=INT(r_date(2))
        yday=r_date(3)
        month=INT(r_date(4))
        day=INT(r_date(5))
        hour=r_date(6)+r_date(7)/60.0_r8+r_date(8)/3600.0_r8
!
!  The reference time is for a climatological simulation with 365.25
!  days in every year.
!
      elseif (INT(r_date(1)).eq.0) then
        year=INT(r_date(2))+INT(time/365.0_r8)
        yday=1.0_r8+MOD(time,365.25_r8)
        leap=MOD(year,4)
        if (leap.eq.0) then
          month=MIN(12,1+INT((yday+1.0_r8)/30.6001_r8))
          day=INT(yday)-iyd(month)+1
        else
          month=MIN(12,1+INT(yday/30.6001_r8))
          if ((yday.gt.59).and.(yday.le.90)) month=3
          day=INT(yday)-iydl(month)+1
        endif
        hour=(time-AINT(time))*24.0_r8
!
!  The reference time is for a climatological simulation with 360.0
!  days in every year.
!
      elseif (INT(r_date(1)).eq.-1) then
        year=0
        yday=MOD(time,360.0_r8)
        month=0
        day=0
        hour=0.0_r8
!
!  The reference time is in terms of modified Julian days.
!       
      else
        if (time.ge.2440000.0_r8) then
          jday=INT(time)
        else
          jday=INT(time)+2440000
        endif
        hour=(time-AINT(time))*24.0_r8
        if (jday.ge.gregorian) then
          jalpha=INT(((jday-1867216)-0.25_r8)/36524.25_r8)
          ja=jday+1+jalpha-INT(0.25_r8*FLOAT(jalpha))
        else
          ja=jday
        endif
        jb=ja+1524
        jc=INT(6680.0_r8+(FLOAT(jb-2439870)-122.1_r8)/365.25_r8)
        jd=365*jc+INT(0.25_r8*FLOAT(jc))
        je=INT(FLOAT(jb-jd)/30.6001_r8)
        day=jb-jd-INT(30.6001_r8*FLOAT(je))
        month=je-1
        if (month.gt.12) month=month-12
        year=jc-4715
        if (month.gt.2) year=year-1
        if (year.le.0) year=year-1
        leap=MOD(year,4)
        if (leap.eq.0) then
          yday=FLOAT(iydl(month))+FLOAT(day)-1.0_r8
        else
          yday=FLOAT(iyd(month))+FLOAT(day)-1.0_r8
        endif
        yday=yday+(time-AINT(time))
      endif
      return
      end
      function ref_att(r_time,r_date)
!
!=====================================================================
!                                                                    !
!  This function encodes the relative time attribute that gives the  !
!  elapsed interval since a specified reference time.  The "units"   !
!  attribute takes the form "time-unit since reference-time".        !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     r_time     Time-reference (real; %Y%m%d.%f, for example,       !
!                  20020115.5 for 15 Jan 2002, 12:0:0).              !
!                                                                    !
!  On Output:                                                        !
!                                                                    !
!     ref_att    Time-reference for "units" attribute (string).      !
!     r_date     Calendar date vector (real):                        !
!                  r_date(1) => reference date (yyyymmdd.f).         !
!                  r_date(2) => year.                                !
!                  r_date(3) => year day.                            !
!                  r_date(4) => month.                               !
!                  r_date(5) => day.                                 !
!                  r_date(6) => hour.                                !
!                  r_date(7) => minute.                              !
!                  r_date(8) => second.                              !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        iday, ihour, isec, iyear, leap, minute, month
      INTEGER_TYPE
     &        iyd(13), iydl(13)
      REAL_TYPE
     &        day, sec, r_time, yday
      REAL_TYPE
     &        r_date(8)
      character*19 ref_att, text
      data iyd  /1,32,60,91,121,152,182,213,244,274,305,335,366/
      data iydl /1,32,61,92,122,153,183,214,245,275,306,336,367/
!
!  Decode reference time.
!
      iyear=INT(r_time*0.0001_r8)
      month=MIN(12,MAX(1,INT((r_time-FLOAT(iyear*10000))*0.01_r8)))
      day=r_time-AINT(r_time*0.01_r8)*100.0_r8
      iday=INT(day)
      sec=(day-AINT(day))*86400.0_r8
      ihour=INT(sec/3600.0_r8)
      minute=INT(MOD(sec,3600.0_r8)/60.0_r8)
      isec=INT(MOD(sec,60.0_r8))
!
!  Get year day.
!
      leap=MOD(iyear,4)
      if (leap.eq.0) then
        yday=FLOAT(iydl(month))+FLOAT(iday)-1.0_r8
      else
        yday=FLOAT(iyd(month))+FLOAT(iday)-1.0_r8
      endif
!
!  Build output date vector.
!
      r_date(1)=r_time
      r_date(2)=FLOAT(iyear)
      r_date(3)=yday
      r_date(4)=FLOAT(month)
      r_date(5)=FLOAT(iday)
      r_date(6)=FLOAT(ihour)
      r_date(7)=FLOAT(minute)
      r_date(8)=FLOAT(isec)
!
!  Build reference-time string.
!
      write(text,10) iyear, month, iday, ihour, minute, isec
 10   format(i4,'-',i2.2,'-',i2.2,1x,i2.2,':',i2.2,':',i2.2)
      ref_att=text
      return
      end
