#include "cppdefs.h"
      subroutine get_data
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine reads in forcing, climatology and assimilation data  !
!  from input NetCDF files.  If there is more than one time-record,  !
!  data  is loaded  into global two-time record arrays.  The actual  !
!  interpolation is carried elsewhere.                               !
!                                                                    !
!  Currently,  this routine is only executed in serial mode by the   !
!  main thread.                                                      !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "boundary.h"
#include "clima.h"
#include "forces.h"
#include "iounits.h"
#include "ncparam.h"
#include "obs.h"
#include "scalars.h"
#include "sources.h"
#include "tides.h"
!
      logical update(3)
      INTEGER_TYPE
     &        irad, is, itrc
      REAL_TYPE
     &        time_save
!
      irad=0
      itrc=0
      time_save=0.0_r8
      do is=1,3
        update(is)=.false.
      enddo
#ifdef PROFILE
!
!---------------------------------------------------------------------
!  Turn on input data time wall clock.
!---------------------------------------------------------------------
!
      call wclock_on (3)
#endif
!
!=====================================================================
!  Read in forcing data from FORCING NetCDF file.
!=====================================================================
!
#if defined SSH_TIDES || defined UV_TIDES
!
!  Tidal Period.
!
      if (iic.eq.0) then
        NTC=0
        call get_ngfld (Tperiod,1,MTC,1,1,NTC,1,idTper,ncfrcid,
     &                  frcname,update(1))
      endif
#endif
#ifdef SSH_TIDES
!
!  Tidal elevation amplitude and phase. In order to read data as a
!  function of tidal period, we need to reset the model time variables
!  temporarily.
!
      if (iic.eq.0) then
        time_save=time
        time=8640000.0_r8
        tdays=time*sec2day
        call get_2dfld (SSH_Tamp(START_2D_ARRAY,1),MTC,NTC,
     &                  idTzam,ncfrcid,frcname,update(1))
        call get_2dfld (SSH_Tphase(START_2D_ARRAY,1),MTC,NTC,
     &                  idTzph,ncfrcid,frcname,update(1))
        time=time_save
        tdays=time*sec2day
      endif
#endif
#ifdef UV_TIDES
!
!  Tidal currents angle, phase, major and minor ellipse axis.
!
      if (iic.eq.0) then
        time_save=time
        time=8640000.0_r8
        tdays=time*sec2day
        call get_2dfld (UV_Tangle(START_2D_ARRAY,1),MTC,NTC,
     &                  idTvan,ncfrcid,frcname,update(1))
        call get_2dfld (UV_Tphase(START_2D_ARRAY,1),MTC,NTC,
     &                  idTvph,ncfrcid,frcname,update(1))
        call get_2dfld (UV_Tmajor(START_2D_ARRAY,1),MTC,NTC,
     &                  idTvma,ncfrcid,frcname,update(1))
        call get_2dfld (UV_Tminor(START_2D_ARRAY,1),MTC,NTC,
     &                  idTvmi,ncfrcid,frcname,update(1))
        time=time_save
        tdays=time*sec2day
      endif
#endif
#if !defined ANA_PSOURCE && (defined UV_PSOURCE || \
                             defined TS_PSOURCE)
!
!  Point Sources/Sinks position, direction, special flag, and mass
!  transport nondimensional shape profile.  Point sources are at U-
!  and V-points.
!
      if (iic.eq.0) then
        call get_ngfld (Xsrc,1,Msrc,1,1,Nsrc,1,idRxpo,ncfrcid,
     &                  frcname,update(1))
        call get_ngfld (Ysrc,1,Msrc,1,1,Nsrc,1,idRepo,ncfrcid,
     &                  frcname,update(1))
        call get_ngfld (Dsrc,1,Msrc,1,1,Nsrc,1,idRdir,ncfrcid,
     &                  frcname,update(1))
        call get_ngfld (Qshape,1,Msrc,N,1,Nsrc,N,idRvsh,ncfrcid,
     &                  frcname,update(1))
# ifdef TS_PSOURCE
        call get_ngfld (Fsrc,1,Msrc,1,1,Nsrc,1,idRflg,ncfrcid,
     &                  frcname,update(1))
        if (update(1)) then
          do is=1,Nsrc
            Lsrc(is,itemp)=.false.
            Lsrc(is,isalt)=.false.
            if (Fsrc(is).eq.1.0_r8) then
              Lsrc(is,itemp)=.true.
            elseif (Fsrc(is).eq.2.0_r8) then
              Lsrc(is,isalt)=.true.
            elseif (Fsrc(is).eq.3.0_r8) then
              Lsrc(is,itemp)=.true.
              Lsrc(is,isalt)=.true.
            endif
          enddo
        endif
# endif
        do is=1,Nsrc
          Isrc(is)=MAX(1,MIN(NINT(Xsrc(is)),L))
          Jsrc(is)=MAX(1,MIN(NINT(Ysrc(is)),M))
        enddo
      endif
# ifdef UV_PSOURCE
!
!  Point Source/Sink vertically integrated mass transport.
!
      call get_ngfld (QbarG,1,Msrc,1,2,Nsrc,1,idRtra,ncfrcid,
     &                frcname,update(1))
# endif
# if defined TS_PSOURCE && defined SOLVE3D
!
!  Tracer Sources/Sinks.
!
      do itrc=1,NAT
        call get_ngfld (TsrcG(1,1,1,itrc),1,Msrc,N,2,Nsrc,N,
     &                  idRtrc(itrc),ncfrcid,frcname,update(1))
      enddo
# endif
#endif
#if !defined ANA_WINDS && defined BULK_FLUXES
!
!  Surface wind components.
!
      call get_2dfld (UwindG(START_2D_ARRAY,1),2,1,
     &                idUair,ncfrcid,frcname,update(1))
      call get_2dfld (VwindG(START_2D_ARRAY,1),2,1,
     &                idVair,ncfrcid,frcname,update(1))
#endif
#if !defined ANA_SMFLUX && !defined BULK_FLUXES
!
!  Surface wind stress components.
!
      call get_2dfld (sustrG(START_2D_ARRAY,1),2,1,
     &                idUsms,ncfrcid,frcname,update(1))
      call get_2dfld (svstrG(START_2D_ARRAY,1),2,1,
     &                idVsms,ncfrcid,frcname,update(1))
#endif
#ifdef SOLVE3D
# if !defined ANA_WWAVE && defined BBL
!
!  Surface wind induced wave amplitude, direction and period.
!
      call get_2dfld (AwaveG(START_2D_ARRAY,1),2,1,
     &                idWamp,ncfrcid,frcname,update(1))
      call get_2dfld (DwaveG(START_2D_ARRAY,1),2,1,
     &                idWdir,ncfrcid,frcname,update(1))
      call get_2dfld (PwaveG(START_2D_ARRAY,1),2,1,
     &                idWper,ncfrcid,frcname,update(1))
# endif
# if !defined ANA_CLOUD && defined CLOUDS
!
!  Cloud fraction.
!
      call get_2dfld (cloudG(START_2D_ARRAY,1),2,1,
     &                idCfra,ncfrcid,frcname,update(1))
# endif
# if !defined ANA_SRFLUX && defined SHORTWAVE
!
!  Surface solar shortwave radiation.
!
      call get_2dfld (srflxG(START_2D_ARRAY,1),2,1,
     &                idSrad,ncfrcid,frcname,update(1))
# endif
# ifdef BULK_FLUXES
#  ifndef LONGWAVE
!
!  Surface net longwave radiation.
!
      call get_2dfld (lrflxG(START_2D_ARRAY,1),2,1,
     &                idLrad,ncfrcid,frcname,update(1))
#  endif
#  ifndef ANA_PAIR
!
!  Surface air pressure.
!
      call get_2dfld (PairG(START_2D_ARRAY,1),2,1,
     &                idPair,ncfrcid,frcname,update(1))
#  endif
#  ifndef ANA_TAIR
!
!  Surface air temperature.
!
      call get_2dfld (TairG(START_2D_ARRAY,1),2,1,
     &                idTair,ncfrcid,frcname,update(1))
#  endif
#  ifndef ANA_HUMIDITY
!
!  Surface air humidity.
!
      call get_2dfld (HairG(START_2D_ARRAY,1),2,1,
     &                idQair,ncfrcid,frcname,update(1))
#  endif
#  ifndef ANA_RAIN
      call get_2dfld (rainG(START_2D_ARRAY,1),2,1,
     &                idrain,ncfrcid,frcname,update(1))
#  endif
# else
#  ifndef ANA_STFLUX
!
!  Surface net heat flux.
!
      call get_2dfld (stflxG(START_2D_ARRAY,1,itemp),2,1,
     &                idTsur(itemp),ncfrcid,frcname,update(1))
#  endif
# endif /* BULK_FLUXES */
# if !defined ANA_SST && defined QCORRECTION
!
!  Surface net heat flux correction fields: sea surface temperature
!  (SST) and heat flux sensitivity to SST (dQdSST).
!
      call get_2dfld (sstG(START_2D_ARRAY,1),2,1,
     &                idSSTc,ncfrcid,frcname,update(1))
      call get_2dfld (dqdtG(START_2D_ARRAY,1),2,1,
     &                iddQdT,ncfrcid,frcname,update(1))
# endif
#  ifndef ANA_BTFLUX
!
!  Bottom net heat flux.
!
      call get_2dfld (btflxG(START_2D_ARRAY,1,itemp),2,1,
     &                idTbot(itemp),ncfrcid,frcname,update(1))
#  endif
# ifdef SALINITY
#  ifndef ANA_SSFLUX
!
!  Surface net freshwater flux: E-P.
!
      call get_2dfld (stflxG(START_2D_ARRAY,1,isalt),2,1,
     &                idTsur(isalt),ncfrcid,frcname,update(1))
#  endif
#  if !defined ANA_SSS && (defined SCORRECTION || defined SRELAXATION)
!
!  Surface net freshwater flux correction field: sea surface salinity.
!
      call get_2dfld (sssG(START_2D_ARRAY,1),2,1,
     &                idSSSc,ncfrcid,frcname,update(1))
#  endif
#  ifndef ANA_BSFLUX
!
!  Bottom net freshwater flux.
!
      call get_2dfld (btflxG(START_2D_ARRAY,1,isalt),2,1,
     &                idTbot(isalt),ncfrcid,frcname,update(1))
#  endif
# endif /* SALINITY */
# if defined SEDIMENT || defined BIOLOGY
#  ifndef ANA_SPFLUX
!
!  Passive tracers surface fluxes.
!
      do itrc=NAT+1,NT
        call get_2dfld (stflxG(START_2D_ARRAY,1,itrc),2,1,
     &                  idTsur(itrc),ncfrcid,frcname,update(1))
      enddo
#  endif
#  ifndef ANA_BPFLUX
!
!  Passive tracers bottom fluxes.
!
      do itrc=NAT+1,NT
        call get_2dfld (btflxG(START_2D_ARRAY,1,itrc),2,1,
     &                  idTbot(itrc),ncfrcid,frcname,update(1))
      enddo
#  endif
# endif /* SEDIMENT || BIOLOGY */
#endif /* SOLVE3D */
#ifdef OBC_DATA
!
!=====================================================================
!  Read in open boundary conditions from BOUNDARY NetCDF file.
!=====================================================================
!
# ifndef ANA_FSOBC
#  ifdef WEST_FSOBC
      call get_ngfld (zetaG_west(0,1),0,M,1,2,M,1,idZbry(iwest),
     &                ncbryid,bryname,update(1))
#  endif
#  ifdef EAST_FSOBC
      call get_ngfld (zetaG_east(0,1),0,M,1,2,M,1,idZbry(ieast),
     &                ncbryid,bryname,update(1))
#  endif
#  ifdef SOUTH_FSOBC
      call get_ngfld (zetaG_south(0,1),0,L,1,2,L,1,idZbry(isouth),
     &                ncbryid,bryname,update(1))
#  endif
#  ifdef NORTH_FSOBC
      call get_ngfld (zetaG_north(0,1),0,L,1,2,L,1,idZbry(inorth),
     &                ncbryid,bryname,update(1))
#  endif
# endif /* !ANA_FSOBC */
# ifndef ANA_M2OBC
#  ifdef WEST_M2OBC
      call get_ngfld (ubarG_west(0,1),0,M,1,2,M,1,idU2bc(iwest),
     &                ncbryid,bryname,update(1))
      call get_ngfld (vbarG_west(1,1),1,M,1,2,M,1,idV2bc(iwest),
     &                ncbryid,bryname,update(1))
#  endif
#  ifdef EAST_M2OBC
      call get_ngfld (ubarG_east(0,1),0,M,1,2,M,1,idU2bc(ieast),
     &                ncbryid,bryname,update(1))
      call get_ngfld (vbarG_east(1,1),1,M,1,2,M,1,idV2bc(ieast),
     &                ncbryid,bryname,update(1))
#  endif
#  ifdef SOUTH_M2OBC
      call get_ngfld (ubarG_south(1,1),1,L,1,2,L,1,idU2bc(isouth),
     &                ncbryid,bryname,update(1))
      call get_ngfld (vbarG_south(0,1),0,L,1,2,L,1,idV2bc(isouth),
     &                ncbryid,bryname,update(1))
#  endif
#  ifdef NORTH_M2OBC
      call get_ngfld (ubarG_north(1,1),1,L,1,2,L,1,idU2bc(inorth),
     &                ncbryid,bryname,update(1))
      call get_ngfld (vbarG_north(0,1),0,L,1,2,L,1,idV2bc(inorth),
     &                ncbryid,bryname,update(1))
#  endif
# endif /* !ANA_M2OBC */
# ifdef SOLVE3D
#  ifndef ANA_M3OBC
#   ifdef WEST_M3OBC
      call get_ngfld (uG_west(0,1,1),0,M,N,2,M,N,idU3bc(iwest),
     &                ncbryid,bryname,update(1))
      call get_ngfld (vG_west(1,1,1),1,M,N,2,M,N,idV3bc(iwest),
     &                ncbryid,bryname,update(1))
#   endif
#   ifdef EAST_M3OBC
      call get_ngfld (uG_east(0,1,1),0,M,N,2,M,N,idU3bc(ieast),
     &                ncbryid,bryname,update(1))
      call get_ngfld (vG_east(1,1,1),1,M,N,2,M,N,idV3bc(ieast),
     &                ncbryid,bryname,update(1))
#   endif
#   ifdef SOUTH_M3OBC
      call get_ngfld (uG_south(1,1,1),1,L,N,2,L,N,idU3bc(isouth),
     &                ncbryid,bryname,update(1))
      call get_ngfld (vG_south(0,1,1),0,L,N,2,L,N,idV3bc(isouth),
     &                ncbryid,bryname,update(1))
#   endif
#   ifdef NORTH_M3OBC
      call get_ngfld (uG_north(1,1,1),1,L,N,2,L,N,idU3bc(inorth),
     &                ncbryid,bryname,update(1))
      call get_ngfld (vG_north(0,1,1),0,L,N,2,L,N,idV3bc(inorth),
     &                ncbryid,bryname,update(1))
#   endif
#  endif /* !ANA_M3OBC */
#  ifndef ANA_TOBC
#   ifdef WEST_TOBC
      do itrc=1,NAT
        call get_ngfld (tG_west(0,1,1,itrc),0,M,N,2,M,N,
     &                  idTbry(iwest,itrc),ncbryid,bryname,update(1))
      enddo
#   endif
#   ifdef EAST_TOBC
      do itrc=1,NAT
        call get_ngfld (tG_east(0,1,1,itrc),0,M,N,2,M,N,
     &                  idTbry(ieast,itrc),ncbryid,bryname,update(1))
      enddo
#   endif
#   ifdef SOUTH_TOBC
      do itrc=1,NAT
        call get_ngfld (tG_south(0,1,1,itrc),0,L,N,2,L,N,
     &                  idTbry(isouth,itrc),ncbryid,bryname,update(1))
      enddo
#   endif
#   ifdef NORTH_TOBC
      do itrc=1,NAT
        call get_ngfld (tG_north(0,1,1,itrc),0,L,N,2,L,N,
     &                  idTbry(inorth,itrc),ncbryid,bryname,update(1))
      enddo
#   endif
#  endif /* !ANA_TOBC */
# endif /* SOLVE3D */
#endif /* OBC_DATA */
#if defined ZCLIMATOLOGY || defined M2CLIMATOLOGY || \
    defined TCLIMATOLOGY || defined M3CLIMATOLOGY
!
!=====================================================================
!  Read in climatology data from CLIMATOLOGY NetCDF file.
!=====================================================================
!
# if !defined ANA_SSH && defined ZCLIMATOLOGY
      call get_2dfld (sshG(START_2D_ARRAY,1),2,1,
     &                idSSHc,ncclmid,clmname,update(1))
# endif
# if !defined ANA_M2CLIMA && defined M2CLIMATOLOGY
      call get_2dfld (ubarclmG(START_2D_ARRAY,1),2,1,
     &                idUbcl,ncclmid,clmname,update(1))
      call get_2dfld (vbarclmG(START_2D_ARRAY,1),2,1,
     &                idVbcl,ncclmid,clmname,update(1))
# endif
# ifdef SOLVE3D
#  if !defined ANA_TCLIMA && defined TCLIMATOLOGY
      do itrc=1,NAT
        call get_3dfld (tclmG(START_2D_ARRAY,1,1,itrc),2,1,
     &                  idTclm(itrc),ncclmid,clmname,update(1))
      enddo
#  endif
#  if !defined ANA_M3CLIMA && defined M3CLIMATOLOGY
      call get_3dfld (uclmG(START_2D_ARRAY,1,1),2,1,
     &                idUclm,ncclmid,clmname,update(1))
      call get_3dfld (vclmG(START_2D_ARRAY,1,1),2,1,
     &                idVclm,ncclmid,clmname,update(1))
#  endif
# endif
#endif
#if defined ASSIMILATION || defined NUDGING
!
!=====================================================================
!  Read in assimilation data from ASSIMILATION NetCDF files.
!=====================================================================
!
# if defined NUDGING_SSH || defined ASSIMILATION_SSH
!
!---------------------------------------------------------------------
!  Read in sea surface height observations and error variance.
!---------------------------------------------------------------------
!
      if (assi_SSH) then
#  ifdef NUDGING_SSH
        call get_2dfld (SSHdat(START_2D_ARRAY,1),2,1,
     &                  idSSHo,ncSSHid,SSHname,update(1))
        call get_2dfld (EdatSSH(START_2D_ARRAY,1),2,1,
     &                  idSSHe,ncSSHid,SSHname,update(2))
        if (update(1).and.update(2)) update_SSH=.true.
#  else
        call get_2dfld (SSHobs(START_2D_ARRAY),1,1,
     &                  idSSHo,ncSSHid,SSHname,update(1))
        call get_2dfld (EobsSSH(START_2D_ARRAY),1,1,
     &                  idSSHe,ncSSHid,SSHname,update(2))
        if (update(1).and.update(2)) then
          update_SSH=.true.
          tSSHobs(1)=Vtime(1,idSSHo)
          tsSSHobs=Vtime(1,idSSHo)*day2sec
          Tmono(idSSHo)=tsSSHobs
          Tmono(idSSHe)=tsSSHobs
          EobsSSHmin=Finfo(4,idSSHe)
          EobsSSHmax=Finfo(5,idSSHe)
        endif
#  endif
      endif
# endif
# if defined NUDGING_SST || defined ASSIMILATION_SST
!
!---------------------------------------------------------------------
!  Read in sea surface temperature observations and error variance.
!---------------------------------------------------------------------
!
      if (assi_SST) then
#  ifdef NUDGING_SST
        call get_2dfld (SSTdat(START_2D_ARRAY,1),2,1,
     &                  idSSTo,ncSSTid,SSTname,update(1))
        call get_2dfld (EdatSST(START_2D_ARRAY,1),2,1,
     &                  idSSTe,ncSSTid,SSTname,update(2))
#  else
        call get_2dfld (SSTobs(START_2D_ARRAY),1,1,
     &                  idSSTo,ncSSTid,SSTname,update(1))
        call get_2dfld (EobsSST(START_2D_ARRAY),1,1,
     &                  idSSTe,ncSSTid,SSTname,update(2))
#  endif
        if (update(1).and.update(2)) update_SST=.true.
      endif
# endif
# if defined NUDGING_T || defined ASSIMILATION_T
!
!---------------------------------------------------------------------
!  Read in tracers observations and error variance.
!---------------------------------------------------------------------
!
      do itrc=1,NAT
        if (assi_T(itrc)) then
#  ifdef NUDGING_T
          call get_3dfld (Tdat(START_2D_ARRAY,1,1,itrc),2,1,
     &                    idTobs(itrc),ncTOBSid,TOBSname,update(1))
          call get_3dfld (EdatT(START_2D_ARRAY,1,1,itrc),2,1,
     &                    idTerr(itrc),ncTOBSid,TOBSname,update(2))
          if (update(1).and.update(2)) update_T(itrc)=.true.
#  else
          call get_3dfld (Tobs(START_2D_ARRAY,1,itrc),1,1,
     &                    idTobs(itrc),ncTOBSid,TOBSname,update(1))
          call get_3dfld (EobsT(START_2D_ARRAY,1,itrc),1,1,
     &                    idTerr(itrc),ncTOBSid,TOBSname,update(2))
          if (update(1).and.update(2)) then
            update_T(itrc)=.true.
            tTobs(1,itrc)=Vtime(1,idTobs(itrc))
            tsTobs(itrc)=Vtime(1,idTobs(itrc))*day2sec
            Tmono(idTobs(itrc))=tsTobs(itrc)
            Tmono(idTerr(itrc))=tsTobs(itrc)
            EobsTmin(itrc)=Finfo(4,idTerr(itrc))
            EobsTmax(itrc)=Finfo(5,idTerr(itrc))
          endif
#  endif
        endif
      enddo
# endif
# if defined NUDGING_UVsur || defined ASSIMILATION_UVsur
!
!---------------------------------------------------------------------
!  Read in surface current observations and error variance.
!---------------------------------------------------------------------
!
      if (assi_UVsur) then
#  ifdef NUDGING_UVsur
        call get_2dfld (Usurdat(START_2D_ARRAY,1),2,1,
     &                  idUsur,ncVSURid,VSURname,update(1))
        call get_2dfld (Vsurdat(START_2D_ARRAY,1),2,1,
     &                  idVsur,ncVSURid,VSURname,update(2))
        call get_2dfld (EdatVsur(START_2D_ARRAY,1),2,1,
     &                  idUVse,ncVSURid,VSURname,update(3))
#  else
        call get_2dfld (Usur(START_2D_ARRAY),1,1,
     &                  idUsur,ncVSURid,VSURname,update(1))
        call get_2dfld (Vsur(START_2D_ARRAY),1,1,
     &                  idVsur,ncVSURid,VSURname,update(2))
        call get_2dfld (EobsVsur(START_2D_ARRAY),1,1,
     &                  idUVse,ncVSURid,VSURname,update(3))
#  endif
        if (update(1).and.update(2).and.update(3)) update_UVsur=.true.
      endif
# endif
# if defined NUDGING_UV || defined ASSIMILATION_UV
!
!---------------------------------------------------------------------
!  Read in horizontal current observations and error variance.
!---------------------------------------------------------------------
!
      if (assi_UV) then
#  ifdef NUDGING_UV
        call get_3dfld (Udat(START_2D_ARRAY,1,1),2,1,
     &                  idUobs,ncVOBSid,VOBSname,update(1))
        call get_3dfld (Vdat(START_2D_ARRAY,1,1),2,1,
     &                  idVobs,ncVOBSid,VOBSname,update(2))
        call get_3dfld (EdatUV(START_2D_ARRAY,1,1),2,1,
     &                  idUVer,ncVOBSid,VOBSname,update(3))
        if (update(1).and.update(2).and.update(3)) update_UV=.true.
#  else
        call get_3dfld (Uobs(START_2D_ARRAY,1),1,1,
     &                  idUobs,ncVOBSid,VOBSname,update(1))
        call get_3dfld (Vobs(START_2D_ARRAY,1),1,1,
     &                  idVobs,ncVOBSid,VOBSname,update(2))
        call get_3dfld (EobsUV(START_2D_ARRAY,1),1,1,
     &                  idUVer,ncVOBSid,VOBSname,update(3))
        if (update(1).and.update(2).and.update(3)) then
          update_UV=.true.
          tVobs(1)=Vtime(1,idVobs)
          tsVobs=Vtime(1,idVobs)*day2sec
          Tmono(idUobs)=tsVobs
          Tmono(idVobs)=tsVobs
          Tmono(idUVer)=tsVobs
          EobsUVmin=Finfo(4,idUVer)
          EobsUVmax=Finfo(5,idUVer)
        endif
#  endif
      endif
# endif
#endif
#ifdef PROFILE
!
!---------------------------------------------------------------------
!  Turn off input data time wall clock.
!---------------------------------------------------------------------
!
      call wclock_off (3)
#endif
      return
      end
