#include "cppdefs.h"
      subroutine get_cycle (ncid,tfldid,ntime,smday,cycle,clength,
     &                      tindex,sfday,tstr,tend,tscale)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine determines relevant parameters for time cycling      !
!  of data from a input NetCDF file.                                 !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     ncid     NetCDF file ID.                                       !
!     tfldid   NetCDF field time variable ID.                        !
!     ntime    Size of time dimension.                               !
!     smday    Starting model day.                                   !
!                                                                    !
!  On Output:                                                        !
!                                                                    !
!     cycle    Logical switch indicating cycling of input fields.    !
!     clength  Length of field time cycle.                           !
!     tindex   Starting field time index to read.                    !
!     sfday    Starting field day.                                   !
!     tstr     Starting field day.
!     tend     Ending field day.                                     !
!     tscale   Scale to convert time coordinate to day units.        !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "netcdf.inc"
#include "scalars.h"
!
      logical cycle
      INTEGER_TYPE
     &        i, lenatt, lenvar, ncid, ntime, nvatts, nvdims, status,
     &        tfldid, tindex, vartype
      INTEGER_TYPE
     &        vdims(5)
      INTEGER_TYPE
     &        lenstr
      REAL_TYPE
     &        clength, mday, sfday, smday, tend, tscale, tnext,
     &        tstart, tstr
      character*15 attnam, varnam
      character*40 tunits
!
!---------------------------------------------------------------------
!  Find time cycling parameters, if any.
!---------------------------------------------------------------------
!
!  Initialize.
!
      cycle=.false.
      tindex=0
      clength=0.0_r8
      sfday=0.0_r8
      tscale=1.0_r8
!
!  Check if time cycling attribute is present and then read in time
!  cycle length.  Check time coordinate units and determine time
!  scale.  The internal processing of all fields requires time in
!  day units.  Check if more than one time record is available.
!
      if (ntime.gt.1) then
        status=nf_inq_var(ncid,tfldid,varnam,vartype,nvdims,vdims,
     &                    nvatts)
        lenvar=lenstr(varnam)
        if (status.eq.nf_noerr) then
          do i=1,nvatts
            status=nf_inq_attname(ncid,tfldid,i,attnam)
            if (status.eq.nf_noerr) then
              lenatt=lenstr(attnam)
              if (attnam(1:lenatt).eq.'cycle_length') then
                cycle=.true.
                status=nf_get_att_FTYPE(ncid,tfldid,attnam(1:lenatt),
     &                                  clength)
                if (status.ne.nf_noerr) then
                  write (stdout,10) attnam(1:lenatt)
                  exit_flag=2
                  return
                endif
              elseif (attnam(1:lenatt).eq.'units') then
                status=nf_get_att_text(ncid,tfldid,attnam(1:lenatt),
     &                                 tunits)
                if (status.eq.nf_noerr) then
                  if (tunits(1:6).eq.'second') then
                    tscale=sec2day
                  endif
                else
                  write (stdout,10) attnam(1:lenatt)
                  exit_flag=2
                  return
                endif
              endif
            else
              write(stdout,20) varnam(1:lenvar)
              exit_flag=2
              return
            endif
          enddo
        else
          write(stdout,30)
          exit_flag=2
          return
        endif
      endif
!
!  Read in starting and ending times for input field.
!
      status=nf_get_var1_FTYPE(ncid,tfldid,1,tstr)
      if (status.ne.nf_noerr) then
        write(stdout,40) varnam(1:lenvar)
        exit_flag=2
        return
      endif
      status=nf_get_var1_FTYPE(ncid,tfldid,ntime,tend)
      if (status.ne.nf_noerr) then
        write(stdout,40) varnam(1:lenvar)
        exit_flag=2
        return
      endif
!
!  Search for starting field time and time-index.
!
      tstr=tstr*tscale
      tend=tend*tscale
      if (cycle) then
        mday=MOD(smday,clength)
      else
        mday=smday
      endif
      if ((mday.lt.tstr).or.(mday.ge.tend)) then
        tindex=ntime
        sfday=tend
      else
        tstart=tstr
        do i=2,ntime
          status=nf_get_var1_FTYPE(ncid,tfldid,i,tnext)
          tnext=tnext*tscale
          if (status.ne.nf_noerr) then
            write(stdout,40) varnam(1:lenvar)
            exit_flag=2
            return
          endif
          if ((tstart.le.mday).and.(mday.lt.tnext)) then
            tindex=i-1
            sfday=tstart
            goto 50
          endif
          tstart=tnext
        enddo
  50    continue
      endif
!
!  If not cycling, stop execution if there is not field data
!  available for current model time.
!
      if (.not.cycle.and.(ntime.gt.1)) then
        if (smday.lt.tstr) then
          write(stdout,60) varnam(1:lenvar), tstr, smday
          exit_flag=2
          return
        endif
      endif
!
  10  format(/,' GET_CYCLE - error while reading attribute: ',a)
  20  format(/,' GET_CYCLE - error while inquiring attributes for',
     &        ' variable: ',a)
  30  format(/,' GET_CYCLE - cannot inquire about time variable from',
     &        ' input NetCDF file.')
  40  format(/,' GET_CYCLE - error while reading variable: ',a)
  60  format(/,' GET_CYCLE - starting time for variable: ',a,
     &       /,13x,'is greater than current model time. ',
     &       /,13x,'TSTR = ',f15.4,2x,'TDAYS = ',f15.4)
      return
      end
