/*
** Include file "forces.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Surface momentum stresses.                                       **
**                                                                  **
** sustr        Kinematic surface momentum flux (wind stress) in    **
**                the XI-direction (m2/s2) at horizontal U-points.  **
** sustrG       Latest two-time snapshots of input "sustr" grided   **
**                data used for interpolation.                      **
** svstr        Kinematic surface momentum flux (wind stress) in    **
**                the ETA-direction (m2/s2) at horizontal V-points. **
** svstrG       Latest two-time snapshots of input "svstr" grided   **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

#if !defined ANA_SMFLUX || !defined BULK_FLUXES
      common /forces_sustrG/ sustrG
      REAL_TYPE sustrG(GLOBAL_2D_ARRAY,2)

      common /forces_svstrG/ svstrG
      REAL_TYPE svstrG(GLOBAL_2D_ARRAY,2)
#endif /* !ANA_SMFLUX */

      common /forces_sustr/ sustr
      REAL_TYPE sustr(GLOBAL_2D_ARRAY)

      common /forces_svstr/ svstr
      REAL_TYPE svstr(GLOBAL_2D_ARRAY)

/*
**********************************************************************
** Bottom momentum stresses.                                        **
**********************************************************************
**                                                                  **
** bustr        Kinematic bottom momentum flux (bottom stress) in   **
**                the XI-direction (m2/s2) at horizontal U-points.  **
** bvstr        Kinematic bottom momentum flux (bottom stress) in   **
**                ETA-direction (m2/s2) at horizontal V-points.     **
**                                                                  **
**********************************************************************
*/

      common /forces_bustr/ bustr
      REAL_TYPE bustr(GLOBAL_2D_ARRAY)

      common /forces_bvstr/ bvstr
      REAL_TYPE bvstr(GLOBAL_2D_ARRAY)

#ifdef SOLVE3D

# ifdef SHORTWAVE

/*
**********************************************************************
** Solar shortwave radiation flux.                                  **
**********************************************************************
**                                                                  **
** srflx        Kinematic surface shortwave solar radiation flux    **
**                (Celsius m/s) at horizontal RHO-points            **
** srflxG       Latest two-time snapshots of input "srflx" grided   **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

#  ifndef ANA_SRFLUX
      common /forces_srflxG/ srflxG
      REAL_TYPE srflxG(GLOBAL_2D_ARRAY,2)
#  endif /* !ANA_SRFLUX */

      common /forces_srflx/ srflx
      REAL_TYPE srflx(GLOBAL_2D_ARRAY)

# endif /* SHORTWAVE */

# ifdef CLOUDS

/*
**********************************************************************
** Cloud fraction.                                                  **
**********************************************************************
**                                                                  **
** cloud        Cloud fraction (percentage/100).                    **
** cloudG       Latest two-time snapshots of input "cloud" grided   **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

#  ifndef ANA_CLOUD
      common /forces_cloudg/ cloudG
      REAL_TYPE cloudG(GLOBAL_2D_ARRAY,2)
#  endif /* !ANA_CLOUD */

      common /forces_cloud/ cloud
      REAL_TYPE cloud(GLOBAL_2D_ARRAY)

# endif /* CLOUDS */

# ifdef BULK_FLUXES

/*
**********************************************************************
** Surface heat fluxes, Atmosphere-Ocean bulk parameterization.     **
**********************************************************************
**                                                                  **
** lhflx        Kinematic net sensible heat flux (degC m/s).        **
** lrflx        Kinematic net longwave radiation (degC m/s).        **
** lrflxG       Latest two-time snapshots of input "lrflx" grided   **
**                data used for interpolation.                      **
** shflx        Kinematic net sensible heat flux (degC m/s).        **
**                                                                  **
**********************************************************************
*/

      common /forces_lhflx/ lhflx
      REAL_TYPE lhflx(GLOBAL_2D_ARRAY)

      common /forces_lrflx/ lrflx
      REAL_TYPE lrflx(GLOBAL_2D_ARRAY)

#  ifndef LONGWAVE
      common /forces_lrflxG/ lrflxG
      REAL_TYPE lrflxG(GLOBAL_2D_ARRAY,2)
#  endif /* !LONGWAVE */

      common /forces_shflx/ shflx
      REAL_TYPE shflx(GLOBAL_2D_ARRAY)

/*
**********************************************************************
** Surface air humidity.                                            **
**********************************************************************
**                                                                  **
** Hair         Surface air specific (g/kg) or relative humidity    **
**                (percentage).                                     **
** HairG        Latest two-time snapshots of input "Hair" grided    **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

#  ifndef ANA_HUMIDITY
      common /forces_HairG/ HairG
      REAL_TYPE HairG(GLOBAL_2D_ARRAY,2)
#  endif /* !ANA_HUMIDITY */

      common /forces_Hair/ Hair
      REAL_TYPE Hair(GLOBAL_2D_ARRAY)

/*
**********************************************************************
** Surface air pressure.                                            **
**********************************************************************
**                                                                  **
** Pair         Surface air pressure (mb).                          **
** PairG        Latest two-time snapshots of input "Pair" grided    **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

#  ifndef ANA_PAIR
      common /forces_PairG/ PairG
      REAL_TYPE PairG(GLOBAL_2D_ARRAY,2)
#  endif /* !ANA_PAIR */

      common /forces_Pair/ Pair
      REAL_TYPE Pair(GLOBAL_2D_ARRAY)

/*
**********************************************************************
** Surface air temperature.                                         **
**********************************************************************
**                                                                  **
** Tair         Surface air temperature (Celsius)                   **
** TairG        Latest two-time snapshots of input "Tair" grided    **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

#  ifndef ANA_TAIR
      common /forces_TairG/ TairG
      REAL_TYPE TairG(GLOBAL_2D_ARRAY,2)
#  endif /* !ANA_TAIR */

      common /forces_Tair/ Tair
      REAL_TYPE Tair(GLOBAL_2D_ARRAY)

/*
**********************************************************************
** Surface Winds.                                                   **
**********************************************************************
**                                                                  **
** Uwind        Surface wind in the XI-direction (m/s) at           **
**                horizontal RHO-points.                            **
** UwindG       Latest two-time snapshots of input "Uwind" grided   **
**                data used for interpolation.                      **
** Vwind        Surface wind in the ETA-direction (m/s) at          **
**                horizontal RHO-points.                            **
** VwindG       Latest two-time snapshots of input "Vwind" grided   **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

#  ifndef ANA_WINDS
      common /forces_UwindG/ UwindG
      REAL_TYPE UwindG(GLOBAL_2D_ARRAY,2)

      common /forces_VwindG/ VwindG
      REAL_TYPE VwindG(GLOBAL_2D_ARRAY,2)
#  endif /* !ANA_WINDS */

      common /forces_Uwind/ Uwind
      REAL_TYPE Uwind(GLOBAL_2D_ARRAY)

      common /forces_Vwind/ Vwind
      REAL_TYPE Vwind(GLOBAL_2D_ARRAY)

/*
**********************************************************************
** Rain fall rate.                                                  **
**********************************************************************
**                                                                  **
** rain         Rain fall rate (kg/m2/s).                           **
** rainG        Latest two-time snapshots of input "rain" grided    **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

#  ifndef ANA_RAIN
      common /forces_rainG/ rainG
      REAL_TYPE rainG(GLOBAL_2D_ARRAY,2)
#  endif /* !ANA_RAIN */

      common /forces_rain/ rain
      REAL_TYPE rain(GLOBAL_2D_ARRAY)

# endif /* BULK_FLUXES */

/*
**********************************************************************
** Surface tracer fluxes.                                           **
**********************************************************************
**                                                                  **
** stflx        Kinematic surface flux of tracer type variables     **
**                (temperature: degC m/s; salinity: PSU m/s) at     **
**                horizontal RHO-points.                            **
** stflxG       Latest two-time snapshots of input "stflx" grided   **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

# if !defined BULK_FLUXES && \
     (!defined ANA_STFLUX || !defined ANA_SSFLUX)
      common /forces_stflxG/ stflxG
      REAL_TYPE stflxG(GLOBAL_2D_ARRAY,2,NT)
# endif /* !BULK_FLUXES && (!ANA_STFLUX || !ANA_SSFLUX) */

      common /forces_stflx/ stflx
      REAL_TYPE stflx(GLOBAL_2D_ARRAY,NT)

/*
**********************************************************************
** Bottom tracer fluxes.                                            **
**********************************************************************
**                                                                  **
** btflx        Kinematic bottom flux of tracer type variables      **
**                (temperature: degC m/s; salinity: PSU m/s) at     **
**                horizontal RHO-points.                            **
** btflxG       Latest two-time snapshots of input "btflx" grided   **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

# if !defined ANA_BTFLUX || !defined ANA_BSFLUX
      common /forces_btflxG/ btflxG
      REAL_TYPE btflxG (GLOBAL_2D_ARRAY,2,NT)
# endif /* !ANA_BTFLUX || !ANA_BSFLUX */

      common /forces_btflx/ btflx
      REAL_TYPE btflx(GLOBAL_2D_ARRAY,NT)

# ifdef QCORRECTION

/*
**********************************************************************
** Surface heat flux correction.                                    **
**********************************************************************
**                                                                  **
** dqdt         Kinematic surface net heat flux sensitivity to SST, **
**                d(Q)/d(SST), (m/s).                               **
** dqdtG        Latest two-time snapshots of input "dqdt" grided    **
**                data used for interpolation.                      **
** sst          Sea surface temperature (Celsius).                  **
** sstG         Latest two-time snapshots of input "sst" grided     **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

# ifndef ANA_SST
      common /forces_dqdtG/ dqdtG
      REAL_TYPE dqdtG(GLOBAL_2D_ARRAY,2)

      common /forces_sstG/ sstG
      REAL_TYPE sstG(GLOBAL_2D_ARRAY,2)
#  endif /* !ANA_SST */

      common /forces_dqdt/ dqdt
      REAL_TYPE dqdt(GLOBAL_2D_ARRAY)

      common /forces_sst/ sst
      REAL_TYPE sst(GLOBAL_2D_ARRAY)

# endif /* QCORRECTION */

# if defined SALINITY && (defined SCORRECTION || defined SRELAXATION)

/*
**********************************************************************
** Surface freshwater flux correction.                              **
**********************************************************************
**                                                                  **
** sss          Sea surface salinity (PSU).                         **
** sssG         Latest two-time snapshots of input "sss" grided     **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

# ifndef ANA_SSS
      common /forces_sssG/ sssG
      REAL_TYPE sssG(GLOBAL_2D_ARRAY,2)
#  endif /* !ANA_SSS */

      common /forces_sss/ sss
      REAL_TYPE sss(GLOBAL_2D_ARRAY)

# endif /* SALINITY && (SCORRECTION || SRELAXATION) */

#endif /* SOLVE3D */
#if defined BBL

/*
**********************************************************************
** Surface wind induced waves.                                      **
**********************************************************************
**                                                                  **
** Awave        Surface wind induced wave amplitude (m).            **
** AwaveG       Latest two-time snapshots of input "Awave" grided   **
**                data used for interpolation.                      **
** Dwave        Surface wind induced wave direction (radians).      **
** DwaveG       Latest two-time snapshots of input "Dwave" grided   **
**                data used for interpolation.                      **
** Pwave        Surface wind induced wave period (s).               **
** PwaveG       Latest two-time snapshots of input "Pwave" grided   **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

# ifndef ANA_WWAVE
      common /forces_AwaveG/ AwaveG
      REAL_TYPE AwaveG(GLOBAL_2D_ARRAY,2)

      common /forces_DwaveG/ DwaveG
      REAL_TYPE DwaveG(GLOBAL_2D_ARRAY,2)

      common /forces_PwaveG/ PwaveG
      REAL_TYPE PwaveG(GLOBAL_2D_ARRAY,2)
# endif /* ANA_WAVE */

      common /forces_Awave/ Awave
      REAL_TYPE Awave(GLOBAL_2D_ARRAY)

      common /forces_Dwave/ Dwave
      REAL_TYPE Dwave(GLOBAL_2D_ARRAY)

      common /forces_Pwave/ Pwave
      REAL_TYPE Pwave(GLOBAL_2D_ARRAY)

#endif /* BBL */
