/*
** Include file "floats.h".
*************************************************** John M. Klinck ***
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** NFT        Number of float time levels (minus one).              **
** NFV        Number of float variables.                            **
** Ftitle     Floats application title.                             **
** Tinfo      Float trajectory initial information.                 **
** bounded    Float bounded status switch.                          **
** frrec      Float trajectory restart flag.                        **
** ifakt      Index for float diffusivity.                          **
** ifdak      Index for float vertical gradient in diffusivity.     **
** idpth      Index for float depth.                                **
** ifden      Index for float density anomaly.                      **
** iflat      Index for float latitude location.                    **
** iflon      Index for float longitude location.                   **
** iftem      Index for float potential temperature.                **
** ifsal      Index for float salinity.                             **
** itstr      Index for float release time.                         **
** ixgrd      Index for float x-grid location.                      **
** ixrhs      Index for float x-slope, u*dx.                        **
** iygrd      Index for float y-grid location.                      **
** iyrhs      Index for float y-slope, v*dy.                        **
** izgrd      Index for float z-grid location.                      **
** izrhs      Index for float z-slope, w*dz.                        **
** nfloats    Number of float trajectories to compute.              **
** track      Multivariate float trajectory data at several time    **
**              time levels.                                        **
**                                                                  **
**********************************************************************
*/

      INTEGER_TYPE
     &        NFT,               NFV
      INTEGER_TYPE
     &        itstr,             ixgrd,             iygrd,
     &        izgrd,             iflon,             iflat,
     &        idpth,             ixrhs,             iyrhs,
     &        izrhs,             ifden
#ifdef FLOAT_VWALK
      INTEGER_TYPE
     &        ifakt,          ifdak
#endif
      parameter
     &       (NFT=4)
#ifdef FLOAT_VWALK
      parameter
     &       (NFV=NT+12)
#else
      parameter
     &       (NFV=NT+10)
#endif
      parameter
     &       (itstr=0,           ixgrd=1,           iygrd=2,
     &        izgrd=3,           iflon=4,           iflat=5,
     &        idpth=6,           ixrhs=7,           iyrhs=8,
     &        izrhs=9,           ifden=10)
#ifdef FLOAT_VWALK
      parameter
     &       (ifakt=11,          ifdak=12)
#endif

      common /lfloats/
     &        bounded
      logical
     &        bounded(Mfloats)

      common /ifloats/
     &        frrec,             nfloats
      INTEGER_TYPE
     &        frrec,             nfloats

      common /sfloats/ Ftitle
      character*80 Ftitle

      common /floats_info/ Tinfo
      REAL_TYPE Tinfo(0:izgrd,Mfloats)

      common /floats_track/ track
      REAL_TYPE track(NFV,0:NFT,Mfloats)
