#include "cppdefs.h"
#ifdef SOLVE3D
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This package contains fills non-computational points of output    !
!  3D fields using periodic or gradient boundary conditions.         !
!                                                                    !
!  Routines:                                                         !
!                                                                    !
!    fill_r3d_tile        Fill field at RHO-points                   !
!    fill_u3d_tile        Fill field at U-points                     !
!    fill_v3d_tile        Fill field at V-points                     !
!    fill_w3d_tile        Fill field at W-points                     !
!                                                                    !
!=====================================================================
!
      subroutine fill_r3d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic or gradient boundary conditions for    !
!  3D variables at RHO-points.  This is done for output purposes.    !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY,N)
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
# ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West gradient boundary conditions.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
        do k=1,N
          do j=Jstr,Jend
            A(Lm+1,j,k)=A(Lm,j,k)
          enddo
        enddo
      endif
      if (WESTERN_EDGE) then
        do k=1,N
          do j=Jstr,Jend
            A(0,j,k)=A(1,j,k)
          enddo
        enddo
      endif
# endif /* !EW_PERIODIC */
# ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South gradient boundary conditions.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
        do k=1,N
          do i=Istr,Iend
            A(i,Mm+1,k)=A(i,Mm,k)
          enddo
        enddo
      endif
      if (SOUTHERN_EDGE) then
        do k=1,N
          do i=Istr,Iend
            A(i,0,k)=A(i,1,k)
          enddo
        enddo
      endif
# endif /* !NS_PERIODIC */
# if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          A(0,0,k)=0.5_r8*(A(1,0,k)+A(0,1,k))
        enddo
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          A(L,0,k)=0.5_r8*(A(L,1,k)+A(Lm,0,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          A(0,M,k)=0.5_r8*(A(0,Mm,k)+A(1,M,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          A(L,M,k)=0.5_r8*(A(L,Mm,k)+A(Lm,M,k))
        enddo
      endif
# else
!
!---------------------------------------------------------------------
!  Set periodic boundary conditons.
!---------------------------------------------------------------------
!
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,A(START_2D_ARRAY,1))
# endif
      return
      end
      subroutine fill_u3d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic or gradient boundary conditions for    !
!  3D variables at U-points.  This is done for output purposes.      !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY,N)
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
# ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West gradient boundary conditions.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
        do k=1,N
          do j=Jstr,Jend
            A(Lm+1,j,k)=A(Lm,j,k)
          enddo
        enddo
      endif
      if (WESTERN_EDGE) then
        do k=1,N
          do j=Jstr,Jend
            A(1,j,k)=A(2,j,k)
          enddo
        enddo
      endif
# endif /* !EW_PERIODIC */
# ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South gradient boundary conditions.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
        do k=1,N
          do i=IstrU,Iend
            A(i,Mm+1,k)=A(i,Mm,k)
          enddo
        enddo
      endif
      if (SOUTHERN_EDGE) then
        do k=1,N
          do i=IstrU,Iend
            A(i,0,k)=A(i,1,k)
          enddo
        enddo
      endif
# endif /* !NS_PERIODIC */
# if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          A(1,0,k)=0.5_r8*(A(2,0,k)+A(1,1,k))
        enddo
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          A(L,0,k)=0.5_r8*(A(Lm,0,k)+A(L,1,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          A(1,M,k)=0.5_r8*(A(2,M,k)+A(1,Mm,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          A(L,M,k)=0.5_r8*(A(Lm,M,k)+A(L,Mm,k))
        enddo
      endif
# else
!
!---------------------------------------------------------------------
!  Set periodic boundary conditons.
!---------------------------------------------------------------------
!
      call exchange_u3d_tile (Istr,Iend,Jstr,Jend,A(START_2D_ARRAY,1))
# endif
      return
      end
      subroutine fill_v3d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic or gradient boundary conditions for    !
!  3D variables at V-points.  This is done for output purposes.      !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY,N)
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
# ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West gradient boundary conditions.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
        do k=1,N
          do j=JstrV,Jend
            A(Lm+1,j,k)=A(Lm,j,k)
          enddo
        enddo
      endif
      if (WESTERN_EDGE) then
        do k=1,N
          do j=JstrV,Jend
            A(0,j,k)=A(1,j,k)
          enddo
        enddo
      endif
# endif /* !EW_PERIODIC */
# ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South periodic boundary conditions.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
        do k=1,N
          do i=Istr,Iend
            A(i,Mm+1,k)=A(i,Mm,k)
          enddo
        enddo
      endif
      if (SOUTHERN_EDGE) then
        do k=1,N
          do i=Istr,Iend
            A(i,1,k)=A(i,2,k)
          enddo
        enddo
      endif
# endif /* !NS_PERIODIC */
# if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          A(0,1,k)=0.5_r8*(A(0,2,k)+A(1,1,k))
        enddo
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          A(L,0,k)=0.5_r8*(A(L,1,k)+A(Lm,0,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          A(0,M,k)=0.5_r8*(A(0,Mm,k)+A(1,M,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          A(L,M,k)=0.5_r8*(A(L,Mm,k)+A(Lm,M,k))
        enddo
      endif
# else
!
!---------------------------------------------------------------------
!  Set periodic boundary conditons.
!---------------------------------------------------------------------
!
      call exchange_v3d_tile (Istr,Iend,Jstr,Jend,A(START_2D_ARRAY,1))
# endif
      return
      end
      subroutine fill_w3d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic or gradient boundary conditions for    !
!  3D variables at W-points.  This is done for output purposes.      !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY,0:N)
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
# ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West gradient boundary conditions.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
        do k=0,N
          do j=Jstr,Jend
            A(Lm+1,j,k)=A(Lm,j,k)
          enddo
        enddo
      endif
      if (WESTERN_EDGE) then
        do k=0,N
          do j=Jstr,Jend
            A(0,j,k)=A(1,j,k)
          enddo
        enddo
      endif
# endif /* !EW_PERIODIC */
# ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South gradient boundary conditions.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
        do k=0,N
          do i=Istr,Iend
            A(i,Mm+1,k)=A(i,Mm,k)
          enddo
        enddo
      endif
      if (SOUTHERN_EDGE) then
        do k=0,N
          do i=Istr,Iend
            A(i,0,k)=A(i,1,k)
          enddo
        enddo
      endif
# endif /* !NS_PERIODIC */
# if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=0,N
          A(0,0,k)=0.5_r8*(A(1,0,k)+A(0,1,k))
        enddo
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=0,N
          A(L,0,k)=0.5_r8*(A(L,1,k)+A(Lm,0,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=0,N
          A(0,M,k)=0.5_r8*(A(0,Mm,k)+A(1,M,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=0,N
          A(L,M,k)=0.5_r8*(A(L,Mm,k)+A(Lm,M,k))
        enddo
      endif
# else
!
!---------------------------------------------------------------------
!  Set periodic boundary conditons.
!---------------------------------------------------------------------
!
      call exchange_w3d_tile (Istr,Iend,Jstr,Jend,A(START_2D_ARRAY,0))
# endif
#else
      subroutine fill_3d
#endif /* SOLVE3D */
      return
      end
