#include "cppdefs.h"
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This package contains fills non-computational points of output    !
!  2D fields using periodic or gradient boundary conditions.         !
!                                                                    !
!  Routines:                                                         !
!                                                                    !
!    fill_r2d_tile        Fill field at RHO-points                   !
!    fill_u2d_tile        Fill field at U-points                     !
!    fill_v2d_tile        Fill field at V-points                     !
!                                                                    !
!=====================================================================
!
      subroutine fill_r2d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic or gradient boundary conditions for    !
!  2D variables at RHO-points.  This is done for output purposes.    !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY)
!
#include "set_bounds.h"
!
      i=0
      j=0
#ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West gradient boundary conditions.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
        do j=Jstr,Jend
          A(Lm+1,j)=A(Lm,j)
        enddo
      endif
      if (WESTERN_EDGE) then
        do j=Jstr,Jend
          A(0,j)=A(1,j)
        enddo
      endif
#endif /* !EW_PERIODIC */
#ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South gradient boundary conditions.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
        do i=Istr,Iend
          A(i,Mm+1)=A(i,Mm)
        enddo
      endif
      if (SOUTHERN_EDGE) then
        do i=Istr,Iend
          A(i,0)=A(i,1)
        enddo
      endif
#endif /* !NS_PERIODIC */
#if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        A(0,0)=0.5_r8*(A(1,0)+A(0,1))
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        A(L,0)=0.5_r8*(A(L,1)+A(Lm,0))
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        A(0,M)=0.5_r8*(A(0,Mm)+A(1,M))
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        A(L,M)=0.5_r8*(A(L,Mm)+A(Lm,M))
      endif
#else
!
!---------------------------------------------------------------------
!  Set periodic boundary conditons.
!---------------------------------------------------------------------
!
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,A(START_2D_ARRAY))
#endif
      return
      end
      subroutine fill_u2d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic or gradient boundary conditions for    !
!  2D variables at U-points.  This is done for output purposes.      !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY)
!
#include "set_bounds.h"
!
      i=0
      j=0
#ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West gradient boundary conditions.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
        do j=Jstr,Jend
          A(Lm+1,j)=A(Lm,j)
        enddo
      endif
      if (WESTERN_EDGE) then
        do j=Jstr,Jend
          A(1,j)=A(2,j)
        enddo
      endif
#endif /* !EW_PERIODIC */
#ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South gradient boundary conditions.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
        do i=IstrU,Iend
          A(i,Mm+1)=A(i,Mm)
        enddo
      endif
      if (SOUTHERN_EDGE) then
        do i=IstrU,Iend
          A(i,0)=A(i,1)
        enddo
      endif
#endif /* !NS_PERIODIC */
#if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        A(1,0)=0.5_r8*(A(2,0)+A(1,1))
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        A(L,0)=0.5_r8*(A(Lm,0)+A(L,1))
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        A(1,M)=0.5_r8*(A(2,M)+A(1,Mm))
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        A(L,M)=0.5_r8*(A(Lm,M)+A(L,Mm))
      endif
#else
!
!---------------------------------------------------------------------
!  Set periodic boundary conditons.
!---------------------------------------------------------------------
!
      call exchange_u2d_tile (Istr,Iend,Jstr,Jend,A(START_2D_ARRAY))
#endif
      return
      end
      subroutine fill_v2d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic or gradient boundary conditions for    !
!  2D variables at V-points.  This is done for output purposes.      !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY)
!
#include "set_bounds.h"
!
      i=0
      j=0
#ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West gradient boundary conditions.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
        do j=JstrV,Jend
          A(Lm+1,j)=A(Lm,j)
        enddo
      endif
      if (WESTERN_EDGE) then
        do j=JstrV,Jend
          A(0,j)=A(1,j)
        enddo
      endif
#endif /* !EW_PERIODIC */
#ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South periodic boundary conditions.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
        do i=Istr,Iend
          A(i,Mm+1)=A(i,Mm)
        enddo
      endif
      if (SOUTHERN_EDGE) then
        do i=Istr,Iend
          A(i,1)=A(i,2)
        enddo
      endif
#endif /* !NS_PERIODIC */
#if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        A(0,1)=0.5_r8*(A(0,2)+A(1,1))
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        A(L,0)=0.5_r8*(A(L,1)+A(Lm,0))
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        A(0,M)=0.5_r8*(A(0,Mm)+A(1,M))
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        A(L,M)=0.5_r8*(A(L,Mm)+A(Lm,M))
      endif
#else
!
!---------------------------------------------------------------------
!  Set periodic boundary conditons.
!---------------------------------------------------------------------
!
      call exchange_v2d_tile (Istr,Iend,Jstr,Jend,A(START_2D_ARRAY))
#endif
      return
      end
