#include "cppdefs.h"
#ifdef SOLVE3D
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This package contains periodic boundary conditions routines for   !
!  3D variables.                                                     !
!                                                                    !
!  Routines:                                                         !
!                                                                    !
!    exchange_p3d_tile    periodic conditions at PSI-points          !
!    exchange_r3d_tile    periodic conditions at RHO-points          !
!    exchange_u3d_tile    periodic conditions at U-points            !
!    exchange_v3d_tile    periodic conditions at V-points            !
!    exchange_w3d_tile    periodic conditions at W-points            !
!                                                                    !
!=====================================================================
!
      subroutine exchange_p3d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic boundary conditions for 3D variables   !
!  at PSI-points.                                                    !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY,N)
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
# ifdef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West periodic boundary conditions.
!---------------------------------------------------------------------
!
#  ifdef NS_PERIODIC
#   define J_RANGE Jstr,Jend
#  else
#   define J_RANGE Jstr,JendR
#  endif
      if (WESTERN_EDGE) then
        do k=1,N
          do j=J_RANGE
            A(Lm+1,j,k)=A(1,j,k)
            A(Lm+2,j,k)=A(2,j,k)
          enddo
        enddo
      endif
      if (EASTERN_EDGE) then
        do k=1,N
          do j=J_RANGE
            A(-2,j,k)=A(Lm-2,j,k)
            A(-1,j,k)=A(Lm-1,j,k)
            A( 0,j,k)=A(Lm  ,j,k)
          enddo
        enddo
      endif
#  undef J_RANGE
# endif /* EW_PERIODIC */
# ifdef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South periodic boundary conditions.
!---------------------------------------------------------------------
!
#  ifdef EW_PERIODIC
#   define I_RANGE Istr,Iend
#  else
#   define I_RANGE Istr,IendR
#  endif
      if (SOUTHERN_EDGE) then
        do k=1,N
          do i=I_RANGE
            A(i,Mm+1,k)=A(i,1,k)
            A(i,Mm+2,k)=A(i,2,k)
          enddo
        enddo
      endif
      if (NORTHERN_EDGE) then
        do k=1,N
          do i=I_RANGE
            A(i,-2,k)=A(i,Mm-2,k)
            A(i,-1,k)=A(i,Mm-1,k)
            A(i, 0,k)=A(i,Mm  ,k)
          enddo
        enddo
      endif
#  undef I_RANGE
# endif /* NS_PERIODIC */
# if defined EW_PERIODIC && defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE .and. SOUTHERN_EDGE) then
        do k=1,N
          A(Lm+1,Mm+1,k)=A(1,1,k)
          A(Lm+1,Mm+2,k)=A(1,2,k)
          A(Lm+2,Mm+1,k)=A(2,1,k)
          A(Lm+2,Mm+2,k)=A(2,2,k)
        enddo
      endif
      if (EASTERN_EDGE .and. SOUTHERN_EDGE) then
        do k=1,N
          A(-2,Mm+1,k)=A(Lm-2,1,k)
          A(-1,Mm+1,k)=A(Lm-1,1,k)
          A( 0,Mm+1,k)=A(Lm  ,1,k)
          A(-2,Mm+2,k)=A(Lm-2,2,k)
          A(-1,Mm+2,k)=A(Lm-1,2,k)
          A( 0,Mm+2,k)=A(Lm  ,2,k)
        enddo
      endif
      if (WESTERN_EDGE .and. NORTHERN_EDGE) then
        do k=1,N
          A(Lm+1,-2,k)=A(1,Mm-2,k)
          A(Lm+1,-1,k)=A(1,Mm-1,k)
          A(Lm+1, 0,k)=A(1,Mm  ,k)
          A(Lm+2,-2,k)=A(2,Mm-2,k)
          A(Lm+2,-1,k)=A(2,Mm-1,k)
          A(Lm+2, 0,k)=A(2,Mm  ,k)
        enddo
      endif
      if (EASTERN_EDGE .and. NORTHERN_EDGE) then
        do k=1,N
          A(-2,-2,k)=A(Lm-2,Mm-2,k)
          A(-2,-1,k)=A(Lm-2,Mm-1,k)
          A(-2, 0,k)=A(Lm-2,Mm  ,k)
          A(-1,-2,k)=A(Lm-1,Mm-2,k)
          A(-1,-1,k)=A(Lm-1,Mm-1,k)
          A(-1, 0,k)=A(Lm-1,Mm  ,k)
          A( 0,-2,k)=A(Lm  ,Mm-2,k)
          A( 0,-1,k)=A(Lm  ,Mm-1,k)
          A( 0, 0,k)=A(Lm  ,Mm  ,k)
        enddo
      endif
# endif /* EW_PERIODIC && NS_PERIODIC */
      return
      end
      subroutine exchange_r3d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic boundary conditions for 3D variables   !
!  at RHO-points.                                                    !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY,N)
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
# ifdef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West periodic boundary conditions.
!---------------------------------------------------------------------
!
#  ifdef NS_PERIODIC
#   define J_RANGE Jstr,Jend
#  else
#   define J_RANGE JstrR,JendR
#  endif
      if (WESTERN_EDGE) then
        do k=1,N
          do j=J_RANGE
            A(Lm+1,j,k)=A(1,j,k)
            A(Lm+2,j,k)=A(2,j,k)
          enddo
        enddo
      endif
      if (EASTERN_EDGE) then
        do k=1,N
          do j=J_RANGE
            A(-2,j,k)=A(Lm-2,j,k)
            A(-1,j,k)=A(Lm-1,j,k)
            A( 0,j,k)=A(Lm  ,j,k)
          enddo
        enddo
      endif
#  undef J_RANGE
# endif /* EW_PERIODIC */
# ifdef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South periodic boundary conditions.
!---------------------------------------------------------------------
!
#  ifdef EW_PERIODIC
#   define I_RANGE Istr,Iend
#  else
#   define I_RANGE IstrR,IendR
#  endif
      if (SOUTHERN_EDGE) then
        do k=1,N
          do i=I_RANGE
            A(i,Mm+1,k)=A(i,1,k)
            A(i,Mm+2,k)=A(i,2,k)
          enddo
        enddo
      endif
      if (NORTHERN_EDGE) then
        do k=1,N
          do i=I_RANGE
            A(i,-2,k)=A(i,Mm-2,k)
            A(i,-1,k)=A(i,Mm-1,k)
            A(i, 0,k)=A(i,Mm  ,k)
          enddo
        enddo
      endif
#  undef I_RANGE
# endif /* NS_PERIODIC */
# if defined EW_PERIODIC && defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE .and. SOUTHERN_EDGE) then
        do k=1,N
          A(Lm+1,Mm+1,k)=A(1,1,k)
          A(Lm+1,Mm+2,k)=A(1,2,k)
          A(Lm+2,Mm+1,k)=A(2,1,k)
          A(Lm+2,Mm+2,k)=A(2,2,k)
        enddo
      endif
      if (EASTERN_EDGE .and. SOUTHERN_EDGE) then
        do k=1,N
          A(-2,Mm+1,k)=A(Lm-2,1,k)
          A(-1,Mm+1,k)=A(Lm-1,1,k)
          A( 0,Mm+1,k)=A(Lm  ,1,k)
          A(-2,Mm+2,k)=A(Lm-2,2,k)
          A(-1,Mm+2,k)=A(Lm-1,2,k)
          A( 0,Mm+2,k)=A(Lm  ,2,k)
        enddo
      endif
      if (WESTERN_EDGE .and. NORTHERN_EDGE) then
        do k=1,N
          A(Lm+1,-2,k)=A(1,Mm-2,k)
          A(Lm+1,-1,k)=A(1,Mm-1,k)
          A(Lm+1, 0,k)=A(1,Mm  ,k)
          A(Lm+2,-2,k)=A(2,Mm-2,k)
          A(Lm+2,-1,k)=A(2,Mm-1,k)
          A(Lm+2, 0,k)=A(2,Mm  ,k)
        enddo
      endif
      if (EASTERN_EDGE .and. NORTHERN_EDGE) then
        do k=1,N
          A(-2,-2,k)=A(Lm-2,Mm-2,k)
          A(-2,-1,k)=A(Lm-2,Mm-1,k)
          A(-2, 0,k)=A(Lm-2,Mm  ,k)
          A(-1,-2,k)=A(Lm-1,Mm-2,k)
          A(-1,-1,k)=A(Lm-1,Mm-1,k)
          A(-1, 0,k)=A(Lm-1,Mm  ,k)
          A( 0,-2,k)=A(Lm  ,Mm-2,k)
          A( 0,-1,k)=A(Lm  ,Mm-1,k)
          A( 0, 0,k)=A(Lm  ,Mm  ,k)
        enddo
      endif
# endif /* EW_PERIODIC && NS_PERIODIC */
      return
      end
      subroutine exchange_u3d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic boundary conditions for 3D variables   !
!  at U-points.                                                      !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY,N)
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
# ifdef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West periodic boundary conditions.
!---------------------------------------------------------------------
!
#  ifdef NS_PERIODIC
#   define J_RANGE Jstr,Jend
#  else
#   define J_RANGE JstrR,JendR
#  endif
      if (WESTERN_EDGE) then
        do k=1,N
          do j=J_RANGE
            A(Lm+1,j,k)=A(1,j,k)
            A(Lm+2,j,k)=A(2,j,k)
          enddo
        enddo
      endif
      if (EASTERN_EDGE) then
        do k=1,N
          do j=J_RANGE
            A(-2,j,k)=A(Lm-2,j,k)
            A(-1,j,k)=A(Lm-1,j,k)
            A( 0,j,k)=A(Lm  ,j,k)
          enddo
        enddo
      endif
#  undef J_RANGE
# endif /* EW_PERIODIC */
# ifdef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South periodic boundary conditions.
!---------------------------------------------------------------------
!
#  ifdef EW_PERIODIC
#   define I_RANGE Istr,Iend
#  else
#   define I_RANGE Istr,IendR
#  endif
      if (SOUTHERN_EDGE) then
        do k=1,N
          do i=I_RANGE
            A(i,Mm+1,k)=A(i,1,k)
            A(i,Mm+2,k)=A(i,2,k)
          enddo
        enddo
      endif
      if (NORTHERN_EDGE) then
        do k=1,N
          do i=I_RANGE
            A(i,-2,k)=A(i,Mm-2,k)
            A(i,-1,k)=A(i,Mm-1,k)
            A(i, 0,k)=A(i,Mm  ,k)
          enddo
        enddo
      endif
#  undef I_RANGE
# endif /* NS_PERIODIC */
# if defined EW_PERIODIC && defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE .and. SOUTHERN_EDGE) then
        do k=1,N
          A(Lm+1,Mm+1,k)=A(1,1,k)
          A(Lm+1,Mm+2,k)=A(1,2,k)
          A(Lm+2,Mm+1,k)=A(2,1,k)
          A(Lm+2,Mm+2,k)=A(2,2,k)
        enddo
      endif
      if (EASTERN_EDGE .and. SOUTHERN_EDGE) then
        do k=1,N
          A(-2,Mm+1,k)=A(Lm-2,1,k)
          A(-1,Mm+1,k)=A(Lm-1,1,k)
          A( 0,Mm+1,k)=A(Lm  ,1,k)
          A(-2,Mm+2,k)=A(Lm-2,2,k)
          A(-1,Mm+2,k)=A(Lm-1,2,k)
          A( 0,Mm+2,k)=A(Lm  ,2,k)
        enddo
      endif
      if (WESTERN_EDGE .and. NORTHERN_EDGE) then
        do k=1,N
          A(Lm+1,-2,k)=A(1,Mm-2,k)
          A(Lm+1,-1,k)=A(1,Mm-1,k)
          A(Lm+1, 0,k)=A(1,Mm  ,k)
          A(Lm+2,-2,k)=A(2,Mm-2,k)
          A(Lm+2,-1,k)=A(2,Mm-1,k)
          A(Lm+2, 0,k)=A(2,Mm  ,k)
        enddo
      endif
      if (EASTERN_EDGE .and. NORTHERN_EDGE) then
        do k=1,N
          A(-2,-2,k)=A(Lm-2,Mm-2,k)
          A(-2,-1,k)=A(Lm-2,Mm-1,k)
          A(-2, 0,k)=A(Lm-2,Mm  ,k)
          A(-1,-2,k)=A(Lm-1,Mm-2,k)
          A(-1,-1,k)=A(Lm-1,Mm-1,k)
          A(-1, 0,k)=A(Lm-1,Mm  ,k)
          A( 0,-2,k)=A(Lm  ,Mm-2,k)
          A( 0,-1,k)=A(Lm  ,Mm-1,k)
          A( 0, 0,k)=A(Lm  ,Mm  ,k)
        enddo
      endif
# endif /* EW_PERIODIC && NS_PERIODIC */
      return
      end
      subroutine exchange_v3d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic boundary conditions for 3D variables   !
!  at V-points.                                                      !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY,N)
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
# ifdef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West periodic boundary conditions.
!---------------------------------------------------------------------
!
#  ifdef NS_PERIODIC
#   define J_RANGE Jstr,Jend
#  else
#   define J_RANGE Jstr,JendR
#  endif
      if (WESTERN_EDGE) then
        do k=1,N
          do j=J_RANGE
            A(Lm+1,j,k)=A(1,j,k)
            A(Lm+2,j,k)=A(2,j,k)
          enddo
        enddo
      endif
      if (EASTERN_EDGE) then
        do k=1,N
          do j=J_RANGE
            A(-2,j,k)=A(Lm-2,j,k)
            A(-1,j,k)=A(Lm-1,j,k)
            A( 0,j,k)=A(Lm  ,j,k)
          enddo
        enddo
      endif
#  undef J_RANGE
# endif /* EW_PERIODIC */
# ifdef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South periodic boundary conditions.
!---------------------------------------------------------------------
!
#  ifdef EW_PERIODIC
#   define I_RANGE Istr,Iend
#  else
#   define I_RANGE IstrR,IendR
#  endif
      if (SOUTHERN_EDGE) then
        do k=1,N
          do i=I_RANGE
            A(i,Mm+1,k)=A(i,1,k)
            A(i,Mm+2,k)=A(i,2,k)
          enddo
        enddo
      endif
      if (NORTHERN_EDGE) then
        do k=1,N
          do i=I_RANGE
            A(i,-2,k)=A(i,Mm-2,k)
            A(i,-1,k)=A(i,Mm-1,k)
            A(i, 0,k)=A(i,Mm  ,k)
          enddo
        enddo
      endif
#  undef I_RANGE
# endif /* NS_PERIODIC */
# if defined EW_PERIODIC && defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE .and. SOUTHERN_EDGE) then
        do k=1,N
          A(Lm+1,Mm+1,k)=A(1,1,k)
          A(Lm+1,Mm+2,k)=A(1,2,k)
          A(Lm+2,Mm+1,k)=A(2,1,k)
          A(Lm+2,Mm+2,k)=A(2,2,k)
        enddo
      endif
      if (EASTERN_EDGE .and. SOUTHERN_EDGE) then
        do k=1,N
          A(-2,Mm+1,k)=A(Lm-2,1,k)
          A(-1,Mm+1,k)=A(Lm-1,1,k)
          A( 0,Mm+1,k)=A(Lm  ,1,k)
          A(-2,Mm+2,k)=A(Lm-2,2,k)
          A(-1,Mm+2,k)=A(Lm-1,2,k)
          A( 0,Mm+2,k)=A(Lm  ,2,k)
        enddo
      endif
      if (WESTERN_EDGE .and. NORTHERN_EDGE) then
        do k=1,N
          A(Lm+1,-2,k)=A(1,Mm-2,k)
          A(Lm+1,-1,k)=A(1,Mm-1,k)
          A(Lm+1, 0,k)=A(1,Mm  ,k)
          A(Lm+2,-2,k)=A(2,Mm-2,k)
          A(Lm+2,-1,k)=A(2,Mm-1,k)
          A(Lm+2, 0,k)=A(2,Mm  ,k)
        enddo
      endif
      if (EASTERN_EDGE .and. NORTHERN_EDGE) then
        do k=1,N
          A(-2,-2,k)=A(Lm-2,Mm-2,k)
          A(-2,-1,k)=A(Lm-2,Mm-1,k)
          A(-2, 0,k)=A(Lm-2,Mm  ,k)
          A(-1,-2,k)=A(Lm-1,Mm-2,k)
          A(-1,-1,k)=A(Lm-1,Mm-1,k)
          A(-1, 0,k)=A(Lm-1,Mm  ,k)
          A( 0,-2,k)=A(Lm  ,Mm-2,k)
          A( 0,-1,k)=A(Lm  ,Mm-1,k)
          A( 0, 0,k)=A(Lm  ,Mm  ,k)
        enddo
      endif
# endif /* EW_PERIODIC && NS_PERIODIC */
      return
      end
      subroutine exchange_w3d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic boundary conditions for 3D variables   !
!  at W-points.                                                      !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY,0:N)
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
# ifdef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West periodic boundary conditions.
!---------------------------------------------------------------------
!
#  ifdef NS_PERIODIC
#   define J_RANGE Jstr,Jend
#  else
#   define J_RANGE JstrR,JendR
#  endif
      if (WESTERN_EDGE) then
        do k=0,N
          do j=J_RANGE
            A(Lm+1,j,k)=A(1,j,k)
            A(Lm+2,j,k)=A(2,j,k)
          enddo
        enddo
      endif
      if (EASTERN_EDGE) then
        do k=0,N
          do j=J_RANGE
            A(-2,j,k)=A(Lm-2,j,k)
            A(-1,j,k)=A(Lm-1,j,k)
            A( 0,j,k)=A(Lm  ,j,k)
          enddo
        enddo
      endif
#  undef J_RANGE
# endif /* EW_PERIODIC */
# ifdef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South periodic boundary conditions.
!---------------------------------------------------------------------
!
#  ifdef EW_PERIODIC
#   define I_RANGE Istr,Iend
#  else
#   define I_RANGE IstrR,IendR
#  endif
      if (SOUTHERN_EDGE) then
        do k=0,N
          do i=I_RANGE
            A(i,Mm+1,k)=A(i,1,k)
            A(i,Mm+2,k)=A(i,2,k)
          enddo
        enddo
      endif
      if (NORTHERN_EDGE) then
        do k=0,N
          do i=I_RANGE
            A(i,-2,k)=A(i,Mm-2,k)
            A(i,-1,k)=A(i,Mm-1,k)
            A(i, 0,k)=A(i,Mm  ,k)
          enddo
        enddo
      endif
#  undef I_RANGE
# endif /* NS_PERIODIC */
# if defined EW_PERIODIC && defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE .and. SOUTHERN_EDGE) then
        do k=0,N
          A(Lm+1,Mm+1,k)=A(1,1,k)
          A(Lm+1,Mm+2,k)=A(1,2,k)
          A(Lm+2,Mm+1,k)=A(2,1,k)
          A(Lm+2,Mm+2,k)=A(2,2,k)
        enddo
      endif
      if (EASTERN_EDGE .and. SOUTHERN_EDGE) then
        do k=0,N
          A(-2,Mm+1,k)=A(Lm-2,1,k)
          A(-1,Mm+1,k)=A(Lm-1,1,k)
          A( 0,Mm+1,k)=A(Lm  ,1,k)
          A(-2,Mm+2,k)=A(Lm-2,2,k)
          A(-1,Mm+2,k)=A(Lm-1,2,k)
          A( 0,Mm+2,k)=A(Lm  ,2,k)
        enddo
      endif
      if (WESTERN_EDGE .and. NORTHERN_EDGE) then
        do k=0,N
          A(Lm+1,-2,k)=A(1,Mm-2,k)
          A(Lm+1,-1,k)=A(1,Mm-1,k)
          A(Lm+1, 0,k)=A(1,Mm  ,k)
          A(Lm+2,-2,k)=A(2,Mm-2,k)
          A(Lm+2,-1,k)=A(2,Mm-1,k)
          A(Lm+2, 0,k)=A(2,Mm  ,k)
        enddo
      endif
      if (EASTERN_EDGE .and. NORTHERN_EDGE) then
        do k=0,N
          A(-2,-2,k)=A(Lm-2,Mm-2,k)
          A(-2,-1,k)=A(Lm-2,Mm-1,k)
          A(-2, 0,k)=A(Lm-2,Mm  ,k)
          A(-1,-2,k)=A(Lm-1,Mm-2,k)
          A(-1,-1,k)=A(Lm-1,Mm-1,k)
          A(-1, 0,k)=A(Lm-1,Mm  ,k)
          A( 0,-2,k)=A(Lm  ,Mm-2,k)
          A( 0,-1,k)=A(Lm  ,Mm-1,k)
          A( 0, 0,k)=A(Lm  ,Mm  ,k)
        enddo
      endif
# endif /* EW_PERIODIC && NS_PERIODIC */
#else
      subroutine exchange_3d
#endif /* SOLVE3D */
      return
      end
