#include "cppdefs.h"
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This package contains periodic boundary conditions routines for   !
!  2D primitive variables.                                           !
!                                                                    !
!  Routines:                                                         !
!                                                                    !
!    exchange_p2d_tile    periodic conditions at PSI-points          !
!    exchange_r2d_tile    periodic conditions at RHO-points          !
!    exchange_u2d_tile    periodic conditions at U-points            !
!    exchange_v2d_tile    periodic conditions at V-points            !
!                                                                    !
!=====================================================================
!
      subroutine exchange_p2d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic boundary conditions for 2D variables   !
!  at PSI-points.                                                    !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY)
!
#include "set_bounds.h"
!
      i=0
      j=0
#ifdef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West periodic boundary conditions.
!---------------------------------------------------------------------
!
# ifdef NS_PERIODIC
#  define J_RANGE Jstr,Jend
# else
#  define J_RANGE Jstr,JendR
# endif
      if (WESTERN_EDGE) then
        do j=J_RANGE
          A(Lm+1,j)=A(1,j)
          A(Lm+2,j)=A(2,j)
        enddo
      endif
      if (EASTERN_EDGE) then
        do j=J_RANGE
          A(-2,j)=A(Lm-2,j)
          A(-1,j)=A(Lm-1,j)
          A( 0,j)=A(Lm  ,j)
        enddo
      endif
# undef J_RANGE
#endif /* EW_PERIODIC */
#ifdef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South periodic boundary conditions.
!---------------------------------------------------------------------
!
# ifdef EW_PERIODIC
#  define I_RANGE Istr,Iend
# else
#  define I_RANGE Istr,IendR
# endif
      if (SOUTHERN_EDGE) then
        do i=I_RANGE
          A(i,Mm+1)=A(i,1)
          A(i,Mm+2)=A(i,2)
        enddo
      endif
      if (NORTHERN_EDGE) then
        do i=I_RANGE
          A(i,-2)=A(i,Mm-2)
          A(i,-1)=A(i,Mm-1)
          A(i, 0)=A(i,Mm  )
        enddo
      endif
# undef I_RANGE
#endif /* NS_PERIODIC */
#if defined EW_PERIODIC && defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE .and. SOUTHERN_EDGE) then
        A(Lm+1,Mm+1)=A(1,1)
        A(Lm+1,Mm+2)=A(1,2)
        A(Lm+2,Mm+1)=A(2,1)
        A(Lm+2,Mm+2)=A(2,2)
      endif
      if (EASTERN_EDGE .and. SOUTHERN_EDGE) then
        A(-2,Mm+1)=A(Lm-2,1)
        A(-1,Mm+1)=A(Lm-1,1)
        A( 0,Mm+1)=A(Lm  ,1)
        A(-2,Mm+2)=A(Lm-2,2)
        A(-1,Mm+2)=A(Lm-1,2)
        A( 0,Mm+2)=A(Lm  ,2)
      endif
      if (WESTERN_EDGE .and. NORTHERN_EDGE) then
        A(Lm+1,-2)=A(1,Mm-2)
        A(Lm+1,-1)=A(1,Mm-1)
        A(Lm+1, 0)=A(1,Mm  )
        A(Lm+2,-2)=A(2,Mm-2)
        A(Lm+2,-1)=A(2,Mm-1)
        A(Lm+2, 0)=A(2,Mm  )
      endif
      if (EASTERN_EDGE .and. NORTHERN_EDGE) then
        A(-2,-2)=A(Lm-2,Mm-2)
        A(-2,-1)=A(Lm-2,Mm-1)
        A(-2, 0)=A(Lm-2,Mm  )
        A(-1,-2)=A(Lm-1,Mm-2)
        A(-1,-1)=A(Lm-1,Mm-1)
        A(-1, 0)=A(Lm-1,Mm  )
        A( 0,-2)=A(Lm  ,Mm-2)
        A( 0,-1)=A(Lm  ,Mm-1)
        A( 0, 0)=A(Lm  ,Mm  )
      endif
#endif /* EW_PERIODIC && NS_PERIODIC */
      return
      end
      subroutine exchange_r2d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic boundary conditions for 2D variables   !
!  at RHO-points.                                                    !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY)
!
#include "set_bounds.h"
!
      i=0
      j=0
#ifdef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West periodic boundary conditions.
!---------------------------------------------------------------------
!
# ifdef NS_PERIODIC
#  define J_RANGE Jstr,Jend
# else
#  define J_RANGE JstrR,JendR
# endif
      if (WESTERN_EDGE) then
        do j=J_RANGE
          A(Lm+1,j)=A(1,j)
          A(Lm+2,j)=A(2,j)
        enddo
      endif
      if (EASTERN_EDGE) then
        do j=J_RANGE
          A(-2,j)=A(Lm-2,j)
          A(-1,j)=A(Lm-1,j)
          A( 0,j)=A(Lm  ,j)
        enddo
      endif
# undef J_RANGE
#endif /* EW_PERIODIC */
#ifdef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South periodic boundary conditions.
!---------------------------------------------------------------------
!
# ifdef EW_PERIODIC
#  define I_RANGE Istr,Iend
# else
#  define I_RANGE IstrR,IendR
# endif
      if (SOUTHERN_EDGE) then
        do i=I_RANGE
          A(i,Mm+1)=A(i,1)
          A(i,Mm+2)=A(i,2)
        enddo
      endif
      if (NORTHERN_EDGE) then
        do i=I_RANGE
          A(i,-2)=A(i,Mm-2)
          A(i,-1)=A(i,Mm-1)
          A(i, 0)=A(i,Mm  )
        enddo
      endif
# undef I_RANGE
#endif /* NS_PERIODIC */
#if defined EW_PERIODIC && defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE .and. SOUTHERN_EDGE) then
        A(Lm+1,Mm+1)=A(1,1)
        A(Lm+1,Mm+2)=A(1,2)
        A(Lm+2,Mm+1)=A(2,1)
        A(Lm+2,Mm+2)=A(2,2)
      endif
      if (EASTERN_EDGE .and. SOUTHERN_EDGE) then
        A(-2,Mm+1)=A(Lm-2,1)
        A(-1,Mm+1)=A(Lm-1,1)
        A( 0,Mm+1)=A(Lm  ,1)
        A(-2,Mm+2)=A(Lm-2,2)
        A(-1,Mm+2)=A(Lm-1,2)
        A( 0,Mm+2)=A(Lm  ,2)
      endif
      if (WESTERN_EDGE .and. NORTHERN_EDGE) then
        A(Lm+1,-2)=A(1,Mm-2)
        A(Lm+1,-1)=A(1,Mm-1)
        A(Lm+1, 0)=A(1,Mm  )
        A(Lm+2,-2)=A(2,Mm-2)
        A(Lm+2,-1)=A(2,Mm-1)
        A(Lm+2, 0)=A(2,Mm  )
      endif
      if (EASTERN_EDGE .and. NORTHERN_EDGE) then
        A(-2,-2)=A(Lm-2,Mm-2)
        A(-2,-1)=A(Lm-2,Mm-1)
        A(-2, 0)=A(Lm-2,Mm  )
        A(-1,-2)=A(Lm-1,Mm-2)
        A(-1,-1)=A(Lm-1,Mm-1)
        A(-1, 0)=A(Lm-1,Mm  )
        A( 0,-2)=A(Lm  ,Mm-2)
        A( 0,-1)=A(Lm  ,Mm-1)
        A( 0, 0)=A(Lm  ,Mm  )
      endif
#endif /* EW_PERIODIC && NS_PERIODIC */
      return
      end
      subroutine exchange_u2d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic boundary conditions for 2D variables   !
!  at U-points.                                                      !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY)
!
#include "set_bounds.h"
!
      i=0
      j=0
#ifdef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West periodic boundary conditions.
!---------------------------------------------------------------------
!
# ifdef NS_PERIODIC
#  define J_RANGE Jstr,Jend
# else
#  define J_RANGE JstrR,JendR
# endif
      if (WESTERN_EDGE) then
        do j=J_RANGE
          A(Lm+1,j)=A(1,j)
          A(Lm+2,j)=A(2,j)
        enddo
      endif
      if (EASTERN_EDGE) then
        do j=J_RANGE
          A(-2,j)=A(Lm-2,j)
          A(-1,j)=A(Lm-1,j)
          A( 0,j)=A(Lm  ,j)
        enddo
      endif
# undef J_RANGE
#endif /* EW_PERIODIC */
#ifdef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South periodic boundary conditions.
!---------------------------------------------------------------------
!
# ifdef EW_PERIODIC
#  define I_RANGE Istr,Iend
# else
#  define I_RANGE Istr,IendR
# endif
      if (SOUTHERN_EDGE) then
        do i=I_RANGE
          A(i,Mm+1)=A(i,1)
          A(i,Mm+2)=A(i,2)
        enddo
      endif
      if (NORTHERN_EDGE) then
        do i=I_RANGE
          A(i,-2)=A(i,Mm-2)
          A(i,-1)=A(i,Mm-1)
          A(i, 0)=A(i,Mm  )
        enddo
      endif
# undef I_RANGE
#endif /* NS_PERIODIC */
#if defined EW_PERIODIC && defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE .and. SOUTHERN_EDGE) then
        A(Lm+1,Mm+1)=A(1,1)
        A(Lm+1,Mm+2)=A(1,2)
        A(Lm+2,Mm+1)=A(2,1)
        A(Lm+2,Mm+2)=A(2,2)
      endif
      if (EASTERN_EDGE .and. SOUTHERN_EDGE) then
        A(-2,Mm+1)=A(Lm-2,1)
        A(-1,Mm+1)=A(Lm-1,1)
        A( 0,Mm+1)=A(Lm  ,1)
        A(-2,Mm+2)=A(Lm-2,2)
        A(-1,Mm+2)=A(Lm-1,2)
        A( 0,Mm+2)=A(Lm  ,2)
      endif
      if (WESTERN_EDGE .and. NORTHERN_EDGE) then
        A(Lm+1,-2)=A(1,Mm-2)
        A(Lm+1,-1)=A(1,Mm-1)
        A(Lm+1, 0)=A(1,Mm  )
        A(Lm+2,-2)=A(2,Mm-2)
        A(Lm+2,-1)=A(2,Mm-1)
        A(Lm+2, 0)=A(2,Mm  )
      endif
      if (EASTERN_EDGE .and. NORTHERN_EDGE) then
        A(-2,-2)=A(Lm-2,Mm-2)
        A(-2,-1)=A(Lm-2,Mm-1)
        A(-2, 0)=A(Lm-2,Mm  )
        A(-1,-2)=A(Lm-1,Mm-2)
        A(-1,-1)=A(Lm-1,Mm-1)
        A(-1, 0)=A(Lm-1,Mm  )
        A( 0,-2)=A(Lm  ,Mm-2)
        A( 0,-1)=A(Lm  ,Mm-1)
        A( 0, 0)=A(Lm  ,Mm  )
      endif
#endif /* EW_PERIODIC && NS_PERIODIC */
      return
      end
      subroutine exchange_v2d_tile (Istr,Iend,Jstr,Jend,A)
!
!=====================================================================
!                                                                    !
!  This routine sets periodic boundary conditions for 2D variables   !
!  at V-points.                                                      !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY)
!
#include "set_bounds.h"
!
      i=0
      j=0
#ifdef EW_PERIODIC
!
!---------------------------------------------------------------------
!  East-West periodic boundary conditions.
!---------------------------------------------------------------------
!
# ifdef NS_PERIODIC
#  define J_RANGE Jstr,Jend
# else
#  define J_RANGE Jstr,JendR
# endif
      if (WESTERN_EDGE) then
        do j=J_RANGE
          A(Lm+1,j)=A(1,j)
          A(Lm+2,j)=A(2,j)
        enddo
      endif
      if (EASTERN_EDGE) then
        do j=J_RANGE
          A(-2,j)=A(Lm-2,j)
          A(-1,j)=A(Lm-1,j)
          A( 0,j)=A(Lm  ,j)
        enddo
      endif
# undef J_RANGE
#endif /* EW_PERIODIC */
#ifdef NS_PERIODIC
!
!---------------------------------------------------------------------
!  North-South periodic boundary conditions.
!---------------------------------------------------------------------
!
# ifdef EW_PERIODIC
#  define I_RANGE Istr,Iend
# else
#  define I_RANGE IstrR,IendR
# endif
      if (SOUTHERN_EDGE) then
        do i=I_RANGE
          A(i,Mm+1)=A(i,1)
          A(i,Mm+2)=A(i,2)
        enddo
      endif
      if (NORTHERN_EDGE) then
        do i=I_RANGE
          A(i,-2)=A(i,Mm-2)
          A(i,-1)=A(i,Mm-1)
          A(i, 0)=A(i,Mm  )
        enddo
      endif
# undef I_RANGE
#endif /* NS_PERIODIC */
#if defined EW_PERIODIC && defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE .and. SOUTHERN_EDGE) then
        A(Lm+1,Mm+1)=A(1,1)
        A(Lm+1,Mm+2)=A(1,2)
        A(Lm+2,Mm+1)=A(2,1)
        A(Lm+2,Mm+2)=A(2,2)
      endif
      if (EASTERN_EDGE .and. SOUTHERN_EDGE) then
        A(-2,Mm+1)=A(Lm-2,1)
        A(-1,Mm+1)=A(Lm-1,1)
        A( 0,Mm+1)=A(Lm  ,1)
        A(-2,Mm+2)=A(Lm-2,2)
        A(-1,Mm+2)=A(Lm-1,2)
        A( 0,Mm+2)=A(Lm  ,2)
      endif
      if (WESTERN_EDGE .and. NORTHERN_EDGE) then
        A(Lm+1,-2)=A(1,Mm-2)
        A(Lm+1,-1)=A(1,Mm-1)
        A(Lm+1, 0)=A(1,Mm  )
        A(Lm+2,-2)=A(2,Mm-2)
        A(Lm+2,-1)=A(2,Mm-1)
        A(Lm+2, 0)=A(2,Mm  )
      endif
      if (EASTERN_EDGE .and. NORTHERN_EDGE) then
        A(-2,-2)=A(Lm-2,Mm-2)
        A(-2,-1)=A(Lm-2,Mm-1)
        A(-2, 0)=A(Lm-2,Mm  )
        A(-1,-2)=A(Lm-1,Mm-2)
        A(-1,-1)=A(Lm-1,Mm-1)
        A(-1, 0)=A(Lm-1,Mm  )
        A( 0,-2)=A(Lm  ,Mm-2)
        A( 0,-1)=A(Lm  ,Mm-1)
        A( 0, 0)=A(Lm  ,Mm  )
      endif
#endif /* EW_PERIODIC && NS_PERIODIC */
      return
      end
