#include "cppdefs.h"
#ifdef RANDOM_ESPERT
      subroutine res_pert
!
!========================================== Pierre F.J. Lermusiaux ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine reads  state error subspace data from ES NetCDF      !
!  file  and computes state variables perturbations as a ramdon      !
!  linear combination of error subspaces.                            !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "ncparam.h"
#include "netcdf.inc"
#include "obs.h"
#include "ocean.h"
#include "scalars.h"
#include "scratch.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr
      logical got(NSV), normalize
      INTEGER_TYPE
     &        i, ifield, j, lstr, lsvar, lvar, nrec, nvec, status,
     &        varid
# ifdef SOLVE3D
      INTEGER_TYPE
     &        itrc, k
# endif
      INTEGER_TYPE
     &        idvar(NSV)
      INTEGER_TYPE
     &        lenstr, nf_fread
      REAL_TYPE
     &        cff, Fmax, Fmin
      REAL_TYPE
     &        EEval(Msev), Erms(NSV), rancoef(Msev)
      REAL_TYPE
     &        wrk(GLOBAL_2D_ARRAY,1:N)
      equivalence (wrk,A3d)
!
      Istr=1
      Iend=Lm
      Jstr=1
      Jend=Mm
# include "set_bounds.h"
!
# ifdef EW_PERIODIC
#  define IU_RANGE Istr,Iend
#  define IV_RANGE Istr,Iend
# else
#  define IU_RANGE Istr,IendR
#  define IV_RANGE IstrR,IendR
# endif
# ifdef NS_PERIODIC
#  define JU_RANGE Jstr,Jend
#  define JV_RANGE Jstr,Jend
# else
#  define JU_RANGE JstrR,JendR
#  define JV_RANGE Jstr,JendR
# endif
!
!---------------------------------------------------------------------
!  Inquire about the contents of ES NetCDF file:  Inquire about
!  the dimensions and variables.  Check for consistency.
!---------------------------------------------------------------------
!
      if (exit_flag.ne.0) return
      ifield=0
      call opencdf (ESname,N,ifield,nrec)
      if (exit_flag.ne.0) return
!
!  Scan variable list from input NetCDF and check for needed state
!  error subspace variables.
!
      lstr=lenstr(ESname)
      do j=1,NSV
        lsvar=lenstr(Vname(1,idSvar(j)))
        do i=1,nvars
          lvar=lenstr(varnam(i))
          if (varnam(i)(1:lvar).eq.Vname(1,idSvar(j))) then
            idvar(j)=i
            got(j)=.true.
          endif
        enddo
      enddo
!
!  Open ES NetCDF file for reading.
!
      if (ncesid.eq.-1) then
        status=nf_open(ESname(1:lstr),nf_nowrite,ncesid)
        if (status.ne.nf_noerr) then
          write(stdout,10) ESname(1:lstr)
          exit_flag=2
          return
        endif
      endif
!
!---------------------------------------------------------------------
!  Compute perturbations base on a random linear combination of error
!  subspace eigenvectors.
!---------------------------------------------------------------------
!
!  Roll the dice, compute a set of normalized random coefficients.
!
      normalize=.true.
      call random (rancoef,Nsev,normalize)
      do nvec=1,Nsev
        rancoef(nvec)=rancoef(nvec)*err_fct
      enddo
!
!  Read in error subspace eigenvalues, EEval.
!
      status=nf_inq_varid(ncesid,'EEval',varid)
      if (status.ne.nf_noerr) then
        write(stdout,20) 'EEval', ESname(1:lstr)
        exit_flag=2
        return
      endif
      status=nf_get_vara_FTYPE(ncesid,varid,1,Nsev,EEval)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'EEval', ESname(1:lstr)
      endif
!
!  Read in state error subspace normalization factors, Erms.  They are
!  needed to dimensionalize error subspaces to the appropriate units.
!
      status=nf_inq_varid(ncesid,'Erms',varid)
      if (status.ne.nf_noerr) then
        write(stdout,20) 'Erms', ESname(1:lstr)
        exit_flag=2
        return
      endif
      status=nf_get_vara_FTYPE(ncesid,varid,1,NSV,Erms)
      if (status.ne.nf_noerr) then
        write(stdout,30) 'Erms', ESname(1:lstr)
        exit_flag=2
        return
      endif
!
!  Read in "Nsev" error subspace eingenvectors and add them randomly
!  to state variables.
!
      do nvec=1,Nsev
!
!  Perturb free-surface.
!
        if (pert(isFsur)) then
          if (got(isFsur)) then
            status=nf_fread(wrk(START_2D_ARRAY,1),Fmin,Fmax,
     &                      ncesid,idvar(isFsur),nvec,r2dvar)
            if (status.ne.nf_noerr) then
              lsvar=lenstr(Vname(1,idSvar(isFsur)))
              write(stdout,40) Vname(1,idSvar(isFsur))(1:lsvar), nvec,
     &                         ESname(1:lstr)
              exit_flag=2
              return
            endif
            cff=rancoef(nvec)*Erms(isFsur)*SQRT(EEval(nvec))
            do j=JU_RANGE
              do i=IV_RANGE
                zeta(i,j,1)=zeta(i,j,1)+wrk(i,j,1)*cff
              enddo
            enddo
          else
            lsvar=lenstr(Vname(1,idSvar(isFsur)))
            write(stdout,20) Vname(1,idSvar(isFsur))(1:lsvar),
     &                       ESname(1:lstr)
            exit_flag=2
            return
          endif
        endif
!
! Perturb 2D momentum in the XI-direction.
!
        if (pert(isUbar)) then
          if (got(isUbar)) then
            status=nf_fread(wrk(START_2D_ARRAY,1),Fmin,Fmax,
     &                      ncesid,idvar(isUbar),nvec,u2dvar)
            if (status.ne.nf_noerr) then
              lsvar=lenstr(Vname(1,idSvar(isUbar)))
              write(stdout,40) Vname(1,idSvar(isUbar))(1:lsvar), nvec,
     &                         ESname(1:lstr)
              exit_flag=2
              return
            endif
            cff=rancoef(nvec)*Erms(isUbar)*SQRT(EEval(nvec))
            do j=JU_RANGE
              do i=IU_RANGE
                ubar(i,j,1)=ubar(i,j,1)+wrk(i,j,1)*cff
              enddo
            enddo
          else
            lsvar=lenstr(Vname(1,idSvar(isUbar)))
            write(stdout,20) Vname(1,idSvar(isUbar))(1:lsvar),
     &                       ESname(1:lstr)
            exit_flag=2
            return
          endif
        endif
!
! Perturb 2D momentum in the ETA-direction.
!
        if (pert(isVbar)) then
          if (got(isVbar)) then
            status=nf_fread(wrk(START_2D_ARRAY,1),Fmin,Fmax,
     &                      ncesid,idvar(isVbar),nvec,v2dvar)
            if (status.ne.nf_noerr) then
              lsvar=lenstr(Vname(1,idSvar(isVbar)))
              write(stdout,40) Vname(1,idSvar(isVbar))(1:lsvar), nvec,
     &                         ESname(1:lstr)
              exit_flag=2
              return
            endif
            cff=rancoef(nvec)*Erms(isVbar)*SQRT(EEval(nvec))
            do j=JV_RANGE
              do i=IV_RANGE
                vbar(i,j,1)=vbar(i,j,1)+wrk(i,j,1)*cff
              enddo
            enddo
          else
            lsvar=lenstr(Vname(1,idSvar(isVbar)))
            write(stdout,20) Vname(1,idSvar(isVbar))(1:lsvar),
     &                       ESname(1:lstr)
            exit_flag=2
            return
          endif
        endif
# ifdef SOLVE3D
!
! Perturb 3D momentum in the XI-direction.
!
        if (pert(isUvel)) then
          if (got(isUvel)) then
            status=nf_fread(wrk(START_2D_ARRAY,1),Fmin,Fmax,
     &                      ncesid,idvar(isUvel),nvec,u3dvar)
            if (status.ne.nf_noerr) then
              lsvar=lenstr(Vname(1,idSvar(isUvel)))
              write(stdout,40) Vname(1,idSvar(isUvel))(1:lsvar), nvec,
     &                         ESname(1:lstr)
              exit_flag=2
              return
            endif
            cff=rancoef(nvec)*Erms(isUvel)*SQRT(EEval(nvec))
            do k=1,N
              do j=JU_RANGE
                do i=IU_RANGE
                  u(i,j,k,1)=u(i,j,k,1)+wrk(i,j,k)*cff
                enddo
              enddo
            enddo
          else
            lsvar=lenstr(Vname(1,idSvar(isUvel)))
            write(stdout,20) Vname(1,idSvar(isUvel))(1:lsvar),
     &                       ESname(1:lstr)
            exit_flag=2
            return
          endif
        endif
!
! Perturb 3D momentum in the ETA-direction.
!
        if (pert(isVvel)) then
          if (got(isVvel)) then
            status=nf_fread(wrk(START_2D_ARRAY,1),Fmin,Fmax,
     &                      ncesid,idvar(isVvel),nvec,v3dvar)
            if (status.ne.nf_noerr) then
              lsvar=lenstr(Vname(1,idSvar(isVvel)))
              write(stdout,40) Vname(1,idSvar(isVvel))(1:lsvar), nvec,
     &                         ESname(1:lstr)
              exit_flag=2
              return
            endif
            cff=rancoef(nvec)*Erms(isVvel)*SQRT(EEval(nvec))
            do k=1,N
              do j=JV_RANGE
                do i=IV_RANGE
                  v(i,j,k,1)=v(i,j,k,1)+wrk(i,j,k)*cff
                enddo
              enddo
            enddo
          else
            lsvar=lenstr(Vname(1,idSvar(isVvel)))
            write(stdout,20) Vname(1,idSvar(isVvel))(1:lsvar),
     &                       ESname(1:lstr)
            exit_flag=2
            return
          endif
        endif
!
! Perturb tracer type variables.
!
        do itrc=1,NT
          if (pert(isTvar(itrc))) then
            if (got(isTvar(itrc))) then
              status=nf_fread(wrk(START_2D_ARRAY,1),Fmin,Fmax,
     &                        ncesid,idvar(isTvar(itrc)),nvec,r3dvar)
              if (status.ne.nf_noerr) then
                lsvar=lenstr(Vname(1,idSvar(isTvar(itrc))))
                write(stdout,40) Vname(1,idSvar(isTvar(itrc)))(1:lsvar),
     &                            nvec, ESname(1:lstr)
                exit_flag=2
                return
              endif
              cff=rancoef(nvec)*Erms(isTvar(itrc))*SQRT(EEval(nvec))
              do k=1,N
                do j=JU_RANGE
                  do i=IV_RANGE
                    t(i,j,k,itrc,1)=t(i,j,k,itrc,1)+wrk(i,j,k)*cff
                  enddo
                enddo
              enddo
            else
              lsvar=lenstr(Vname(1,idSvar(isTvar(itrc))))
              write(stdout,20) Vname(1,idSvar(isTvar(itrc)))(1:lsvar),
     &                         ESname(1:lstr)
              exit_flag=2
              return
            endif
          endif
        enddo
# endif /* SOLVE3D */
      enddo
!
  10  format(/,' RES_PERT - unable to open ES NetCDF file: ',a)
  20  format(/,' RES_PERT - unable to find ES variable: ',a,
     &       /,12x,'in NetCDF file: ',a)
  30  format(/,' RES_PERT - error while reading variable: ',a,2x,
     &       /,12x,'in ES NetCDF file: ',a)
  40  format(/,' RES_PERT - error while reading variable: ',a,2x,
     &       'for eigenvector = ',i3,/,12x,'in ES NetCDF file: ',a)
      return
      end
# ifdef DOUBLE_PRECISION
#  ifdef SUN
#   define rand drand
#  endif
# endif
      subroutine random (r,nr,norm)
!
!========================================== Pierre F.J. Lermusiaux ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine generates a sequence of random numbers with the      !
!  seed.   The "idate" and "itime" library routines are used to      !
!  compute the "seed" value.                                         !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     nr       Number of random numbers to generate.                 !
!     norm     Logical switch to normalize randon numbers (T/F).     !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     r(1:nr)  Random numbers.                                       !
!                                                                    !
!=====================================================================
!
      implicit none
      logical norm
      INTEGER_TYPE
     &        i, ia(6), nr, seed
      REAL_TYPE
     &        cff, r(nr)
      REAL_TYPE
     &        rand
!
!---------------------------------------------------------------------
!  Get current date and time.
!---------------------------------------------------------------------
!
#if defined SGI
      call idate (ia(1),ia(2),ia(3))
      call itime (ia(4))
#elif defined SUN
      call idate (ia(1))
      call itime (ia(4))
#endif
!
!---------------------------------------------------------------------
!  Generate a sequence of normalized random numbers.
!---------------------------------------------------------------------
!
!  First, compute a new seed for random number generator.
!
      seed=ia(2)*1e+6 + ia(4)*1e+4 + ia(5)*1e+2 + ia(6)
!
!  Inialize and generate random numbers.
!
#if defined SGI
      call srand (seed)
      do i=1,nr
        r(i)=2.0_r8*rand()-1.0_r8
      enddo
#elif defined SUN
      cff=rand(seed)
      do i=1,nr
        r(i)=2.0_r8*rand(0)-1.0_r8
      enddo
#endif
!
!  Normalize random numbers.
!
      cff=0.0_r8
      if (norm) then
        do i=1,nr
          cff=cff+r(i)*r(i)
        enddo
        cff=1.0_r8/SQRT(cff/FLOAT(nr))
        do i=1,nr
          r(i)=r(i)*cff
        enddo
      endif
      return
      end
#else
      subroutine res_pert
      end
#endif /* RANDOM_ESPERT */
