#ifdef ECOSIM

/*
************************************************** W. Paul Bissett ***
** Copyright (c) 2002 TOMS Group/FERI                               **
** Copyright (c) 1997 W. Paul Bissett                               **
**                                                                  **
** The EcoSim model  has been developed for research purposes only. **
** It is freely available on request from the Florida Environmental **
** Research Institute (FERI).  Commercial usage of this formulation **
** is forbidden without express written permission from  FERI.  All **
** rights reserved.                                                 **
**                                                                  **
**=============================================== Hernan G. Arango ===
**                                                                  **
** This routine computes the EcoSim sources and sinks and adds them **
** to the global biological fields.                                 **
**                                                                  **
**  Reference:                                                      **
**                                                                  **
**    Bissett, W.P., J.J. Walsh, D.A. Dieterle, K.L. Carder, 1999:  **
**      Carbon cycling in the upper waters of the Sargasso Sea: I.  **
**      Numerical  simulation of  differential carbon and nitrogen  **
**      fluxes,  Deep-Sea Res., 46, 205-269.                        **
**                                                                  **
**   Bissett, W.P., K.L. Carder, J.J. Walsh, D.A. Dieterle, 1999:   **
**     Carbon cycling in the upper waters of the Sargasso Sea: II.  **
**     Numerical  simulation  of  apparent  and  inherent optical   **
**     properties, Deep-Sea Res., 46, 271-317                       **
**                                                                  **
** Currently, there is a maximum of seven phytoplantin species and  **
** seven different pigments.                                        **
**                                                                  **
**       1: diatom 1               1:  chlorophyll a                **
**       2: diatom 2               2:  chlorophyll b                **
**       3: dinoflagellate 1       3:  chlorophyll c                **
**       4: dinoflagellate 2       4:  photosythetic carotenoids    **
**       5: synechococcus          5:  photoprotective carotenoids  **
**       6: prochlorococcus 1      6:  HPUB                         **
**       7: prochlorococcus 2      7:  LPUB                         **
**                                                                  **
** The full phytoplankton/pigment matrix is as follows:             **
**                                                                  **
**              P i g m e n t s                                     **
**             [1]   [2]   [3]   [4]   [5]   [6]   [7]              **
**                                                                  **
**      P [1]   1     0     1     1     1     0     0               **
**      h [2]   1     0     1     1     1     0     0               **
**      y [3]   1     0     1     1     1     0     0               **
**      t [4]   1     0     1     1     1     0     0               **
**      o [5]   1     0     0     0     1     0     1               **
**        [6]   1     1     0     0     1     0     0               **
**        [7]   1     1     0     0     1     0     0               **
**                                                                  **
** Sediment tracer identification indices:                          **
**                                                                  **
** iBacC     Bateria, Carbon group.                                 **
** iBacN     Bateria, Nitrogen group.                               **
** iBacP     Bateria, Phosphorous group.                            **
** iBacF     Bateria, Iron group.                                   **
** iDOMC     Dissolved organic matter, Carbon group.                **
** iDOMN     Dissolved organic matter, Nitrogen group.              **
** iDOMP     Dissolved organic matter, Phosphorous group.           **
** iCDMC     Color degradational matter.                            **
** iFecC     Fecal matter, Carbon group.                            **
** iFecN     Fecal matter, Nitrogen group.                          **
** iFecP     Fecal matter, Phosphorous group.                       **
** iFecF     Fecal matter, Iron group.                              **
** iFecS     Fecal matter, Silica group.                            **
** iPhyC     Phytoplankton, Carbon group.                           **
** iPhyN     Phytoplankton, Nitrogen group.                         **
** iPhyP     Phytoplankton, Phosphorous group.                      **
** iPhyF     Phytoplankton, Iron group.                             **
** iPhyS     Phytoplankton, Silica group.                           **
** iPigs     Phytoplankton, pigment group.                          **
** iNO3_     Nitrate concentration.                                 **
** iNH4_     Ammonium concentration.                                **
** iPO4_     Phosphate concentration.                               **
** iFeO_     Iron concentration.                                    **
** iSiO_     Silica concentration.                                  ** 
** iDIC_     Dissolved inorganic Carbon.                            **
**                                                                  **
** PIG       Full phytoplankton/pigment matrix.                     **
**                                                                  **
**********************************************************************
*/
 
**                                                                  **
**====================================================================
**
*/
      INTEGER_TYPE
     &        Nbnd, Tbnd
      parameter (Tbnd=11233, Nbnd=60)
!
!  Global test parameters.
!
      REAL_TYPE
     &        SMALL, VSMALL, LARGE, VLARGE
      parameter (SMALL  = 1.0_e8-6)
      parameter (VSMALL = 1.0_e8-14)
      parameter (LARGE  = 1.0_e8+10)
      parameter (VLARGE = 1.0_e8+50)
!
!  EcoSim frequently used calculation value.
!
      REAL_TYPE
     &        DLAM, SEC_DAY, I_SEC_DAY
      parameter (DLAM      = 5.0_r8)
      parameter (SEC_DAY   = 86400.0_r8)
      parameter (I_SEC_DAY = 1.0_r8 / 86400.0_r8)
!
!  Bacteria parameters.
!
      REAL_TYPE
     &        C2nBAC, N2cBAC, C2pBAC, P2cBAC, C2FeBAC, Fe2cBAC
      parameter (C2nBAC    = 5.0_r8)               !C to N of Bacteria
      parameter (N2cBAC    = 1.0_r8 / C2nBAC)      !N to C of Bacteria
      parameter (C2pBAC    = 12.0_r8 * C2nBAC)     !C to P of Bacteria
      parameter (P2cBAC    = 1.0_r8 / C2pBAC)      !P to C of Bacteria
      parameter (C2FeBAC   = 1000.0_r8)            !C to Fe of Bacteria
      parameter (Fe2cBAC   = 1.0_r8 / C2FeBAC)     !Fe to C of Bacteria
!
!  Bio-optical tracer indices.
!
      common /ecosim_indices/
     &        iDIC_,             iFeO_,             iNH4_,
     &        iNO3_,             iPO4_,             iSiO_,
     &        iBacC,             iBacF,             iBacN,
     &        iBacP,             iCDMC,             iDOMC,
     &        iDOMN,             iDOMP,             iFecC,
     &        iFecF,             iFecN,             iFecP,
     &        iFecS,             iPhyC,             iPhyF,
     &        iPhyN,             iPhyP,             iPhyS,
     &        iPigs   
      INTEGER_TYPE
     &        iDIC_,             iFeO_,             iNH4_,
     &        iNO3_,             iPO4_,             iSiO_,
     &        iBacC(Nbac),       iBacF(Nbac),       iBacN(Nbac),
     &        iBacP(Nbac),       iCDMC(Ndom),       iDOMC(Ndom),
     &        iDOMN(Ndom),       iDOMP(Ndom),       iFecC(Nfec),
     &        iFecF(Nfec),       iFecN(Nfec),       iFecP(Nfec),
     &        iFecS(Nfec),       iPhyC(Nphy),       iPhyF(Nphy),
     &        iPhyN(Nphy),       iPhyP(Nphy),       iPhyS(Nphy),
     &        iPigs(Nphy,Npig)
!
! Light Inputs
! these three variables need to go into a common block for light field
! calculations. The data for these fields can be found in the
! sfcirr.dat and sfcper.dat files. The first line of each of these files
! is the spectral resolution of the irradiance. The subsequent lines
! are integer(day-of-year),real(ZULU time),real(sun angle theta),
! and real(spectral irradiance(number of bands)). The dat files run
! from July 1 to August 8 at a 300 sec DT.
! format of data is:
!
! Light arrays
!
      common /ecosim_light/
     &        Irr_time,          Irr_angle,         theta_m,
     &        specir_m,          specper_m
      common /ecosim_irr/
     &        D_irr,             T_irr
      REAL_TYPE
     &        Irr_time(Tbnd),    Irr_angle(Tbnd),   D_irr(Nbnd,Tbnd),
     &        T_irr(Nbnd,Tbnd),  theta_m,           specir_m(Nbnd),
     &        specper_m(Nbnd)
!
! The ecosim_phyto, ecosim_IOP, and ecosim_other common blocks only
! need to be set once for the entire domain at the initialization of
! the model.
! Phytoplankton parameters (no change with time, space); read in from
! phyto_param.dat file in the exact order as listed here.
! Calculated phytoplankton parameters (no change with time, space)
!
      common /ecosim_phyto/
     &        HsNO3,              HsNH4,            HsSiO,
     &        HsPO4,              HsFe,             BET_,
     &        GtALG_max,          maxC2nALG,        minC2nALG,
     &        maxC2SiALG,         minC2SiALG,       maxC2pALG,
     &        minC2pALG,          maxC2FeALG,       minC2FeALG,
     &        qu_yld,             E0_comp,          E0_inhib,
     &        inhib_fac,          C2CHL_max,        mxC2Cl,
     &        b_C2Cl,             mxC2Cn,           b_C2Cn,
     &        mxPacEff,           b_PacEff,         mxChlB,
     &        b_ChlB,             mxChlC,           b_ChlC,
     &        mxPSC,              b_PSC,            mxPPC,
     &        b_PPC,              mxLPUb,           b_LPUb,
     &        mxHPUb,             b_HPUb,           FecDOC,
     &        FecPEL,             FecCYC,           ExALG,
     &        WS,                 HsGRZ,            MinRefuge,
     &        RefugeDep,          Norm_Vol,         Norm_Surf,
     &        HsDOP,              C2pALKPHOS,       HsDON,
     &        C2nNupDON,          C2nALGminABS,     C2SiALGminABS,
     &        C2pALGminABS,       C2FeALGminABS,    ImaxC2nALG,
     &        ImaxC2sALG,         ImaxC2pALG,       ImaxC2fALG
      REAL_TYPE
     &        HsNO3(Nphy),        HsNH4(Nphy),      HsSiO(Nphy),
     &        HsPO4(Nphy),        HsFe(Nphy),       BET_(Nphy),
     &        GtALG_max(Nphy),    maxC2nALG(Nphy),  minC2nALG(Nphy),
     &        maxC2SiALG(Nphy),   minC2SiALG(Nphy), maxC2pALG(Nphy),
     &        minC2pALG(Nphy),    maxC2FeALG(Nphy), minC2FeALG(Nphy),
     &        qu_yld(Nphy),       E0_comp(Nphy),    E0_inhib(Nphy),
     &        inhib_fac(Nphy),    C2CHL_max(Nphy),  mxC2Cl(Nphy),
     &        b_C2Cl(Nphy),       mxC2Cn(Nphy),     b_C2Cn(Nphy),
     &        mxPacEff(Nphy),     b_PacEff(Nphy),   mxChlB(Nphy),
     &        b_ChlB(Nphy),       mxChlC(Nphy),     b_ChlC(Nphy),
     &        mxPSC(Nphy),        b_PSC(Nphy),      mxPPC(Nphy),
     &        b_PPC(Nphy),        mxLPUb(Nphy),     b_LPUb(Nphy),
     &        mxHPUb(Nphy),       b_HPUb(Nphy),     FecDOC(Nphy),
     &        FecPEL(Nphy,Nfec),  FecCYC(Nphy),     ExALG(Nphy),
     &        WS(Nphy),           HsGRZ(Nphy),      MinRefuge(Nphy),
     &        RefugeDep(Nphy),    Norm_Vol(Nphy),   Norm_Surf(Nphy),
     &        HsDOP(Nphy),        C2pALKPHOS(Nphy), HsDON(Nphy)
      REAL_TYPE
     &        C2nNupDON(Nphy),    C2nALGminABS(Nphy),
     &        C2SiALGminABS(Nphy),C2pALGminABS(Nphy),
     &        C2FeALGminABS(Nphy),ImaxC2nALG(Nphy),ImaxC2sALG(Nphy),
     &        ImaxC2pALG(Nphy),   ImaxC2fALG(Nphy)

!
      common /ecosim_iop/
     &        wave_ab,            apigs,            aDOC,
     &        awater,             bwater,
     &        aDOC300,            aDOC410,          cDOCfrac_c
      REAL_TYPE
     &        wave_ab(Nbnd),      awater(Nbnd),     bwater(Nbnd),
     &        apigs(Npig,Nbnd),   aDOC(Ndom,Nbnd),
     &        aDOC300(Ndom),      aDOC410(Ndom),    cDOCfrac_c(Ndom)

      common /ecosim_other/
     &         HsDOC_ba,   HsFe_ba,
     &         HsNH4_ba,   HsPO4_ba,
     &         WF
      REAL_TYPE
     &          HsDOC_ba(Nbac), HsFe_ba(Nbac),
     &          HsNH4_ba(Nbac), HsPO4_ba(Nbac),
     &          WF(Nfec)
#endif /* ECOSIM */
