#include "cppdefs.h"
      subroutine diag (tile)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine computes various diagnostic fields.                  !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
#include "param.h"
#include "scratch.h"
#include "tile.h"
!
#ifdef PROFILE
      call wclock_on (7)
#endif
      call diag_tile (Istr,Iend,Jstr,Jend,
     &                A2d(1,1),A2d(1,2))
#ifdef ANA_DIAG
      call ana_diag (Istr,Iend,Jstr,Jend)
#endif
#ifdef PROFILE
      call wclock_off (7)
#endif
      return
      end
!
!*********************************************************************
      subroutine diag_tile (Istr,Iend,Jstr,Jend,ke2d,pe2d)
!*********************************************************************
!
      implicit none
#include "param.h"
#include "grid.h"
#include "iounits.h"
#include "ocean.h"
#include "scalars.h"
#include "wclock.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k, trd
      INTEGER_TYPE
     &        my_threadnum
      REAL_TYPE
     &        ke2d(PRIVATE_2D_SCRATCH_ARRAY),
     &        pe2d(PRIVATE_2D_SCRATCH_ARRAY)
      character*8 kechar, pechar
      REAL_TYPE
     &        NSUB, cff
      REAL_TYPE
     &        my_avgke, my_avgpe, my_volume
!
      k=0
!
!---------------------------------------------------------------------
!  Compute and report out volume averaged kinetic, potential
!  total energy, and volume.
!---------------------------------------------------------------------
!
      if (MOD(iic-1,ninfo).eq.0) then
        do j=Jstr,Jend
#ifdef SOLVE3D
          do i=Istr,Iend
            ke2d(i,j)=0.0_r8
            pe2d(i,j)=0.5_r8*g*z_w(i,j,N)*z_w(i,j,N)
          enddo
          cff=g/rho0
          do k=N,1,-1
            do i=Istr,Iend
              ke2d(i,j)=ke2d(i,j)+
     &                  Hz(i,j,k)*(rho(i,j,k)+1000.0_r8)*
     &                  0.25_r8*(u(i  ,j,k,nstp)*u(i,j,k,nstp)+
     &                           u(i+1,j,k,nstp)*u(i+1,j,k,nstp)+
     &                           v(i,j  ,k,nstp)*v(i,j  ,k,nstp)+
     &                           v(i,j+1,k,nstp)*v(i,j+1,k,nstp))
             pe2d(i,j)=pe2d(i,j)+
     &                 cff*Hz(i,j,k)*(rho(i,j,k)+1000.0_r8)*
     &                 (z_r(i,j,k)-z_w(i,j,0))
            enddo
          enddo
#else
          cff=0.5_r8*g
          do i=Istr,Iend
            ke2d(i,j)=(zeta(i,j,krhs)+h(i,j))*
     &                0.25_r8*(ubar(i  ,j,krhs)*ubar(i  ,j,krhs)+
     &                         ubar(i+1,j,krhs)*ubar(i+1,j,krhs)+
     &                         vbar(i,j  ,krhs)*vbar(i,j  ,krhs)+
     &                         vbar(i,j+1,krhs)*vbar(i,j+1,krhs))
            pe2d(i,j)=cff*zeta(i,j,krhs)*zeta(i,j,krhs)
          enddo
#endif /* SOLVE3D */
        enddo
!
!  Integrate horizontally within one tile. In order to reduce the
!  round-off errors, the summation is performed in two stages. First,
!  the index j is collapsed and then the accumulation is carried out
!  along index i. In this order, the partial sums consist on much
!  fewer number of terms than in a straightforward two-dimensional
!  summation. Thus, adding numbers which are orders of magnitude
!  apart is avoided.
!
        do i=Istr,Iend
          pe2d(i,Jend+1)=0.0_r8
          pe2d(i,Jstr-1)=0.0_r8
          ke2d(i,Jstr-1)=0.0_r8
        enddo
        do j=Jstr,Jend
          do i=Istr,Iend
            cff=1.0_r8/(pm(i,j)*pn(i,j))
#ifdef SOLVE3D
            pe2d(i,Jend+1)=pe2d(i,Jend+1)+cff*(z_w(i,j,N)-z_w(i,j,0))
#else
            pe2d(i,Jend+1)=pe2d(i,Jend+1)+cff*(zeta(i,j,krhs)+h(i,j))
#endif
            pe2d(i,Jstr-1)=pe2d(i,Jstr-1)+cff*pe2d(i,j)
            ke2d(i,Jstr-1)=ke2d(i,Jstr-1)+cff*ke2d(i,j)
          enddo
        enddo
        my_volume=0.0_r8
        my_avgpe=0.0_r8
        my_avgke=0.0_r8
        do i=Istr,Iend
          my_volume=my_volume + pe2d(i,Jend+1)
          my_avgpe =my_avgpe  + pe2d(i,Jstr-1)
          my_avgke =my_avgke  + ke2d(i,Jstr-1)
        enddo
        if (WESTERN_EDGE .and. EASTERN_EDGE .and.
     &      SOUTHERN_EDGE .and. NORTHERN_EDGE) then
          NSUB=0.5_r8
        else
          NSUB=FLOAT(NSUB_X*NSUB_E)-0.5_r8
        endif
!
!  Perform global summation: whoever gets first to the critical region
!  resets global sums before global summation starts; after the global
!  summation is completed, thread, which is the last one to enter the
!  critical region, finalizes the computation of diagnostics and prints
!  them out.
!
        call my_setlock (lock)
        if (dia_count.lt.0.5_r8) then
          volume=0.0_r8
          avgke=0.0_r8
          avgpe=0.0_r8
        endif
        dia_count=dia_count+1.0_r8
        volume=volume+my_volume
        avgke=avgke+my_avgke
        avgpe=avgpe+my_avgpe
        if (dia_count.gt.NSUB) then
          dia_count=0.0_r8
          trd=my_threadnum()
          avgke=avgke/volume
          avgpe=avgpe/volume
          avgkp=avgke+avgpe
          if (first_time.eq.0) then
            first_time=1
            write(stdout,10) 'STEP','time[DAYS]','KINETIC_ENRG',
     &                       'POTEN_ENRG','TOTAL_ENRG','NET_VOLUME',
     &                       'trd'
 10         format(/,1x,a,4x,a,2x,a,3x,a,4x,a,4x,a,2x,a,/)
          endif
          write(stdout,20) iic-1,tdays,avgke,avgpe,avgkp,volume,trd
 20       format(i6,f13.6,4(1pe14.6),i3)
!
!  If blowing-up, set exit_flag to stop computations.
!
          write(kechar,'(1pe8.1)') avgke
          write(pechar,'(1pe8.1)') avgpe
          do i=1,8
            if ((kechar(i:i).eq.'N').or.(pechar(i:i).eq.'N').or.
     &          (kechar(i:i).eq.'n').or.(pechar(i:i).eq.'n').or.
     &          (kechar(i:i).eq.'*').or.(pechar(i:i).eq.'*')) then
              exit_flag=1
            endif
          enddo
        endif
        call my_unsetlock (lock)
      endif
      return
      end

