#include "cppdefs.h"
      function def_var (ncid,Vid,Vtype,nVdims,Vdims,Aval,Vinfo,ncname)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine defines the requested NetCDF variable.               !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     ncid     NetCDF file ID (integer).                             !
!     Vtype    NetCDF variable type (integer).                       !
!     nVdims   Number of variable dimensions (integer; 0=scalar).    !
!     Vdims    Dimensions IDs for this variable (integer vector).    !
!     Aval     Attribute values (real vector):                       !
!                Aval(1)   =>  Add offset value.                     !
!                Aval(2)   =>  Valid minimum value.                  !
!                Aval(3)   =>  Valid maximum value.                  !
!     Vinfo    Variable information (character array):               !
!                Vinfo( 1) =>  Variable name.                        !
!                Vinfo( 2) =>  Variable "longname" attribute.        !
!                Vinfo( 3) =>  Variable "units" attribute.           !
!                Vinfo( 4) =>  Variable "calendar" attrivute.        !
!                Vinfo( 5) =>  Variable "valid_min" attribute.       !
!                Vinfo( 6) =>  Variable "valid_max" attribute.       !
!                Vinfo( 7) =>  Variable "option_T" attribute.        !
!                Vinfo( 8) =>  Variable "option_F" attribute.        !
!                Vinfo( 9) =>  Variable "option_0" attribute.        !
!                Vinfo(10) =>  Variable "option_1" attribute.        !
!                Vinfo(11) =>  Variable "negative" attribute.        !
!                Vinfo(12) =>  Variable "positive" attribute.        !
!                Vinfo(13) =>  Variable "cycle" attribute.           !
!                Vinfo(14) =>  Variable "field" attribute.           !
!                Vinfo(15) =>  Variable "positions" attribute.       !
!                Vinfo(16) =>  Variable "time" attribute.            !
!                Vinfo(17) =>  Variable "missing_value" attribute.   !
!                Vinfo(18) =>  Variable "add_offset" attribute.      !
!                Vinfo(19) =>  Variable "size_class" attribute.      !
!                Vinfo(20) =>  Variable "water_points" attribute.    !
!     ncname   NetCDF file name.                                     !
!                                                                    !
!  On Output:                                                        !
!                                                                    !
!     def_var  Error flag (integer).                                 !
!     Vid      NetCDF variable ID (integer).                         !
!                                                                    !
!  Notice that arrays "Aval" and "Vinfo" is destroyed on output to   !
!  facilitate the definition of the next variable.                   !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "netcdf.inc"
#include "scalars.h"
!
      INTEGER_TYPE
     &        Vid, Vtype, latt, lstr, lvar, ncid, nVdims
      INTEGER_TYPE
     &        Vdims(*)
      INTEGER_TYPE
     &        def_var, lenstr
      REAL_TYPE
     &        Aval(*)
      character*(*) ncname, Vinfo(20)
      character*40  name
!
!---------------------------------------------------------------------
!  Define requested variable and its attributes.
!---------------------------------------------------------------------
!
!  Define variable.
!
      name=Vinfo(1)
      lvar=lenstr(name)
      lstr=lenstr(ncname)
      if (lvar.gt.0) then
        def_var=nf_def_var(ncid,name(1:lvar),Vtype,nVdims,Vdims,
     &                     Vid)
        if (def_var.ne.nf_noerr) then
          write(stdout,10) name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(1)=' '
      endif
!
!  Define "longname" attribute.
!
      latt=lenstr(Vinfo(2))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'long_name',
     &                          latt,Vinfo(2)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'long_name', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(2)=' '
      endif
!
!  Define "size_class" attribute.
!
      latt=lenstr(Vinfo(19))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'size_class',
     &                          latt,Vinfo(19)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'size_class', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(19)=' '
      endif
!
!  If applicable, define "units" attribute.
!
      latt=lenstr(Vinfo(3))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'units',
     &                          latt,Vinfo(3)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'units', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(3)=' '
      endif
!
!  If applicable, define "calendar" attribute.
!
      latt=lenstr(Vinfo(4))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'calendar',
     &                          latt,Vinfo(4)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'calendar', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(4)=' '
      endif
!
!  If applicable, define "valid_min" attribute.
!
      latt=lenstr(Vinfo(5))
      if (latt.gt.0) then
        if (Vtype.eq.nf_int) then
          def_var=nf_put_att_int(ncid,Vid,Vinfo(5)(1:latt),
     &                           Vtype,1,INT(Aval(2)))
        else
          def_var=nf_put_att_FTYPE(ncid,Vid,Vinfo(5)(1:latt),
     &                             Vtype,1,Aval(2))
        endif
        if (def_var.ne.nf_noerr) then
          write(stdout,20) Vinfo(5)(1:latt), name(1:lvar),
     &                     ncname(1:lstr)
          exit_flag=3
          return
        endif
        Aval(2)=0.0_r8
        Vinfo(5)=' '
      endif
!
!  If applicable, define "valid_max" attribute.
!
      latt=lenstr(Vinfo(6))
      if (latt.gt.0) then
        if (Vtype.eq.nf_int) then
          def_var=nf_put_att_int(ncid,Vid,Vinfo(6)(1:latt),
     &                           Vtype,1,INT(Aval(3)))
        else
          def_var=nf_put_att_FTYPE(ncid,Vid,Vinfo(6)(1:latt),
     &                             Vtype,1,Aval(3))
        endif
        if (def_var.ne.nf_noerr) then
          write(stdout,20) Vinfo(6)(1:latt), name(1:lvar),
     &                     ncname(1:lstr)
          exit_flag=3
          return
        endif
        Aval(3)=0.0_r8
        Vinfo(6)=' '
      endif
!
!  If applicable, define "option_T" attribute.
!
      latt=lenstr(Vinfo(7))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'option_T',
     &                          latt,Vinfo(7)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'option_T', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(7)=' '
      endif
!
!  If applicable, define "option_F" attribute.
!
      latt=lenstr(Vinfo(8))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'option_F',
     &                          latt,Vinfo(8)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'option_F', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(8)=' '
      endif
!
!  If applicable, define "option_0" attribute.
!
      latt=lenstr(Vinfo(9))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'option_0',
     &                          latt,Vinfo(9)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'option_0', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(9)=' '
      endif
!
!  If applicable, define "option_1" attribute.
!
      latt=lenstr(Vinfo(10))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'option_1',
     &                          latt,Vinfo(10)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'option_1', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(10)=' '
      endif
!
!  If applicable, define "negative" attribute.
!
      latt=lenstr(Vinfo(11))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'negative',
     &                          latt,Vinfo(11)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'negative', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(11)=' '
      endif
!
!  If applicable, define "option_F" attribute.
!
      latt=lenstr(Vinfo(12))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'positive',
     &                          latt,Vinfo(12)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'positive', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(12)=' '
      endif
!
!  If applicable, define "cycle" attribute.
!
      latt=lenstr(Vinfo(13))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'cycle',
     &                          latt,Vinfo(13)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'cycle', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(13)=' '
      endif
!
!  If applicable, define "positions" attribute.
!
      latt=lenstr(Vinfo(15))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'positions',
     &                          latt,Vinfo(15)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'positions', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(15)=' '
      endif
!
!  If applicable, define "time" attribute.
!
      latt=lenstr(Vinfo(16))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'time',
     &                          latt,Vinfo(16)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'time', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(16)=' '
      endif
!
!  If applicable, define "missing_value" attribute.
!
      latt=lenstr(Vinfo(17))
      if (latt.gt.0) then
        if (Vtype.eq.nf_int) then
          def_var=nf_put_att_int(ncid,Vid,Vinfo(17)(1:latt),
     &                           Vtype,1,INT(Aval(4)))
        else
          def_var=nf_put_att_FTYPE(ncid,Vid,Vinfo(17)(1:latt),
     &                             Vtype,1,Aval(4))
        endif
        if (def_var.ne.nf_noerr) then
          write(stdout,20) Vinfo(17)(1:latt), name(1:lvar),
     &                     ncname(1:lstr)
          exit_flag=3
          return
        endif
        Aval(4)=0.0_r8
        Vinfo(17)=' '
      endif
!
!  If applicable, define "add_offset" attribute.
!
      latt=lenstr(Vinfo(18))
      if (latt.gt.0) then
        if (Vtype.eq.nf_int) then
          def_var=nf_put_att_int(ncid,Vid,Vinfo(18)(1:latt),
     &                           Vtype,1,INT(Aval(1)))
        else
          def_var=nf_put_att_FTYPE(ncid,Vid,Vinfo(18)(1:latt),
     &                             Vtype,1,Aval(1))
        endif
        if (def_var.ne.nf_noerr) then
          write(stdout,20) Vinfo(18)(1:latt), name(1:lvar),
     &                     ncname(1:lstr)
          exit_flag=3
          return
        endif
        Aval(1)=0.0_r8
        Vinfo(18)=' '
      endif
!
!  If applicable, define "water_points" attribute.
!
      latt=lenstr(Vinfo(20))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'water_points',
     &                          latt,Vinfo(20)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'water_points', name(1:lvar),
     &                     ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(20)=' '
      endif
!
!  If applicable, define "field" attribute (always last).
!
      latt=lenstr(Vinfo(14))
      if (latt.gt.0) then
        def_var=nf_put_att_text(ncid,Vid,'field',
     &                          latt,Vinfo(14)(1:latt))
        if (def_var.ne.nf_noerr) then
          write(stdout,20) 'field', name(1:lvar), ncname(1:lstr)
          exit_flag=3
          return
        endif
        Vinfo(14)=' '
      endif
!
 10   format(/,'DEF_VAR - unable to define variable: ',a,/,
     &       11x,'in NetCDF file: ',a)
 20   format(/,'DEF_VAR - error while defining attribute: ',a,
     &       ' for variable: ',a,/,11x,'in NetCDF file: ',a)
      return
      end
