#include "cppdefs.h"
      subroutine def_station
#ifdef STATIONS
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine creates station data NetCDF file, it defines its     !
!  dimensions, attributes, and variables.                            !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "iounits.h"
# include "ncparam.h"
# include "netcdf.inc"
# include "scalars.h"
!
      logical got_var(NV)
      INTEGER_TYPE
     &        Natt
      parameter (Natt=20)
      INTEGER_TYPE
     &        i, ifield, lstr, lsvar, lvar, nrec, recdim, stadim,
     &        status
      INTEGER_TYPE
     &        DimIDs(24), pgrd(2)
      INTEGER_TYPE
     &        def_info, def_var, lenstr, wrt_info
# ifdef SOLVE3D
      logical got_trc(NT)
      INTEGER_TYPE
     &        itrc
      INTEGER_TYPE
     &        bgrd(3), rgrd(3), wgrd(3)
# endif /* SOLVE3D */
      REAL_TYPE
     &        Aval(4)
      character*65 Vinfo(Natt)
!
!=====================================================================
!  Create a new station data file.
!=====================================================================
!
!  Deactivate file creation, if a restart run.
!
      if (nrrec.ne.0) LdefSTA=.false.
!
!  Create stations NetCDF file.
!
      if (exit_flag.ne.0) return
      if (LdefSTA) then
        lstr=lenstr(staname)
        status=nf_create(staname(1:lstr),nf_clobber,ncstaid)
        if (status.ne.nf_noerr) then
          write(stdout,10) staname(1:lstr)
          exit_flag=3
          return
        endif
!
!---------------------------------------------------------------------
!  Define the dimensions of staggered fields.
!---------------------------------------------------------------------
!
# ifdef SOLVE3D
        status=nf_def_dim(ncstaid,'s_rho'  ,N   ,DimIDs( 9))
        status=nf_def_dim(ncstaid,'s_w'    ,N   ,DimIDs(10))
        status=nf_def_dim(ncstaid,'tracer' ,NT  ,DimIDs(11))
#  ifdef SEDIMENT
        status=nf_def_dim(ncstaid,'Nbed'   ,Nbed,DimIDs(16))
#  endif /* SEDIMENT */
# endif /* SOLVE3D */
        status=nf_def_dim(ncstaid,'station',nstation,DimIDs(13))
        status=nf_def_dim(ncstaid,'boundary',4,DimIDs(14))
        status=nf_def_dim(ncstaid,'time',
     &                    nf_unlimited,DimIDs(12))
        recdim=DimIDs(12)
        stadim=DimIDs(13)
!
!  Define dimension vector for point variables.
!
        pgrd(1)=DimIDs(13)
        pgrd(2)=DimIDs(12)
# ifdef SOLVE3D
!
!  Define dimension vector for cast variables at vertical RHO-points.
!
        rgrd(1)=DimIDs( 9)
        rgrd(2)=DimIDs(13)
        rgrd(3)=DimIDs(12)
!
!  Define dimension vector for cast variables at vertical W-points.
!
        wgrd(1)=DimIDs(10)
        wgrd(2)=DimIDs(13)
        wgrd(3)=DimIDs(12)
!
!  Define dimension vector for sediment bed layer type variables.
!
        bgrd(1)=DimIDs(16)
        bgrd(2)=DimIDs(13)
        bgrd(3)=DimIDs(12)
# endif /* SOLVE3D */
!
!  Initialize unlimited time record dimension.
!
        tstaindx=0
!
!  Initialize local information variable arrays.
!
        do i=1,Natt
          Vinfo(i)=' '
        enddo
        do i=1,4
          Aval(i)=0.0_r8
        enddo
!
!---------------------------------------------------------------------
!  Define time-recordless information variables.
!---------------------------------------------------------------------
!
        status=def_info(ncstaid,staname,DimIDs)
        if (exit_flag.ne.0) return
!
!---------------------------------------------------------------------
!  Define variables and their attributes.
!---------------------------------------------------------------------
!
!  Define model time.
!
        Vinfo( 1)=Vname(1,idtime)
        Vinfo( 2)=Vname(2,idtime)
        if (INT(time_ref).eq.-2) then
          Vinfo( 3)='seconds since 1968-05-23 00:00:00 GMT'
          Vinfo( 4)='modified Julian day number'
          Vinfo(18)='add_offset'
          Aval(1)=jul_off
        elseif (INT(time_ref).eq.-1) then
          Vinfo( 3)='seconds since 0000-01-01 00:00:00'
          Vinfo( 4)='360 days in every year, 30 days in each month'
        elseif (INT(time_ref).eq.0) then
          Vinfo( 3)='seconds since 0000-01-01 00:00:00'
          Vinfo( 4)='365.25 days in every year'
        elseif (time_ref.gt.0.0_r8) then
          Vinfo( 3)='seconds since '/ /r_text
        endif
        Vinfo(14)=Vname(4,idtime)
        status=def_var(ncstaid,staVid(idtime),NF_FTYPE,1,recdim,Aval,
     &                 Vinfo,staname)
!
!  Define free-surface.
!
        if (Sout(idFsur)) then
          Vinfo( 1)=Vname(1,idFsur)
          Vinfo( 2)=Vname(2,idFsur)
          Vinfo( 3)=Vname(3,idFsur)
          Vinfo(14)=Vname(4,idFsur)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idFsur),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define 2D momentum in the XI-direction.
!
        if (Sout(idUbar)) then
          Vinfo( 1)=Vname(1,idUbar)
          Vinfo( 2)=Vname(2,idUbar)
          Vinfo( 3)=Vname(3,idUbar)
          Vinfo(14)=Vname(4,idUbar)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idUbar),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define 2D momentum in the ETA-direction.
!
        if (Sout(idVbar)) then
          Vinfo( 1)=Vname(1,idVbar)
          Vinfo( 2)=Vname(2,idVbar)
          Vinfo( 3)=Vname(3,idVbar)
          Vinfo(14)=Vname(4,idVbar)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idVbar),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
# ifdef SOLVE3D
!
!  Define 3D momentum component in the XI-direction.
!
        if (Sout(idUvel)) then
          Vinfo( 1)=Vname(1,idUvel)
          Vinfo( 2)=Vname(2,idUvel)
          Vinfo( 3)=Vname(3,idUvel)
          Vinfo(14)=Vname(4,idUvel)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idUvel),NF_FOUT,3,rgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define 3D momentum component in the ETA-direction.
!
        if (Sout(idVvel)) then
          Vinfo( 1)=Vname(1,idVvel)
          Vinfo( 2)=Vname(2,idVvel)
          Vinfo( 3)=Vname(3,idVvel)
          Vinfo(14)=Vname(4,idVvel)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idVvel),NF_FOUT,3,rgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define 3D momentum component in the S-direction.
!
        if (Sout(idWvel)) then
          Vinfo( 1)=Vname(1,idWvel)
          Vinfo( 2)=Vname(2,idWvel)
          Vinfo( 3)=Vname(3,idWvel)
          Vinfo(14)=Vname(4,idWvel)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idWvel),NF_FOUT,3,rgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define tracer type variables.
!
        do itrc=1,NT
          if (Sout(idTvar(itrc))) then
            Vinfo( 1)=Vname(1,idTvar(itrc))
            Vinfo( 2)=Vname(2,idTvar(itrc))
            Vinfo( 3)=Vname(3,idTvar(itrc))
            Vinfo(14)=Vname(4,idTvar(itrc))
            Vinfo(16)=Vname(1,idtime)
# ifdef SEDIMENT
            do i=1,NST
              if (itrc.eq.idsed(i)) then
                write(Vinfo(19),20) 1000.0_r8*Sd50(i)
              endif
            enddo
# endif
            status=def_var(ncstaid,staTid(itrc),NF_FOUT,3,rgrd,Aval,
     &                     Vinfo,staname)
          endif
        enddo
!
!  Define density anomaly.
!
        if (Sout(idDano)) then
          Vinfo( 1)=Vname(1,idDano)
          Vinfo( 2)=Vname(2,idDano)
          Vinfo( 3)=Vname(3,idDano)
          Vinfo(14)=Vname(4,idDano)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idDano),NF_FOUT,3,rgrd,Aval,
     &                   Vinfo,staname)
        endif
#  ifdef LMD_SKPP
!
!  Define depth of surface boundary layer.
!
        if (Sout(idHsbl)) then
          Vinfo( 1)=Vname(1,idHsbl)
          Vinfo( 2)=Vname(2,idHsbl)
          Vinfo( 3)=Vname(3,idHsbl)
          Vinfo(14)=Vname(4,idHsbl)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idHsbl),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
#  endif /* LMD_SKPP */
#  ifdef LMD_BKPP
!
!  Define depth of bottom boundary layer.
!
        if (Sout(idHbbl)) then
          Vinfo( 1)=Vname(1,idHbbl)
          Vinfo( 2)=Vname(2,idHbbl)
          Vinfo( 3)=Vname(3,idHbbl)
          Vinfo(14)=Vname(4,idHbbl)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idHbbl),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
#  endif /* LMD_BKPP */
!
!  Define vertical viscosity coefficient.
!
        if (Sout(idVvis)) then
          Vinfo( 1)=Vname(1,idVvis)
          Vinfo( 2)=Vname(2,idVvis)
          Vinfo( 3)=Vname(3,idVvis)
          Vinfo(14)=Vname(4,idVvis)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idVvis),NF_FOUT,3,wgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define vertical diffusion coefficient for potential temperature.
!
        if (Sout(idTdif)) then
          Vinfo( 1)=Vname(1,idTdif)
          Vinfo( 2)=Vname(2,idTdif)
          Vinfo( 3)=Vname(3,idTdif)
          Vinfo(14)=Vname(4,idTdif)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idTdif),NF_FOUT,3,wgrd,Aval,
     &                   Vinfo,staname)
        endif
#  ifdef SALINITY
!
!  Define vertical diffusion coefficient for salinity.
!
        if (Sout(idSdif)) then
          Vinfo( 1)=Vname(1,idSdif)
          Vinfo( 2)=Vname(2,idSdif)
          Vinfo( 3)=Vname(3,idSdif)
          Vinfo(14)=Vname(4,idSdif)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idSdif),NF_FOUT,3,wgrd,Aval,
     &                   Vinfo,staname)
        endif
#  endif /* SALINITY */
#  if defined GLS_MIXING || defined MY25_MIXING
!
!  Define turbulent kinetic energy.
!
        if (Sout(idMtke)) then
          Vinfo( 1)=Vname(1,idMtke)
          Vinfo( 2)=Vname(2,idMtke)
          Vinfo( 3)=Vname(3,idMtke)
          Vinfo(14)=Vname(4,idMtke)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idMtke),NF_FOUT,3,wgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define turbulent kinetic energy time length scale.
!
        if (Sout(idMtls)) then
          Vinfo( 1)=Vname(1,idMtls)
          Vinfo( 2)=Vname(2,idMtls)
          Vinfo( 3)=Vname(3,idMtls)
          Vinfo(14)=Vname(4,idMtls)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idMtls),NF_FOUT,3,wgrd,Aval,
     &                   Vinfo,staname)
        endif
#  endif /* GLS_MIXING || MY25_MIXING */
!
!  Define surface net heat flux.
!
        if (Sout(idTsur(itemp))) then
          Vinfo( 1)=Vname(1,idTsur(itemp))
          Vinfo( 2)=Vname(2,idTsur(itemp))
          Vinfo( 3)=Vname(3,idTsur(itemp))
          Vinfo(11)='upward flux, cooling'
          Vinfo(12)='downward flux, heating'
          Vinfo(14)=Vname(4,idTsur(itemp))
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idTsur(itemp)),NF_FOUT,2,
     &                   pgrd,Aval,Vinfo,staname)
        endif
#  ifdef BULK_FLUXES
!
!  Define latent heat flux.
!
        if (Sout(idLhea)) then
          Vinfo( 1)=Vname(1,idLhea)
          Vinfo( 2)=Vname(2,idLhea)
          Vinfo( 3)=Vname(3,idLhea)
          Vinfo(11)='upward flux, cooling'
          Vinfo(12)='downward flux, heating'
          Vinfo(14)=Vname(4,idLhea)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idLhea),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define sensible heat flux.
!
        if (Sout(idShea)) then
          Vinfo( 1)=Vname(1,idShea)
          Vinfo( 2)=Vname(2,idShea)
          Vinfo( 3)=Vname(3,idShea)
          Vinfo(11)='upward flux, cooling'
          Vinfo(12)='downward flux, heating'
          Vinfo(14)=Vname(4,idShea)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idShea),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define longwave radiation flux.
!
        if (Sout(idLrad)) then
          Vinfo( 1)=Vname(1,idLrad)
          Vinfo( 2)=Vname(2,idLrad)
          Vinfo( 3)=Vname(3,idLrad)
          Vinfo(11)='upward flux, cooling'
          Vinfo(12)='downward flux, heating'
          Vinfo(14)=Vname(4,idLrad)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idLrad),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
#  endif /* BULK_FLUXES */
#  ifdef SHORTWAVE
!
!  Define shortwave radiation flux.
!
        if (Sout(idSrad)) then
          Vinfo( 1)=Vname(1,idSrad)
          Vinfo( 2)=Vname(2,idSrad)
          Vinfo( 3)=Vname(3,idSrad)
          Vinfo(11)='upward flux, cooling'
          Vinfo(12)='downward flux, heating'
          Vinfo(14)=Vname(4,idSrad)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idSrad),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
#  endif /* SHORTWAVE */
# endif /* SOLVE3D */
!
!  Define surface U-momentum stress.
!
        if (Sout(idUsms)) then
          Vinfo( 1)=Vname(1,idUsms)
          Vinfo( 2)=Vname(2,idUsms)
          Vinfo( 3)=Vname(3,idUsms)
          Vinfo(14)=Vname(4,idUsms)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idUsms),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define surface V-momentum stress.
!
        if (Sout(idVsms)) then
          Vinfo( 1)=Vname(1,idVsms)
          Vinfo( 2)=Vname(2,idVsms)
          Vinfo( 3)=Vname(3,idVsms)
          Vinfo(14)=Vname(4,idVsms)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idVsms),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define bottom U-momentum stress.
!
        if (Sout(idUbms)) then
          Vinfo( 1)=Vname(1,idUbms)
          Vinfo( 2)=Vname(2,idUbms)
          Vinfo( 3)=Vname(3,idUbms)
          Vinfo(14)=Vname(4,idUbms)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idUbms),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define bottom V-momentum stress.
!
        if (Sout(idVbms)) then
          Vinfo( 1)=Vname(1,idVbms)
          Vinfo( 2)=Vname(2,idVbms)
          Vinfo( 3)=Vname(3,idVbms)
          Vinfo(14)=Vname(4,idVbms)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idVbms),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
# ifdef BBL
!
!  Define wind-induced, bottom U-wave stress.
!
        if (Sout(idUbws)) then
          Vinfo( 1)=Vname(1,idUbws)
          Vinfo( 2)=Vname(2,idUbws)
          Vinfo( 3)=Vname(3,idUbws)
          Vinfo(14)=Vname(4,idUbws)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idUbws),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define bottom wind-induced, bottom V-wave stress.
!
        if (Sout(idVbws)) then
          Vinfo( 1)=Vname(1,idVbws)
          Vinfo( 2)=Vname(2,idVbws)
          Vinfo( 3)=Vname(3,idVbws)
          Vinfo(14)=Vname(4,idVbws)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idVbws),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define wind-induced, bed wave excursion amplitude.
!
        if (Sout(idAbed)) then
          Vinfo( 1)=Vname(1,idAbed)
          Vinfo( 2)=Vname(2,idAbed)
          Vinfo( 3)=Vname(3,idAbed)
          Vinfo(14)=Vname(4,idAbed)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idAbed),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define wind-induced, bed wave orbital U-velocity.
!
        if (Sout(idUbed)) then
          Vinfo( 1)=Vname(1,idUbed)
          Vinfo( 2)=Vname(2,idUbed)
          Vinfo( 3)=Vname(3,idUbed)
          Vinfo(14)=Vname(4,idUbed)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idUbed),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define wind-induced, bed wave orbital V-velocity.
!
        if (Sout(idVbed)) then
          Vinfo( 1)=Vname(1,idVbed)
          Vinfo( 2)=Vname(2,idVbed)
          Vinfo( 3)=Vname(3,idVbed)
          Vinfo(14)=Vname(4,idVbed)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idVbed),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define bottom U-momentum above bed.
!
        if (Sout(idUbot)) then
          Vinfo( 1)=Vname(1,idUbot)
          Vinfo( 2)=Vname(2,idUbot)
          Vinfo( 3)=Vname(3,idUbot)
          Vinfo(14)=Vname(4,idUbot)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idUbot),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define bottom V-momentum above bed.
!
        if (Sout(idVbot)) then
          Vinfo( 1)=Vname(1,idVbot)
          Vinfo( 2)=Vname(2,idVbot)
          Vinfo( 3)=Vname(3,idVbot)
          Vinfo(14)=Vname(4,idVbot)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idVbot),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define bed ripple height.
!
        if (Sout(idHrip)) then
          Vinfo( 1)=Vname(1,idHrip)
          Vinfo( 2)=Vname(2,idHrip)
          Vinfo( 3)=Vname(3,idHrip)
          Vinfo(14)=Vname(4,idHrip)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idHrip),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define bed ripple length.
!
        if (Sout(idLrip)) then
          Vinfo( 1)=Vname(1,idLrip)
          Vinfo( 2)=Vname(2,idLrip)
          Vinfo( 3)=Vname(3,idLrip)
          Vinfo(14)=Vname(4,idLrip)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idLrip),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define hydraulic bottom roughness.
!
        if (Sout(idZnot)) then
          Vinfo( 1)=Vname(1,idZnot)
          Vinfo( 2)=Vname(2,idZnot)
          Vinfo( 3)=Vname(3,idZnot)
          Vinfo(14)=Vname(4,idZnot)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idZnot),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
!
!  Define apparent hydraulic bottom roughness.
!
        if (Sout(idZapp)) then
          Vinfo( 1)=Vname(1,idZapp)
          Vinfo( 2)=Vname(2,idZapp)
          Vinfo( 3)=Vname(3,idZapp)
          Vinfo(14)=Vname(4,idZapp)
          Vinfo(16)=Vname(1,idtime)
          status=def_var(ncstaid,staVid(idZapp),NF_FOUT,2,pgrd,Aval,
     &                   Vinfo,staname)
        endif
# endif /* BBL */
!
!  Initialize unlimited time record dimension.
!
        tstaindx=0
!
!---------------------------------------------------------------------
!  Leave definition mode.
!---------------------------------------------------------------------
!
        status=nf_enddef(ncstaid)
!
!---------------------------------------------------------------------
!  Write out time-recordless, information variables.
!---------------------------------------------------------------------
!
        status=wrt_info(ncstaid,staname)
        if (exit_flag.ne.0) return
      else
!
!=====================================================================
!  Open an existing stations file, check its contents, and prepare for
!  appending data.
!=====================================================================
!
!  Inquire about the contents of stations NetCDF file:  Inquire about
!  the dimensions and variables.  Check for consistency.
!
        ifield=0
        call opencdf (staname,N,ifield,nrec)
        if (exit_flag.ne.0) return
!
!  Open stations file for read/write.
!
        lstr=lenstr(staname)
        status=nf_open(staname(1:lstr),nf_write,ncstaid)
        if (status.ne.nf_noerr) then
          write(stdout,30) staname(1:lstr)
          exit_flag=3
          return
        endif
!
!  Initialize logical switches.
!
        do i=1,NV
          got_var(i)=.false.
        enddo
# ifdef SOLVE3D
        do itrc=1,NT
          got_trc(itrc)=.false.
        enddo
# endif /* SOLVE3D */
!
!  Scan variable list from input NetCDF and activate switches for
!  stations variables. Get variable IDs.
!
        do i=1,nvars
          lvar=lenstr(varnam(i))
          lsvar=lenstr(Vname(1,idtime))
          if (varnam(i)(1:lvar).eq.Vname(1,idtime)(1:lsvar)) then
            got_var(idtime)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idtime)(1:lsvar),
     &                          staVid(idtime))
          endif
          lsvar=lenstr(Vname(1,idFsur))
          if (varnam(i)(1:lvar).eq.Vname(1,idFsur)(1:lsvar)) then
            got_var(idFsur)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idFsur)(1:lsvar),
     &                          staVid(idFsur))
          endif
          lsvar=lenstr(Vname(1,idUbar))
          if (varnam(i)(1:lvar).eq.Vname(1,idUbar)(1:lsvar)) then
            got_var(idUbar)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idUbar)(1:lsvar),
     &                          staVid(idUbar))
          endif
          lsvar=lenstr(Vname(1,idVbar))
          if (varnam(i)(1:lvar).eq.Vname(1,idVbar)(1:lsvar)) then
            got_var(idVbar)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idVbar)(1:lsvar),
     &                          staVid(idVbar))
          endif
# ifdef SOLVE3D
          lsvar=lenstr(Vname(1,idUvel))
          if (varnam(i)(1:lvar).eq.Vname(1,idUvel)(1:lsvar)) then
            got_var(idUvel)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idUvel)(1:lsvar),
     &                          staVid(idUvel))
          endif
          lsvar=lenstr(Vname(1,idVvel))
          if (varnam(i)(1:lvar).eq.Vname(1,idVvel)(1:lsvar)) then
            got_var(idVvel)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idVvel)(1:lsvar),
     &                          staVid(idVvel))
          endif
          lsvar=lenstr(Vname(1,idWvel))
          if (varnam(i)(1:lvar).eq.Vname(1,idWvel)(1:lsvar)) then
            got_var(idWvel)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idWvel)(1:lsvar),
     &                          staVid(idWvel))
          endif
          do itrc=1,NT
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            if (varnam(i)(1:lvar).eq.
     &          Vname(1,idTvar(itrc))(1:lsvar)) then
             got_trc(itrc)=.true.
             status=nf_inq_varid(ncstaid,
     &                           Vname(1,idTvar(itrc))(1:lsvar),
     &                           staTid(itrc))
            endif
          enddo
          lsvar=lenstr(Vname(1,idDano))
          if (varnam(i)(1:lvar).eq.Vname(1,idDano)(1:lsvar)) then
            got_var(idDano)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idDano)(1:lsvar),
     &                          staVid(idDano))
          endif
#  ifdef LMD_SKPP
          lsvar=lenstr(Vname(1,idHsbl))
          if (varnam(i)(1:lvar).eq.Vname(1,idHsbl)(1:lsvar)) then
            got_var(idHsbl)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idHsbl)(1:lsvar),
     &                          staVid(idHsbl))
          endif
#  endif /* LMD_SKPP */
#  ifdef LMD_BKPP
          lsvar=lenstr(Vname(1,idHbbl))
          if (varnam(i)(1:lvar).eq.Vname(1,idHbbl)(1:lsvar)) then
            got_var(idHbbl)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idHbbl)(1:lsvar),
     &                          staVid(idHbbl))
          endif
#  endif /* LMD_BKPP */
          lsvar=lenstr(Vname(1,idVvis))
          if (varnam(i)(1:lvar).eq.Vname(1,idVvis)(1:lsvar)) then
            got_var(idVvis)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idVvis)(1:lsvar),
     &                          staVid(idVvis))
          endif
          lsvar=lenstr(Vname(1,idTdif))
          if (varnam(i)(1:lvar).eq.Vname(1,idTdif)(1:lsvar)) then
            got_var(idTdif)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idTdif)(1:lsvar),
     &                          staVid(idTdif))
          endif
          lsvar=lenstr(Vname(1,idSdif))
          if (varnam(i)(1:lvar).eq.Vname(1,idSdif)(1:lsvar)) then
            got_var(idSdif)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idSdif)(1:lsvar),
     &                          staVid(idSdif))
          endif
#  if defined GLS_MIXING || defined MY25_MIXING
          lsvar=lenstr(Vname(1,idMtke))
          if (varnam(i)(1:lvar).eq.Vname(1,idMtke)(1:lsvar)) then
            got_var(idMtke)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idMtke)(1:lsvar),
     &                          staVid(idMtke))
          endif
          lsvar=lenstr(Vname(1,idMtls))
          if (varnam(i)(1:lvar).eq.Vname(1,idMtls)(1:lsvar)) then
            got_var(idMtls)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idMtls)(1:lsvar),
     &                          staVid(idMtls))
          endif
#  endif /* GLS_MIXING || MY25_MIXING */
          lsvar=lenstr(Vname(1,idTsur(itemp)))
          if (varnam(i)(1:lvar).eq.
     &        Vname(1,idTsur(itemp))(1:lsvar)) then
            got_var(idTsur(itemp))=.true.
            status=nf_inq_varid(ncstaid,
     &                          Vname(1,idTsur(itemp))(1:lsvar),
     &                          staVid(idTsur(itemp)))
          endif
#  ifdef BULK_FLUXES
          lsvar=lenstr(Vname(1,idLhea))
          if (varnam(i)(1:lvar).eq.Vname(1,idLhea)(1:lsvar)) then
            got_var(idLhea)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idLhea)(1:lsvar),
     &                          staVid(idLhea))
          endif
          lsvar=lenstr(Vname(1,idShea))
          if (varnam(i)(1:lvar).eq.Vname(1,idShea)(1:lsvar)) then
            got_var(idShea)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idShea)(1:lsvar),
     &                          staVid(idShea))
          endif
          lsvar=lenstr(Vname(1,idLrad))
          if (varnam(i)(1:lvar).eq.Vname(1,idLrad)(1:lsvar)) then
            got_var(idLrad)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idLrad)(1:lsvar),
     &                          staVid(idLrad))
          endif
#  endif /* BULK_FLUXES */
#  ifdef SHORTWAVE
          lsvar=lenstr(Vname(1,idSrad))
          if (varnam(i)(1:lvar).eq.Vname(1,idSrad)(1:lsvar)) then
            got_var(idSrad)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idSrad)(1:lsvar),
     &                          staVid(idSrad))
          endif
#  endif /* SHORTWAVE */
# endif /* SOLVE3D */
          lsvar=lenstr(Vname(1,idUsms))
          if (varnam(i)(1:lvar).eq.Vname(1,idUsms)(1:lsvar)) then
            got_var(idUsms)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idUsms)(1:lsvar),
     &                          staVid(idUsms))
          endif
          lsvar=lenstr(Vname(1,idVsms))
          if (varnam(i)(1:lvar).eq.Vname(1,idVsms)(1:lsvar)) then
            got_var(idVsms)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idVsms)(1:lsvar),
     &                          staVid(idVsms))
          endif
          lsvar=lenstr(Vname(1,idUbms))
          if (varnam(i)(1:lvar).eq.Vname(1,idUbms)(1:lsvar)) then
            got_var(idUbms)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idUbms)(1:lsvar),
     &                          staVid(idUbms))
          endif
          lsvar=lenstr(Vname(1,idVbms))
          if (varnam(i)(1:lvar).eq.Vname(1,idVbms)(1:lsvar)) then
            got_var(idVbms)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idVbms)(1:lsvar),
     &                          staVid(idVbms))
          endif
# ifdef BBL
          lsvar=lenstr(Vname(1,idUbws))
          if (varnam(i)(1:lvar).eq.Vname(1,idUbws)(1:lsvar)) then
            got_var(idUbws)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idUbws)(1:lsvar),
     &                          staVid(idUbws))
          endif
          lsvar=lenstr(Vname(1,idVbws))
          if (varnam(i)(1:lvar).eq.Vname(1,idVbws)(1:lsvar)) then
            got_var(idVbws)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idVbws)(1:lsvar),
     &                          staVid(idVbws))
          endif
          lsvar=lenstr(Vname(1,idAbed))
          if (varnam(i)(1:lvar).eq.Vname(1,idAbed)(1:lsvar)) then
            got_var(idAbed)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idAbed)(1:lsvar),
     &                          staVid(idAbed))
          endif
          lsvar=lenstr(Vname(1,idUbed))
          if (varnam(i)(1:lvar).eq.Vname(1,idUbed)(1:lsvar)) then
            got_var(idUbed)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idUbed)(1:lsvar),
     &                          staVid(idUbed))
          endif
          lsvar=lenstr(Vname(1,idVbed))
          if (varnam(i)(1:lvar).eq.Vname(1,idVbed)(1:lsvar)) then
            got_var(idVbed)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idVbed)(1:lsvar),
     &                          staVid(idVbed))
          endif
          lsvar=lenstr(Vname(1,idUbot))
          if (varnam(i)(1:lvar).eq.Vname(1,idUbot)(1:lsvar)) then
            got_var(idUbot)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idUbot)(1:lsvar),
     &                          staVid(idUbot))
          endif
          lsvar=lenstr(Vname(1,idVbot))
          if (varnam(i)(1:lvar).eq.Vname(1,idVbot)(1:lsvar)) then
            got_var(idVbot)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idVbot)(1:lsvar),
     &                          staVid(idVbot))
          endif
          lsvar=lenstr(Vname(1,idHrip))
          if (varnam(i)(1:lvar).eq.Vname(1,idHrip)(1:lsvar)) then
            got_var(idHrip)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idHrip)(1:lsvar),
     &                          staVid(idHrip))
          endif
          lsvar=lenstr(Vname(1,idLrip))
          if (varnam(i)(1:lvar).eq.Vname(1,idLrip)(1:lsvar)) then
            got_var(idLrip)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idLrip)(1:lsvar),
     &                          staVid(idLrip))
          endif
          lsvar=lenstr(Vname(1,idZnot))
          if (varnam(i)(1:lvar).eq.Vname(1,idZnot)(1:lsvar)) then
            got_var(idZnot)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idZnot)(1:lsvar),
     &                          staVid(idZnot))
          endif
          lsvar=lenstr(Vname(1,idZapp))
          if (varnam(i)(1:lvar).eq.Vname(1,idZapp)(1:lsvar)) then
            got_var(idZapp)=.true.
            status=nf_inq_varid(ncstaid,Vname(1,idZapp)(1:lsvar),
     &                          staVid(idZapp))
          endif
# endif /* BBL */
        enddo
!
!  Check if station variables are available in input NetCDF file.
!
        if (.not.got_var(idtime)) then
          lsvar=lenstr(Vname(1,idtime))
          write(stdout,40) Vname(1,idtime)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idFsur).and.Sout(idFsur)) then
          lsvar=lenstr(Vname(1,idFsur))
          write(stdout,40) Vname(1,idFsur)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idUbar).and.Sout(idUbar)) then
          lsvar=lenstr(Vname(1,idUbar))
          write(stdout,40) Vname(1,idUbar)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVbar).and.Sout(idVbar)) then
          lsvar=lenstr(Vname(1,idVbar))
          write(stdout,40) Vname(1,idVbar)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
# ifdef SOLVE3D
        if (.not.got_var(idUvel).and.Sout(idUvel)) then
          lsvar=lenstr(Vname(1,idUvel))
          write(stdout,40) Vname(1,idUvel)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVvel).and.Sout(idVvel)) then
          lsvar=lenstr(Vname(1,idVvel))
          write(stdout,40) Vname(1,idVvel)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idWvel).and.Sout(idWvel)) then
          lsvar=lenstr(Vname(1,idWvel))
          write(stdout,40) Vname(1,idWvel)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        do itrc=1,NT
          if (.not.got_trc(itrc).and.Sout(idTvar(itrc))) then
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            write(stdout,40) Vname(1,idTvar(itrc))(1:lsvar),
     &                       staname(1:lstr)
            exit_flag=3
            return
          endif
        enddo
        if (.not.got_var(idDano).and.Sout(idDano)) then
          lsvar=lenstr(Vname(1,idDano))
          write(stdout,40) Vname(1,idDano)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
#  ifdef LMD_SKPP
        if (.not.got_var(idHsbl).and.Sout(idHsbl)) then
          lsvar=lenstr(Vname(1,idHsbl))
          write(stdout,40) Vname(1,idHsbl)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
#  endif /* LMD_SKPP */
#  ifdef LMD_BKPP
        if (.not.got_var(idHbbl).and.Sout(idHbbl)) then
          lsvar=lenstr(Vname(1,idHbbl))
          write(stdout,40) Vname(1,idHbbl)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
#  endif /* LMD_BKPP */
        if (.not.got_var(idVvis).and.Sout(idVvis)) then
          lsvar=lenstr(Vname(1,idVvis))
          write(stdout,40) Vname(1,idVvis)(1:lsvar),staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idTdif).and.Sout(idTdif)) then
          lsvar=lenstr(Vname(1,idTdif))
          write(stdout,40) Vname(1,idTdif)(1:lsvar),staname(1:lstr)
          exit_flag=3
          return
        endif
#  ifdef SALINITY
        if (.not.got_var(idSdif).and.Sout(idSdif)) then
          lsvar=lenstr(Vname(1,idSdif))
          write(stdout,40) Vname(1,idSdif)(1:lsvar),staname(1:lstr)
          exit_flag=3
          return
        endif
#  endif /* SALINITY */
#  if defined GLS_MIXING || defined MY25_MIXING
        if (.not.got_var(idMtke).and.Sout(idMtke)) then
          lsvar=lenstr(Vname(1,idMtke))
          write(stdout,40) Vname(1,idMtke)(1:lsvar),staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idMtls).and.Sout(idMtls)) then
          lsvar=lenstr(Vname(1,idMtls))
          write(stdout,40) Vname(1,idMtls)(1:lsvar),staname(1:lstr)
          exit_flag=3
          return
        endif
#  endif /* GLS_MIXING || MY25_MIXING */
        if (.not.got_var(idTsur(itemp)).and.Sout(idTsur(itemp))) then
          lsvar=lenstr(Vname(1,idTsur(itemp)))
          write(stdout,40) Vname(1,idTsur(itemp))(1:lsvar),
     &                     staname(1:lstr)
          exit_flag=3
          return
        endif
#  ifdef BULK_FLUXES
        if (.not.got_var(idLhea).and.Sout(idLhea)) then
          lsvar=lenstr(Vname(1,idLhea))
          write(stdout,40) Vname(1,idLhea)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idShea).and.Sout(idShea)) then
          lsvar=lenstr(Vname(1,idShea))
          write(stdout,40) Vname(1,idShea)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idLrad).and.Sout(idLrad)) then
          lsvar=lenstr(Vname(1,idLrad))
          write(stdout,40) Vname(1,idLrad)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
#  endif /* BULK_FLUXES */
#  ifdef SHORTWAVE
        if (.not.got_var(idSrad).and.Sout(idSrad)) then
          lsvar=lenstr(Vname(1,idSrad))
          write(stdout,40) Vname(1,idSrad)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
#  endif /* SHORTWAVE */
# endif /* SOLVE3D */
        if (.not.got_var(idUsms).and.Sout(idUsms)) then
          lsvar=lenstr(Vname(1,idUsms))
          write(stdout,40) Vname(1,idUsms)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVsms).and.Sout(idVsms)) then
          lsvar=lenstr(Vname(1,idVsms))
          write(stdout,40) Vname(1,idVsms)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idUbms).and.Sout(idUbms)) then
          lsvar=lenstr(Vname(1,idUbms))
          write(stdout,40) Vname(1,idUbms)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVbms).and.Sout(idVbms)) then
          lsvar=lenstr(Vname(1,idVbms))
          write(stdout,40) Vname(1,idVbms)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
# ifdef BBL
        if (.not.got_var(idUbws).and.Sout(idUbws)) then
          lsvar=lenstr(Vname(1,idUbws))
          write(stdout,40) Vname(1,idUbws)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVbws).and.Sout(idVbws)) then
          lsvar=lenstr(Vname(1,idVbws))
          write(stdout,40) Vname(1,idVbws)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idAbed).and.Sout(idAbed)) then
          lsvar=lenstr(Vname(1,idAbed))
          write(stdout,40) Vname(1,idAbed)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idUbed).and.Sout(idUbed)) then
          lsvar=lenstr(Vname(1,idUbed))
          write(stdout,40) Vname(1,idUbed)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVbed).and.Sout(idVbed)) then
          lsvar=lenstr(Vname(1,idVbed))
          write(stdout,40) Vname(1,idVbed)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idUbot).and.Sout(idUbot)) then
          lsvar=lenstr(Vname(1,idUbot))
          write(stdout,40) Vname(1,idUbot)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVbot).and.Sout(idVbot)) then
          lsvar=lenstr(Vname(1,idVbot))
          write(stdout,40) Vname(1,idVbot)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idHrip).and.Sout(idHrip)) then
          lsvar=lenstr(Vname(1,idHrip))
          write(stdout,40) Vname(1,idHrip)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idLrip).and.Sout(idLrip)) then
          lsvar=lenstr(Vname(1,idLrip))
          write(stdout,40) Vname(1,idLrip)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idZnot).and.Sout(idZnot)) then
          lsvar=lenstr(Vname(1,idZnot))
          write(stdout,40) Vname(1,idZnot)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idZapp).and.Sout(idZapp)) then
          lsvar=lenstr(Vname(1,idZapp))
          write(stdout,40) Vname(1,idZapp)(1:lsvar), staname(1:lstr)
          exit_flag=3
          return
        endif
# endif /* BBL */
!
!  Set unlimited time record dimension to the appropriate value.
!
!!      tstaindx=tsize
        tstaindx=1+(ntstart-1)/nsta
      endif
!
  10  format(/,' DEF_STATION - unable to create stations NetCDF ',
     &       'file: ',a)
  20  format(1pe11.4,1x,'millimeter')
  30  format(/,' DEF_STATION - unable to open stations NetCDF file: ',
     &       a)
  40  format(/,' DEF_STATION - unable to find variable: ',a,2x,
     &         ' in stations NetCDF file: ',a)
#endif /* STATIONS */
      return
      end
