#include "cppdefs.h"
      subroutine def_rst
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine creates restart NetCDF file, it defines its          !
!  dimensions, attributes, and variables.                            !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "ncparam.h"
#include "netcdf.inc"
#include "scalars.h"
#include "sediment.h"
!
      logical Ldefine, got_var(NV)
      INTEGER_TYPE
     &        Natt
      parameter (Natt=20)
      INTEGER_TYPE
     &        i, ifield, lini, lstr, lsvar, lvar, nrec, nvd3, nvd4,
     &        recdim, status
      INTEGER_TYPE
     &        def_info, def_var, lenstr, wrt_info
      INTEGER_TYPE
     &        DimIDs(24), t2dgrd(3), u2dgrd(3), v2dgrd(3)
#ifdef SOLVE3D
      logical got_trc(NT)
      INTEGER_TYPE
     &        itrc
      INTEGER_TYPE
     &        b3dgrd(4), t3dgrd(4), u3dgrd(4), v3dgrd(4), w3dgrd(4)
#endif
      REAL_TYPE
     &        Aval(4)
      character*65 Vinfo(Natt)
!
!=====================================================================
!  Create a new restart NetCDF file.
!=====================================================================
!
!  Activate creation of restart NetCDF file.  Create a new restart
!  file if during a restart run, the restart filename "rstname"
!  is different than the initial filename "ininame".
!
      if (exit_flag.ne.0) return
      lstr=lenstr(rstname)
      lini=lenstr(ininame)
      Ldefine=.false.
      if (((nrrec.eq.0).and.(iic.eq.ntstart)).or.
     &    ((nrrec.ne.0).and.(rstname(1:lstr).ne.
     &                       ininame(1:lini)))) then
        Ldefine=.true.
      endif
!
      if (Ldefine) then
        status=nf_create(rstname(1:lstr),nf_clobber,ncrstid)
        if (status.ne.nf_noerr) then
          write(stdout,10) rstname(1:lstr)
          exit_flag=3
          return
        endif
!
!---------------------------------------------------------------------
!  Define the dimensions of staggered fields.
!---------------------------------------------------------------------
!
        status=nf_def_dim(ncrstid,'xi_rho' ,Lp,DimIDs( 1))
        status=nf_def_dim(ncrstid,'xi_u'   ,L ,DimIDs( 2))
        status=nf_def_dim(ncrstid,'xi_v'   ,Lp,DimIDs( 3))
        status=nf_def_dim(ncrstid,'xi_psi' ,L ,DimIDs( 4))
        status=nf_def_dim(ncrstid,'eta_rho',Mp,DimIDs( 5))
        status=nf_def_dim(ncrstid,'eta_u'  ,Mp,DimIDs( 6))
        status=nf_def_dim(ncrstid,'eta_v'  ,M ,DimIDs( 7))
        status=nf_def_dim(ncrstid,'eta_psi',M ,DimIDs( 8))
#if defined WRITE_WATER && defined MASKING
        status=nf_def_dim(ncrstid,'xy_rho' ,Nxyr,DimIDs(17))
        status=nf_def_dim(ncrstid,'xy_u'   ,Nxyu,DimIDs(18))
        status=nf_def_dim(ncrstid,'xy_v'   ,Nxyv,DimIDs(19))
#endif
#ifdef SOLVE3D
# if defined WRITE_WATER && defined MASKING
        status=nf_def_dim(ncrstid,'xyz_rho',Nxyr*N ,DimIDs(20))
        status=nf_def_dim(ncrstid,'xyz_u'  ,Nxyu*N ,DimIDs(21))
        status=nf_def_dim(ncrstid,'xyz_v'  ,Nxyv*N ,DimIDs(22))
        status=nf_def_dim(ncrstid,'xyz_w'  ,Nxyr*Np,DimIDs(23))
# endif
        status=nf_def_dim(ncrstid,'s_rho'  ,N ,DimIDs( 9))
        status=nf_def_dim(ncrstid,'s_w'    ,Np,DimIDs(10))
        status=nf_def_dim(ncrstid,'tracer' ,NT,DimIDs(11))
# ifdef SEDIMENT
        status=nf_def_dim(ncrstid,'Nbed'   ,Nbed,DimIDs(16))
#  if defined WRITE_WATER && defined MASKING
        status=nf_def_dim(ncrstid,'xybed'  ,Nxyr*Nbed,DimIDs(24))
#  endif
# endif
#endif
        status=nf_def_dim(ncrstid,'boundary',4,DimIDs(14))
        status=nf_def_dim(ncrstid,'time',
     &                    nf_unlimited,DimIDs(12))
        recdim=DimIDs(12)
!
!  Set number of dimensions for output variables.
!
#if defined WRITE_WATER && defined MASKING
        nvd3=2
        nvd4=2
#else
        nvd3=3
        nvd4=4
#endif
!
!  Define dimension vectors for staggered tracer type variables.
!
#if defined WRITE_WATER && defined MASKING
        t2dgrd(1)=DimIDs(17)
        t2dgrd(2)=DimIDs(12)
# ifdef SOLVE3D
        t3dgrd(1)=DimIDs(20)
        t3dgrd(2)=DimIDs(12)
# endif
#else
        t2dgrd(1)=DimIDs( 1)
        t2dgrd(2)=DimIDs( 5)
        t2dgrd(3)=DimIDs(12)
# ifdef SOLVE3D
        t3dgrd(1)=DimIDs( 1)
        t3dgrd(2)=DimIDs( 5)
        t3dgrd(3)=DimIDs( 9)
        t3dgrd(4)=DimIDs(12)
# endif
#endif
!
!  Define dimension vectors for staggered u-momemtum type variables.
!
#if defined WRITE_WATER && defined MASKING
        u2dgrd(1)=DimIDs(18)
        u2dgrd(2)=DimIDs(12)
# ifdef SOLVE3D
        u3dgrd(1)=DimIDs(21)
        u3dgrd(2)=DimIDs(12)
# endif
#else
        u2dgrd(1)=DimIDs( 2)
        u2dgrd(2)=DimIDs( 6)
        u2dgrd(3)=DimIDs(12)
# ifdef SOLVE3D
        u3dgrd(1)=DimIDs( 2)
        u3dgrd(2)=DimIDs( 6)
        u3dgrd(3)=DimIDs( 9)
        u3dgrd(4)=DimIDs(12)
# endif
#endif
!
!  Define dimension vectors for staggered v-momemtum type variables.
!
#if defined WRITE_WATER && defined MASKING
        v2dgrd(1)=DimIDs(19)
        v2dgrd(2)=DimIDs(12)
# ifdef SOLVE3D
        v3dgrd(1)=DimIDs(22)
        v3dgrd(2)=DimIDs(12)
# endif
#else
        v2dgrd(1)=DimIDs( 3)
        v2dgrd(2)=DimIDs( 7)
        v2dgrd(3)=DimIDs(12)
# ifdef SOLVE3D
        v3dgrd(1)=DimIDs( 3)
        v3dgrd(2)=DimIDs( 7)
        v3dgrd(3)=DimIDs( 9)
        v3dgrd(4)=DimIDs(12)
# endif
#endif
#ifdef SOLVE3D
!
!  Define dimension vector for staggered w-momemtum type variables.
!
# if defined WRITE_WATER && defined MASKING
        w3dgrd(1)=DimIDs(23)
        w3dgrd(2)=DimIDs(12)
# else
        w3dgrd(1)=DimIDs( 1)
        w3dgrd(2)=DimIDs( 5)
        w3dgrd(3)=DimIDs(10)
        w3dgrd(4)=DimIDs(12)
# endif
!
!  Define dimension vector for sediment bed layer type variables.
!
# if defined WRITE_WATER && defined MASKING
        b3dgrd(1)=DimIDs(24)
        b3dgrd(2)=DimIDs(12)
# else
        b3dgrd(1)=DimIDs( 1)
        b3dgrd(2)=DimIDs( 5)
        b3dgrd(3)=DimIDs(16)
        b3dgrd(4)=DimIDs(12)
# endif
#endif
!
!  Initialize unlimited time record dimension.
!
        trstindx=0
!
!  Initialize local information variable arrays.
!
        do i=1,Natt
          Vinfo(i)=' '
        enddo
        do i=1,4
          Aval(i)=0.0_r8
        enddo
!
!---------------------------------------------------------------------
!  Define time-recordless information variables.
!---------------------------------------------------------------------
!
        status=def_info(ncrstid,rstname,DimIDs)
        if (exit_flag.ne.0) return
!
!---------------------------------------------------------------------
!  Define variables and their attributes.
!---------------------------------------------------------------------
!
!  Define model time.
!
        Vinfo( 1)=Vname(1,idtime)
        Vinfo( 2)=Vname(2,idtime)
        if (INT(time_ref).eq.-2) then
          Vinfo( 3)='seconds since 1968-05-23 00:00:00 GMT'
          Vinfo( 4)='modified Julian day number'
          Vinfo(18)='add_offset'
          Aval(1)=jul_off
        elseif (INT(time_ref).eq.-1) then
          Vinfo( 3)='seconds since 0001-01-01 00:00:00'
          Vinfo( 4)='360 days in every year, 30 days in each month'
        elseif (INT(time_ref).eq.0) then
          Vinfo( 3)='seconds since 0001-01-01 00:00:00'
          Vinfo( 4)='365.25 days in every year'
        elseif (time_ref.gt.0.0_r8) then
          Vinfo( 3)='seconds since '/ /r_text
        endif
        Vinfo(14)=Vname(4,idtime)
        status=def_var(ncrstid,rstVid(idtime),NF_FTYPE,1,recdim,
     &                 Aval,Vinfo,rstname)
!
!  Define free-surface.
!
        Vinfo( 1)=Vname(1,idFsur)
        Vinfo( 2)=Vname(2,idFsur)
        Vinfo( 3)=Vname(3,idFsur)
        Vinfo(14)=Vname(4,idFsur)
        Vinfo(16)=Vname(1,idtime)
#if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#endif
        status=def_var(ncrstid,rstVid(idFsur),NF_FRST,nvd3,t2dgrd,
     &                 Aval,Vinfo,rstname)
!
!  Define 2D momentum in the XI-direction.
!
        Vinfo( 1)=Vname(1,idUbar)
        Vinfo( 2)=Vname(2,idUbar)
        Vinfo( 3)=Vname(3,idUbar)
        Vinfo(14)=Vname(4,idUbar)
        Vinfo(16)=Vname(1,idtime)
#if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_u'
#endif
        status=def_var(ncrstid,rstVid(idUbar),NF_FRST,nvd3,u2dgrd,
     &                 Aval,Vinfo,rstname)
!
!  Define 2D momentum in the ETA-direction.
!
        Vinfo( 1)=Vname(1,idVbar)
        Vinfo( 2)=Vname(2,idVbar)
        Vinfo( 3)=Vname(3,idVbar)
        Vinfo(14)=Vname(4,idVbar)
        Vinfo(16)=Vname(1,idtime)
#if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_v'
#endif
        status=def_var(ncrstid,rstVid(idVbar),NF_FRST,nvd3,v2dgrd,
     &                 Aval,Vinfo,rstname)
#ifdef SOLVE3D
!
!  Define 3D momentum component in the XI-direction.
!
        Vinfo( 1)=Vname(1,idUvel)
        Vinfo( 2)=Vname(2,idUvel)
        Vinfo( 3)=Vname(3,idUvel)
        Vinfo(14)=Vname(4,idUvel)
        Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_u'
# endif
        status=def_var(ncrstid,rstVid(idUvel),NF_FRST,nvd4,u3dgrd,
     &                 Aval,Vinfo,rstname)
!
!  Define 3D momentum component in the ETA-direction.
!
        Vinfo( 1)=Vname(1,idVvel)
        Vinfo( 2)=Vname(2,idVvel)
        Vinfo( 3)=Vname(3,idVvel)
        Vinfo(14)=Vname(4,idVvel)
        Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_v'
# endif
        status=def_var(ncrstid,rstVid(idVvel),NF_FRST,nvd4,v3dgrd,
     &                 Aval,Vinfo,rstname)
!
!  Define tracer type variables.
!
        do itrc=1,NT
          Vinfo( 1)=Vname(1,idTvar(itrc))
          Vinfo( 2)=Vname(2,idTvar(itrc))
          Vinfo( 3)=Vname(3,idTvar(itrc))
          Vinfo(14)=Vname(4,idTvar(itrc))
          Vinfo(16)=Vname(1,idtime)
# ifdef SEDIMENT
            do i=1,NST
              if (itrc.eq.idsed(i)) then
                write(Vinfo(19),20) 1000.0_r8*Sd50(i)
              endif
            enddo
# endif
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(ncrstid,rstTid(itrc),NF_FRST,nvd4,t3dgrd,
     &                   Aval,Vinfo,rstname)
        enddo
!
!  Define density anomaly.
!
        Vinfo( 1)=Vname(1,idDano)
        Vinfo( 2)=Vname(2,idDano)
        Vinfo( 3)=Vname(3,idDano)
        Vinfo(14)=Vname(4,idDano)
        Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
# endif
        status=def_var(ncrstid,rstVid(idDano),NF_FRST,nvd4,t3dgrd,
     &                 Aval,Vinfo,rstname)
# ifdef LMD_SKPP
!
!  Define depth of surface boundary layer.
!
        Vinfo( 1)=Vname(1,idHsbl)
        Vinfo( 2)=Vname(2,idHsbl)
        Vinfo( 3)=Vname(3,idHsbl)
        Vinfo(14)=Vname(4,idHsbl)
        Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#  endif
        status=def_var(ncrstid,rstVid(idHsbl),NF_FRST,nvd3,t2dgrd,
     &                 Aval,Vinfo,rstname)
# endif
# ifdef LMD_BKPP
!
!  Define depth of bottom boundary layer.
!
        Vinfo( 1)=Vname(1,idHbbl)
        Vinfo( 2)=Vname(2,idHbbl)
        Vinfo( 3)=Vname(3,idHbbl)
        Vinfo(14)=Vname(4,idHbbl)
        Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#  endif
        status=def_var(ncrstid,rstVid(idHbbl),NF_FRST,nvd3,t2dgrd,
     &                 Aval,Vinfo,rstname)
# endif
# if defined BVF_MIXING  || defined LMD_MIXING || \
     defined GLS_MIXING || defined MY25_MIXING
!
!  Define vertical viscosity coefficient.
!
        Vinfo( 1)=Vname(1,idVvis)
        Vinfo( 2)=Vname(2,idVvis)
        Vinfo( 3)=Vname(3,idVvis)
        Vinfo(14)=Vname(4,idVvis)
        Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#  endif
        status=def_var(ncrstid,rstVid(idVvis),NF_FRST,nvd4,w3dgrd,
     &                 Aval,Vinfo,rstname)
!
!  Define vertical diffusion coefficient for potential temperature.
!
        Vinfo( 1)=Vname(1,idTdif)
        Vinfo( 2)=Vname(2,idTdif)
        Vinfo( 3)=Vname(3,idTdif)
        Vinfo(14)=Vname(4,idTdif)
        Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#  endif
        status=def_var(ncrstid,rstVid(idTdif),NF_FRST,nvd4,w3dgrd,
     &                 Aval,Vinfo,rstname)
#  ifdef SALINITY
!
!  Define vertical diffusion coefficient for salinity.
!
        Vinfo( 1)=Vname(1,idSdif)
        Vinfo( 2)=Vname(2,idSdif)
        Vinfo( 3)=Vname(3,idSdif)
        Vinfo(14)=Vname(4,idSdif)
        Vinfo(16)=Vname(1,idtime)
#   if defined WRITE_WATER && defined MASKING
        Vinfo(20)='mask_rho'
#   endif
        status=def_var(ncrstid,rstVid(idSdif),NF_FRST,nvd4,w3dgrd,
     &                 Aval,Vinfo,rstname)
#  endif
# endif
# ifdef SEDIMENT
!
!  Define bed layer sediment fraction for each size class.
!
        do i=1,NST
          Vinfo( 1)=Vname(1,idfrac(i))
          Vinfo( 2)=Vname(2,idfrac(i))
          Vinfo( 3)=Vname(3,idfrac(i))
          Vinfo(14)=Vname(4,idfrac(i))
          Vinfo(16)=Vname(1,idtime)
          write(Vinfo(19),20) 1000.0_r8*Sd50(i)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(ncrstid,rstVid(idfrac(i)),NF_FRST,nvd4,
     &                   b3dgrd,Aval,Vinfo,rstname)
        enddo
!
!  Define bed layer sediment properties.
!
        do i=1,MBEDP
          Vinfo( 1)=Vname(1,idSbed(i))
          Vinfo( 2)=Vname(2,idSbed(i))
          Vinfo( 3)=Vname(3,idSbed(i))
          Vinfo(14)=Vname(4,idSbed(i))
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(ncrstid,rstVid(idSbed(i)),NF_FRST,nvd4,
     &                   b3dgrd,Aval,Vinfo,rstname)
        enddo
# endif
#endif
!
!---------------------------------------------------------------------
!  Leave definition mode.
!---------------------------------------------------------------------
!
        status=nf_enddef(ncrstid)
!
!---------------------------------------------------------------------
!  Write out time-recordless, information variables.
!---------------------------------------------------------------------
!
        status=wrt_info(ncrstid,rstname)
        if (exit_flag.ne.0) return
      else
!
!=====================================================================
!  Open an existing restart file, check its contents, and prepare for
!  appending data.
!=====================================================================
!
!  Inquire about the contents of restart NetCDF file:  Inquire about
!  the dimensions and variables.  Check for consistency.
!
        ifield=0
        call opencdf (rstname,N,ifield,nrec)
        if (exit_flag.ne.0) return
!
!  Open restart file for read/write.
!
        status=nf_open(rstname(1:lstr),nf_write,ncrstid)
        if (status.ne.nf_noerr) then
          write(stdout,40) rstname(1:lstr)
          exit_flag=3
          return
        endif
!
!  Initialize logical switches.
!
        do i=1,NV
          got_var(i)=.false.
        enddo
#ifdef SOLVE3D
        do itrc=1,NT
          got_trc(itrc)=.false.
        enddo
#endif
!
!  Scan variable list from input NetCDF and activate switches for
!  restart variables. Get variable IDs.
!
        do i=1,nvars
          lvar=lenstr(varnam(i))
          lsvar=lenstr(Vname(1,idtime))
          if (varnam(i)(1:lvar).eq.Vname(1,idtime)(1:lsvar)) then
            got_var(idtime)=.true.
            status=nf_inq_varid(ncrstid,Vname(1,idtime)(1:lsvar),
     &                          rstVid(idtime))
          endif
          lsvar=lenstr(Vname(1,idFsur))
          if (varnam(i)(1:lvar).eq.Vname(1,idFsur)(1:lsvar)) then
            got_var(idFsur)=.true.
            status=nf_inq_varid(ncrstid,Vname(1,idFsur)(1:lsvar),
     &                          rstVid(idFsur))
          endif
          lsvar=lenstr(Vname(1,idUbar))
          if (varnam(i)(1:lvar).eq.Vname(1,idUbar)(1:lsvar)) then
            got_var(idUbar)=.true.
            status=nf_inq_varid(ncrstid,Vname(1,idUbar)(1:lsvar),
     &                          rstVid(idUbar))
          endif
          lsvar=lenstr(Vname(1,idVbar))
          if (varnam(i)(1:lvar).eq.Vname(1,idVbar)(1:lsvar)) then
            got_var(idVbar)=.true.
            status=nf_inq_varid(ncrstid,Vname(1,idVbar)(1:lsvar),
     &                          rstVid(idVbar))
          endif
#ifdef SOLVE3D
          lsvar=lenstr(Vname(1,idUvel))
          if (varnam(i)(1:lvar).eq.Vname(1,idUvel)(1:lsvar)) then
            got_var(idUvel)=.true.
            status=nf_inq_varid(ncrstid,Vname(1,idUvel)(1:lsvar),
     &                          rstVid(idUvel))
          endif
          lsvar=lenstr(Vname(1,idVvel))
          if (varnam(i)(1:lvar).eq.Vname(1,idVvel)(1:lsvar)) then
            got_var(idVvel)=.true.
            status=nf_inq_varid(ncrstid,Vname(1,idVvel)(1:lsvar),
     &                          rstVid(idVvel))
          endif
          do itrc=1,NT
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            if (varnam(i)(1:lvar).eq.
     &          Vname(1,idTvar(itrc))(1:lsvar)) then
             got_trc(itrc)=.true.
             status=nf_inq_varid(ncrstid,
     &                           Vname(1,idTvar(itrc))(1:lsvar),
     &                           rstTid(itrc))
            endif
          enddo
          lsvar=lenstr(Vname(1,idDano))
          if (varnam(i)(1:lvar).eq.Vname(1,idDano)(1:lsvar)) then
            got_var(idDano)=.true.
            status=nf_inq_varid(ncrstid,Vname(1,idDano)(1:lsvar),
     &                          rstVid(idDano))
          endif
# ifdef LMD_SKPP
          lsvar=lenstr(Vname(1,idHsbl))
          if (varnam(i)(1:lvar).eq.Vname(1,idHsbl)(1:lsvar)) then
            got_var(idHsbl)=.true.
            status=nf_inq_varid(ncrstid,Vname(1,idHsbl)(1:lsvar),
     &                          rstVid(idHsbl))
          endif
# endif
# ifdef LMD_BKPP
          lsvar=lenstr(Vname(1,idHbbl))
          if (varnam(i)(1:lvar).eq.Vname(1,idHbbl)(1:lsvar)) then
            got_var(idHbbl)=.true.
            status=nf_inq_varid(ncrstid,Vname(1,idHbbl)(1:lsvar),
     &                          rstVid(idHbbl))
          endif
# endif
          lsvar=lenstr(Vname(1,idVvis))
          if (varnam(i)(1:lvar).eq.Vname(1,idVvis)(1:lsvar)) then
            got_var(idVvis)=.true.
            status=nf_inq_varid(ncrstid,Vname(1,idVvis)(1:lsvar),
     &                          rstVid(idVvis))
          endif
          lsvar=lenstr(Vname(1,idTdif))
          if (varnam(i)(1:lvar).eq.Vname(1,idTdif)(1:lsvar)) then
            got_var(idTdif)=.true.
            status=nf_inq_varid(ncrstid,Vname(1,idTdif)(1:lsvar),
     &                          rstVid(idTdif))
          endif
          lsvar=lenstr(Vname(1,idSdif))
          if (varnam(i)(1:lvar).eq.Vname(1,idSdif)(1:lsvar)) then
            got_var(idSdif)=.true.
            status=nf_inq_varid(ncrstid,Vname(1,idSdif)(1:lsvar),
     &                          rstVid(idSdif))
          endif
# ifdef SEDIMENT
          do itrc=1,NST
            lsvar=lenstr(Vname(1,idfrac(itrc)))
            if (varnam(i)(1:lvar).eq.
     &          Vname(1,idfrac(itrc))(1:lsvar)) then
              got_var(idfrac(itrc))=.true.
              status=nf_inq_varid(ncrstid,
     &                            Vname(1,idfrac(itrc))(1:lsvar),
     &                            rstVid(idfrac(itrc)))
            endif
          enddo
          do itrc=1,MBEDP
            lsvar=lenstr(Vname(1,idSbed(itrc)))
            if (varnam(i)(1:lvar).eq.
     &          Vname(1,idSbed(itrc))(1:lsvar)) then
              got_var(idSbed(itrc))=.true.
              status=nf_inq_varid(ncrstid,
     &                            Vname(1,idSbed(itrc))(1:lsvar),
     &                            rstVid(idSbed(itrc)))
            endif
          enddo
# endif
#endif
        enddo
!
!  Check if initialization variables are available in input NetCDF
!  file.
!
        if (.not.got_var(idtime)) then
          lsvar=lenstr(Vname(1,idtime))
          write(stdout,40) Vname(1,idtime)(1:lsvar), rstname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idFsur)) then
          lsvar=lenstr(Vname(1,idFsur))
          write(stdout,40) Vname(1,idFsur)(1:lsvar), rstname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idUbar)) then
          lsvar=lenstr(Vname(1,idUbar))
          write(stdout,40) Vname(1,idUbar)(1:lsvar), rstname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVbar)) then
          lsvar=lenstr(Vname(1,idVbar))
          write(stdout,40) Vname(1,idVbar)(1:lsvar), rstname(1:lstr)
          exit_flag=3
          return
        endif
#ifdef SOLVE3D
        if (.not.got_var(idUvel)) then
          lsvar=lenstr(Vname(1,idUvel))
          write(stdout,40) Vname(1,idUvel)(1:lsvar), rstname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVvel)) then
          lsvar=lenstr(Vname(1,idVvel))
          write(stdout,40) Vname(1,idVvel)(1:lsvar), rstname(1:lstr)
          exit_flag=3
          return
        endif
        do itrc=1,NT
          if (.not.got_trc(itrc)) then
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            write(stdout,40) Vname(1,idTvar(itrc))(1:lsvar),
     &                       rstname(1:lstr)
            exit_flag=3
            return
          endif
        enddo
        if (.not.got_var(idDano)) then
          lsvar=lenstr(Vname(1,idDano))
          write(stdout,40) Vname(1,idDano)(1:lsvar), rstname(1:lstr)
          exit_flag=3
          return
        endif
# ifdef SEDIMENT
        do i=1,NST
          if (.not.got_var(idfrac(i))) then
            lsvar=lenstr(Vname(1,idfrac(i)))
            write(stdout,40) Vname(1,idfrac(i))(1:lsvar), rstname(1:lstr)
            exit_flag=3
            return
          endif
        enddo
        do i=1,MBEDP
          if (.not.got_var(idSbed(i))) then
            lsvar=lenstr(Vname(1,idSbed(i)))
            write(stdout,40) Vname(1,idSbed(i))(1:lsvar), rstname(1:lstr)
            exit_flag=3
            return
          endif
        enddo
# endif
#endif
!
!  Set unlimited time record dimension to current value.
!
        if (lcycle) then
          trstindx=0
        else
          trstindx=tsize
        endif
      endif
!
  10  format(/,' DEF_RST - unable to create restart NetCDF file: ',a)
  20  format(1pe11.4,1x,'millimeter')
  30  format(/,' DEF_RST - unable to open restart NetCDF file: ',a)
  40  format(/,' DEF_RST - unable to find variable: ',a,2x,
     &         ' in restart NetCDF file: ',a)
      return
      end
