#include "cppdefs.h"
      function def_info (ncid,ncname,DimIDs)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine defines information variables in requested NetCDF    !
!  file.                                                             !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     ncid     NetCDF file ID (INTEGER_TYPE).                        !
!     ncname   NetCDF file name (character).                         !
!     DimIDs   NetCDF dimensions IDs (INTEGER_TYPE vector):          !
!                DimIDs( 1) => XI-dimension at RHO-points.           !
!                DimIDs( 2) => XI-dimension at U-points.             !
!                DimIDs( 3) => XI-dimension at V-points.             !
!                DimIDs( 4) => XI-dimension at PSI-points.           !
!                DimIDs( 5) => ETA-dimension at RHO-points.          !
!                DimIDs( 6) => ETA-dimension at U-points.            !
!                DimIDs( 7) => ETA-dimension at V-points.            !
!                DimIDs( 8) => ETA-dimension at PSI-points.          !
!                DimIDs( 9) => S-dimension at RHO-points.            !
!                DimIDs(10) => S-dimension at W-points.              !
!                DimIDs(11) => Number of tracers dimension.          !
!                DimIDs(12) => Unlimited time record dimension.      !
!                DimIDs(13) => Number of stations dimension.         !
!                DimIDs(14) => Boundary dimension.                   !
!                DimIDs(15) => Number of floats dimension.           !
!                DimIDs(16) => Number sediment bed layers dimension. !
!                DimIDs(17) => Dimension 2D water RHO-points.        !
!                DimIDs(18) => Dimension 2D water U-points.          !
!                DimIDs(19) => Dimension 2D water V-points.          !
!                DimIDs(20) => Dimension 3D water RHO-points.        !
!                DimIDs(21) => Dimension 3D water U-points.          !
!                DimIDs(23) => Dimension 3D water W-points.          !
!                DimIDs(24) => Dimension sediment bed water points.  !
!                                                                    !
!  On Output:                                                        !
!                                                                    !
!     def_info   Error flag (INTEGER_TYPE).                          !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "grid.h"
#include "iounits.h"
#include "ncparam.h"
#include "netcdf.inc"
#include "scalars.h"
#include "strings.h"
!
      INTEGER_TYPE
     &        Natt
      parameter (Natt=20)
      INTEGER_TYPE
     &        brydim, i, lstr, ncid, srdim, stadim, status, swdim,
     &        trcdim, usrdim, varid
      INTEGER_TYPE
     &        DimIDs(24), p2dgrd(2), tbrydim(2), t2dgrd(3), u2dgrd(3),
     &        v2dgrd(3)
      INTEGER_TYPE
     &        def_info, def_var, lenstr
      REAL_TYPE
     &        Aval(4)
      character*(*) ncname
      character*65  Vinfo(Natt)
!
!---------------------------------------------------------------------
!  Set dimension variables.
!---------------------------------------------------------------------
!
      p2dgrd(1)=DimIDs(4)
      p2dgrd(2)=DimIDs(8)
      t2dgrd(1)=DimIDs(1)
      t2dgrd(2)=DimIDs(5)
      u2dgrd(1)=DimIDs(2)
      u2dgrd(2)=DimIDs(6)
      v2dgrd(1)=DimIDs(3)
      v2dgrd(2)=DimIDs(7)
      srdim=DimIDs(9)
      swdim=DimIDs(10)
      trcdim=DimIDs(11)
      stadim=DimIDs(13)
      brydim=DimIDs(14)
      tbrydim(1)=DimIDs(14)
      tbrydim(2)=DimIDs(11)
!
!  Set dimension for generic user parameters.
!
      if (Nuser.gt.0) then
        status=nf_def_dim(ncid,'Nuser',25,usrdim)
      endif
!
!  Initialize local information variable arrays.
!
      do i=1,Natt
        Vinfo(i)=' '
      enddo
      do i=1,4
        Aval(i)=0.0_r8
      enddo
!
!---------------------------------------------------------------------
!  Define global attributes.
!---------------------------------------------------------------------
!
!  Define history global attribute.
!
      lstr=lenstr(date_str)
      if (lstr.gt.0) then
        history='ROMS, Version '/ /version/ /', '/ /date_str(1:lstr)
      else
        history='ROMS, Version '/ /version
      endif
!
!  Define file type global attribute.
!
      if (ncid.eq.ncavgid) then
        type='ROMS averages file'
      elseif (ncid.eq.nchisid) then
        type='ROMS hystory file'
      elseif (ncid.eq.ncrstid) then
        type='ROMS restart file'
      elseif (ncid.eq.ncstaid) then
        type='ROMS station file'
      elseif (ncid.eq.ncfltid) then
        type='ROMS floats file'
      endif
      lstr=lenstr(type)
      status=nf_put_att_text(ncid,nf_global,'type',lstr,type(1:lstr))
!
!  Define other global attributes to NetCDF file.
!
      lstr=lenstr(title)
      status=nf_put_att_text(ncid,nf_global,'title',
     &                       lstr,title(1:lstr))
      lstr=lenstr(rstname)
      status=nf_put_att_text(ncid,nf_global,'rst_file',
     &                       lstr,rstname(1:lstr))
      if (LdefHIS) then
        if (ndefhis.gt.0) then
          lstr=lenstr(hisbase)-3
          status=nf_put_att_text(ncid,nf_global,'his_base',
     &                           lstr,hisbase(1:lstr))
        else
          lstr=lenstr(hisname)
          status=nf_put_att_text(ncid,nf_global,'his_file',
     &                           lstr,hisname(1:lstr))
        endif
      endif
#ifdef AVERAGES
      if (ndefavg.gt.0) then
        lstr=lenstr(avgbase)-3
        status=nf_put_att_text(ncid,nf_global,'avg_base',
     &                         lstr,avgbase(1:lstr))
      else
        lstr=lenstr(avgname)
        status=nf_put_att_text(ncid,nf_global,'avg_file',
     &                         lstr,avgname(1:lstr))
      endif
#endif /* AVERAGES */
#ifdef STATIONS
      lstr=lenstr(staname)
      status=nf_put_att_text(ncid,nf_global,'sta_file',
     &                       lstr,staname(1:lstr))
#endif /* STATIONS */
#ifdef FLOATS
      lstr=lenstr(fltname)
      status=nf_put_att_text(ncid,nf_global,'flt_file',
     &                       lstr,fltname(1:lstr))
#endif /* FLOATS */
#ifndef ANA_GRID
      lstr=lenstr(grdname)
      status=nf_put_att_text(ncid,nf_global,'grd_file',
     &                       lstr,grdname(1:lstr))
#endif /* !ANA_GRID */
#ifndef ANA_INITIAL
      lstr=lenstr(ininame)
      status=nf_put_att_text(ncid,nf_global,'ini_file',
     &                       lstr,ininame(1:lstr))
#endif /* !ANA_INITIAL */
#ifdef FRC_FILE
      lstr=lenstr(frcname)
      status=nf_put_att_text(ncid,nf_global,'frc_file',
     &                       lstr,frcname(1:lstr))
#endif /* FRC_FILE */
#if (defined  ZCLIMATOLOGY && !defined ANA_SSH)     || \
    (defined M2CLIMATOLOGY && !defined ANA_M2CLIMA) || \
    (defined  TCLIMATOLOGY && !defined ANA_TCLIMA)  || \
    (defined M3CLIMATOLOGY && !defined ANA_M3CLIMA)
      lstr=lenstr(clmname)
      status=nf_put_att_text(ncid,nf_global,'clm_file',
     &                       lstr,clmname(1:lstr))
#endif
#if defined ASSIMILATION || defined NUDGING
      lstr=lenstr(aparnam)
      status=nf_put_att_text(ncid,nf_global,'apar_file',
     &                       lstr,aparnam(1:lstr))
#endif /* ASSIMILATION || NUDGING */
#ifdef BIOLOGY
      lstr=lenstr(bparnam)
      status=nf_put_att_text(ncid,nf_global,'bpar_file',
     &                       lstr,bparnam(1:lstr))
#endif /* BIOLOGY */
#ifdef FLOATS
      lstr=lenstr(fposnam)
      status=nf_put_att_text(ncid,nf_global,'fpos_file',
     &                       lstr,fposnam(1:lstr))
#endif /* FLOATS */
#ifdef STATIONS
      lstr=lenstr(sposnam)
      status=nf_put_att_text(ncid,nf_global,'spos_file',
     &                       lstr,sposnam(1:lstr))
#endif
      lstr=lenstr(history)
      status=nf_put_att_text(ncid,nf_global,'history',
     &                       lstr,history(1:lstr))
      lstr=lenstr(Coptions)
      status=nf_put_att_text(ncid,nf_global,'CPP_options',
     &                       lstr,Coptions(1:lstr))
!
!---------------------------------------------------------------------
!  Define running parameters.
!---------------------------------------------------------------------
!
!  Time stepping parameters.
!
      Vinfo( 1)='ntimes'
      Vinfo( 2)='number of long time-steps'
      status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='ndtfast'
      Vinfo( 2)='number of short time-steps'
      status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='dt'
      Vinfo( 2)='size of long time-steps'
      Vinfo( 3)='second'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='dtfast'
      Vinfo( 2)='size of short time-steps'
      Vinfo( 3)='second'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='dstart'
      Vinfo( 2)='time stamp assigned to model initilization'
      if (INT(time_ref).eq.-2) then
        Vinfo( 3)='days since 1968-05-23 00:00:00 GMT'
        Vinfo( 4)='modified Julian day number'
        Vinfo(18)='add_offset'
        Aval(1)=jul_off
      elseif (INT(time_ref).eq.-1) then
        Vinfo( 3)='days since 0000-01-01 00:00:00'
        Vinfo( 4)='360 days in every year, 30 days in each month'
      elseif (INT(time_ref).eq.0) then
        Vinfo( 3)='days since 0000-01-01 00:00:00'
        Vinfo( 4)='365.25 days in every year'
      elseif (time_ref.gt.0.0_r8) then
        Vinfo( 3)='days since '/ /r_text
      endif
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='nhis'
      Vinfo( 2)='number of time-steps between history records'
      status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)

      if (ndefhis.gt.0) then
        Vinfo( 1)='ndefhis'
        Vinfo( 2)=
     &    'number of time-steps between the creation of history files'
          status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)
      endif

      Vinfo( 1)='nrst'
      Vinfo( 2)='number of time-steps between restart records'
      if (lcycle) then
        Vinfo(13)='only latest two records are maintained'
      endif
      status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)

#ifdef AVERAGES
      Vinfo( 1)='ntsavg'
      Vinfo( 2)=
     &   'starting time-step for accumulation of time-averaged fields'
      status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='navg'
      Vinfo( 2)='number of time-steps between time-averaged records'
      status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)

      if (ndefavg.gt.0) then
        Vinfo( 1)='ndefavg'
        Vinfo( 2)=
     &    'number of time-steps between the creation of average files'
        status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)
      endif
#endif /* AVERAGES */

#ifdef STATIONS
      Vinfo( 1)='nsta'
      Vinfo( 2)='number of time-steps between stations records'
      status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)
#endif /* STATIONS */

#if defined SOLVE3D && defined MIX_ISO_TS
      Vinfo( 1)='nmix_en'
      Vinfo( 2)='number of time-steps between isopycnal slopes'
      status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)
#endif /* SOLVE3D && MIX_ISO_TS */
!
!  Horizontal mixing coefficients.
!
#if defined SOLVE3D && defined TS_DIF2
      Vinfo( 1)='tnu2'
      Vinfo( 2)='Laplacian mixing coefficient for tracers'
      Vinfo( 3)='meter2 second-1'
      status=def_var(ncid,varid,NF_FTYPE,1,trcdim,Aval,Vinfo,ncname)
#endif /* SOLVE3D && TS_DIF2 */

#if defined SOLVE3D && defined TS_DIF4
      Vinfo( 1)='tnu4'
      Vinfo( 2)='biharmonic mixing coefficient for tracers'
      Vinfo( 3)='meter4 second-1'
      status=def_var(ncid,varid,NF_FTYPE,1,trcdim,Aval,Vinfo,ncname)
#endif /* SOLVE3D && TS_DIF4 */

#ifdef UV_VIS2
      Vinfo( 1)='visc2'
      Vinfo( 2)='Laplacian mixing coefficient for momentum'
      Vinfo( 3)='meter2 second-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)
#endif /* UV_VIS2 */
#ifdef UV_VIS4
      Vinfo( 1)='visc4'
      Vinfo( 2)='biharmonic mixing coefficient for momentum'
      Vinfo( 3)='meter4 second-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)
#endif /* UV_VIS4 */

#if defined SOLVE3D && (defined MY25_MIXING || defined GLS_MIXING)
# ifdef TKE_DIF2
      Vinfo( 1)='tkenu2'
      Vinfo( 2)='harmonic mixing coefficient for turbulent energy'
      Vinfo( 3)='meter2 second-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)
# endif /* TKE_DIF2 */

# ifdef TKE_DIF4
      Vinfo( 1)='tkenu4'
      Vinfo( 2)='biharmonic mixing coefficient for turbulent energy'
      Vinfo( 3)='meter4 second-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)
# endif /* TKE_DIF4 */
#endif /* SOLVE3D && (MY25_MIXING || GLS_MIXING) */
#ifdef SOLVE3D
!
!  Background vertical mixing coefficients.
!
      Vinfo( 1)='Akt_bak'
      Vinfo( 2)='background vertical mixing coefficient for tracers'
      Vinfo( 3)='meter2 second-1'
      status=def_var(ncid,varid,NF_FTYPE,1,trcdim,Aval,Vinfo,ncname)

      Vinfo( 1)='Akv_bak'
      Vinfo( 2)='background vertical mixing coefficient for momentum'
      Vinfo( 3)='meter2 second-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

# if defined MY25_MIXING || defined GLS_MIXING
      Vinfo( 1)='Akk_bak'
      Vinfo( 2)=
     &   'background vertical mixing coefficient for turbulent energy'
      Vinfo( 3)='meter2 second-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='Akp_bak'
      Vinfo( 2)=
     &   'background vertical mixing coefficient for length scale'
      Vinfo( 3)='meter2 second-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)
# endif /* MY25_MIXING || GLS_MIXING */
#endif /* SOLVE3D */
!
!  Drag coefficients.
!
      Vinfo( 1)='rdrg'
      Vinfo( 2)='linear drag coefficient'
      Vinfo( 3)='meter second-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='rdrg2'
      Vinfo( 2)='quadratic drag coefficient'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

#ifdef SOLVE3D
      Vinfo( 1)='Zob'
      Vinfo( 2)='bottom roughness'
      Vinfo( 3)='meter'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='Zos'
      Vinfo( 2)='surface roughness'
      Vinfo( 3)='meter'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)
#endif /* SOLVE3D */
#if defined SOLVE3D && defined GLS_MIXING
!
!  Generic length-scale parameters.
!
      Vinfo( 1)='gls_p'
      Vinfo( 2)='stability exponent'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='gls_m'
      Vinfo( 2)='turbulent kinetic energy exponent'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='gls_n'
      Vinfo( 2)='turbulent length scale exponent'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='gls_cmu0'
      Vinfo( 2)='stability coefficient'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='gls_c1'
      Vinfo( 2)='shear production coefficient'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='gls_c2'
      Vinfo( 2)='dissipation coefficient'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='gls_c3m'
      Vinfo( 2)='buoyancy production coefficient (minus)'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='gls_c3p'
      Vinfo( 2)='buoyancy production coefficient (plus)'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='gls_sigk'
      Vinfo( 2)='constant Schmidt number for TKE'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='gls_sigp'
      Vinfo( 2)='constant Schmidt number for PSI'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='gls_Kmin'
      Vinfo( 2)='stability exponent'
      Vinfo( 3)='minimum value of specific turbulent kinetic energy'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='gls_Pmin'
      Vinfo( 2)='minimum Value of dissipation'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)
#endif /* SOLVE3D && GLS_MIXING */
!
!  Nudging inverse time scales used in various tasks.
!
      Vinfo( 1)='Znudg'
      Vinfo( 2)='free-surface nudging/relaxation inverse time scale'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='M2nudg'
      Vinfo( 2)='2D momentum nudging/relaxation inverse time scale'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

#ifdef SOLVE3D
      Vinfo( 1)='M3nudg'
      Vinfo( 2)='3D momentum nudging/relaxation inverse time scale'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='Tnudg'
      Vinfo( 2)='Tracers nudging/relaxation inverse time scale'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,1,trcdim,Aval,Vinfo,ncname)
#endif /* SOLVE3D */
#ifdef NUDGING
!
!  Nudging inverse time scales used in data assimilation.
!
      Vinfo( 1)='Znudass'
      Vinfo( 2)='free-surface nudging assimilation inverse time scale'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='M2nudass'
      Vinfo( 2)='2D momentum nudging assimilation inverse time scale'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

# ifdef SOLVE3D
      Vinfo( 1)='M3nudass'
      Vinfo( 2)='3D momentum nudging assimilation inverse time scale'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='Tnudass'
      Vinfo( 2)='Tracers nudging assimilation inverse time scale'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,1,trcdim,Aval,Vinfo,ncname)
# endif /* SOLVE3D */
#endif /* NUDGING */
#ifdef NUDGING_COFF
!
!  Open boundary nudging, inverse time scales.
!
      Vinfo( 1)='FSobc_in'
      Vinfo( 2)='free-surface inflow, nudging inverse time scale'
      Vinfo( 3)='second-1'
      status=def_var(ncid,varid,NF_FTYPE,1,brydim,Aval,Vinfo,ncname)

      Vinfo( 1)='FSobc_out'
      Vinfo( 2)='free-surface outflow, nudging inverse time scale'
      Vinfo( 3)='second-1'
      status=def_var(ncid,varid,NF_FTYPE,1,brydim,Aval,Vinfo,ncname)

      Vinfo( 1)='M2obc_in'
      Vinfo( 2)='2D momentum inflow, nudging inverse time scale'
      Vinfo( 3)='second-1'
      status=def_var(ncid,varid,NF_FTYPE,1,brydim,Aval,Vinfo,ncname)

      Vinfo( 1)='M2obc_out'
      Vinfo( 2)='2D momentum outflow, nudging inverse time scale'
      Vinfo( 3)='second-1'
      status=def_var(ncid,varid,NF_FTYPE,1,brydim,Aval,Vinfo,ncname)

# ifdef SOLVE3D
      Vinfo( 1)='Tobc_in'
      Vinfo( 2)='tracers inflow, nudging inverse time scale'
      Vinfo( 3)='second-1'
      status=def_var(ncid,varid,NF_FTYPE,2,tbrydim,Aval,Vinfo,ncname)

      Vinfo( 1)='Tobc_out'
      Vinfo( 2)='tracers outflow, nudging inverse time scale'
      Vinfo( 3)='second-1'
      status=def_var(ncid,varid,NF_FTYPE,2,tbrydim,Aval,Vinfo,ncname)

      Vinfo( 1)='M3obc_in'
      Vinfo( 2)='3D momentum inflow, nudging inverse time scale'
      Vinfo( 3)='second-1'
      status=def_var(ncid,varid,NF_FTYPE,1,brydim,Aval,Vinfo,ncname)

      Vinfo( 1)='M3obc_out'
      Vinfo( 2)='3D momentum outflow, nudging inverse time scale'
      Vinfo( 3)='second-1'
      status=def_var(ncid,varid,NF_FTYPE,1,brydim,Aval,Vinfo,ncname)
# endif /* SOLVE3D */
#endif /* NUDGING_COFF */
!
!  Equation of State parameters.
!
      Vinfo( 1)='rho0'
      Vinfo( 2)='mean density used in Boussinesq approximation'
      Vinfo( 3)='kilogram meter-3'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

#if defined SOLVE3D && !defined NONLIN_EOS
      Vinfo( 1)='R0'
      Vinfo( 2)='background density used in linear equation of state'
      Vinfo( 3)='kilogram meter-3'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='Tcoef'
      Vinfo( 2)='thermal expansion coefficient'
      Vinfo( 3)='Celsius-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='Scoef'
      Vinfo( 2)='Saline contraction coefficient'
      Vinfo( 3)='PSU-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)
#endif /* SOLVE3D && !NONLIN_EOS */
#ifdef SOLVE3D
!
!  Various parameters.
!
# ifdef SMOLARKIEWICZ
      Vinfo( 1)='adv_ord'
      Vinfo( 2)='order of Smolarkiewicz advection scheme'
      status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)
# endif /*  SMOLARKIEWICZ */

# ifdef BODYFORCE
      Vinfo( 1)='levsfrc'
      Vinfo( 2)='shallowest level for body-force stress'
      status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='levbfrc'
      Vinfo( 2)='deepest level for body-force stress'
      status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)
# endif /* BODYFORCE */
#endif /* SOLVE3D */
!
!  Slipperiness parameters.
!
      Vinfo( 1)='gamma2'
      Vinfo( 2)='Slipperiness parameter'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

#if defined BIOLOGY && defined SOLVE3D
# ifdef BIO_FASHAM
!
!  Define Fasham type biological module parameters.
!
      Vinfo( 1)='BioIter'
      Vinfo( 2)='number of iterations to achieve convergence'
      status=def_var(ncid,varid,nf_int,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='AttSW'
      Vinfo( 2)='light attenuation by seawater'
      Vinfo( 3)='meter-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='AttChl'
      Vinfo( 2)='light attenuation by chlorophyll'
      Vinfo( 3)='meter-2 milligram-1 chlorophyll'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='PARfrac'
      Vinfo( 2)='photosynthetically available radiation fraction'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='K_NO3'
      Vinfo( 2)='inverse half-saturation for phytoplankton NO3 uptake'
      Vinfo( 3)='meter3 millimole-1 nitrogen'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='K_NH4'
      Vinfo( 2)='inverse half-saturation for phytoplankton NH4 uptake'
      Vinfo( 3)='meter3 millimole-1 nitrogen'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='K_Phy'
      Vinfo( 2)='zooplankton half-saturation constant for ingestion'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='PhyIS'
      Vinfo( 2)='phytoplankton, initial slope of P-I curve'
      Vinfo( 3)='milligram C milligram-1 Chl Watts-1 meter2 day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='PhyCN'
      Vinfo( 2)='phytoplankton C:N ratio'
      Vinfo( 3)='millimole carbon millimole-1 nitrogen'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='PhyIP'
      Vinfo( 2)='phytoplankton, NH4 inhibition parameter'
      Vinfo( 3)='millimole-1 nitrogen'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='PhyMR'
      Vinfo( 2)='phytoplankton mortality rate'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='ZooAE'
      Vinfo( 2)='zooplankton assimilation efficiency fraction'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='ZooGR'
      Vinfo( 2)='zooplankton maximum growth rate'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='ZooER'
      Vinfo( 2)='zooplankton specific excretion rate'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='ZooMR'
      Vinfo( 2)='zooplankton mortality rate'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='ChlMB'
      Vinfo( 2)='mass balance for chlorophyll molecule'
      Vinfo( 3)='milligram chlorophyll milligram-1 carbon'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='CPrMax'
      Vinfo( 2)='maximum cellular chlorophyll to carbon ratio'
      Vinfo( 3)='milligram chlorophyll milligram-1 carbon'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='SDeBR'
      Vinfo( 2)='rate of small detritus breakdown to NH4'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='SDeAR'
      Vinfo( 2)='rate of small detritus aggregation to large detritus'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='LDeRR'
      Vinfo( 2)='rate of large detritus re-mineralization to NO3'
      Vinfo( 3)='day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='wSDe'
      Vinfo( 2)='vertical sinking velocity for small detritus'
      Vinfo( 3)='meter day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='wLDe'
      Vinfo( 2)='vertical sinking velocity for large detritus'
      Vinfo( 3)='meter day-1'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

# endif /* BIO_FASHAM */
#endif /* BIOLOGY && SOLVE3D */
!
!---------------------------------------------------------------------
!  Define grid variables.
!---------------------------------------------------------------------
!
!  Grid type switch: Spherical or Cartesian.
!
      Vinfo( 1)='spherical'
      Vinfo( 2)='grid type logical switch'
      Vinfo( 7)='spherical'
      Vinfo( 8)='Cartesian'
      status=def_var(ncid,varid,nf_char,0,0,Aval,Vinfo,ncname)
!
!  Domain Length.
!
      Vinfo( 1)='xl'
      Vinfo( 2)='domain length in the XI-direction'
      Vinfo( 3)='meter'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='el'
      Vinfo( 2)='domain length in the ETA-direction'
      Vinfo( 3)='meter'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)
#ifdef SOLVE3D
!
!  S-coordinate parameters.
!
      Vinfo( 1)='theta_s'
      Vinfo( 2)='S-coordinate surface control parameter'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='theta_b'
      Vinfo( 2)='S-coordinate bottom control parameter'
      Vinfo( 3)='nondimensional'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='Tcline'
      Vinfo( 2)='S-coordinate surface/bottom layer width'
      Vinfo( 3)='meter'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)

      Vinfo( 1)='hc'
      Vinfo( 2)='S-coordinate parameter, critical depth'
      Vinfo( 3)='meter'
      status=def_var(ncid,varid,NF_FTYPE,0,0,Aval,Vinfo,ncname)
!
!  S-coordinate non-dimensional independent variable at RHO-points.
!
      Vinfo( 1)='sc_r'
      Vinfo( 2)='S-coordinate at RHO-points'
      Vinfo( 3)='nondimensional'
      Vinfo( 5)='valid_min'
      Vinfo( 6)='valid_max'
      Vinfo(14)='sc_r, scalar'
      Aval(2)=-1.0_r8
      Aval(3)=0.0_r8
      status=def_var(ncid,varid,NF_FTYPE,1,srdim,Aval,Vinfo,ncname)
!
!  S-coordinate non-dimensional independent variable at W-points.
!
      Vinfo( 1)='sc_w'
      Vinfo( 2)='S-coordinate at W-points'
      Vinfo( 3)='nondimensional'
      Vinfo( 5)='valid_min'
      Vinfo( 6)='valid_max'
      Vinfo(14)='sc_w, scalar'
      Aval(2)=-1.0_r8
      Aval(3)=0.0_r8
      status=def_var(ncid,varid,NF_FTYPE,1,swdim,Aval,Vinfo,ncname)
!
!  S-coordinate non-dimensional stretching curves at RHO-points.
!
      Vinfo( 1)='Cs_r'
      Vinfo( 2)='S-coordinate stretching curves at RHO-points'
      Vinfo( 3)='nondimensional'
      Vinfo( 5)='valid_min'
      Vinfo( 6)='valid_max'
      Vinfo(14)='Cs_r, scalar'
      Aval(2)=-1.0_r8
      Aval(3)=0.0_r8
      status=def_var(ncid,varid,NF_FTYPE,1,srdim,Aval,Vinfo,ncname)
!
!  S-coordinate non-dimensional stretching curves at W-points.
!
      Vinfo( 1)='Cs_w'
      Vinfo( 2)='S-coordinate stretching curves at W-points'
      Vinfo( 3)='nondimensional'
      Vinfo( 5)='valid_min'
      Vinfo( 6)='valid_max'
      Vinfo(14)='Cs_w, scalar'
      Aval(2)=-1.0_r8
      Aval(3)=0.0_r8
      status=def_var(ncid,varid,NF_FTYPE,1,swdim,Aval,Vinfo,ncname)
!
!  Output levels.
!
      if (ncid.eq.nchisid) then
        Vinfo( 1)='Lev'
        Vinfo( 2)='output levels'
        Vinfo( 5)='valid_min'
        Vinfo( 6)='valid_max'
        Vinfo(14)='Lev, scalar'
        Aval(2)=1.0_r8
        Aval(3)=FLOAT(N)
        status=def_var(ncid,varid,nf_int,1,srdim,Aval,Vinfo,ncname)
      endif
#endif /* SOLVE3D */
!
!  User generic parameters.
!
      if (Nuser.gt.0) then
        Vinfo( 1)='user'
        Vinfo( 2)='user generic parameters'
        Vinfo(14)='user, scalar'
        status=def_var(ncid,varid,NF_FTYPE,1,usrdim,Aval,Vinfo,ncname)
      endif
#ifdef STATIONS
!
!  IJ-index station positions.
!
      if (ncid.eq.ncstaid) then
        Vinfo( 1)='Ipos'
        Vinfo( 2)='I-index station positions'
        Vinfo( 5)='valid_min'
        Vinfo( 6)='valid_max'
        Aval(2)=2.0_r8
        Aval(3)=FLOAT(Lm)
        status=def_var(ncid,varid,nf_int,1,stadim,Aval,Vinfo,ncname)

        Vinfo( 1)='Jpos'
        Vinfo( 2)='J-index station positions'
        Vinfo( 5)='valid_min'
        Vinfo( 6)='valid_max'
        Aval(2)=2.0_r8
        Aval(3)=FLOAT(Mm)
        status=def_var(ncid,varid,nf_int,1,stadim,Aval,Vinfo,ncname)
      endif
#endif STATIONS
#ifndef NO_WRITE_GRID
!
!  Bathymetry.
!
      if (ncid.ne.ncfltid) then
        Vinfo( 1)='h'
        Vinfo( 2)='bathymetry at RHO-points'
        Vinfo( 3)='meter'
        Vinfo(14)='bath, scalar'
        if (ncid.eq.ncstaid) then
          status=def_var(ncid,varid,NF_FTYPE,1,stadim,Aval,Vinfo,
     &                   ncname)
        else
          status=def_var(ncid,varid,NF_FTYPE,2,t2dgrd,Aval,Vinfo,
     &                   ncname)
        endif
!
!  Coriolis Parameter.
!
        if (ncid.ne.ncstaid) then
          Vinfo( 1)='f'
          Vinfo( 2)='Coriolis parameter at RHO-points'
          Vinfo( 3)='second-1'
          Vinfo(14)='coriolis, scalar'
          status=def_var(ncid,varid,NF_FTYPE,2,t2dgrd,Aval,Vinfo,
     &                   ncname)
        endif
!
!  Curvilinear coordinate metrics.
!
        if (ncid.ne.ncstaid) then
          Vinfo( 1)='pm'
          Vinfo( 2)='curvilinear coordinate metric in XI'
          Vinfo( 3)='meter-1'
          Vinfo(14)='pm, scalar'
          status=def_var(ncid,varid,NF_FTYPE,2,t2dgrd,Aval,Vinfo,
     &                   ncname)

          Vinfo( 1)='pn'
          Vinfo( 2)='curvilinear coordinate metric in ETA'
          Vinfo( 3)='meter-1'
          Vinfo(14)='pn, scalar'
          status=def_var(ncid,varid,NF_FTYPE,2,t2dgrd,Aval,Vinfo,
     &                   ncname)
        endif
!
!  Longitude and latitude coordinates of RHO-points, if appropriate.
!
        if (spherical) then
          Vinfo( 1)='lon_rho'
          Vinfo( 2)='longitude of RHO-points'
          Vinfo( 3)='degree_east'
          Vinfo(14)='lon_rho, scalar'
          if (ncid.eq.ncstaid) then
            status=def_var(ncid,varid,NF_FTYPE,1,stadim,Aval,Vinfo,
     &                     ncname)
          else
            status=def_var(ncid,varid,NF_FTYPE,2,t2dgrd,Aval,Vinfo,
     &                     ncname)
          endif

          Vinfo( 1)='lat_rho'
          Vinfo( 2)='latitude of RHO-points'
          Vinfo( 3)='degree_north'
          Vinfo(14)='lat_rho, scalar'
          if (ncid.eq.ncstaid) then
            status=def_var(ncid,varid,NF_FTYPE,1,stadim,Aval,Vinfo,
     &                     ncname)
          else
            status=def_var(ncid,varid,NF_FTYPE,2,t2dgrd,Aval,Vinfo,
     &                     ncname)
          endif
        else
          Vinfo( 1)='x_rho'
          Vinfo( 2)='x-locations of RHO-points'
          Vinfo( 3)='meter'
          Vinfo(14)='x_rho, scalar'
          if (ncid.eq.ncstaid) then
            status=def_var(ncid,varid,NF_FTYPE,1,stadim,Aval,Vinfo,
     &                     ncname)
          else
            status=def_var(ncid,varid,NF_FTYPE,2,t2dgrd,Aval,Vinfo,
     &                     ncname)
          endif
          Vinfo( 1)='y_rho'
          Vinfo( 2)='y-locations of RHO-points'
          Vinfo( 3)='meter'
          Vinfo(14)='y_rho, scalar'
          if (ncid.eq.ncstaid) then
            status=def_var(ncid,varid,NF_FTYPE,1,stadim,Aval,Vinfo,
     &                     ncname)
          else
            status=def_var(ncid,varid,NF_FTYPE,2,t2dgrd,Aval,Vinfo,
     &                     ncname)
          endif
        endif
# ifdef CURVGRID
!
!  Angle between XI-axis and EAST at RHO-points, if appropriate.
!
        if (spherical) then
          Vinfo( 1)='angle'
          Vinfo( 2)='angle between XI-axis and EAST'
          Vinfo( 3)='radians'
          Vinfo(14)='angle, scalar'
          if (ncid.eq.ncstaid) then
            status=def_var(ncid,varid,NF_FTYPE,1,stadim,Aval,Vinfo,
     &                     ncname)
          else
            status=def_var(ncid,varid,NF_FTYPE,2,t2dgrd,Aval,Vinfo,
     &                     ncname)
          endif
        endif
# endif /* CURVGRID */
# ifdef MASKING
!
!  Masking fields at RHO-, U-, V-points, and PSI-points.
!
        if (ncid.ne.ncstaid) then
          Vinfo( 1)='mask_rho'
          Vinfo( 2)='mask on RHO-points'
          Vinfo( 9)='land'
          Vinfo(10)='water'
          status=def_var(ncid,varid,NF_FTYPE,2,t2dgrd,Aval,Vinfo,
     &                   ncname)

          Vinfo( 1)='mask_u'
          Vinfo( 2)='mask on U-points'
          Vinfo( 9)='land'
          Vinfo(10)='water'
          status=def_var(ncid,varid,NF_FTYPE,2,u2dgrd,Aval,Vinfo,
     &                   ncname)

          Vinfo( 1)='mask_v'
          Vinfo( 2)='mask on V-points'
          Vinfo( 9)='land'
          Vinfo(10)='water'
          status=def_var(ncid,varid,NF_FTYPE,2,v2dgrd,Aval,Vinfo,
     &                   ncname)

          Vinfo( 1)='mask_psi'
          Vinfo( 2)='mask on psi-points'
          Vinfo( 9)='land'
          Vinfo(10)='water'
          status=def_var(ncid,varid,NF_FTYPE,2,p2dgrd,Aval,Vinfo,
     &                   ncname)
        endif
# endif /* MASKING */
      endif
#endif /* !NO_WRITE_GRID */
      def_info=status
!
      return
      end
