#include "cppdefs.h"
      subroutine def_his
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine creates history NetCDF file, it defines its          !
!  dimensions, attributes, and variables.                            !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "ncparam.h"
#include "netcdf.inc"
#include "scalars.h"
#include "sediment.h"
!
      logical got_var(NV)
      INTEGER_TYPE
     &        Natt
      parameter (Natt=20)
      INTEGER_TYPE
     &        i, ifield, lstr, lsvar, lvar, nrec, nvd3, nvd4, recdim,
     &        status
      INTEGER_TYPE
     &        def_info, def_var, lenstr, wrt_info
      INTEGER_TYPE
     &        DimIDs(24), t2dgrd(3), u2dgrd(3), v2dgrd(3)
#ifdef SOLVE3D
      logical got_trc(NT)
      INTEGER_TYPE
     &        itrc
      INTEGER_TYPE
     &        b3dgrd(4), t3dgrd(4), u3dgrd(4), v3dgrd(4), w3dgrd(4)
#endif
      REAL_TYPE
     &        Aval(4)
      character*65 Vinfo(Natt)
!
!=====================================================================
!  Create a new history file.
!=====================================================================
!
      if (exit_flag.ne.0) return
      if (ldefout) then
        lstr=lenstr(hisname)
        status=nf_create(hisname(1:lstr),nf_clobber,nchisid)
        if (status.ne.nf_noerr) then
          write(stdout,10) hisname(1:lstr)
          exit_flag=3
          return
        endif
!
!---------------------------------------------------------------------
!  Define the dimensions of staggered fields.
!---------------------------------------------------------------------
!
        status=nf_def_dim(nchisid,'xi_rho' ,Lp  ,DimIDs( 1))
        status=nf_def_dim(nchisid,'xi_u'   ,L   ,DimIDs( 2))
        status=nf_def_dim(nchisid,'xi_v'   ,Lp  ,DimIDs( 3))
        status=nf_def_dim(nchisid,'xi_psi' ,L   ,DimIDs( 4))
        status=nf_def_dim(nchisid,'eta_rho',Mp  ,DimIDs( 5))
        status=nf_def_dim(nchisid,'eta_u'  ,Mp  ,DimIDs( 6))
        status=nf_def_dim(nchisid,'eta_v'  ,M   ,DimIDs( 7))
        status=nf_def_dim(nchisid,'eta_psi',M   ,DimIDs( 8))
#if defined WRITE_WATER && defined MASKING
        status=nf_def_dim(nchisid,'xy_rho' ,Nxyr,DimIDs(17))
        status=nf_def_dim(nchisid,'xy_u'   ,Nxyu,DimIDs(18))
        status=nf_def_dim(nchisid,'xy_v'   ,Nxyv,DimIDs(19))
#endif
#ifdef SOLVE3D
# if defined WRITE_WATER && defined MASKING
        status=nf_def_dim(nchisid,'xyz_rho',Nxyr*Nlev,DimIDs(20))
        status=nf_def_dim(nchisid,'xyz_u'  ,Nxyu*Nlev,DimIDs(21))
        status=nf_def_dim(nchisid,'xyz_v'  ,Nxyv*Nlev,DimIDs(22))
        status=nf_def_dim(nchisid,'xyz_w'  ,Nxyr*Nlev,DimIDs(23))
# endif
        status=nf_def_dim(nchisid,'N'      ,N   ,DimIDs( 9))
        status=nf_def_dim(nchisid,'s_rho'  ,Nlev,DimIDs( 9))
        status=nf_def_dim(nchisid,'s_w'    ,Nlev,DimIDs(10))
        status=nf_def_dim(nchisid,'tracer' ,NT  ,DimIDs(11))
# ifdef SEDIMENT
        status=nf_def_dim(nchisid,'Nbed'   ,Nbed,DimIDs(16))
#  if defined WRITE_WATER && defined MASKING
        status=nf_def_dim(nchisid,'xybed'  ,Nxyr*Nbed,DimIDs(24))
#  endif
# endif
#endif
        status=nf_def_dim(nchisid,'boundary',4  ,DimIDs(14))
        status=nf_def_dim(nchisid,'time',
     &                    nf_unlimited,DimIDs(12))
        recdim=DimIDs(12)
!
!  Set number of dimensions for output variables.
!
#if defined WRITE_WATER && defined MASKING
        nvd3=2
        nvd4=2
#else
        nvd3=3
        nvd4=4
#endif
!
!  Define dimension vectors for staggered tracer type variables.
!
#if defined WRITE_WATER && defined MASKING
        t2dgrd(1)=DimIDs(17)
        t2dgrd(2)=DimIDs(12)
# ifdef SOLVE3D
        t3dgrd(1)=DimIDs(20)
        t3dgrd(2)=DimIDs(12)
# endif
#else
        t2dgrd(1)=DimIDs( 1)
        t2dgrd(2)=DimIDs( 5)
        t2dgrd(3)=DimIDs(12)
# ifdef SOLVE3D
        t3dgrd(1)=DimIDs( 1)
        t3dgrd(2)=DimIDs( 5)
        t3dgrd(3)=DimIDs( 9)
        t3dgrd(4)=DimIDs(12)
# endif
#endif
!
!  Define dimension vectors for staggered u-momemtum type variables.
!
#if defined WRITE_WATER && defined MASKING
        u2dgrd(1)=DimIDs(18)
        u2dgrd(2)=DimIDs(12)
# ifdef SOLVE3D
        u3dgrd(1)=DimIDs(21)
        u3dgrd(2)=DimIDs(12)
# endif
#else
        u2dgrd(1)=DimIDs( 2)
        u2dgrd(2)=DimIDs( 6)
        u2dgrd(3)=DimIDs(12)
# ifdef SOLVE3D
        u3dgrd(1)=DimIDs( 2)
        u3dgrd(2)=DimIDs( 6)
        u3dgrd(3)=DimIDs( 9)
        u3dgrd(4)=DimIDs(12)
# endif
#endif
!
!  Define dimension vectors for staggered v-momemtum type variables.
!
#if defined WRITE_WATER && defined MASKING
        v2dgrd(1)=DimIDs(19)
        v2dgrd(2)=DimIDs(12)
# ifdef SOLVE3D
        v3dgrd(1)=DimIDs(22)
        v3dgrd(2)=DimIDs(12)
# endif
#else
        v2dgrd(1)=DimIDs( 3)
        v2dgrd(2)=DimIDs( 7)
        v2dgrd(3)=DimIDs(12)
# ifdef SOLVE3D
        v3dgrd(1)=DimIDs( 3)
        v3dgrd(2)=DimIDs( 7)
        v3dgrd(3)=DimIDs( 9)
        v3dgrd(4)=DimIDs(12)
# endif
#endif
#ifdef SOLVE3D
!
!  Define dimension vector for staggered w-momemtum type variables.
!
# if defined WRITE_WATER && defined MASKING
        w3dgrd(1)=DimIDs(23)
        w3dgrd(2)=DimIDs(12)
# else
        w3dgrd(1)=DimIDs( 1)
        w3dgrd(2)=DimIDs( 5)
        w3dgrd(3)=DimIDs(10)
        w3dgrd(4)=DimIDs(12)
# endif
!
!  Define dimension vector for sediment bed layer type variables.
!
# if defined WRITE_WATER && defined MASKING
        b3dgrd(1)=DimIDs(24)
        b3dgrd(2)=DimIDs(12)
# else
        b3dgrd(1)=DimIDs( 1)
        b3dgrd(2)=DimIDs( 5)
        b3dgrd(3)=DimIDs(16)
        b3dgrd(4)=DimIDs(12)
# endif
#endif
!
!  Initialize unlimited time record dimension.
!
        thisindx=0
!
!  Initialize local information variable arrays.
!
        do i=1,Natt
          Vinfo(i)=' '
        enddo
        do i=1,4
          Aval(i)=0.0_r8
        enddo
!
!---------------------------------------------------------------------
!  Define time-recordless information variables.
!---------------------------------------------------------------------
!
        status=def_info(nchisid,hisname,DimIDs)
        if (exit_flag.ne.0) return
!
!---------------------------------------------------------------------
!  Define time-varying variables.
!---------------------------------------------------------------------
!
!  Define model time.
!
        Vinfo( 1)=Vname(1,idtime)
        Vinfo( 2)=Vname(2,idtime)
        if (INT(time_ref).eq.-2) then
          Vinfo( 3)='seconds since 1968-05-23 00:00:00 GMT'
          Vinfo( 4)='modified Julian day number'
          Vinfo(18)='add_offset'
          Aval(1)=jul_off
        elseif (INT(time_ref).eq.-1) then
          Vinfo( 3)='seconds since 0000-01-01 00:00:00'
          Vinfo( 4)='360 days in every year, 30 days in each month'
        elseif (INT(time_ref).eq.0) then
          Vinfo( 3)='seconds since 0000-01-01 00:00:00'
          Vinfo( 4)='365.25 days in every year'
        elseif (time_ref.gt.0.0_r8) then
          Vinfo( 3)='seconds since '/ /r_text
        endif
        Vinfo(14)=Vname(4,idtime)
        status=def_var(nchisid,hisVid(idtime),NF_FTYPE,1,recdim,Aval,
     &                 Vinfo,hisname)
!
!  Define free-surface.
!
        if (Hout(idFsur)) then
          Vinfo( 1)=Vname(1,idFsur)
          Vinfo( 2)=Vname(2,idFsur)
          Vinfo( 3)=Vname(3,idFsur)
          Vinfo(14)=Vname(4,idFsur)
          Vinfo(16)=Vname(1,idtime)
#if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#endif
          status=def_var(nchisid,hisVid(idFsur),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define 2D momentum in the XI-direction.
!
        if (Hout(idUbar)) then
          Vinfo( 1)=Vname(1,idUbar)
          Vinfo( 2)=Vname(2,idUbar)
          Vinfo( 3)=Vname(3,idUbar)
          Vinfo(14)=Vname(4,idUbar)
          Vinfo(16)=Vname(1,idtime)
#if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_u'
#endif
          status=def_var(nchisid,hisVid(idUbar),NF_FOUT,nvd3,u2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define 2D momentum in the ETA-direction.
!
        if (Hout(idVbar)) then
          Vinfo( 1)=Vname(1,idVbar)
          Vinfo( 2)=Vname(2,idVbar)
          Vinfo( 3)=Vname(3,idVbar)
          Vinfo(14)=Vname(4,idVbar)
          Vinfo(16)=Vname(1,idtime)
#if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_v'
#endif
          status=def_var(nchisid,hisVid(idVbar),NF_FOUT,nvd3,v2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
#ifdef SOLVE3D
!
!  Define 3D momentum component in the XI-direction.
!
        if (Hout(idUvel)) then
          Vinfo( 1)=Vname(1,idUvel)
          Vinfo( 2)=Vname(2,idUvel)
          Vinfo( 3)=Vname(3,idUvel)
          Vinfo(14)=Vname(4,idUvel)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_u'
# endif
          status=def_var(nchisid,hisVid(idUvel),NF_FOUT,nvd4,u3dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define 3D momentum component in the ETA-direction.
!
        if (Hout(idVvel)) then
          Vinfo( 1)=Vname(1,idVvel)
          Vinfo( 2)=Vname(2,idVvel)
          Vinfo( 3)=Vname(3,idVvel)
          Vinfo(14)=Vname(4,idVvel)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_v'
# endif
          status=def_var(nchisid,hisVid(idVvel),NF_FOUT,nvd4,v3dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define 3D momentum component in the S-direction.
!
        if (Hout(idWvel)) then
          Vinfo( 1)=Vname(1,idWvel)
          Vinfo( 2)=Vname(2,idWvel)
          Vinfo( 3)=Vname(3,idWvel)
          Vinfo(14)=Vname(4,idWvel)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(nchisid,hisVid(idWvel),NF_FOUT,nvd4,t3dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define S-coordinate vertical "omega" momentum component.
!
        if (Hout(idOvel)) then
          Vinfo( 1)=Vname(1,idOvel)
          Vinfo( 2)=Vname(2,idOvel)
          Vinfo( 3)=Vname(3,idOvel)
          Vinfo(14)=Vname(4,idOvel)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(nchisid,hisVid(idOvel),NF_FOUT,nvd4,w3dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define tracer type variables.
!
        do itrc=1,NT
          if (Hout(idTvar(itrc))) then
            Vinfo( 1)=Vname(1,idTvar(itrc))
            Vinfo( 2)=Vname(2,idTvar(itrc))
            Vinfo( 3)=Vname(3,idTvar(itrc))
            Vinfo(14)=Vname(4,idTvar(itrc))
            Vinfo(16)=Vname(1,idtime)
# ifdef SEDIMENT
            do i=1,NST
              if (itrc.eq.idsed(i)) then
                write(Vinfo(19),20) 1000.0_r8*Sd50(i)
              endif
            enddo
# endif
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
            status=def_var(nchisid,hisTid(itrc),NF_FOUT,nvd4,t3dgrd,
     &                     Aval,Vinfo,hisname)
          endif
        enddo
!
!  Define density anomaly.
!
        if (Hout(idDano)) then
          Vinfo( 1)=Vname(1,idDano)
          Vinfo( 2)=Vname(2,idDano)
          Vinfo( 3)=Vname(3,idDano)
          Vinfo(14)=Vname(4,idDano)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(nchisid,hisVid(idDano),NF_FOUT,nvd4,t3dgrd,
     &                   Aval,Vinfo,hisname)
        endif
# ifdef LMD_SKPP
!
!  Define depth of surface boundary layer.
!
        if (Hout(idHsbl)) then
          Vinfo( 1)=Vname(1,idHsbl)
          Vinfo( 2)=Vname(2,idHsbl)
          Vinfo( 3)=Vname(3,idHsbl)
          Vinfo(14)=Vname(4,idHsbl)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(nchisid,hisVid(idHsbl),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
# endif
# ifdef LMD_BKPP
!
!  Define depth of bottom boundary layer.
!
        if (Hout(idHbbl)) then
          Vinfo( 1)=Vname(1,idHbbl)
          Vinfo( 2)=Vname(2,idHbbl)
          Vinfo( 3)=Vname(3,idHbbl)
          Vinfo(14)=Vname(4,idHbbl)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(nchisid,hisVid(idHbbl),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
# endif
!
!  Define vertical viscosity coefficient.
!
        if (Hout(idVvis)) then
          Vinfo( 1)=Vname(1,idVvis)
          Vinfo( 2)=Vname(2,idVvis)
          Vinfo( 3)=Vname(3,idVvis)
          Vinfo(14)=Vname(4,idVvis)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(nchisid,hisVid(idVvis),NF_FOUT,nvd4,w3dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define vertical diffusion coefficient for potential temperature.
!
        if (Hout(idTdif)) then
          Vinfo( 1)=Vname(1,idTdif)
          Vinfo( 2)=Vname(2,idTdif)
          Vinfo( 3)=Vname(3,idTdif)
          Vinfo(14)=Vname(4,idTdif)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(nchisid,hisVid(idTdif),NF_FOUT,nvd4,w3dgrd,
     &                   Aval,Vinfo,hisname)
        endif
# ifdef SALINITY
!
!  Define vertical diffusion coefficient for salinity.
!
        if (Hout(idSdif)) then
          Vinfo( 1)=Vname(1,idSdif)
          Vinfo( 2)=Vname(2,idSdif)
          Vinfo( 3)=Vname(3,idSdif)
          Vinfo(14)=Vname(4,idSdif)
          Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#  endif
          status=def_var(nchisid,hisVid(idSdif),NF_FOUT,nvd4,w3dgrd,
     &                   Aval,Vinfo,hisname)
        endif
# endif
# if defined GLS_MIXING || defined MY25_MIXING
!
!  Define turbulent kinetic energy.
!
        if (Hout(idMtke)) then
          Vinfo( 1)=Vname(1,idMtke)
          Vinfo( 2)=Vname(2,idMtke)
          Vinfo( 3)=Vname(3,idMtke)
          Vinfo(14)=Vname(4,idMtke)
          Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#  endif
          status=def_var(nchisid,hisVid(idMtke),NF_FOUT,nvd4,w3dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define turbulent kinetic energy time length scale.
!
        if (Hout(idMtls)) then
          Vinfo( 1)=Vname(1,idMtls)
          Vinfo( 2)=Vname(2,idMtls)
          Vinfo( 3)=Vname(3,idMtls)
          Vinfo(14)=Vname(4,idMtls)
          Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#  endif
          status=def_var(nchisid,hisVid(idMtls),NF_FOUT,nvd4,w3dgrd,
     &                   Aval,Vinfo,hisname)
        endif
# endif
!
!  Define surface net heat flux.
!
        if (Hout(idTsur(itemp))) then
          Vinfo( 1)=Vname(1,idTsur(itemp))
          Vinfo( 2)=Vname(2,idTsur(itemp))
          Vinfo( 3)=Vname(3,idTsur(itemp))
          Vinfo(11)='upward flux, cooling'
          Vinfo(12)='downward flux, heating'
          Vinfo(14)=Vname(4,idTsur(itemp))
          Vinfo(16)=Vname(1,idtime)
          status=def_var(nchisid,hisVid(idTsur(itemp)),NF_FOUT,nvd3,
     &                   t2dgrd,Aval,Vinfo,hisname)
        endif
# ifdef BULK_FLUXES
!
!  Define latent heat flux.
!
        if (Hout(idLhea)) then
          Vinfo( 1)=Vname(1,idLhea)
          Vinfo( 2)=Vname(2,idLhea)
          Vinfo( 3)=Vname(3,idLhea)
          Vinfo(11)='upward flux, cooling'
          Vinfo(12)='downward flux, heating'
          Vinfo(14)=Vname(4,idLhea)
          Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#  endif
          status=def_var(nchisid,hisVid(idLhea),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define sensible heat flux.
!
        if (Hout(idShea)) then
          Vinfo( 1)=Vname(1,idShea)
          Vinfo( 2)=Vname(2,idShea)
          Vinfo( 3)=Vname(3,idShea)
          Vinfo(11)='upward flux, cooling'
          Vinfo(12)='downward flux, heating'
          Vinfo(14)=Vname(4,idShea)
          Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#  endif
          status=def_var(nchisid,hisVid(idShea),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define longwave radiation flux.
!
        if (Hout(idLrad)) then
          Vinfo( 1)=Vname(1,idLrad)
          Vinfo( 2)=Vname(2,idLrad)
          Vinfo( 3)=Vname(3,idLrad)
          Vinfo(11)='upward flux, cooling'
          Vinfo(12)='downward flux, heating'
          Vinfo(14)=Vname(4,idLrad)
          Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#  endif
          status=def_var(nchisid,hisVid(idLrad),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
# endif
# ifdef SHORTWAVE
!
!  Define shortwave radiation flux.
!
        if (Hout(idSrad)) then
          Vinfo( 1)=Vname(1,idSrad)
          Vinfo( 2)=Vname(2,idSrad)
          Vinfo( 3)=Vname(3,idSrad)
          Vinfo(11)='upward flux, cooling'
          Vinfo(12)='downward flux, heating'
          Vinfo(14)=Vname(4,idSrad)
          Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#  endif
          status=def_var(nchisid,hisVid(idSrad),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
# endif
#endif
!
!  Define surface U-momentum stress.
!
        if (Hout(idUsms)) then
          Vinfo( 1)=Vname(1,idUsms)
          Vinfo( 2)=Vname(2,idUsms)
          Vinfo( 3)=Vname(3,idUsms)
          Vinfo(14)=Vname(4,idUsms)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_u'
# endif
          status=def_var(nchisid,hisVid(idUsms),NF_FOUT,nvd3,u2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define surface V-momentum stress.
!
        if (Hout(idVsms)) then
          Vinfo( 1)=Vname(1,idVsms)
          Vinfo( 2)=Vname(2,idVsms)
          Vinfo( 3)=Vname(3,idVsms)
          Vinfo(14)=Vname(4,idVsms)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_v'
# endif
          status=def_var(nchisid,hisVid(idVsms),NF_FOUT,nvd3,v2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define bottom U-momentum stress.
!
        if (Hout(idUbms)) then
          Vinfo( 1)=Vname(1,idUbms)
          Vinfo( 2)=Vname(2,idUbms)
          Vinfo( 3)=Vname(3,idUbms)
          Vinfo(14)=Vname(4,idUbms)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_u'
# endif
          status=def_var(nchisid,hisVid(idUbms),NF_FOUT,nvd3,u2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define bottom V-momentum stress.
!
        if (Hout(idVbms)) then
          Vinfo( 1)=Vname(1,idVbms)
          Vinfo( 2)=Vname(2,idVbms)
          Vinfo( 3)=Vname(3,idVbms)
          Vinfo(14)=Vname(4,idVbms)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_v'
# endif
          status=def_var(nchisid,hisVid(idVbms),NF_FOUT,nvd3,v2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
#ifdef BBL
!
!  Define wind-induced, bottom U-wave stress.
!
        if (Hout(idUbws)) then
          Vinfo( 1)=Vname(1,idUbws)
          Vinfo( 2)=Vname(2,idUbws)
          Vinfo( 3)=Vname(3,idUbws)
          Vinfo(14)=Vname(4,idUbws)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_u'
# endif
          status=def_var(nchisid,hisVid(idUbws),NF_FOUT,nvd3,u2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define bottom wind-induced, bottom V-wave stress.
!
        if (Hout(idVbws)) then
          Vinfo( 1)=Vname(1,idVbws)
          Vinfo( 2)=Vname(2,idVbws)
          Vinfo( 3)=Vname(3,idVbws)
          Vinfo(14)=Vname(4,idVbws)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_v'
# endif
          status=def_var(nchisid,hisVid(idVbws),NF_FOUT,nvd3,v2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define wind-induced, bed wave excursion amplitude.
!
        if (Hout(idAbed)) then
          Vinfo( 1)=Vname(1,idAbed)
          Vinfo( 2)=Vname(2,idAbed)
          Vinfo( 3)=Vname(3,idAbed)
          Vinfo(14)=Vname(4,idAbed)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(nchisid,hisVid(idAbed),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define wind-induced, bed wave orbital U-velocity.
!
        if (Hout(idUbed)) then
          Vinfo( 1)=Vname(1,idUbed)
          Vinfo( 2)=Vname(2,idUbed)
          Vinfo( 3)=Vname(3,idUbed)
          Vinfo(14)=Vname(4,idUbed)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_u'
# endif
          status=def_var(nchisid,hisVid(idUbed),NF_FOUT,nvd3,u2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define wind-induced, bed wave orbital V-velocity.
!
        if (Hout(idVbed)) then
          Vinfo( 1)=Vname(1,idVbed)
          Vinfo( 2)=Vname(2,idVbed)
          Vinfo( 3)=Vname(3,idVbed)
          Vinfo(14)=Vname(4,idVbed)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_v'
# endif
          status=def_var(nchisid,hisVid(idVbed),NF_FOUT,nvd3,v2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define bottom U-momentum above bed.
!
        if (Hout(idUbot)) then
          Vinfo( 1)=Vname(1,idUbot)
          Vinfo( 2)=Vname(2,idUbot)
          Vinfo( 3)=Vname(3,idUbot)
          Vinfo(14)=Vname(4,idUbot)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_u'
# endif
          status=def_var(nchisid,hisVid(idUbot),NF_FOUT,nvd3,u2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define bottom V-momentum above bed.
!
        if (Hout(idVbot)) then
          Vinfo( 1)=Vname(1,idVbot)
          Vinfo( 2)=Vname(2,idVbot)
          Vinfo( 3)=Vname(3,idVbot)
          Vinfo(14)=Vname(4,idVbot)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_v'
# endif
          status=def_var(nchisid,hisVid(idVbot),NF_FOUT,nvd3,v2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define bed ripple height.
!
        if (Hout(idHrip)) then
          Vinfo( 1)=Vname(1,idHrip)
          Vinfo( 2)=Vname(2,idHrip)
          Vinfo( 3)=Vname(3,idHrip)
          Vinfo(14)=Vname(4,idHrip)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(nchisid,hisVid(idHrip),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define bed ripple length.
!
        if (Hout(idLrip)) then
          Vinfo( 1)=Vname(1,idLrip)
          Vinfo( 2)=Vname(2,idLrip)
          Vinfo( 3)=Vname(3,idLrip)
          Vinfo(14)=Vname(4,idLrip)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(nchisid,hisVid(idLrip),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define hydraulic bottom roughness.
!
        if (Hout(idZnot)) then
          Vinfo( 1)=Vname(1,idZnot)
          Vinfo( 2)=Vname(2,idZnot)
          Vinfo( 3)=Vname(3,idZnot)
          Vinfo(14)=Vname(4,idZnot)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(nchisid,hisVid(idZnot),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
!
!  Define apparent hydraulic bottom roughness.
!
        if (Hout(idZapp)) then
          Vinfo( 1)=Vname(1,idZapp)
          Vinfo( 2)=Vname(2,idZapp)
          Vinfo( 3)=Vname(3,idZapp)
          Vinfo(14)=Vname(4,idZapp)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(nchisid,hisVid(idZapp),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,hisname)
        endif
#endif
#ifdef SEDIMENT
!
!  Define bed layer sediment fraction for each size class.
!
        do i=1,NST
          if (Hout(idfrac(i))) then
            Vinfo( 1)=Vname(1,idfrac(i))
            Vinfo( 2)=Vname(2,idfrac(i))
            Vinfo( 3)=Vname(3,idfrac(i))
            Vinfo(14)=Vname(4,idfrac(i))
            Vinfo(16)=Vname(1,idtime)
            write(Vinfo(19),20) 1000.0_r8*Sd50(i)
# if defined WRITE_WATER && defined MASKING
            Vinfo(20)='mask_rho'
# endif
            status=def_var(nchisid,hisVid(idfrac(i)),NF_FOUT,nvd4,
     &                     b3dgrd,Aval,Vinfo,hisname)
          endif
        enddo
!
!  Define bed layer sediment properties.
!
        do i=1,MBEDP
          if (Hout(idSbed(i))) then
            Vinfo( 1)=Vname(1,idSbed(i))
            Vinfo( 2)=Vname(2,idSbed(i))
            Vinfo( 3)=Vname(3,idSbed(i))
            Vinfo(14)=Vname(4,idSbed(i))
            Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
            Vinfo(20)='mask_rho'
# endif
            status=def_var(nchisid,hisVid(idSbed(i)),NF_FOUT,nvd4,
     &                     b3dgrd,Aval,Vinfo,hisname)
          endif
        enddo
!
!  Define bottom sediment properties.
!
        do i=1,MBOTP
          if (Hout(idBott(i))) then
            Vinfo( 1)=Vname(1,idBott(i))
            Vinfo( 2)=Vname(2,idBott(i))
            Vinfo( 3)=Vname(3,idBott(i))
            Vinfo(14)=Vname(4,idBott(i))
            Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
            status=def_var(nchisid,hisVid(idBott(i)),NF_FOUT,nvd3,
     &                     t2dgrd,Aval,Vinfo,hisname)
          endif
        enddo
#endif
!
!---------------------------------------------------------------------
!  Leave definition mode.
!---------------------------------------------------------------------
!
        status=nf_enddef(nchisid)
!
!---------------------------------------------------------------------
!  Write out time-recordless, information variables.
!---------------------------------------------------------------------
!
        status=wrt_info(nchisid,hisname)
        if (exit_flag.ne.0) return
      else
!
!=====================================================================
!  Open an existing history file, check its contents, and prepare for
!  appending data.
!=====================================================================
!
!  Inquire about the contents of history NetCDF file:  Inquire about
!  the dimensions and variables.  Check for consistency.
!
        ifield=0
        call opencdf (hisname,Nlev,ifield,nrec)
        if (exit_flag.ne.0) return
!
!  Open history file for read/write.
!
        lstr=lenstr(hisname)
        status=nf_open(hisname(1:lstr),nf_write,nchisid)
        if (status.ne.nf_noerr) then
          write(stdout,30) hisname(1:lstr)
          exit_flag=3
          return
        endif
!
!  Initialize logical switches.
!
        do i=1,NV
          got_var(i)=.false.
        enddo
#ifdef SOLVE3D
        do itrc=1,NT
          got_trc(itrc)=.false.
        enddo
#endif
!
!  Scan variable list from input NetCDF and activate switches for
!  history variables. Get variable IDs.
!
        do i=1,nvars
          lvar=lenstr(varnam(i))
          lsvar=lenstr(Vname(1,idtime))
          if (varnam(i)(1:lvar).eq.Vname(1,idtime)(1:lsvar)) then
            got_var(idtime)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idtime)(1:lsvar),
     &                          hisVid(idtime))
          endif
          lsvar=lenstr(Vname(1,idFsur))
          if (varnam(i)(1:lvar).eq.Vname(1,idFsur)(1:lsvar)) then
            got_var(idFsur)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idFsur)(1:lsvar),
     &                          hisVid(idFsur))
          endif
          lsvar=lenstr(Vname(1,idUbar))
          if (varnam(i)(1:lvar).eq.Vname(1,idUbar)(1:lsvar)) then
            got_var(idUbar)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idUbar)(1:lsvar),
     &                          hisVid(idUbar))
          endif
          lsvar=lenstr(Vname(1,idVbar))
          if (varnam(i)(1:lvar).eq.Vname(1,idVbar)(1:lsvar)) then
            got_var(idVbar)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idVbar)(1:lsvar),
     &                          hisVid(idVbar))
          endif
#ifdef SOLVE3D
          lsvar=lenstr(Vname(1,idUvel))
          if (varnam(i)(1:lvar).eq.Vname(1,idUvel)(1:lsvar)) then
            got_var(idUvel)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idUvel)(1:lsvar),
     &                          hisVid(idUvel))
          endif
          lsvar=lenstr(Vname(1,idVvel))
          if (varnam(i)(1:lvar).eq.Vname(1,idVvel)(1:lsvar)) then
            got_var(idVvel)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idVvel)(1:lsvar),
     &                          hisVid(idVvel))
          endif
          lsvar=lenstr(Vname(1,idWvel))
          if (varnam(i)(1:lvar).eq.Vname(1,idWvel)(1:lsvar)) then
            got_var(idWvel)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idWvel)(1:lsvar),
     &                          hisVid(idWvel))
          endif
          lsvar=lenstr(Vname(1,idOvel))
          if (varnam(i)(1:lvar).eq.Vname(1,idOvel)(1:lsvar)) then
            got_var(idOvel)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idOvel)(1:lsvar),
     &                          hisVid(idOvel))
          endif
          do itrc=1,NT
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            if (varnam(i)(1:lvar).eq.
     &          Vname(1,idTvar(itrc))(1:lsvar)) then
              got_trc(itrc)=.true.
              status=nf_inq_varid(nchisid,
     &                            Vname(1,idTvar(itrc))(1:lsvar),
     &                            hisTid(itrc))
            endif
          enddo
          lsvar=lenstr(Vname(1,idDano))
          if (varnam(i)(1:lvar).eq.Vname(1,idDano)(1:lsvar)) then
            got_var(idDano)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idDano)(1:lsvar),
     &                          hisVid(idDano))
          endif
# ifdef LMD_SKPP
          lsvar=lenstr(Vname(1,idHsbl))
          if (varnam(i)(1:lvar).eq.Vname(1,idHsbl)(1:lsvar)) then
            got_var(idHsbl)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idHsbl)(1:lsvar),
     &                          hisVid(idHsbl))
          endif
# endif
# ifdef LMD_BKPP
          lsvar=lenstr(Vname(1,idHbbl))
          if (varnam(i)(1:lvar).eq.Vname(1,idHbbl)(1:lsvar)) then
            got_var(idHbbl)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idHbbl)(1:lsvar),
     &                          hisVid(idHbbl))
          endif
# endif
          lsvar=lenstr(Vname(1,idVvis))
          if (varnam(i)(1:lvar).eq.Vname(1,idVvis)(1:lsvar)) then
            got_var(idVvis)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idVvis)(1:lsvar),
     &                          hisVid(idVvis))
          endif
          lsvar=lenstr(Vname(1,idTdif))
          if (varnam(i)(1:lvar).eq.Vname(1,idTdif)(1:lsvar)) then
            got_var(idTdif)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idTdif)(1:lsvar),
     &                          hisVid(idTdif))
          endif
          lsvar=lenstr(Vname(1,idSdif))
          if (varnam(i)(1:lvar).eq.Vname(1,idSdif)(1:lsvar)) then
            got_var(idSdif)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idSdif)(1:lsvar),
     &                          hisVid(idSdif))
          endif
# if defined GLS_MIXING || defined MY25_MIXING
          lsvar=lenstr(Vname(1,idMtke))
          if (varnam(i)(1:lvar).eq.Vname(1,idMtke)(1:lsvar)) then
            got_var(idMtke)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idMtke)(1:lsvar),
     &                          hisVid(idMtke))
          endif
          lsvar=lenstr(Vname(1,idMtls))
          if (varnam(i)(1:lvar).eq.Vname(1,idMtls)(1:lsvar)) then
            got_var(idMtls)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idMtls)(1:lsvar),
     &                          hisVid(idMtls))
          endif
# endif
          lsvar=lenstr(Vname(1,idTsur(itemp)))
          if (varnam(i)(1:lvar).eq.
     &        Vname(1,idTsur(itemp))(1:lsvar)) then
            got_var(idTsur(itemp))=.true.
            status=nf_inq_varid(nchisid,
     &                          Vname(1,idTsur(itemp))(1:lsvar),
     &                          hisVid(idTsur(itemp)))
          endif
# ifdef BULK_FLUXES
          lsvar=lenstr(Vname(1,idLhea))
          if (varnam(i)(1:lvar).eq.Vname(1,idLhea)(1:lsvar)) then
            got_var(idLhea)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idLhea)(1:lsvar),
     &                          hisVid(idLhea))
          endif
          lsvar=lenstr(Vname(1,idShea))
          if (varnam(i)(1:lvar).eq.Vname(1,idShea)(1:lsvar)) then
            got_var(idShea)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idShea)(1:lsvar),
     &                          hisVid(idShea))
          endif
          lsvar=lenstr(Vname(1,idLrad))
          if (varnam(i)(1:lvar).eq.Vname(1,idLrad)(1:lsvar)) then
            got_var(idLrad)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idLrad)(1:lsvar),
     &                          hisVid(idLrad))
          endif
# endif
# ifdef SHORTWAVE
          lsvar=lenstr(Vname(1,idSrad))
          if (varnam(i)(1:lvar).eq.Vname(1,idSrad)(1:lsvar)) then
            got_var(idSrad)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idSrad)(1:lsvar),
     &                          hisVid(idSrad))
          endif
# endif
# ifdef SEDIMENT
          do itrc=1,NST
            lsvar=lenstr(Vname(1,idfrac(itrc)))
            if (varnam(i)(1:lvar).eq.
     &          Vname(1,idfrac(itrc))(1:lsvar)) then
              got_var(idfrac(itrc))=.true.
              status=nf_inq_varid(nchisid,
     &                            Vname(1,idfrac(itrc))(1:lsvar),
     &                            hisVid(idfrac(itrc)))
            endif
          enddo
          do itrc=1,MBEDP
            lsvar=lenstr(Vname(1,idSbed(itrc)))
            if (varnam(i)(1:lvar).eq.
     &          Vname(1,idSbed(itrc))(1:lsvar)) then
              got_var(idSbed(itrc))=.true.
              status=nf_inq_varid(nchisid,
     &                            Vname(1,idSbed(itrc))(1:lsvar),
     &                            hisVid(idSbed(itrc)))
            endif
          enddo
          do itrc=1,MBOTP
            lsvar=lenstr(Vname(1,idBott(itrc)))
            if (varnam(i)(1:lvar).eq.
     &          Vname(1,idBott(itrc))(1:lsvar)) then
              got_var(idBott(itrc))=.true.
              status=nf_inq_varid(nchisid,
     &                            Vname(1,idBott(itrc))(1:lsvar),
     &                            hisVid(idBott(itrc)))
            endif
          enddo
# endif
#endif
          lsvar=lenstr(Vname(1,idUsms))
          if (varnam(i)(1:lvar).eq.Vname(1,idUsms)(1:lsvar)) then
            got_var(idUsms)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idUsms)(1:lsvar),
     &                          hisVid(idUsms))
          endif
          lsvar=lenstr(Vname(1,idVsms))
          if (varnam(i)(1:lvar).eq.Vname(1,idVsms)(1:lsvar)) then
            got_var(idVsms)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idVsms)(1:lsvar),
     &                          hisVid(idVsms))
          endif
          lsvar=lenstr(Vname(1,idUbms))
          if (varnam(i)(1:lvar).eq.Vname(1,idUbms)(1:lsvar)) then
            got_var(idUbms)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idUbms)(1:lsvar),
     &                          hisVid(idUbms))
          endif
          lsvar=lenstr(Vname(1,idVbms))
          if (varnam(i)(1:lvar).eq.Vname(1,idVbms)(1:lsvar)) then
            got_var(idVbms)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idVbms)(1:lsvar),
     &                          hisVid(idVbms))
          endif
#ifdef BBL
          lsvar=lenstr(Vname(1,idUbws))
          if (varnam(i)(1:lvar).eq.Vname(1,idUbws)(1:lsvar)) then
            got_var(idUbws)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idUbws)(1:lsvar),
     &                          hisVid(idUbws))
          endif
          lsvar=lenstr(Vname(1,idVbws))
          if (varnam(i)(1:lvar).eq.Vname(1,idVbws)(1:lsvar)) then
            got_var(idVbws)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idVbws)(1:lsvar),
     &                          hisVid(idVbws))
          endif
          lsvar=lenstr(Vname(1,idAbed))
          if (varnam(i)(1:lvar).eq.Vname(1,idAbed)(1:lsvar)) then
            got_var(idAbed)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idAbed)(1:lsvar),
     &                          hisVid(idAbed))
          endif
          lsvar=lenstr(Vname(1,idUbed))
          if (varnam(i)(1:lvar).eq.Vname(1,idUbed)(1:lsvar)) then
            got_var(idUbed)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idUbed)(1:lsvar),
     &                          hisVid(idUbed))
          endif
          lsvar=lenstr(Vname(1,idVbed))
          if (varnam(i)(1:lvar).eq.Vname(1,idVbed)(1:lsvar)) then
            got_var(idVbed)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idVbed)(1:lsvar),
     &                          hisVid(idVbed))
          endif
          lsvar=lenstr(Vname(1,idUbot))
          if (varnam(i)(1:lvar).eq.Vname(1,idUbot)(1:lsvar)) then
            got_var(idUbot)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idUbot)(1:lsvar),
     &                          hisVid(idUbot))
          endif
          lsvar=lenstr(Vname(1,idVbot))
          if (varnam(i)(1:lvar).eq.Vname(1,idVbot)(1:lsvar)) then
            got_var(idVbot)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idVbot)(1:lsvar),
     &                          hisVid(idVbot))
          endif
          lsvar=lenstr(Vname(1,idHrip))
          if (varnam(i)(1:lvar).eq.Vname(1,idHrip)(1:lsvar)) then
            got_var(idHrip)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idHrip)(1:lsvar),
     &                          hisVid(idHrip))
          endif
          lsvar=lenstr(Vname(1,idLrip))
          if (varnam(i)(1:lvar).eq.Vname(1,idLrip)(1:lsvar)) then
            got_var(idLrip)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idLrip)(1:lsvar),
     &                          hisVid(idLrip))
          endif
          lsvar=lenstr(Vname(1,idZnot))
          if (varnam(i)(1:lvar).eq.Vname(1,idZnot)(1:lsvar)) then
            got_var(idZnot)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idZnot)(1:lsvar),
     &                          hisVid(idZnot))
          endif
          lsvar=lenstr(Vname(1,idZapp))
          if (varnam(i)(1:lvar).eq.Vname(1,idZapp)(1:lsvar)) then
            got_var(idZapp)=.true.
            status=nf_inq_varid(nchisid,Vname(1,idZapp)(1:lsvar),
     &                          hisVid(idZapp))
          endif
#endif
        enddo
!
!  Check if history variables are available in input NetCDF file.
!
        if (.not.got_var(idtime)) then
          lsvar=lenstr(Vname(1,idtime))
          write(stdout,40) Vname(1,idtime)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idFsur).and.Hout(idFsur)) then
          lsvar=lenstr(Vname(1,idFsur))
          write(stdout,40) Vname(1,idFsur)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idUbar).and.Hout(idUbar)) then
          lsvar=lenstr(Vname(1,idUbar))
          write(stdout,40) Vname(1,idUbar)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVbar).and.Hout(idVbar)) then
          lsvar=lenstr(Vname(1,idVbar))
          write(stdout,40) Vname(1,idVbar)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
#ifdef SOLVE3D
        if (.not.got_var(idUvel).and.Hout(idUvel)) then
          lsvar=lenstr(Vname(1,idUvel))
          write(stdout,40) Vname(1,idUvel)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVvel).and.Hout(idVvel)) then
          lsvar=lenstr(Vname(1,idVvel))
          write(stdout,40) Vname(1,idVvel)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idWvel).and.Hout(idWvel)) then
          lsvar=lenstr(Vname(1,idWvel))
          write(stdout,40) Vname(1,idWvel)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idOvel).and.Hout(idOvel)) then
          lsvar=lenstr(Vname(1,idOvel))
          write(stdout,40) Vname(1,idOvel)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        do itrc=1,NT
          if (.not.got_trc(itrc).and.Hout(idTvar(itrc))) then
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            write(stdout,40) Vname(1,idTvar(itrc))(1:lsvar),
     &                       hisname(1:lstr)
            exit_flag=3
            return
          endif
        enddo
        if (.not.got_var(idDano).and.Hout(idDano)) then
          lsvar=lenstr(Vname(1,idDano))
          write(stdout,40) Vname(1,idDano)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
# ifdef LMD_SKPP
        if (.not.got_var(idHsbl).and.Hout(idHsbl)) then
          lsvar=lenstr(Vname(1,idHsbl))
          write(stdout,40) Vname(1,idHsbl)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
# endif
# ifdef LMD_BKPP
        if (.not.got_var(idHbbl).and.Hout(idHbbl)) then
          lsvar=lenstr(Vname(1,idHbbl))
          write(stdout,40) Vname(1,idHbbl)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
# endif
        if (.not.got_var(idVvis).and.Hout(idVvis)) then
          lsvar=lenstr(Vname(1,idVvis))
          write(stdout,40) Vname(1,idVvis)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idTdif).and.Hout(idTdif)) then
          lsvar=lenstr(Vname(1,idTdif))
          write(stdout,40) Vname(1,idTdif)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
# ifdef SALINITY
        if (.not.got_var(idSdif).and.Hout(idSdif)) then
          lsvar=lenstr(Vname(1,idSdif))
          write(stdout,40) Vname(1,idSdif)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
# endif
# if defined GLS_MIXING || defined MY25_MIXING
        if (.not.got_var(idMtke).and.Hout(idMtke)) then
          lsvar=lenstr(Vname(1,idMtke))
          write(stdout,40) Vname(1,idMtke)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idMtls).and.Hout(idMtls)) then
          lsvar=lenstr(Vname(1,idMtls))
          write(stdout,40) Vname(1,idMtls)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
# endif
        if (.not.got_var(idTsur(itemp)).and.Hout(idTsur(itemp))) then
          lsvar=lenstr(Vname(1,idTsur(itemp)))
          write(stdout,40) Vname(1,idTsur(itemp))(1:lsvar),
     &                     hisname(1:lstr)
          exit_flag=3
          return
        endif
# ifdef BULK_FLUXES
        if (.not.got_var(idLhea).and.Hout(idLhea)) then
          lsvar=lenstr(Vname(1,idLhea))
          write(stdout,40) Vname(1,idLhea)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idShea).and.Hout(idShea)) then
          lsvar=lenstr(Vname(1,idShea))
          write(stdout,40) Vname(1,idShea)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idLrad).and.Hout(idLrad)) then
          lsvar=lenstr(Vname(1,idLrad))
          write(stdout,40) Vname(1,idLrad)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
# endif
# ifdef SHORTWAVE
        if (.not.got_var(idSrad).and.Hout(idSrad)) then
          lsvar=lenstr(Vname(1,idSrad))
          write(stdout,40) Vname(1,idSrad)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
# endif
# ifdef SEDIMENT
        do itrc=1,NST
          if (.not.got_var(idfrac(itrc)).and.Hout(idfrac(itrc))) then
            lsvar=lenstr(Vname(1,idfrac(itrc)))
            write(stdout,40) Vname(1,idfrac(itrc))(1:lsvar),
     &                       hisname(1:lstr)
            exit_flag=3
            return
          endif
        enddo
        do itrc=1,MBEDP
          if (.not.got_var(idSbed(itrc)).and.Hout(idSbed(itrc))) then
            lsvar=lenstr(Vname(1,idSbed(itrc)))
            write(stdout,40) Vname(1,idSbed(itrc))(1:lsvar),
     &                       hisname(1:lstr)
            exit_flag=3
            return
          endif
        enddo
        do itrc=1,MBOTP
          if (.not.got_var(idBott(itrc)).and.Hout(idBott(itrc))) then
            lsvar=lenstr(Vname(1,idBott(itrc)))
            write(stdout,40) Vname(1,idBott(itrc))(1:lsvar),
     &                       hisname(1:lstr)
            exit_flag=3
            return
          endif
        enddo
# endif
#endif
        if (.not.got_var(idUsms).and.Hout(idUsms)) then
          lsvar=lenstr(Vname(1,idUsms))
          write(stdout,40) Vname(1,idUsms)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVsms).and.Hout(idVsms)) then
          lsvar=lenstr(Vname(1,idVsms))
          write(stdout,40) Vname(1,idVsms)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idUbms).and.Hout(idUbms)) then
          lsvar=lenstr(Vname(1,idUbms))
          write(stdout,40) Vname(1,idUbms)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVbms).and.Hout(idVbms)) then
          lsvar=lenstr(Vname(1,idVbms))
          write(stdout,40) Vname(1,idVbms)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
#ifdef BBL
        if (.not.got_var(idUbws).and.Hout(idUbws)) then
          lsvar=lenstr(Vname(1,idUbws))
          write(stdout,40) Vname(1,idUbws)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVbws).and.Hout(idVbws)) then
          lsvar=lenstr(Vname(1,idVbws))
          write(stdout,40) Vname(1,idVbws)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idAbed).and.Hout(idAbed)) then
          lsvar=lenstr(Vname(1,idAbed))
          write(stdout,40) Vname(1,idAbed)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idUbed).and.Hout(idUbed)) then
          lsvar=lenstr(Vname(1,idUbed))
          write(stdout,40) Vname(1,idUbed)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVbed).and.Hout(idVbed)) then
          lsvar=lenstr(Vname(1,idVbed))
          write(stdout,40) Vname(1,idVbed)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idUbot).and.Hout(idUbot)) then
          lsvar=lenstr(Vname(1,idUbot))
          write(stdout,40) Vname(1,idUbot)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVbot).and.Hout(idVbot)) then
          lsvar=lenstr(Vname(1,idVbot))
          write(stdout,40) Vname(1,idVbot)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idHrip).and.Hout(idHrip)) then
          lsvar=lenstr(Vname(1,idHrip))
          write(stdout,40) Vname(1,idHrip)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idLrip).and.Hout(idLrip)) then
          lsvar=lenstr(Vname(1,idLrip))
          write(stdout,40) Vname(1,idLrip)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idZnot).and.Hout(idZnot)) then
          lsvar=lenstr(Vname(1,idZnot))
          write(stdout,40) Vname(1,idZnot)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idZapp).and.Hout(idZapp)) then
          lsvar=lenstr(Vname(1,idZapp))
          write(stdout,40) Vname(1,idZapp)(1:lsvar), hisname(1:lstr)
          exit_flag=3
          return
        endif
#endif
!
!  Set unlimited time record dimension to the appropriate value.
!
!!      thisindx=tsize
        if (ndefhis.gt.0) then
          if ((ntstart-1).lt.ndefhis) then
            thisindx=1+((ntstart-1)-ndefhis*((ntstart-1)/ndefhis))/nhis
          else
            thisindx=((ntstart-1)-ndefhis*((ntstart-1)/ndefhis))/nhis
          endif
        else
          thisindx=(ntstart-1)/nhis
        endif
        thisindx=MIN(thisindx,tsize)
      endif
!
  10  format(/,' DEF_HIS - unable to create history NetCDF file: ',a)
  20  format(1pe11.4,1x,'millimeter')
  30  format(/,' DEF_HIS - unable to open history NetCDF file: ',a)
  40  format(/,' DEF_HIS - unable to find variable: ',a,2x,
     &         ' in history NetCDF file: ',a)
      return
      end
