#include "cppdefs.h"
      subroutine def_floats
#ifdef FLOATS
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine creates FLOATS NetCDF file, it defines dimensions,   !
!  attributes, and variables.                                        !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "grid.h"
# include "floats.h"
# include "iounits.h"
# include "ncparam.h"
# include "netcdf.inc"
# include "scalars.h"
!
      logical got_var(-6:NV)
      INTEGER_TYPE
     &        Natt
      parameter (Natt=20)
      INTEGER_TYPE
     &        i, ifield, iflt, lstr, lsvar, lvar, nrec, recdim,
     &        fltdim, status
      INTEGER_TYPE
     &        DimIDs(24), count(2), fgrd(2), start(2)
      INTEGER_TYPE
     &        def_info, def_var, lenstr, wrt_info
# ifdef SOLVE3D
      logical got_trc(NT)
      INTEGER_TYPE
     &        itrc
# endif /* SOLVE3D */
      REAL_TYPE
     &        Aval(4), Tinp(Mfloats)
      character*65 Vinfo(Natt), dimnam
!
!=====================================================================
!  Create a new floats data file.
!=====================================================================
!
!  Deactivate file creation, if a restart run.
!
      if (frrec.ne.0) LdefFLT=.false.
!
!  Create floats NetCDF file.
!
      if (exit_flag.ne.0) return
      if (LdefFLT) then
        lstr=lenstr(fltname)
        status=nf_create(fltname(1:lstr),nf_clobber,ncfltid)
        if (status.ne.nf_noerr) then
          write(stdout,10) fltname(1:lstr)
          exit_flag=3
          return
        endif
!
!---------------------------------------------------------------------
!  Define the dimensions of staggered fields.
!---------------------------------------------------------------------
!
# ifdef SOLVE3D
        status=nf_def_dim(ncfltid,'s_rho'  ,N   ,DimIDs( 9))
        status=nf_def_dim(ncfltid,'s_w'    ,N   ,DimIDs(10))
        status=nf_def_dim(ncfltid,'tracer' ,NT  ,DimIDs(11))
#  ifdef SEDIMENT
        status=nf_def_dim(ncfltid,'Nbed'   ,Nbed,DimIDs(16))
#  endif /* SEDIMENT */
# endif /* SOLVE3D */
        status=nf_def_dim(ncfltid,'drifter',nfloats,DimIDs(15))
        status=nf_def_dim(ncfltid,'boundary',4,DimIDs(14))
        status=nf_def_dim(ncfltid,'time',
     &                    nf_unlimited,DimIDs(12))
        recdim=DimIDs(12)
        fltdim=DimIDs(15)
!
!  Define dimension vectors for point variables.
!
        fgrd(1)=DimIDs(15)
        fgrd(2)=DimIDs(12)
!
!  Initialize unlimited time record dimension.
!
        tfltindx=0
!
!  Initialize local information variable arrays.
!
        do i=1,Natt
          Vinfo(i)=' '
        enddo
        do i=1,4
          Aval(i)=0.0_r8
        enddo
!
!---------------------------------------------------------------------
!  Define time-recordless information variables.
!---------------------------------------------------------------------
!
        status=def_info(ncfltid,fltname,DimIDs)
        if (exit_flag.ne.0) return
!
!---------------------------------------------------------------------
!  Define variables and their attributes.
!---------------------------------------------------------------------
!
!  Define model time.
!
        Vinfo( 1)=Vname(1,idtime)
        Vinfo( 2)=Vname(2,idtime)
        if (INT(time_ref).eq.-2) then
          Vinfo( 3)='seconds since 1968-05-23 00:00:00 GMT'
          Vinfo( 4)='modified Julian day number'
          Vinfo(18)='add_offset'
          Aval(1)=jul_off
        elseif (INT(time_ref).eq.-1) then
          Vinfo( 3)='seconds since 0000-01-01 00:00:00'
          Vinfo( 4)='360 days in every year, 30 days in each month'
        elseif (INT(time_ref).eq.0) then
          Vinfo( 3)='seconds since 0000-01-01 00:00:00'
          Vinfo( 4)='365.25 days in every year'
        elseif (time_ref.gt.0.0_r8) then
          Vinfo( 3)='seconds since '/ /r_text
        endif
        Vinfo(14)=Vname(4,idtime)
        status=def_var(ncfltid,fltVid(idtime),NF_FTYPE,1,recdim,Aval,
     &                 Vinfo,fltname)
!
!  Define floats X-grid locations.
!
        Vinfo( 1)='Xgrid'
        Vinfo( 2)='x-grid floats locations'
        Vinfo( 3)='nondimensional'
        Vinfo( 5)='valid_min'
        Vinfo( 6)='valid_max'
        Aval(2)=0.0_r8
        Aval(3)=FLOAT(L)
        Vinfo(14)='Xgrid, scalar, series'
        Vinfo(16)=Vname(1,idtime)
        Vinfo(17)='missing_value'
        Aval(4)=spval
        status=def_var(ncfltid,fltVid(idXgrd),NF_FOUT,2,fgrd,Aval,
     &                 Vinfo,fltname)
!
!  Define floats Y-grid locations.
!
        Vinfo( 1)='Ygrid'
        Vinfo( 2)='Y-grid floats locations'
        Vinfo( 3)='nondimensional'
        Vinfo( 5)='valid_min'
        Vinfo( 6)='valid_max'
        Aval(2)=0.0_r8
        Aval(3)=FLOAT(M)
        Vinfo(14)='Ygrid, scalar, series'
        Vinfo(16)=Vname(1,idtime)
        Vinfo(17)='missing_value'
        Aval(4)=spval
        status=def_var(ncfltid,fltVid(idYgrd),NF_FOUT,2,fgrd,Aval,
     &                 Vinfo,fltname)
# ifdef SOLVE3D
!
!  Define floats Z-grid locations.
!
        Vinfo( 1)='Zgrid'
        Vinfo( 2)='Z-grid floats locations'
        Vinfo( 3)='nondimensional'
        Vinfo( 5)='valid_min'
        Vinfo( 6)='valid_max'
        Aval(2)=0.0_r8
        Aval(3)=FLOAT(N)
        Vinfo(14)='Zgrid, scalar, series'
        Vinfo(16)=Vname(1,idtime)
        Vinfo(17)='missing_value'
        Aval(4)=spval
        status=def_var(ncfltid,fltVid(idZgrd),NF_FOUT,2,fgrd,Aval,
     &                 Vinfo,fltname)
# endif /* SOLVE3D */
!
!  Define floats (lon,lat) or (x,y) locations.
!
        if (spherical) then
          Vinfo( 1)='lon'
          Vinfo( 2)='longitude of floats trajectories'
          Vinfo( 3)='degree_east'
          Vinfo( 5)='valid_min'
          Vinfo( 6)='valid_max'
          Vinfo(14)='lon, scalar, series'
          Vinfo(16)=Vname(1,idtime)
          Vinfo(17)='missing_value'
          Aval(2)=-180.0_r8
          Aval(3)=180.0_r8
          Aval(4)=spval
          status=def_var(ncfltid,fltVid(idglon),NF_FOUT,2,fgrd,Aval,
     &                   Vinfo,fltname)
          Vinfo( 1)='lat'
          Vinfo( 2)='latitude of floats trajectories'
          Vinfo( 3)='degree_north'
          Vinfo( 5)='valid_min'
          Vinfo( 6)='valid_max'
          Vinfo(14)='lat, scalar, series'
          Vinfo(16)=Vname(1,idtime)
          Vinfo(17)='missing_value'
          Aval(2)=-90.0_r8
          Aval(3)=90.0_r8
          Aval(4)=spval
          status=def_var(ncfltid,fltVid(idglat),NF_FOUT,2,fgrd,Aval,
     &                   Vinfo,fltname)
       else
          Vinfo( 1)='x'
          Vinfo( 2)='x-location of floats trajectories'
          Vinfo( 3)='meter'
          Vinfo(14)='x, scalar, series'
          Vinfo(16)=Vname(1,idtime)
          Vinfo(17)='missing_value'
          Aval(4)=spval
          status=def_var(ncfltid,fltVid(idglon),NF_FOUT,2,fgrd,Aval,
     &                   Vinfo,fltname)
          Vinfo( 1)='y'
          Vinfo( 2)='y-location of floats trajectories'
          Vinfo( 3)='meter'
          Vinfo(14)='y, scalar, series'
          Vinfo(16)=Vname(1,idtime)
          Vinfo(17)='missing_value'
          Aval(4)=spval
          status=def_var(ncfltid,fltVid(idglat),NF_FOUT,2,fgrd,Aval,
     &                   Vinfo,fltname)
        endif
# ifdef SOLVE3D
!
!  Define floats depths.
!
        Vinfo( 1)='depth'
        Vinfo( 2)='depth of floats trajectories'
        Vinfo( 3)='meter'
        Vinfo(14)='depth, scalar, series'
        Vinfo(16)=Vname(1,idtime)
        Vinfo(17)='missing_value'
        Aval(4)=spval
        status=def_var(ncfltid,fltVid(iddpth),NF_FOUT,2,fgrd,Aval,
     &                 Vinfo,fltname)
!
!  Define density anomaly.
!
        Vinfo( 1)=Vname(1,idDano)
        Vinfo( 2)=Vname(2,idDano)
        Vinfo( 3)=Vname(3,idDano)
        Vinfo(14)=Vname(4,idDano)
        Vinfo(16)=Vname(1,idtime)
        Vinfo(17)='missing_value'
        Aval(4)=spval
        status=def_var(ncfltid,fltVid(idDano),NF_FOUT,2,fgrd,Aval,
     &                 Vinfo,fltname)
!
!  Define tracer type variables.
!
        do itrc=1,NT
          Vinfo( 1)=Vname(1,idTvar(itrc))
          Vinfo( 2)=Vname(2,idTvar(itrc))
          Vinfo( 3)=Vname(3,idTvar(itrc))
          Vinfo(14)=Vname(4,idTvar(itrc))
          Vinfo(16)=Vname(1,idtime)
          Vinfo(17)='missing_value'
          Aval(4)=spval
# ifdef SEDIMENT
          do i=1,NST
            if (itrc.eq.idsed(i)) then
              write(Vinfo(19),20) 1000.0_r8*Sd50(i)
            endif
          enddo
# endif
          status=def_var(ncfltid,fltTid(itrc),NF_FOUT,2,fgrd,Aval,
     &                   Vinfo,fltname)
        enddo
# endif /* SOLVE3D */
!
!  Initialize unlimited time record dimension.
!
        tfltindx=0
!
!---------------------------------------------------------------------
!  Leave definition mode.
!---------------------------------------------------------------------
!
        status=nf_enddef(ncfltid)
!
!---------------------------------------------------------------------
!  Write out time-recordless, information variables.
!---------------------------------------------------------------------
!
        status=wrt_info(ncfltid,fltname)
        if (exit_flag.ne.0) return
      else
!
!=====================================================================
!  Open an existing floats file, check its contents, and prepare for
!  appending data.
!=====================================================================
!
!  Inquire about the contents of floats NetCDF file:  Inquire about
!  the dimensions and variables.  Check for consistency.
!
        ifield=0
        call opencdf (fltname,N,ifield,nrec)
        if (exit_flag.ne.0) return
!
!  Open floats file for read/write.
!
        lstr=lenstr(fltname)
        status=nf_open(fltname(1:lstr),nf_write,ncfltid)
        if (status.ne.nf_noerr) then
          write(stdout,30) fltname(1:lstr)
          exit_flag=3
          return
        endif
!
!  Initialize logical switches.
!
        do i=1,NV
          got_var(i)=.false.
        enddo
# ifdef SOLVE3D
        do itrc=1,NT
          got_trc(itrc)=.false.
        enddo
# endif /* SOLVE3D */
!
!  Inquire size of the "drifter" dimension.
!
        status=nf_inq_dimid(ncfltid,'drifter',fltdim)
        if (status.ne.nf_noerr) then
          write(stdout,40) 'drifter', fltname(1:lstr)
          exit_flag=3
          return
        endif
        status=nf_inq_dim(ncfltid,fltdim,dimnam,nfloats)
        if (status.ne.nf_noerr) then
          write(stdout,50) 'drifter', fltname(1:lstr)
          exit_flag=3
          return
        endif
!
!  Scan variable list from input NetCDF and activate switches for
!  float variables. Get variable IDs.
!
        do i=1,nvars
          lvar=lenstr(varnam(i))
          lsvar=lenstr(Vname(1,idtime))
          if (varnam(i)(1:lvar).eq.Vname(1,idtime)(1:lsvar)) then
            got_var(idtime)=.true.
            status=nf_inq_varid(ncfltid,Vname(1,idtime)(1:lsvar),
     &                          fltVid(idtime))
          endif
          if (varnam(i)(1:lvar).eq.'Xgrid') then
            got_var(idXgrd)=.true.
            status=nf_inq_varid(ncfltid,'Xgrid',fltVid(idXgrd))
          endif
          if (varnam(i)(1:lvar).eq.'Ygrid') then
            got_var(idYgrd)=.true.
            status=nf_inq_varid(ncfltid,'Ygrid',fltVid(idYgrd))
          endif
# ifdef SOLVE3D
          if (varnam(i)(1:lvar).eq.'Zgrid') then
            got_var(idZgrd)=.true.
            status=nf_inq_varid(ncfltid,'Zgrid',fltVid(idZgrd))
          endif
# endif /* SOLVE3D */
          if (spherical) then
            if (varnam(i)(1:lvar).eq.'lon') then
              got_var(idglon)=.true.
              status=nf_inq_varid(ncfltid,'lon',fltVid(idglon))
            endif
            if (varnam(i)(1:lvar).eq.'lat') then
              got_var(idglat)=.true.
              status=nf_inq_varid(ncfltid,'lat',fltVid(idglat))
            endif
          else
            if (varnam(i)(1:lvar).eq.'x') then
              got_var(idglon)=.true.
              status=nf_inq_varid(ncfltid,'x',fltVid(idglon))
            endif
            if (varnam(i)(1:lvar).eq.'y') then
              got_var(idglat)=.true.
              status=nf_inq_varid(ncfltid,'y',fltVid(idglat))
            endif
          endif
# ifdef SOLVE3D
          if (varnam(i)(1:lvar).eq.'depth') then
            got_var(iddpth)=.true.
            status=nf_inq_varid(ncfltid,'depth',fltVid(iddpth))
          endif
          lsvar=lenstr(Vname(1,idDano))
          if (varnam(i)(1:lvar).eq.Vname(1,idDano)(1:lsvar)) then
            got_var(idDano)=.true.
            status=nf_inq_varid(ncfltid,Vname(1,idDano)(1:lsvar),
     &                          fltVid(idDano))
          endif
          do itrc=1,NT
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            if (varnam(i)(1:lvar).eq.
     &          Vname(1,idTvar(itrc))(1:lsvar)) then
             got_trc(itrc)=.true.
             status=nf_inq_varid(ncfltid,
     &                           Vname(1,idTvar(itrc))(1:lsvar),
     &                           fltTid(itrc))
            endif
          enddo
# endif /* SOLVE3D */
        enddo
!
!  Check if floats variables are available in input NetCDF file.
!
        if (.not.got_var(idtime)) then
          lsvar=lenstr(Vname(1,idtime))
          write(stdout,60) Vname(1,idtime)(1:lsvar), fltname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idXgrd)) then
          write(stdout,60) 'Xgrid', fltname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idYgrd)) then
          write(stdout,60) 'Ygrid', fltname(1:lstr)
          exit_flag=3
          return
        endif
# ifdef SOLVE3D
        if (.not.got_var(idZgrd)) then
          write(stdout,60) 'Zgrid', fltname(1:lstr)
          exit_flag=3
          return
        endif
# endif
        if (.not.got_var(idglon)) then
          if (spherical) then
            write(stdout,60) 'lon', fltname(1:lstr)
          else
            write(stdout,60) 'x', fltname(1:lstr)
          endif
          exit_flag=3
          return
        endif
        if (.not.got_var(idglat)) then
          if (spherical) then
            write(stdout,60) 'lat', fltname(1:lstr)
          else
            write(stdout,60) 'y', fltname(1:lstr)
          endif
          exit_flag=3
          return
        endif
# ifdef SOLVE3D
        if (.not.got_var(iddpth)) then
          write(stdout,60) 'depth', fltname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idDano)) then
          lsvar=lenstr(Vname(1,idDano))
          write(stdout,60) Vname(1,idDano)(1:lsvar), fltname(1:lstr)
          exit_flag=3
          return
        endif
        do itrc=1,NT
          if (.not.got_trc(itrc)) then
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            write(stdout,60) Vname(1,idTvar(itrc))(1:lsvar),
     &                       fltname(1:lstr)
            exit_flag=3
            return
          endif
        enddo
# endif /* SOLVE3D */
!
!---------------------------------------------------------------------
!  Initialize floats positions to the appropriate values.
!---------------------------------------------------------------------
!
!  Set-up floats time record.
!
        if (frrec.lt.0) then
          tfltindx=tsize
        else
         tfltindx=ABS(frrec)
!!       tfltindx=1+(ntstart-1)/nflt
        endif
        nrecflt=tfltindx
!
!  Read in floats nondimentional horizontal positions.
!
        start(1)=1
        count(1)=nfloats
        start(2)=tfltindx
        count(2)=1
        status=nf_get_vara_FTYPE(ncfltid,fltVid(idXgrd),start,count,
     &                           Tinp)
        if (status.ne.nf_noerr) then
          write(stdout,70) 'Xgrid', tfltindx, fltname(1:lstr)
          exit_flag=3
          return
        endif
        do iflt=1,nfloats
          if ((Tinp(iflt).gt.FLOAT(L)-0.5_r8).or.
     &        (Tinp(iflt).lt.0.5_r8)) then
            bounded(iflt)=.false.
          else
            bounded(iflt)=.true.
            do i=0,NFT
              track(ixgrd,i,iflt)=Tinp(iflt)
              track(ixrhs,i,iflt)=0.0_r8
            enddo
          endif
        enddo
        status=nf_get_vara_FTYPE(ncfltid,fltVid(idYgrd),start,count,
     &                           Tinp)
        if (status.ne.nf_noerr) then
          write(stdout,70) 'Ygrid', tfltindx, fltname(1:lstr)
          exit_flag=3
          return
        endif
        do iflt=1,nfloats
          if ((Tinp(iflt).gt.FLOAT(M)-0.5_r8).or.
     &        (Tinp(iflt).lt.0.5_r8)) then
            bounded(iflt)=.false.
          else
            bounded(iflt)=.true.
            do i=0,NFT
              track(iygrd,i,iflt)=Tinp(iflt)
              track(iyrhs,i,iflt)=0.0_r8
            enddo
          endif
        enddo
# ifdef SOLVE3D
        status=nf_get_vara_FTYPE(ncfltid,fltVid(idZgrd),start,count,
     &                           Tinp)
        if (status.ne.nf_noerr) then
          write(stdout,70) 'Zgrid', tfltindx, fltname(1:lstr)
          exit_flag=3
          return
        endif
        do iflt=1,nfloats
          if ((Tinp(iflt).gt.FLOAT(N)).or.
     &        (Tinp(iflt).lt.0.0_r8)) then
            bounded(iflt)=.false.
          else
            bounded(iflt)=.true.
            do i=0,NFT
              track(izgrd,i,iflt)=Tinp(iflt)
              track(izrhs,i,iflt)=0.0_r8
            enddo
          endif
        enddo
# endif
      endif
!
  10  format(/,' DEF_FLOATS - unable to create floats NetCDF ',
     &       'file: ',a)
  20  format(1pe11.4,1x,'millimeter')
  30  format(/,' DEF_FLOATS - unable to open floats NetCDF file: ',
     &       a)
  40  format(/,' DEF_FLOATS - error while inquiring dimension ID ',
     &       ' for: ',a,2x,/,13x,'in floats NetCDF file: ',a)
  50  format(/,' DEF_FLOATS - error while inquiring size of',
     &       ' dimension: ',a,2x,/,13x,'in floats NetCDF file: ',a)
  60  format(/,' DEF_FLOATS - unable to find variable: ',a,2x,
     &         ' in floats NetCDF file: ',a)
  70  format(/,' DEF_FLOATS - error while reading variable: ',a,2x,
     &         ' at time record = ', i6.6,/,13x,
     &         ' in floats NetCDF file: ',a)
#endif /* FLOATS */
      return
      end
