#include "cppdefs.h"
      subroutine def_avg
#ifdef AVERAGES
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine creates averages NetCDF file, it defines its         !
!  dimensions, attributes, and variables.                            !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "iounits.h"
# include "ncparam.h"
# include "netcdf.inc"
# include "scalars.h"
# include "sediment.h"
!
      logical got_var(NV)
      INTEGER_TYPE
     &        Natt
      parameter (Natt=20)
      INTEGER_TYPE
     &        i, ifield, lstr, lsvar, lvar, nrec, nvd3, nvd4, recdim,
     &        status
      INTEGER_TYPE
     &        def_info, def_var, lenstr, wrt_info
      INTEGER_TYPE
     &        DimIDs(24), t2dgrd(3), u2dgrd(3), v2dgrd(3)
# ifdef SOLVE3D
      logical got_trc(NT)
      INTEGER_TYPE
     &        itrc
      INTEGER_TYPE
     &        b3dgrd(4), t3dgrd(4), u3dgrd(4), v3dgrd(4), w3dgrd(4)
# endif
      REAL_TYPE
     &        Aval(4)
      character*65 Vinfo(Natt)
!
!=====================================================================
!  Create a new averages NetCDF file.
!=====================================================================
!
      if (exit_flag.ne.0) return
      if (ldefout) then
        lstr=lenstr(avgname)
        status=nf_create(avgname(1:lstr),nf_clobber,ncavgid)
        if (status.ne.nf_noerr) then
          write(stdout,10) avgname(1:lstr)
          exit_flag=3
          return
        endif
!
!---------------------------------------------------------------------
!  Define the dimensions of staggered fields.
!---------------------------------------------------------------------
!
        status=nf_def_dim(ncavgid,'xi_rho' ,Lp,DimIDs( 1))
        status=nf_def_dim(ncavgid,'xi_u'   ,L ,DimIDs( 2))
        status=nf_def_dim(ncavgid,'xi_v'   ,Lp,DimIDs( 3))
        status=nf_def_dim(ncavgid,'xi_psi' ,L ,DimIDs( 4))
        status=nf_def_dim(ncavgid,'eta_rho',Mp,DimIDs( 5))
        status=nf_def_dim(ncavgid,'eta_u'  ,Mp,DimIDs( 6))
        status=nf_def_dim(ncavgid,'eta_v'  ,M ,DimIDs( 7))
        status=nf_def_dim(ncavgid,'eta_psi',M ,DimIDs( 8))
# if defined WRITE_WATER && defined MASKING
        status=nf_def_dim(ncavgid,'xy_rho' ,Nxyr,DimIDs(17))
        status=nf_def_dim(ncavgid,'xy_u'   ,Nxyu,DimIDs(18))
        status=nf_def_dim(ncavgid,'xy_v'   ,Nxyv,DimIDs(19))
# endif
# ifdef SOLVE3D
# if defined WRITE_WATER && defined MASKING
        status=nf_def_dim(ncavgid,'xyz_rho',Nxyr*N ,DimIDs(20))
        status=nf_def_dim(ncavgid,'xyz_u'  ,Nxyu*N ,DimIDs(21))
        status=nf_def_dim(ncavgid,'xyz_v'  ,Nxyv*N ,DimIDs(22))
        status=nf_def_dim(ncavgid,'xyz_w'  ,Nxyr*Np,DimIDs(23))
# endif
        status=nf_def_dim(ncavgid,'s_rho'  ,N ,DimIDs( 9))
        status=nf_def_dim(ncavgid,'s_w'    ,Np,DimIDs(10))
        status=nf_def_dim(ncavgid,'tracer' ,NT,DimIDs(11))
#  ifdef SEDIMENT
        status=nf_def_dim(ncavgid,'Nbed'   ,Nbed,DimIDs(16))
#   if defined WRITE_WATER && defined MASKING
        status=nf_def_dim(ncavgid,'xybed'  ,Nxyr*Nbed,DimIDs(24))
#   endif
#  endif
# endif
        status=nf_def_dim(ncavgid,'boundary',4,DimIDs(14))
        status=nf_def_dim(ncavgid,'time',
     &                    nf_unlimited,DimIDs(12))
        recdim=DimIDs(12)
!
!  Set number of dimensions for output variables.
!
#if defined WRITE_WATER && defined MASKING
        nvd3=2
        nvd4=2
#else
        nvd3=3
        nvd4=4
#endif
!
!  Define dimension vectors for staggered tracer type variables.
!
# if defined WRITE_WATER && defined MASKING
        t2dgrd(1)=DimIDs(17)
        t2dgrd(2)=DimIDs(12)
#  ifdef SOLVE3D
        t3dgrd(1)=DimIDs(20)
        t3dgrd(2)=DimIDs(12)
#  endif
# else
        t2dgrd(1)=DimIDs( 1)
        t2dgrd(2)=DimIDs( 5)
        t2dgrd(3)=DimIDs(12)
#  ifdef SOLVE3D
        t3dgrd(1)=DimIDs( 1)
        t3dgrd(2)=DimIDs( 5)
        t3dgrd(3)=DimIDs( 9)
        t3dgrd(4)=DimIDs(12)
#  endif
# endif
!
!  Define dimension vectors for staggered u-momemtum type variables.
!
# if defined WRITE_WATER && defined MASKING
        u2dgrd(1)=DimIDs(18)
        u2dgrd(2)=DimIDs(12)
#  ifdef SOLVE3D
        u3dgrd(1)=DimIDs(21)
        u3dgrd(2)=DimIDs(12)
#  endif
# else
        u2dgrd(1)=DimIDs( 2)
        u2dgrd(2)=DimIDs( 6)
        u2dgrd(3)=DimIDs(12)
#  ifdef SOLVE3D
        u3dgrd(1)=DimIDs( 2)
        u3dgrd(2)=DimIDs( 6)
        u3dgrd(3)=DimIDs( 9)
        u3dgrd(4)=DimIDs(12)
#  endif
# endif
!
!  Define dimension vectors for staggered v-momemtum type variables.
!
# if defined WRITE_WATER && defined MASKING
        v2dgrd(1)=DimIDs(19)
        v2dgrd(2)=DimIDs(12)
#  ifdef SOLVE3D
        v3dgrd(1)=DimIDs(22)
        v3dgrd(2)=DimIDs(12)
#  endif
# else
        v2dgrd(1)=DimIDs( 3)
        v2dgrd(2)=DimIDs( 7)
        v2dgrd(3)=DimIDs(12)
#  ifdef SOLVE3D
        v3dgrd(1)=DimIDs( 3)
        v3dgrd(2)=DimIDs( 7)
        v3dgrd(3)=DimIDs( 9)
        v3dgrd(4)=DimIDs(12)
#  endif
# endif
# ifdef SOLVE3D
!
!  Define dimension vector for staggered w-momemtum type variables.
!
#  if defined WRITE_WATER && defined MASKING
        w3dgrd(1)=DimIDs(23)
        w3dgrd(2)=DimIDs(12)
#  else
        w3dgrd(1)=DimIDs( 1)
        w3dgrd(2)=DimIDs( 5)
        w3dgrd(3)=DimIDs(10)
        w3dgrd(4)=DimIDs(12)
#  endif
!
!  Define dimension vector for sediment bed layer type variables.
!
#  if defined WRITE_WATER && defined MASKING
        b3dgrd(1)=DimIDs(24)
        b3dgrd(2)=DimIDs(12)
#  else
        b3dgrd(1)=DimIDs( 1)
        b3dgrd(2)=DimIDs( 5)
        b3dgrd(3)=DimIDs(16)
        b3dgrd(4)=DimIDs(12)
#  endif
# endif
!
!  Initialize unlimited time record dimension.
!
        tavgindx=0
!
!  Initialize local information variable arrays.
!
        do i=1,Natt
          Vinfo(i)=' '
        enddo
        do i=1,4
          Aval(i)=0.0_r8
        enddo
!
!---------------------------------------------------------------------
!  Define time-recordless information variables.
!---------------------------------------------------------------------
!
        status=def_info(ncavgid,avgname,DimIDs)
        if (exit_flag.ne.0) return
!
!---------------------------------------------------------------------
!  Define variables and their attributes.
!---------------------------------------------------------------------
!
!  Define model time.
!
        lvar=lenstr(Vname(2,idtime))
        Vinfo( 1)=Vname(1,idtime)
        Vinfo( 2)='averaged '/ /Vname(2,idtime)(1:lvar)
        if (INT(time_ref).eq.-2) then
          Vinfo( 3)='seconds since 1968-05-23 00:00:00 GMT'
          Vinfo( 4)='modified Julian day number'
          Vinfo(18)='add_offset'
          Aval(1)=jul_off
        elseif (INT(time_ref).eq.-1) then
          Vinfo( 3)='seconds since 0000-01-01 00:00:00'
          Vinfo( 4)='360 days in every year, 30 days in each month'
        elseif (INT(time_ref).eq.0) then
          Vinfo( 3)='seconds since 0000-01-01 00:00:00'
          Vinfo( 4)='365.25 days in every year'
        elseif (time_ref.gt.0.0_r8) then
          Vinfo( 3)='seconds since '/ /r_text
        endif
        Vinfo(14)=Vname(4,idtime)
        status=def_var(ncavgid,avgVid(idtime),NF_FTYPE,1,recdim,Aval,
     &                 Vinfo,avgname)
!
!  Define free-surface.
!
        if (Hout(idFsur)) then
          lvar=lenstr(Vname(2,idFsur))
          Vinfo( 1)=Vname(1,idFsur)
          Vinfo( 2)='averaged '/ /Vname(2,idFsur)(1:lvar)
          Vinfo( 3)=Vname(3,idFsur)
          Vinfo(14)=Vname(4,idFsur)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
# endif
          status=def_var(ncavgid,avgVid(idFsur),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,avgname)
        endif
!
!  Define 2D momentum in the XI-direction.
!
        if (Hout(idUbar)) then
          lvar=lenstr(Vname(2,idUbar))
          Vinfo( 1)=Vname(1,idUbar)
          Vinfo( 2)='averaged '/ /Vname(2,idUbar)(1:lvar)
          Vinfo( 3)=Vname(3,idUbar)
          Vinfo(14)=Vname(4,idUbar)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_u'
# endif
          status=def_var(ncavgid,avgVid(idUbar),NF_FOUT,nvd3,u2dgrd,
     &                   Aval,Vinfo,avgname)
        endif
!
!  Define 2D momentum in the ETA-direction.
!
        if (Hout(idVbar)) then
          lvar=lenstr(Vname(2,idVbar))
          Vinfo( 1)=Vname(1,idVbar)
          Vinfo( 2)='averaged '/ /Vname(2,idVbar)(1:lvar)
          Vinfo( 3)=Vname(3,idVbar)
          Vinfo(14)=Vname(4,idVbar)
          Vinfo(16)=Vname(1,idtime)
# if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_v'
# endif
          status=def_var(ncavgid,avgVid(idVbar),NF_FOUT,nvd3,v2dgrd,
     &                   Aval,Vinfo,avgname)
        endif
# ifdef SOLVE3D
!
!  Define 3D momentum component in the XI-direction.
!
        if (Hout(idUvel)) then
          lvar=lenstr(Vname(2,idUvel))
          Vinfo( 1)=Vname(1,idUvel)
          Vinfo( 2)='averaged '/ /Vname(2,idUvel)(1:lvar)
          Vinfo( 3)=Vname(3,idUvel)
          Vinfo(14)=Vname(4,idUvel)
          Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_u'
#  endif
          status=def_var(ncavgid,avgVid(idUvel),NF_FOUT,nvd4,u3dgrd,
     &                   Aval,Vinfo,avgname)
        endif
!
!  Define 3D momentum component in the ETA-direction.
!
        if (Hout(idVvel)) then
          lvar=lenstr(Vname(2,idVvel))
          Vinfo( 1)=Vname(1,idVvel)
          Vinfo( 2)='averaged '/ /Vname(2,idVvel)(1:lvar)
          Vinfo( 3)=Vname(3,idVvel)
          Vinfo(14)=Vname(4,idVvel)
          Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_v'
#  endif
          status=def_var(ncavgid,avgVid(idVvel),NF_FOUT,nvd4,v3dgrd,
     &                   Aval,Vinfo,avgname)
        endif
!
!  Define S-coordinate vertical "omega" momentum component.
!
        if (Hout(idOvel)) then
          lvar=lenstr(Vname(2,idOvel))
          Vinfo( 1)=Vname(1,idOvel)
          Vinfo( 2)='averaged '/ /Vname(2,idOvel)(1:lvar)
          Vinfo( 3)=Vname(3,idOvel)
          Vinfo(14)=Vname(4,idOvel)
          Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#  endif
          status=def_var(ncavgid,avgVid(idOvel),NF_FOUT,nvd4,w3dgrd,
     &                   Aval,Vinfo,avgname)
        endif
!
!  Define tracer type variables.
!
        do itrc=1,NT
          if (Hout(idTvar(itrc))) then
            lvar=lenstr(Vname(2,idTvar(itrc)))
            Vinfo( 1)=Vname(1,idTvar(itrc))
            Vinfo( 2)='averaged '/ /Vname(2,idTvar(itrc))(1:lvar)
            Vinfo( 3)=Vname(3,idTvar(itrc))
            Vinfo(14)=Vname(4,idTvar(itrc))
            Vinfo(16)=Vname(1,idtime)
#  ifdef SEDIMENT
            do i=1,NST
              if (itrc.eq.idsed(i)) then
                write(Vinfo(19),20) 1000.0_r8*Sd50(i)
              endif
            enddo
#  endif
#  if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#  endif
            status=def_var(ncavgid,avgTid(itrc),NF_FOUT,nvd4,t3dgrd,
     &                     Aval,Vinfo,avgname)
          endif
        enddo
!
!  Define density anomaly.
!
        if (Hout(idDano)) then
          lvar=lenstr(Vname(2,idDano))
          Vinfo( 1)=Vname(1,idDano)
          Vinfo( 2)='averaged '/ /Vname(2,idDano)(1:lvar)
          Vinfo( 3)=Vname(3,idDano)
          Vinfo(14)=Vname(4,idDano)
          Vinfo(16)=Vname(1,idtime)
#  if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#  endif
          status=def_var(ncavgid,avgVid(idDano),NF_FOUT,nvd4,t3dgrd,
     &                   Aval,Vinfo,avgname)
        endif
#  ifdef LMD_SKPP
!
!  Define depth of surface boundary layer.
!
        if (Hout(idHsbl)) then
          lvar=lenstr(Vname(2,idHsbl))
          Vinfo( 1)=Vname(1,idHsbl)
          Vinfo( 2)='averaged '/ /Vname(2,idHsbl)(1:lvar)
          Vinfo( 3)=Vname(3,idHsbl)
          Vinfo(14)=Vname(4,idHsbl)
          Vinfo(16)=Vname(1,idtime)
#   if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#   endif
          status=def_var(ncavgid,avgVid(idHsbl),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,avgname)
        endif
#  endif
#  ifdef LMD_BKPP
!
!  Define depth of bottom boundary layer.
!
        if (Hout(idHbbl)) then
          lvar=lenstr(Vname(2,idHbbl))
          Vinfo( 1)=Vname(1,idHbbl)
          Vinfo( 2)='averaged '/ /Vname(2,idHbbl)(1:lvar)
          Vinfo( 3)=Vname(3,idHbbl)
          Vinfo(14)=Vname(4,idHbbl)
          Vinfo(16)=Vname(1,idtime)
#   if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#   endif
          status=def_var(ncavgid,avgVid(idHbbl),NF_FOUT,nvd3,t2dgrd,
     &                   Aval,Vinfo,avgname)
        endif
#  endif
#  ifdef AVERAGES_AKV
!
!  Define vertical viscosity coefficient.
!
        lvar=lenstr(Vname(2,idVvis))
        Vinfo( 1)=Vname(1,idVvis)
        Vinfo( 2)='averaged '/ /Vname(2,idVvis)(1:lvar)
        Vinfo( 3)=Vname(3,idVvis)
        Vinfo(14)=Vname(4,idVvis)
        Vinfo(16)=Vname(1,idtime)
#   if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#   endif
        status=def_var(ncavgid,avgVid(idVvis),NF_FOUT,nvd4,w3dgrd,
     &                 Aval,Vinfo,avgname)
#  endif
#  ifdef AVERAGES_AKT
!
!  Define vertical diffusion coefficient for potential temperature.
!
        lvar=lenstr(Vname(2,idTdif))
        Vinfo( 1)=Vname(1,idTdif)
        Vinfo( 2)='averaged '/ /Vname(2,idTdif)(1:lvar)
        Vinfo( 3)=Vname(3,idTdif)
        Vinfo(14)=Vname(4,idTdif)
        Vinfo(16)=Vname(1,idtime)
#   if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#   endif
        status=def_var(ncavgid,avgVid(idTdif),NF_FOUT,nvd4,w3dgrd,
     &                 Aval,Vinfo,avgname)
#  endif
#  ifdef AVERAGES_AKS
!
!  Define vertical diffusion coefficient for salinity.
!
        lvar=lenstr(Vname(2,idSdif))
        Vinfo( 1)=Vname(1,idSdif)
        Vinfo( 2)='averaged '/ /Vname(2,idSdif)(1:lvar)
        Vinfo( 3)=Vname(3,idSdif)
        Vinfo(14)=Vname(4,idSdif)
        Vinfo(16)=Vname(1,idtime)
#   if defined WRITE_WATER && defined MASKING
          Vinfo(20)='mask_rho'
#   endif
        status=def_var(ncavgid,avgVid(idSdif),NF_FOUT,nvd4,w3dgrd,
     &                 Aval,Vinfo,avgname)
#  endif
# endif
!
!---------------------------------------------------------------------
!  Leave definition mode.
!---------------------------------------------------------------------
!
        status=nf_enddef(ncavgid)
!
!---------------------------------------------------------------------
!  Write out time-recordless, information variables.
!---------------------------------------------------------------------
!
        status=wrt_info(ncavgid,avgname)
        if (exit_flag.ne.0) return
      else
!
!=====================================================================
!  Open an existing averages file, check its contents, and prepare
!  for appending data.
!=====================================================================
!
!  Inquire about the contents of averages NetCDF file:  Inquire about
!  the dimensions and variables.  Check for consistency.
!
        ifield=0
        call opencdf (avgname,N,ifield,nrec)
        if (exit_flag.ne.0) return
!
!  Open averages file for read/write.
!
        lstr=lenstr(avgname)
        status=nf_open(avgname(1:lstr),nf_write,ncavgid)
        if (status.ne.nf_noerr) then
          write(stdout,30) avgname(1:lstr)
          exit_flag=3
          return
        endif
!
!  Initialize logical switches.
!
        do i=1,NV
          got_var(i)=.false.
        enddo
# ifdef SOLVE3D
        do itrc=1,NT
          got_trc(itrc)=.false.
        enddo
# endif
!
!  Scan variable list from input NetCDF and activate switches for
!  average variables. Get variable IDs.
!
        do i=1,nvars
          lvar=lenstr(varnam(i))
          lsvar=lenstr(Vname(1,idtime))
          if (varnam(i)(1:lvar).eq.Vname(1,idtime)(1:lsvar)) then
            got_var(idtime)=.true.
            status=nf_inq_varid(ncavgid,Vname(1,idtime)(1:lsvar),
     &                          avgVid(idtime))
          endif
          lsvar=lenstr(Vname(1,idFsur))
          if (varnam(i)(1:lvar).eq.Vname(1,idFsur)(1:lsvar)) then
            got_var(idFsur)=.true.
            status=nf_inq_varid(ncavgid,Vname(1,idFsur)(1:lsvar),
     &                          avgVid(idFsur))
          endif
          lsvar=lenstr(Vname(1,idUbar))
          if (varnam(i)(1:lvar).eq.Vname(1,idUbar)(1:lsvar)) then
            got_var(idUbar)=.true.
            status=nf_inq_varid(ncavgid,Vname(1,idUbar)(1:lsvar),
     &                          avgVid(idUbar))
          endif
          lsvar=lenstr(Vname(1,idVbar))
          if (varnam(i)(1:lvar).eq.Vname(1,idVbar)(1:lsvar)) then
            got_var(idVbar)=.true.
            status=nf_inq_varid(ncavgid,Vname(1,idVbar)(1:lsvar),
     &                          avgVid(idVbar))
          endif
# ifdef SOLVE3D
          lsvar=lenstr(Vname(1,idUvel))
          if (varnam(i)(1:lvar).eq.Vname(1,idUvel)(1:lsvar)) then
            got_var(idUvel)=.true.
            status=nf_inq_varid(ncavgid,Vname(1,idUvel)(1:lsvar),
     &                          avgVid(idUvel))
          endif
          lsvar=lenstr(Vname(1,idVvel))
          if (varnam(i)(1:lvar).eq.Vname(1,idVvel)(1:lsvar)) then
            got_var(idVvel)=.true.
            status=nf_inq_varid(ncavgid,Vname(1,idVvel)(1:lsvar),
     &                          avgVid(idVvel))
          endif
          lsvar=lenstr(Vname(1,idOvel))
          if (varnam(i)(1:lvar).eq.Vname(1,idOvel)(1:lsvar)) then
            got_var(idOvel)=.true.
            status=nf_inq_varid(ncavgid,Vname(1,idOvel)(1:lsvar),
     &                          avgVid(idOvel))
          endif
          do itrc=1,NT
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            if (varnam(i)(1:lvar).eq.
     &          Vname(1,idTvar(itrc))(1:lsvar)) then
             got_trc(itrc)=.true.
             status=nf_inq_varid(ncavgid,
     &                           Vname(1,idTvar(itrc))(1:lsvar),
     &                           avgTid(itrc))
            endif
          enddo
          lsvar=lenstr(Vname(1,idDano))
          if (varnam(i)(1:lvar).eq.Vname(1,idDano)(1:lsvar)) then
            got_var(idDano)=.true.
            status=nf_inq_varid(ncavgid,Vname(1,idDano)(1:lsvar),
     &                          avgVid(idDano))
          endif
#  ifdef LMD_SKPP
          lsvar=lenstr(Vname(1,idHsbl))
          if (varnam(i)(1:lvar).eq.Vname(1,idHsbl)(1:lsvar)) then
            got_var(idHsbl)=.true.
            status=nf_inq_varid(ncavgid,Vname(1,idHsbl)(1:lsvar),
     &                          avgVid(idHsbl))
          endif
#  endif
#  ifdef LMD_BKPP
          lsvar=lenstr(Vname(1,idHbbl))
          if (varnam(i)(1:lvar).eq.Vname(1,idHbbl)(1:lsvar)) then
            got_var(idHbbl)=.true.
            status=nf_inq_varid(ncavgid,Vname(1,idHbbl)(1:lsvar),
     &                          avgVid(idHbbl))
          endif
#  endif
#  ifdef AVERAGES_AKV
          lsvar=lenstr(Vname(1,idVvis))
          if (varnam(i)(1:lvar).eq.Vname(1,idVvis)(1:lsvar)) then
            got_var(idVvis)=.true.
            status=nf_inq_varid(ncavgid,Vname(1,idVvis)(1:lsvar),
     &                          avgVid(idVvis))
          endif
#  endif
#  ifdef AVERAGES_AKT
          lsvar=lenstr(Vname(1,idTdif))
          if (varnam(i)(1:lvar).eq.Vname(1,idTdif)(1:lsvar)) then
            got_var(idTdif)=.true.
           status=nf_inq_varid(ncavgid,Vname(1,idTdif)(1:lsvar),
     &                         avgVid(idTdif))
          endif
#  endif
#  ifdef AVERAGES_AKS
          lsvar=lenstr(Vname(1,idSdif))
          if (varnam(i)(1:lvar).eq.Vname(1,idSdif)(1:lsvar)) then
            got_var(idSdif)=.true.
            status=nf_inq_varid(ncavgid,Vname(1,idSdif)(1:lsvar),
     &                          avgVid(idSdif))
          endif
#  endif
# endif
        enddo
!
!  Check if averages variables are available in input NetCDF file.
!
        if (.not.got_var(idtime)) then
          lsvar=lenstr(Vname(1,idtime))
          write(stdout,40) Vname(1,idtime)(1:lsvar), avgname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idFsur).and.Hout(idFsur)) then
          lsvar=lenstr(Vname(1,idFsur))
          write(stdout,40) Vname(1,idFsur)(1:lsvar), avgname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idUbar).and.Hout(idUbar)) then
          lsvar=lenstr(Vname(1,idUbar))
          write(stdout,40) Vname(1,idUbar)(1:lsvar), avgname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVbar).and.Hout(idVbar)) then
          lsvar=lenstr(Vname(1,idVbar))
          write(stdout,40) Vname(1,idVbar)(1:lsvar), avgname(1:lstr)
          exit_flag=3
          return
        endif
# ifdef SOLVE3D
        if (.not.got_var(idUvel).and.Hout(idUvel)) then
          lsvar=lenstr(Vname(1,idUvel))
          write(stdout,40) Vname(1,idUvel)(1:lsvar), avgname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idVvel).and.Hout(idVvel)) then
          lsvar=lenstr(Vname(1,idVvel))
          write(stdout,40) Vname(1,idVvel)(1:lsvar), avgname(1:lstr)
          exit_flag=3
          return
        endif
        if (.not.got_var(idOvel).and.Hout(idOvel)) then
          lsvar=lenstr(Vname(1,idOvel))
          write(stdout,40) Vname(1,idOvel)(1:lsvar), avgname(1:lstr)
          exit_flag=3
          return
        endif
        do itrc=1,NT
          if (.not.got_trc(itrc).and.Hout(idTvar(itrc))) then
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            write(stdout,40) Vname(1,idTvar(itrc))(1:lsvar),
     &                       avgname(1:lstr)
            exit_flag=3
            return
          endif
        enddo
        if (.not.got_var(idDano).and.Hout(idDano)) then
          lsvar=lenstr(Vname(1,idDano))
          write(stdout,40) Vname(1,idDano)(1:lsvar), avgname(1:lstr)
          exit_flag=3
          return
        endif
#  ifdef LMD_SKPP
        if (.not.got_var(idHsbl).and.Hout(idHsbl)) then
          lsvar=lenstr(Vname(1,idHsbl))
          write(stdout,40) Vname(1,idHsbl)(1:lsvar), avgname(1:lstr)
          exit_flag=3
          return
        endif
#  endif
#  ifdef LMD_BKPP
        if (.not.got_var(idHbbl).and.Hout(idHbbl)) then
          lsvar=lenstr(Vname(1,idHbbl))
          write(stdout,40) Vname(1,idHbbl)(1:lsvar), avgname(1:lstr)
          exit_flag=3
          return
        endif
#  endif
#  ifdef AVERAGES_AKV
        if (.not.got_var(idVvis)) then
          lsvar=lenstr(Vname(1,idVvis))
          write(stdout,40) Vname(1,idVvis)(1:lsvar),avgname(1:lstr)
          exit_flag=3
          return
        endif
#  endif
#  ifdef AVERAGES_AKT
        if (.not.got_var(idTdif)) then
          lsvar=lenstr(Vname(1,idTdif))
          write(stdout,40) Vname(1,idTdif)(1:lsvar),avgname(1:lstr)
          exit_flag=3
          return
        endif
#  endif
#  ifdef AVERAGES_AKS
        if (.not.got_var(idSdif)) then
          lsvar=lenstr(Vname(1,idSdif))
          write(stdout,40) Vname(1,idSdif)(1:lsvar),avgname(1:lstr)
          exit_flag=3
          return
        endif
#  endif
# endif
!
!  Set unlimited time record dimension to the appropriate value.
!
        if (nrst.eq.navg) then
          if (ndefavg.gt.0) then
            tavgindx=((ntstart-1)-ndefavg*((ntstart-1)/ndefavg))/navg
          else
            tavgindx=(ntstart-1)/navg
          endif
        else
          tavgindx=tsize
        endif
      endif
!
!  Set initial average time.
!
      if (ntsavg.eq.1) then
        avgtime=time-0.5_r8*FLOAT(navg)*dt
      else
        avgtime=time+FLOAT(ntsavg)*dt-0.5_r8*FLOAT(navg)*dt
      endif
!
  10  format(/,' DEF_AVG - unable to create averages NetCDF file: ',a)
  20  format(1pe11.4,1x,'millimeter')
  30  format(/,' DEF_AVG - unable to open averages NetCDF file: ',a)
  40  format(/,' DEF_AVG - unable to find variable: ',a,2x,
     &         ' in averages NetCDF file: ',a)
#endif
      return
      end
