#ifdef SOLVE3D

/*
** Include file "coupling.h"
***************************************** Alexander F. Shchepetkin ***
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** DU_avg1   Time averaged U-flux for 2D equations (m3/s).          **
** DU_avg2   Time averaged U-flux for 3D equations coupling (m3/s). **
** DV_avg1   Time averaged V-flux for 2D equations (m3/s).          **
** DV_avg2   Time averaged V-flux for 3D equations coupling (m3/s). **
** Zt_avg1   Free-surface averaged over all short time-steps (m).   **
** rhoA      Normalized vertical averaged density.                  **
** rhoS      Normalized vertical averaged density perturbation.     **
** rufrc     Right-hand-side forcing term for 2D U-momentum (m4/s2) **
** rvfrc     Right-hand-side forcing term for 2D V-momentum (m4/s2) **
**                                                                  **
**********************************************************************
*/

      common /coupling_DU_avg1/ DU_avg1
      REAL_TYPE DU_avg1(GLOBAL_2D_ARRAY)

      common /coupling_DU_avg2/ DU_avg2
      REAL_TYPE DU_avg2(GLOBAL_2D_ARRAY)

      common /coupling_DV_avg1/ DV_avg1
      REAL_TYPE DV_avg1(GLOBAL_2D_ARRAY)

      common /coupling_DV_avg2/ DV_avg2
      REAL_TYPE DV_avg2(GLOBAL_2D_ARRAY)

      common /coupling_Zt_avg1/ Zt_avg1
      REAL_TYPE Zt_avg1(GLOBAL_2D_ARRAY)

      common /coupling_rufrc/ rufrc
      REAL_TYPE rufrc(GLOBAL_2D_ARRAY)

      common /coupling_rvfrc/ rvfrc
      REAL_TYPE rvfrc(GLOBAL_2D_ARRAY)

# ifdef VAR_RHO_2D
      common /coupling_rhoA/ rhoA
      REAL_TYPE rhoA(GLOBAL_2D_ARRAY)

      common /coupling_rhoS/ rhoS
      REAL_TYPE rhoS(GLOBAL_2D_ARRAY)
# endif /* VAR_RHO_2D */

#endif
