#include "cppdefs.h"
      subroutine close_io
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
! This subroutine flushes and closes all IO files.                   !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "ncparam.h"
#include "netcdf.inc"
#include "scalars.h"
!
      INTEGER_TYPE
     &        lstr, status
      INTEGER_TYPE
     &        lenstr
!
!---------------------------------------------------------------------
!  Close output NetCDF files.
!---------------------------------------------------------------------
!
      if (ncrstid.ne.-1) then
        status=nf_close(ncrstid)
        ncrstid=-1
      endif
      if (nchisid.ne.-1) then
        status=nf_close(nchisid)
        nchisid=-1
      endif
#ifdef AVERAGES
      if (ncavgid.ne.-1) then
        status=nf_close(ncavgid)
        ncavgid=-1
      endif
#endif
#ifdef FLOATS
      if (ncfltid.ne.-1) then
        status=nf_close(ncfltid)
        ncfltid=-1
      endif
#endif
      if (lcycle) then
        if (nrecrst.gt.1) then
          nrecrst=2
        else
          nrecrst=1
        endif
      endif
!
!  Report number of time records written.
!
      write(stdout,10) nrechis, nrecrst
#ifdef AVERAGES
      write(stdout,20) nrecavg
#endif
#ifdef STATIONS
      write(stdout,30) nrecsta
#endif
!
!---------------------------------------------------------------------
!  If applicable, report internal exit errors.
!---------------------------------------------------------------------
!
      if (exit_flag.eq.0) then
        call get_date (date_str)
        lstr=lenstr(date_str)
        write(stdout,40) date_str(1:lstr)
      elseif (exit_flag.eq.1) then
        write(stdout,50)
      elseif (exit_flag.eq.2) then
        write(stdout,60)
      elseif (exit_flag.eq.3) then
        write(stdout,70)
      elseif (exit_flag.eq.4) then
        write(stdout,80)
      elseif (exit_flag.eq.5) then
        write(stdout,90)
      elseif (exit_flag.eq.6) then
        write(stdout,100)
      endif
!
 10   format (/,' ROMS - number of time records written in history ',
     &        ' file: ',i10.10,/,
     &        8x,'number of time records written in restart  file: ',
     &        i10.10)
 20   format (8x,'number of time records written in averages file: ',
     &        i10.10)
 30   format (8x,'number of time records written in station  file: ',
     &        i10.10)
 40   format (/,' ROMS: DONE... ',a)
 50   format (/,' MAIN: Abnormal termination: BLOWUP.')
 60   format (/,' ERROR: Abnormal termination: NetCDF INPUT.')
 70   format (/,' ERROR: Abnormal termination: NetCDF OUTPUT.')
 80   format (/,' ERROR: OPENCDF - Can not open NetCDF file.')
 90   format (/,' ERROR: CHECKDEFS - Illegal model configuration.')
100   format (/,' ERROR: PARAM - Illegal domain partition.')
      return
      end
