#include "cppdefs.h"
#if defined SSH_TIDES || defined UV_TIDES
      subroutine clm_tides (tile)
!
!================================================== Robert Hetland ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine adds tidal elevation (m) and tidal currents (m/s) to !
!  sea surface height and 2D momentum climatologies, respectively.   !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (11)
# endif
      call clm_tides_tile (Istr,Iend,Jstr,Jend,
     &                     A2d(1,1),A2d(1,2),A2d(1,3),A2d(1,4),
     &                     A2d(1,5))
# ifdef PROFILE
      call wclock_off (11)
# endif
      return
      end
!
!*********************************************************************
      subroutine clm_tides_tile (Istr,Iend,Jstr,Jend,Etide,Utide,Uwrk,
     &                           Vtide,Vwrk)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "boundary.h"
# include "clima.h"
# include "grid.h"
# include "mask.h"
# include "scalars.h"
# include "tides.h"
!
      INTEGER_TYPE
     &     Iend, Istr, Jend, Jstr, i, itide, j
      REAL_TYPE
     &     Cangle, Cphase, Sangle, Sphase, angle, phase, omega, ramp
      REAL_TYPE
     &         Etide(PRIVATE_2D_SCRATCH_ARRAY),
     &         Utide(PRIVATE_2D_SCRATCH_ARRAY),
     &          Uwrk(PRIVATE_2D_SCRATCH_ARRAY),
     &         Vtide(PRIVATE_2D_SCRATCH_ARRAY),
     &          Vwrk(PRIVATE_2D_SCRATCH_ARRAY)
!
# include "set_bounds.h"
!
      angle=0.0_r8
      phase=0.0_r8
!!    ramp=1.0_r8
      ramp=TANH((tdays-dstart)/1.0_r8)
!
# ifdef SSH_TIDES
!---------------------------------------------------------------------
!  Add tidal elevation (m) to sea surface height climatology.
!---------------------------------------------------------------------
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          Etide(i,j)=0.0_r8
        enddo
      enddo
      do itide=1,NTC
        if (Tperiod(itide).gt.0.0_r8) then
          omega=2.0_r8*pi*time/Tperiod(itide)
          do j=JstrR,JendR
            do i=IstrR,IendR
              Etide(i,j)=(Etide(i,j)+
     &                    ramp*SSH_Tamp(i,j,itide)*
     &                    COS(omega-SSH_Tphase(i,j,itide)))
#  ifdef MASKING
     &                  *rmask(i,j)
#  endif
            enddo
          enddo
        endif
      enddo
#  if defined ZCLIMATOLOGY && defined ADD_FSOBC
!
!  Add sub-tidal forcing and adjust climatology to include tides.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          ssh(i,j)=ssh(i,j)+Etide(i,j)
        enddo
      enddo
#  endif
!
!  If appropriate, load tidal forcing into boundary arrays.
! 
#  if defined WEST_FSOBC || defined WEST_M2OBC
      if (WESTERN_EDGE) then
        do j=JstrR,JendR
#   ifdef ADD_FSOBC   
          zeta_west(j)=zeta_west(j)+0.5_r8*(Etide(0,j)+Etide(1,j))
#   else
          zeta_west(j)=0.5_r8*(Etide(0,j)+Etide(1,j))
#   endif
        enddo
      endif
#  endif
#  if defined EAST_FSOBC || defined EAST_M2OBC
      if (EASTERN_EDGE) then
        do j=JstrR,JendR
#   ifdef ADD_FSOBC   
          zeta_east(j)=zeta_east(j)+0.5_r8*(Etide(Lm,j)+Etide(L,j))
#   else
          zeta_east(j)=0.5_r8*(Etide(Lm,j)+Etide(L,j))
#   endif
        enddo
      endif
#  endif
#  if defined SOUTH_FSOBC || defined SOUTH_M2OBC
      if (SOUTHERN_EDGE) then
        do i=IstrR,IendR
#   ifdef ADD_FSOBC   
          zeta_south(i)=zeta_south(i)+0.5_r8*(Etide(i,0)+Etide(i,1))
#   else
          zeta_south(i)=0.5_r8*(Etide(i,0)+Etide(i,1))
#   endif
        enddo
      endif
#  endif
#  if defined NORTH_FSOBC || defined NORTH_M2OBC
      if (NORTHERN_EDGE) then
        do i=IstrR,IendR
#   ifdef ADD_FSOBC   
          zeta_north(i)=zeta_north(i)+0.5_r8*(Etide(i,Mm)+Etide(i,M))
#   else
          zeta_north(i)=0.5_r8*(Etide(i,Mm)+Etide(i,M))
#   endif
        enddo
      endif
#  endif
# endif
# ifdef UV_TIDES
!
!---------------------------------------------------------------------
!  Add tidal currents (m/s) to 2D momentum climatologies.
!---------------------------------------------------------------------
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          Utide(i,j)=0.0_r8
          Vtide(i,j)=0.0_r8
        enddo
      enddo
      do itide=1,NTC
        if (Tperiod(itide).gt.0.0_r8) then
          omega=2.0_r8*pi*time/Tperiod(itide)
          do j=MIN(JstrR,Jstr-1),JendR
            do i=MIN(IstrR,Istr-1),IendR
              angle=UV_Tangle(i,j,itide)-angler(i,j)
              phase=omega-UV_Tphase(i,j,itide)
              Cangle=COS(angle)
              Cphase=COS(phase)
              Sangle=SIN(angle)
              Sphase=SIN(phase)
              Uwrk(i,j)=UV_Tmajor(i,j,itide)*Cangle*Cphase-
     &                  UV_Tminor(i,j,itide)*Sangle*Sphase
              Vwrk(i,j)=UV_Tmajor(i,j,itide)*Sangle*Cphase+
     &                  UV_Tminor(i,j,itide)*Cangle*Sphase
            enddo
          enddo
          do j=JstrR,JendR
            do i=Istr,IendR
              Utide(i,j)=(Utide(i,j)+
     &                    ramp*0.5_r8*(Uwrk(i-1,j)+Uwrk(i,j)))
# ifdef MASKING
     &                  *umask(i,j)
# endif
            enddo
          enddo
          do j=Jstr,JendR
            do i=IstrR,IendR
              Vtide(i,j)=(Vtide(i,j)+
     &                    ramp*0.5_r8*(Vwrk(i,j-1)+Vwrk(i,j)))
# ifdef MASKING
     &                  *vmask(i,j)
# endif
            enddo
          enddo
        endif
      enddo
# if defined M2CLIMATOLOGY && defined ADD_M2OBC
!
!  Add sub-tidal forcing and adjust climatology to include tides.
!
      do j=JstrR,JendR
        do i=Istr,IendR
          ubarclm(i,j)=ubarclm(i,j)+Utide(i,j)
        enddo
      enddo
      do j=Jstr,JendR
        do i=IstrR,IendR
          vbarclm(i,j)=vbarclm(i,j)+Vtide(i,j)
        enddo
      enddo
# endif
!
!  If appropriate, load tidal forcing into boundary arrays.
! 
#  ifdef WEST_M2OBC
      if (WESTERN_EDGE) then
        do j=JstrR,JendR
#   ifdef ADD_M2OBC   
          ubar_west(j)=ubar_west(j)+Utide(1,j)
#   else
          ubar_west(j)=Utide(1,j)
#   endif
        enddo
        do j=Jstr,JendR
#   ifdef ADD_M2OBC   
          vbar_west(j)=vbar_west(j)+Vtide(0,j)
#   else
          vbar_west(j)=Vtide(0,j)
#   endif
        enddo
      endif
#  endif
#  ifdef EAST_M2OBC
      if (EASTERN_EDGE) then
        do j=JstrR,JendR
#   ifdef ADD_M2OBC   
          ubar_east(j)=ubar_east(j)+Utide(L,j)
#   else
          ubar_east(j)=Utide(L,j)
#   endif
        enddo
        do j=Jstr,JendR
#   ifdef ADD_M2OBC   
          vbar_east(j)=vbar_east(j)+Vtide(L,j)
#   else
          vbar_east(j)=Vtide(L,j)
#   endif
        enddo
      endif
#  endif
#  ifdef SOUTH_M2OBC
      if (SOUTHERN_EDGE) then
        do i=Istr,IendR
#   ifdef ADD_M2OBC   
          ubar_south(i)=ubar_south(i)+Utide(i,0)
#   else
          ubar_south(i)=Utide(i,0)
#   endif
        enddo
        do i=IstrR,IendR
#   ifdef ADD_M2OBC   
          vbar_south(i)=vbar_south(i)+Vtide(i,1)
#   else
          vbar_south(i)=Vtide(i,1)
#   endif
        enddo
      endif
#  endif
#  ifdef NORTH_M2OBC
      if (NORTHERN_EDGE) then
        do i=Istr,IendR
#   ifdef ADD_M2OBC   
          ubar_north(i)=ubar_north(i)+Utide(i,M)
#   else
          ubar_north(i)=Utide(i,M)
#   endif
        enddo
        do i=IstrR,IendR
#   ifdef ADD_M2OBC   
          vbar_north(i)=vbar_north(i)+Vtide(i,M)
#   else
          vbar_north(i)=Vtide(i,M)
#   endif
        enddo
      endif
#  endif
# endif /* UV_TIDES */
#else
      subroutine clm_tides
#endif /* SSH_TIDES || UV_TIDES */
      return
      end
