#ifdef ZCLIMATOLOGY

/*
** Include file "clima.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Sea surface height climatology.                                  **
**                                                                  **
** ssh          Climatology for sea surface height (m).             **
** sshG         Latest two-time snapshots of input "ssh" grided     **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

# ifndef ANA_SSH
      common /clima_sshG/ sshG
      REAL_TYPE sshG(GLOBAL_2D_ARRAY,2)
# endif

      common /clima_ssh/ ssh
      REAL_TYPE ssh(GLOBAL_2D_ARRAY)

#endif /* ZCLIMATOLOGY */

#ifdef M2CLIMATOLOGY

/*
**********************************************************************
** 2D momentum climatolocy.                                         **
**********************************************************************
**                                                                  **
** ubarclm      Vertically integrated U-momentum climatology (m/s). **
** ubarclmG     Latest two-time snapshots of input "ubarclm" grided **
**                data used for interpolation.                      **
** vbarclm      Vertically integrated V-momentum climatology (m/s). **
** vbarclmG     Latest two-time snapshots of input "vbarclm" grided **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

# ifndef ANA_M2CLIMA
      common /clima_ubarclmG/ ubarclmG
      REAL_TYPE ubarclmG(GLOBAL_2D_ARRAY,2)

      common /clima_vbarclmG/ vbarclmG
      REAL_TYPE vbarclmG(GLOBAL_2D_ARRAY,2)
# endif

      common /clima_ubarclm/ ubarclm
      REAL_TYPE ubarclm(GLOBAL_2D_ARRAY)

      common /clima_vbarclm/ vbarclm
      REAL_TYPE vbarclm(GLOBAL_2D_ARRAY)

#endif /* M2CLIMATOLOGY */

#ifdef SOLVE3D

# ifdef TCLIMATOLOGY

/*
**********************************************************************
** Tracer climatolocy.                                              **
**********************************************************************
**                                                                  **
** tclm         Climatology for tracer type variables (usually,     **
**                temperature: degC; salinity: PSU).                **
** tclmG        Latest two-time snapshots of input "tclm" grided    **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

#  ifndef ANA_TCLIMA
      common /clima_tclmG/ tclmG
      REAL_TYPE tclmG(GLOBAL_2D_ARRAY,N,2,NT)
#   endif

      common /clima_tclm/ tclm
      REAL_TYPE tclm(GLOBAL_2D_ARRAY,N,NT)

# endif /* TCLIMATOLOGY */

# ifdef M3CLIMATOLOGY

/*
**********************************************************************
** 3D momentum climatolocy.                                         **
**********************************************************************
**                                                                  **
** uclm         3D U-momentum climatology (m/s).                    **
** uclmG        Latest two-time snapshots of input "uclm" grided    **
**                data used for interpolation.                      **
** vclm         3D V-momentum climatology (m/s).                    **
** vclmG        Latest two-time snapshots of input "vclm" grided    **
**                data used for interpolation.                      **
**                                                                  **
**********************************************************************
*/

#  ifndef ANA_M3CLIMA
      common /clima_uclmG/ uclmG
      REAL_TYPE uclmG(GLOBAL_2D_ARRAY,N,2)

      common /clima_vclmG/ vclmG
      REAL_TYPE vclmG(GLOBAL_2D_ARRAY,N,2)
#  endif

      common /clima_uclm/ uclm
      REAL_TYPE uclm(GLOBAL_2D_ARRAY,N)

      common /clima_vclm/ vclm
      REAL_TYPE vclm(GLOBAL_2D_ARRAY,N)

# endif /* M3CLIMATOLOGY */

#endif /* SOLVE3D */

/*
**********************************************************************
** Nudging variables.                                               **
**********************************************************************
**                                                                  **
** M2nudgcof    Time-scale (1/sec) coefficients for nudging towards **
**                2D momentum data.                                 **
** M3nudgcof    Time-scale (1/sec) coefficients for nudging towards **
**                3D momentum data.                                 **
** Tnudgcof     Time-scale (1/sec) coefficients for nudging towards **
**                tracer data.                                      **
** Znudgcof     Time-scale (1/sec) coefficients for nudging towards **
**                sea surface height data.                          **
**                                                                  **
**********************************************************************
*/

#ifdef M2CLM_NUDGING
      common /climat_M2nudgcof/ M2nudgcof
      REAL_TYPE M2nudgcof(GLOBAL_2D_ARRAY)
#endif

#ifdef ZCLM_NUDGING
      common /climat_Znudgcof/ Znudgcof
      REAL_TYPE Znudgcof(GLOBAL_2D_ARRAY)
#endif

#ifdef SOLVE3D

# ifdef M3CLM_NUDGING
      common /clima_M3nudgcof/ M3nudgcof
      REAL_TYPE M3nudgcof(GLOBAL_2D_ARRAY)
# endif

# ifdef TCLM_NUDGING
      common /clima_Tnudgcof/ Tnudgcof
      REAL_TYPE Tnudgcof(GLOBAL_2D_ARRAY,NT)
# endif

#endif /* SOLVE3D */
