#include "cppdefs.h"
      subroutine checkdefs
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine checks activated C-preprocessing options for      !
!  consistency.                                                      !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "scalars.h"
#include "strings.h"
!
      INTEGER_TYPE
     &        FS_east, FS_west, FS_north, FS_south,
     &        M2_east, M2_west, M2_north, M2_south,
     &        M3_east, M3_west, M3_north, M3_south,
     &         K_east,  K_west,  K_north,  K_south,
     &         T_east,  T_west,  T_north,  T_south,
     &        ibiology, iexample, is, ivmix
      INTEGER_TYPE
     &        lenstr
!
!---------------------------------------------------------------------
!  Initialize local variables.
!---------------------------------------------------------------------
!
      Coptions=' '
      FS_east=0
      FS_west=0
      FS_north=0
      FS_south=0
      M2_east=0
      M2_west=0
      M2_north=0
      M2_south=0
      M3_east=0
      M3_west=0
      M3_north=0
      M3_south=0
      K_east=0
      K_west=0
      K_north=0
      K_south=0
      T_east=0
      T_west=0
      T_north=0
      T_south=0
      ibiology=0
      iexample=0
      ivmix=0
!
!---------------------------------------------------------------------
!  Report activated C-preprocessing options.
!---------------------------------------------------------------------
!
      write(stdout,10)
  10  format(/,' Activated C-preprocessing Options:',/)
  20  format(2x,a,t22,a)
#if defined ADD_FSOBC && defined SSH_TIDES
      write(stdout,20) 'ADD_FSOBC',
     &                 'Adding tidal elevation to proccesed OBC data'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' ADD_FSOBC,'
#endif /* ADD_FSOBC && SSH_TIDES */
#if defined ADD_M2OBC && defined UV_TIDES
      write(stdout,20) 'ADD_M2OBC',
     &                 'Adding tidal currents to proccesed OBC data'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' ADD_M2OBC,'
#endif /* ADD_M2OBC && UV_TIDES */
#ifdef ADRIATIC1
      write(stdout,20) 'ADRIATIC1',
     &                 'Adriatic Sea Application, Grid 1.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' ADRIATIC1,'
      iexample=iexample+1
#endif /* ADRIATIC1 */
#ifdef ADRIATIC2
      write(stdout,20) 'ADRIATIC2',
     &                 'Adriatic Sea Application, Grid 2.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' ADRIATIC2,'
      iexample=iexample+1
#endif /* ADRIATIC2 */
#if defined ALBEDO && defined ANA_SRFLUX
      write(stdout,20) 'ALBEDO',
     &                 'Shortwave radiation from albedo equation.'
      is=lenstr(Coptions)+1
      Coptions(is:is+8)=' ALBEDO,'
#endif /* ALBEDO */
#if defined BIOLOGY && defined ANA_BIOLOGY
      write(stdout,20) 'ANA_BIOLOGY',
     &                 'Analytical biology initial conditions.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' ANA_BIOLOGY,'
#endif /* BIOLOGY && ANA_BIOLOGY */
#if defined SEDIMENT || defined BIOLOGY
# ifdef ANA_BPFLUX
      write(stdout,20) 'ANA_BPFLUX',
     &                 'Analytical bottom passive tracers fluxes.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' ANA_BPFLUX,'
# endif /* ANA_BPFLUX */
#endif /* SEDIMENT || BIOLOGY */
#ifdef ANA_BSEDIM
      write(stdout,20) 'ANA_BSEDIM',
     &                 'Analytical bottom sediment size and density.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' ANA_BSEDIM,'
#endif /* ANA_BSEDIM */
#ifdef ANA_BSFLUX
      write(stdout,20) 'ANA_BSFLUX',
     &                 'Analytical kinematic bottom salinity flux.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' ANA_BSFLUX,'
#endif /* ANA_BSFLUX */
#ifdef ANA_BTFLUX
      write(stdout,20) 'ANA_BTFLUX',
     &                 'Analytical kinematic bottom temperature flux.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' ANA_BTFLUX,'
#endif /* ANA_BTFLUX */
#if defined ANA_CLOUD && defined BULK_FLUXES
      write(stdout,20) 'ANA_CLOUD',
     &                 'Analytical cloud fraction.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' ANA_CLOUD,'
#endif /* ANA_CLOUD && BULK_FLUXES */
#ifdef ANA_DIAG
      write(stdout,20) 'ANA_DIAG',
     &                 'Customized diagnostics.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' ANA_DIAG,'
#endif /* ANA_DIAG */
#ifdef ANA_FSOBC
      write(stdout,20) 'ANA_FSOBC',
     &                 'Analytical free-surface boundary conditions.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' ANA_FSOBC,'
#endif /* ANA_FSOBC */
#ifdef ANA_GRID
      write(stdout,20) 'ANA_GRID',
     &                 'Analytical grid set-up.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' ANA_GRID,'
#endif /* ANA_GRID */
#if defined ANA_HUMIDITY && defined BULK_FLUXES
      write(stdout,20) 'ANA_HUMIDITY',
     &                 'Analytical surface air humidity.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' ANA_HUMIDITY,'
#endif /* ANA_HUMIDITY && BULK_FLUXES */
#ifdef ANA_INITIAL
      write(stdout,20) 'ANA_INITIAL',
     &                 'Analytical initial conditions.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' ANA_INITIAL,'
#endif /* ANA_INITIAL */
#ifdef ANA_M2CLIMA
      write(stdout,20) 'ANA_M2CLIMA',
     &                 'Analytical 2D momentum climatology.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' ANA_M2CLIMA,'
#endif /* ANA_M2CLIMA */
#ifdef ANA_M2OBC
      write(stdout,20) 'ANA_M2OBC',
     &                 'Analytical 2D momentum boundary conditions.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' ANA_M2OBC,'
#endif /* ANA_M2OBC */
#if defined ANA_M3CLIMA && defined SOLVE3D
      write(stdout,20) 'ANA_M3CLIMA',
     &                 'Analytical 3D momentum climatology.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' ANA_M3CLIMA,'
#endif /* ANA_M3CLIMA && SOLVE3D */
#if defined ANA_M3OBC && defined SOLVE3D
      write(stdout,20) 'ANA_M3OBC',
     &                 'Analytical 3D momentum boundary conditions.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' ANA_M3OBC,'
#endif /* ANA_M3OBC && SOLVE3D */
#ifdef ANA_MASK
      write(stdout,20) 'ANA_MASK',
     &                 'Analytical Land/Sea Masking.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' ANA_MASK,'
#endif /* ANA_MASK */
#if defined ANA_PAIR && defined BULK_FLUXES
      write(stdout,20) 'ANA_PAIR',
     &                 'Analytical surface air pressure.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' ANA_PAIR,'
#endif /* ANA_PAIR && BULK_FLUXES */
#ifdef ANA_PSOURCE
      write(stdout,20) 'ANA_PSOURCE',
     &                 'Analytical point sources and sinks.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' ANA_PSOURCE,'
#endif /* ANA_PSOURCE */
#if defined ANA_RAIN && defined BULK_FLUXES
      write(stdout,20) 'ANA_RAIN',
     &                 'Analytical rain fall rate.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' ANA_RAIN,'
#endif /* ANA_RAIN && BULK_FLUXES */
#if defined SEDIMENT && defined ANA_SEDIMENT
      write(stdout,20) 'ANA_SEDIMENT',
     &                 'Analytical sediment initial conditions.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' ANA_SEDIMENT,'
#endif /* SEDIMENT && ANA_SEDIMENT */
#ifdef ANA_SMFLUX
      write(stdout,20) 'ANA_SMFLUX',
     &                 'Analytical kinematic surface momentum flux.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' ANA_SMFLUX,'
#endif /* ANA_SMFLUX */
#if defined SEDIMENT || defined BIOLOGY
# ifdef ANA_SPFLUX
      write(stdout,20) 'ANA_SPFLUX',
     &                 'Analytical surface passive tracer fluxes.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' ANA_SPFLUX,'
# endif /* ANA_SPFLUX */
#endif /* SEDIMENT || BIOLOGY */
#ifdef ANA_SPINNING
      write(stdout,20) 'ANA_SPINNING',
     &                 'Analytical time-varying rotation force.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' ANA_SPINNING,'
#endif /* ANA_SPINNING */
#ifdef ANA_SRFLUX
      write(stdout,20) 'ANA_SRFLUX',
     &                'Analytical kinematic shortwave radiation flux.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' ANA_SRFLUX,'
#endif /* ANA_SRFLUX */
#ifdef ANA_SSH
      write(stdout,20) 'ANA_SSH',
     &                 'Analytical sea surface height climatology.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' ANA_SSH,'
#endif /* ANA_SSH */
#ifdef ANA_SSS
      write(stdout,20) 'ANA_SSS',
     &                 'Analytical sea surface salinity.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' ANA_SSS,'
#endif /* ANA_SSS */
#ifdef ANA_SST
      write(stdout,20) 'ANA_SST',
     &                 'Analytical SST and dQdSST.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' ANA_SST,'
#endif /* ANA_SST */
#ifdef ANA_SSFLUX
      write(stdout,20) 'ANA_SSFLUX',
     &                 'Analytical kinematic surface salinity flux.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' ANA_SSFLUX,'
#endif /* ANA_SSFLUX */
#ifdef ANA_STFLUX
      write(stdout,20) 'ANA_STFLUX',
     &                'Analytical kinematic surface temperature flux.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' ANA_STFLUX,'
#endif /* ANA_STFLUX */
#if defined ANA_TCLIMA && defined SOLVE3D
      write(stdout,20) 'ANA_TCLIMA',
     &                 'Analytical tracer climatology.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' ANA_TCLIMA,'
#endif /* ANA_TCLIMA && SOLVE3D */
#if defined ANA_TOBC && defined SOLVE3D
      write(stdout,20) 'ANA_TOBC',
     &                 'Analytical tracers boundary conditions.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' ANA_TOBC,'
#endif /* ANA_TOBC && SOLVE3D */
#if defined ANA_VMIX && defined SOLVE3D
      write(stdout,20) 'ANA_VMIX',
     &                 'Analytical vertical mixing coefficients.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' ANA_VMIX,'
      ivmix=ivmix+1
#endif /* ANA_VMIX && SOLVE3D */
#if defined ANA_WINDS && defined BULK_FLUXES
      write(stdout,20) 'ANA_WINDS',
     &                 'Analytical surface wind components.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' ANA_WINDS,'
#endif /* ANA_WINDS && BULK_FLUXES */
#ifdef ANA_WWAVE
      write(stdout,20) 'ANA_WWAVE',
     &                 'Analytical wind induced waves.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' ANA_WWAVE,'
#endif /* ANA_WWAVE */
#ifdef ASSIMILATION_SSH
      write(stdout,20) 'ASSIMILATION_SSH',
     &                 'Assimilating SSH observations.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' ASSIMILATION_SSH,'
#endif /* ASSIMILATION_SSH */
#ifdef ASSIMILATION_SST
      write(stdout,20) 'ASSIMILATION_SST',
     &                 'Assimilating SST observations.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' ASSIMILATION_SST,'
#endif /* ASSIMILATION_SST */
#ifdef ASSIMILATION_T
      write(stdout,20) 'ASSIMILATION_T',
     &                 'Assimilating tracers observations.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' ASSIMILATION_T,'
#endif /* ASSIMILATION_T */
#ifdef ASSIMILATION_UV
      write(stdout,20) 'ASSIMILATION_UV',
     &                'Assimilating horizontal currents observations.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' ASSIMILATION_UV,'
#endif /* ASSIMILATION_UV */
#ifdef ASSIMILATION_UVsur
      write(stdout,20) 'ASSIMILATION_UVsur',
     &                 'Assimilating surface currents observations.'
      is=lenstr(Coptions)+1
      Coptions(is:is+20)=' ASSIMILATION_UVsur,'
#endif /* ASSIMILATION_UVsur */
#ifdef AVERAGES
      write(stdout,20) 'AVERAGES',
     &                 'Writing out time-averaged fields.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' AVERAGES,'
# ifdef AVERAGES_AKS
      write(stdout,20) 'AVERAGES_AKS',
     &               'Writing out time-averaged vertical S-diffusion.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' AVERAGES_AKS,'
# endif /* AVERAGES_AKS */
# ifdef AVERAGES_AKT
      write(stdout,20) 'AVERAGES_AKT',
     &               'Writing out time-averaged vertical T-diffusion.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' AVERAGES_AKT,'
# endif /* AVERAGES_AKT */
# ifdef AVERAGES_AKV
      write(stdout,20) 'AVERAGES_AKV',
     &                 'Writing out time-averaged vertical viscosity.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' AVERAGES_AKV,'
# endif /* AVERAGES_AKV */
#endif /* AVERAGES */
#ifdef BASIN
      write(stdout,20) 'BASIN',
     &                 'Big Bad Basin Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+7)=' BASIN,'
      iexample=iexample+1
#endif /* BASIN */
#ifdef BIO_FASHAM
      write(stdout,20) 'BIO_FASHAM',
     &                 'Fasham type nitrogen-based model.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' BIO_FASHAM,'
      ibiology=ibiology+1
#endif /* BIO_FASHAM */
#ifdef BL_TEST
      write(stdout,20) 'BL_TEST',
     &                 'Boundary Layers Test.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' BL_TEST,'
      iexample=iexample+1
#endif /* BL_TEST */
#ifdef BODYFORCE
      write(stdout,20) 'BODYFORCE',
     &                 'Momentum stresses as body-forces.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' BODYFORCE,'
#endif /* BODYFORCE */
#ifdef BULK_FLUXES
      write(stdout,20) 'BULK_FLUXES',
     &                 'Surface bulk fluxes parametererization.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' BULK_FLUXES,'
#endif /* BULK_FLUXES */
#ifdef BVF_MIXING
      write(stdout,20) 'BVF_MIXING',
     &                'Brunt-Vaisala frequency based vertical mixing.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' BVF_MIXING,'
      ivmix=ivmix+1
#endif /* BVF_MIXING */
#ifdef CALCOFI
      write(stdout,20) 'CALCOFI',
     &                 'Southern California Bight Application.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' CALCOFI,'
      iexample=iexample+1
#endif /* CALCOFI */
#if defined CANUTO_A && defined GLS_MIXING
      write(stdout,20) 'CANUTO_A',
     &                 'Canuto A-stability function formulation.'
      is=lenstr(Coptions)+1
      Coptions(is:is+8)=' CANUTO_A,'
#endif /* CANUTO_A && GLS_MIXING */
#if defined CANUTO_B && defined GLS_MIXING
      write(stdout,20) 'CANUTO_B',
     &                 'Canuto B-stability function formulation.'
      is=lenstr(Coptions)+1
      Coptions(is:is+8)=' CANUTO_B,'
#endif /* CANUTO_B && GLS_MIXING */
#ifdef CANYON_A
      write(stdout,20) 'CANYON_A',
     &                 'Canyon A Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' CANYON_A,'
      iexample=iexample+1
#endif /* CANYON_A */
#ifdef CANYON_B
      write(stdout,20) 'CANYON_B',
     &                 'Canyon B Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' CANYON_B,'
      iexample=iexample+1
#endif /* CANYON_B */
#if defined COOL_SKIN && defined BULK_FLUXES
      write(stdout,20) 'COOL_SKIN',
     &                 'Surface cool skin correction.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' COOL_SKIN,'
#endif /* COOL_SKIN && BULK_FLUXES */
#if defined COSINE2 && defined SOLVE3D
      write(stdout,20) 'COSINE2',
     &        'Cosine-squared shape time-averaging barotropic filter.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' COSINE2,'
#endif /* COSINE2 && SOLVE3D */
#ifdef CS_BBL
      write(stdout,20) 'CS_BBL',
     &                 'Sherwood Bottom Boundary Layer.'
      is=lenstr(Coptions)+1
      Coptions(is:is+8)=' CS_BBL,'
#endif /* CS_BBL */
#ifdef UV_ADV
# ifdef CURVGRID
      write(stdout,20) 'CURVGRID',
     &                 'Orthogonal curvilinear grid.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' CURVGRID,'
# endif /* CURVGRID */
#endif /* UV_ADV */
#ifdef DAMEE_4
      write(stdout,20) 'DAMEE_4',
     &                 'North Atlantic DAMEE Application, Grid #4.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' DAMEE_4,'
      iexample=iexample+1
#endif /* DAMEE_4 */
#ifdef DAMEE_5
      write(stdout,20) 'DAMEE_5',
     &                 'North Atlantic DAMEE Application, Grid #5.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' DAMEE_5,'
      iexample=iexample+1
#endif /* DAMEE_5 */
#ifdef DAMEE_6
      write(stdout,20) 'DAMEE_6',
     &                 'North Atlantic DAMEE Application, Grid #6.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' DAMEE_6,'
      iexample=iexample+1
#endif /* DAMEE_6 */
#ifdef DAMEE_7
      write(stdout,20) 'DAMEE_7',
     &                 'North Atlantic DAMEE Application, Grid #7.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' DAMEE_7,'
      iexample=iexample+1
#endif /* DAMEE_7 */
#ifdef DAMEE_9
      write(stdout,20) 'DAMEE_9',
     &                 'North Atlantic DAMEE Application, Grid #9.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' DAMEE_9,'
      iexample=iexample+1
#endif /* DAMEE_9 */
#if defined TS_DIF2 || defined TS_DIF4
# ifdef DIFF_GRID
      write(stdout,20) 'DIFF_GRID',
     &         'Horizontal diffusion coefficient scaled by grid size.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' DIFF_GRID,'
# endif /* DIFF_GRID */
#endif /* TS_DIF2 || TS_DIF4 */
#ifdef DJ_GRADPS
      write(stdout,20) 'DJ_GRADPS',
     &       'Parabolic Splines density Jacobian (Shchepetkin, 2000).'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' DJ_GRADPS,'
#endif /* DJ_GRADPS */
#ifdef DOUBLE_GYRE
      write(stdout,20) 'DOUBLE_GYRE',
     &                 'Double Gyre Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' DOUBLE_GYRE,'
      iexample=iexample+1
#endif /* DOUBLE_GYRE */
#ifdef DOUBLE_PRECISION
      write(stdout,20) 'DOUBLE_PRECISION',
     &                 'Double precision arithmetic.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' DOUBLE_PRECISION,'
#endif /* DOUBLE_PRECISION */
#ifdef EAST_FSCLAMPED
      write(stdout,20) 'EAST_FSCLAMPED',
     &                'Eastern edge, free-surface, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' EAST_FSCLAMPED,'
      FS_east=FS_east+1
#endif /* EAST_FSCLAMPED */
#ifdef EAST_FSCHAPMAN
      write(stdout,20) 'EAST_FSCHAPMAN',
     &                'Eastern edge, free-surface, Chapman condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' EAST_FSCHAPMAN,'
      FS_east=FS_east+1
#endif /* EAST_FSCHAPMAN */
#ifdef EAST_FSGRADIENT
      write(stdout,20) 'EAST_FSGRADIENT',
     &               'Eastern edge, free-surface, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' EAST_FSGRADIENT,'
      FS_east=FS_east+1
#endif /* EAST_FSGRADIENT */
#ifdef EAST_FSRADIATION
# ifdef EAST_FSNUDGING
      write(stdout,20) 'EAST_FSNUDGING',
     &    'Eastern edge, free-surface, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' EAST_FSNUDGING,'
# endif /* EAST_FSNUDGING */
      write(stdout,20) 'EAST_FSRADIATION',
     &              'Eastern edge, free-surface, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' EAST_FSRADIATION,'
      FS_east=FS_east+1
#endif /* EAST_FSRADIATION */
#ifdef EAST_M2CLAMPED
      write(stdout,20) 'EAST_M2CLAMPED',
     &                 'Eastern edge, 2D momentum, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' EAST_M2CLAMPED,'
      M2_east=M2_east+1
#endif /* EAST_M2CLAMPED */
#ifdef EAST_M2FLATHER
      write(stdout,20) 'EAST_M2FLATER',
     &                 'Eastern edge, 2D momentum, Flather condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' EAST_M2FLATHER,'
      M2_east=M2_east+1
#endif /* EAST_M2FLATHER */
#ifdef EAST_M2GRADIENT
      write(stdout,20) 'EAST_M2GRADIENT',
     &                'Eastern edge, 2D momentum, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' EAST_M2GRADIENT,'
      M2_east=M2_east+1
#endif /* EAST_M2GRADIENT */
#ifdef EAST_M2RADIATION
# ifdef EAST_M2NUDGING
      write(stdout,20) 'EAST_M2NUDGING',
     &     'Eastern edge, 2D momentum, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' EAST_M2NUDGING,'
# endif /* EAST_M2NUDGING */
      write(stdout,20) 'EAST_M2RADIATION',
     &               'Eastern edge, 2D momentum, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' EAST_M2RADIATION,'
      M2_east=M2_east+1
#endif /* EAST_M2RADIATION */
#ifdef EAST_M3CLAMPED
      write(stdout,20) 'EAST_M3CLAMPED',
     &                 'Eastern edge, 3D momentum, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' EAST_M3CLAMPED,'
      M3_east=M3_east+1
#endif /* EAST_M3CLAMPED */
#ifdef EAST_M3GRADIENT
      write(stdout,20) 'EAST_M3GRADIENT',
     &                'Eastern edge, 3D momentum, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' EAST_M3GRADIENT,'
      M3_east=M3_east+1
#endif /* EAST_M3GRADIENT */
#ifdef EAST_M3RADIATION
# ifdef EAST_M3NUDGING
      write(stdout,20) 'EAST_M3NUDGING',
     &     'Eastern edge, 3D momentum, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' EAST_M3NUDGING,'
# endif /* EAST_M3NUDGING */
      write(stdout,20) 'EAST_M3RADIATION',
     &               'Eastern edge, 3D momentum, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' EAST_M3RADIATION,'
      M3_east=M3_east+1
#endif /* EAST_M3RADIATION */
#if defined GLS_MIXING || defined MY25_MIXING
# ifdef EAST_KGRADIENT
      write(stdout,20) 'EAST_KGRADIENT',
     &                 'Eastern edge, TKE fields, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' EAST_KGRADIENT,'
      K_east=K_east+1
# endif /* EAST_KGRADIENT */
# ifdef EAST_KRADIATION
      write(stdout,20) 'EAST_KRADIATION',
     &                'Eastern edge, TKE fields, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' EAST_KRADIATION,'
      K_east=K_east+1
# endif /* EAST_KRADIATION */
#endif /* GLS_MIXING || MY25_MIXING */
#ifdef EAST_TCLAMPED
      write(stdout,20) 'EAST_TCLAMPED',
     &                 'Eastern edge, tracers, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' EAST_TCLAMPED,'
      T_east=T_east+1
#endif /* EAST_TCLAMPED */
#ifdef EAST_TGRADIENT
      write(stdout,20) 'EAST_TGRADIENT',
     &                 'Eastern edge, tracers, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' EAST_TGRADIENT,'
      T_east=T_east+1
#endif /* EAST_TGRADIENT */
#ifdef EAST_TRADIATION
# ifdef EAST_TNUDGING
      write(stdout,20) 'EAST_TNUDGING',
     &         'Eastern edge, tracers, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' EAST_TNUDGING,'
# endif /* EAST_TNUDGING */
      write(stdout,20) 'EAST_TRADIATION',
     &                 'Eastern edge, tracers, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' EAST_TRADIATION,'
      T_east=T_east+1
#endif /* EAST_TRADIATION */
#ifdef EASTERN_WALL
      write(stdout,20) 'EASTERN_WALL',
     &                 'Wall boundary at Eastern edge.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' EASTERN_WALL,'
#endif /* EASTERN_WALL */
#ifdef EW_PERIODIC
      write(stdout,20) 'EW_PERIODIC',
     &                 'East-West periodic boundaries.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' EW_PERIODIC,'
      FS_east=FS_east+1
      FS_west=FS_west+1
      M2_east=M2_east+1
      M2_west=M2_west+1
      M3_east=M3_east+1
      M3_west=M3_west+1
      K_east=K_east+1
      K_west=K_west+1
      T_east=T_east+1
      T_west=T_west+1
#endif /* EW_PERIODIC */
#ifdef FLOATS
      write(stdout,20) 'FLOATS',
     &                 'Simulated Lagrangian drifters.'
      is=lenstr(Coptions)+1
      Coptions(is:is+8)=' FLOATS,'
#endif /* FLOATS */
#if defined FLOATS && defined FLOAT_VWALK && defined SOLVE3D
      write(stdout,20) 'FLOAT_VWALK',
     &                 'Lagrangian drifter vertical diffusion.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' FLOAT_VWALK,'
#endif /* FLOAT_VWALK */
#ifdef FLT_TEST
      write(stdout,20) 'FLT_TEST',
     &                 'Float Tracking Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' FLT_TEST,'
      iexample=iexample+1
#endif /* FLT_TEST */
#ifdef GLS_MIXING
      write(stdout,20) 'GLS_MIXING',
     &                 'Generic Length-Scale turbulence closure.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' GLS_MIXING,'
      ivmix=ivmix+1
#endif /* GLS_MIXING */
#ifdef GRAV_ADJ
      write(stdout,20) 'GRAV_ADJ',
     &                 'Gravitational Adjustment Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' GRAV_ADJ,'
      iexample=iexample+1
#endif /* GRAV_ADJ */
#ifdef ICESHELF
      write(stdout,20) 'ICESHELF',
     &                 'Include Ice Shelf Cavities.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' ICESHELF,'
#endif /* ICESHELF */
#if defined KANTHA_CLAYSON && (defined GLS_MIXING || defined MY25_MIXING)
      write(stdout,20) 'KANTHA_CLAYSON',
     &            'Kantha and Clayson stability function formulation.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' KANTHA_CLAYSON,'
#endif /* KANTHA_CLAYSON && (GLS_MIXING || MY25_MIXING) */
#ifdef LAB_CANYON
      write(stdout,20) 'LAB_CANYON',
     &                 'Lab Canyon, an annulus example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' LAB_CANYON,'
      iexample=iexample+1
#endif /* LAB_CANYON */
#ifdef LMD_BKPP
      write(stdout,20) 'LMD_BKPP',
     &                 'KPP bottom boundary layer mixing.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' LMD_BKPP,'
#endif /* LMD_BKPP */
#ifdef LMD_CONVEC
      write(stdout,20) 'LMD_CONVEC',
     &               'LMD convective mixing due to shear instability.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' LMD_CONVEC,'
#endif /* LMD_CONVEC */
#ifdef LMD_DDMIX
      write(stdout,20) 'LMD_DDMIX',
     &                 'LMD double-diffusive mixing.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' LMD_DDMIX,'
#endif /* LMD_DDMIX */
#ifdef LMD_MIXING
      write(stdout,20) 'LMD_MIXING',
     &                 'Large/McWilliams/Doney interior mixing.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' LMD_MIXING,'
      ivmix=ivmix+1
#endif /* LMD_MIXING */
#ifdef LMD_NONLOCAL
      write(stdout,20) 'LMD_NONLOCAL',
     &                 'LMD convective nonlocal transport.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' LMD_NONLOCAL,'
#endif /* LMD_NONLOCAL */
#ifdef LMD_RIMIX
      write(stdout,20) 'LMD_RIMIX',
     &                 'LMD diffusivity due to shear instability.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' LMD_RIMIX,'
#endif /* LMD_RIMIX */
#ifdef LMD_SKPP
      write(stdout,20) 'LMD_SKPP',
     &                 'KPP surface boundary layer mixing.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' LMD_SKPP,'
#endif /* LMD_SKPP */
#ifdef LMD_TEST
      write(stdout,20) 'LMD_TEST',
     &                 'Large et al. Inertial Response Test.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' LMD_TEST,'
      iexample=iexample+1
#endif /* LMD_TEST */
#if defined LONGWAVE && defined BULK_FLUXES
      write(stdout,20) 'LONGWAVE',
     &                 'Compute net longwave radiation internally.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' LONGWAVE,'
#endif /* LONGWAVE && BULK_FLUXES */
#ifdef M2CLIMATOLOGY
      write(stdout,20) 'M2CLIMATOLOGY',
     &                 'Processing 2D momentum climatology data.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' M2CLIMATOLOGY,'
#endif /* M2CLIMATOLOGY */
#ifdef M2CLM_NUDGING
      write(stdout,20) 'M2CLM_NUDGING',
     &                 'Nudging toward 2D momentum climatology.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' M2CLM_NUDGING,'
#endif /* M2CLM_NUDGING */
#if defined M3CLIMATOLOGY && defined SOLVE3D
      write(stdout,20) 'M3CLIMATOLOGY',
     &                 'Processing 3D momentum climatology data.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' M3CLIMATOLOGY,'
#endif /* M3CLIMATOLOGY && SOLVE3D */
#if defined M3CLM_NUDGING && defined SOLVE3D
      write(stdout,20) 'M3CLM_NUDGING',
     &                 'Nudging toward 3D momentum climatology.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' M3CLM_NUDGING,'
#endif /* M3CLM_NUDGING && SOLVE3D */
#ifdef MASKING
      write(stdout,20) 'MASKING',
     &                 'Land/Sea masking.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' MASKING,'
#endif /* MASKING */
#ifdef MASS_SOURCE
      write(stdout,20) 'MASS_SOURCE',
     &                 'Add in Mass Source/Sink term.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' MASS_SOURCE,'
#endif /* MASS_SOURCE */
#ifdef MB_BBL
      write(stdout,20) 'MB_BBL',
     &                 'Blaas Bottom Boundary Layer.'
      is=lenstr(Coptions)+1
      Coptions(is:is+8)=' MB_BBL,'
#endif /* MB_BBL */
#if (defined TS_DIF2 || defined TS_DIF4) && defined SOLVE3D
# ifdef MIX_GEO_TS
      write(stdout,20) 'MIX_GEO_TS',
     &                'Mixing of tracers along geopotential surfaces.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' MIX_GEO_TS,'
# endif /* MIX_GEO_TS */
# ifdef MIX_ISO_TS
      write(stdout,20) 'MIX_ISO_TS',
     &                 'Mixing of tracers along isopycnal surfaces.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' MIX_ISO_TS,'
# endif /* MIX_ISO_TS */
# ifdef MIX_S_TS
      write(stdout,20) 'MIX_S_TS',
     &                 'Mixing of tracers along constant S-surfaces.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' MIX_S_TS,'
# endif /* MIX_S_TS */
#endif /* (TS_DIF2 || TS_DIF4) && SOLVE3D */
#if (defined UV_VIS2 || defined UV_VIS4) && defined SOLVE3D
# ifdef MIX_GEO_UV
      write(stdout,20) 'MIX_GEO_UV',
     &               'Mixing of momentum along geopotential surfaces.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' MIX_GEO_UV,'
# endif /* MIX_GEO_UV */
# ifdef MIX_S_UV
      write(stdout,20) 'MIX_S_UV',
     &                 'Mixing of momentum along constant S-surfaces.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' MIX_S_UV,'
# endif /* MIX_S_UV */
#endif /* (UV_VIS2 || UV_VIS4) && SOLVE3D */
#ifdef MY25_MIXING
      write(stdout,20) 'MY25_MIXING',
     &                 'Mellor/Yamada Level-2.5 mixing closure.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' MY25_MIXING,'
      ivmix=ivmix+1
#endif /* MY25_MIXING */
#ifdef NATL
      write(stdout,20) 'NATL',
     &             'High Resolution North Atlantic DAMEE Application.'
      is=lenstr(Coptions)+1
      Coptions(is:is+6)=' NATL,'
      iexample=iexample+1
#endif /* NATL */
#ifdef NENA
      write(stdout,20) 'NENA',
     &                 'North East North America Application.'
      is=lenstr(Coptions)+1
      Coptions(is:is+6)=' NENA,'
      iexample=iexample+1
#endif /* NENA */
#ifdef NJ_BIGHT
      write(stdout,20) 'NJ_BIGHT',
     &                 'New Jersey Bight Application.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' NJ_BIGHT,'
      iexample=iexample+1
#endif /* NJ_BIGHT */
#if defined NONLIN_EOS && defined SOLVE3D
      write(stdout,20) 'NONLIN_EOS',
     &                 'Non-linear Equation of State for seawater.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' NONLIN_EOS,'
#endif /* NONLIN_EOS && SOLVE3D */
#ifdef NORTHERN_WALL
      write(stdout,20) 'NORTHERN_WALL',
     &                 'Wall boundary at Northern edge.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' NORTHERN_WALL,'
#endif /* NORTHERN_WALL */
#ifdef NPACIFIC
      write(stdout,20) 'PACIFIC',
     &                 'North Pacific Application.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' NPACIFIC,'
      iexample=iexample+1
#endif /* NPACIFIC */
#ifdef NORTH_FSCLAMPED
      write(stdout,20) 'NORTH_FSCLAMPED',
     &               'Northern edge, free-surface, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' NORTH_FSCLAMPED,'
      FS_north=FS_north+1
#endif /* NORTH_FSCLAMPED */
#ifdef NORTH_FSCHAPMAN
      write(stdout,20) 'NORTH_FSCHAPMAN',
     &               'Northern edge, free-surface, Chapman condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' NORTH_FSCHAPMAN,'
      FS_north=FS_north+1
#endif /* NORTH_FSCHAPMAN */
#ifdef NORTH_FSGRADIENT
      write(stdout,20) 'NORTH_FSGRADIENT',
     &              'Northern edge, free-surface, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' NORTH_FSGRADIENT,'
      FS_north=FS_north+1
#endif /* NORTH_FSGRADIENT */
#ifdef NORTH_FSRADIATION
# ifdef NORTH_FSNUDGING
      write(stdout,20) 'NORTH_FSNUDGING',
     &   'Northern edge, free-surface, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' NORTH_FSNUDGING,'
# endif /* NORTH_FSNUDGING */
      write(stdout,20) 'NORTH_FSRADIATION',
     &             'Northern edge, free-surface, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+19)=' NORTH_FSRADIATION,'
      FS_north=FS_north+1
#endif /* NORTH_FSRADIATION */
#ifdef NORTH_M2CLAMPED
      write(stdout,20) 'NORTH_M2CLAMPED',
     &                'Northern edge, 2D momentum, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' NORTH_M2CLAMPED,'
      M2_north=M2_north+1
#endif /* NORTH_M2CLAMPED */
#ifdef NORTH_M2FLATHER
      write(stdout,20) 'NORTH_M2FLATHER',
     &                'Northern edge, 2D momentum, Flather condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' NORTH_M2FLATHER,'
      M2_north=M2_north+1
#endif /* NORTH_M2FLATHER */
#ifdef NORTH_M2GRADIENT
      write(stdout,20) 'NORTH_M2GRADIENT',
     &               'Northern edge, 2D momentum, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' NORTH_M2GRADIENT,'
      M2_north=M2_north+1
#endif /* NORTH_M2GRADIENT */
#ifdef NORTH_M2RADIATION
# ifdef NORTH_M2NUDGING
      write(stdout,20) 'NORTH_M2NUDGING',
     &    'Northern edge, 2D momentum, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' NORTH_M2NUDGING,'
# endif /* NORTH_M2NUDGING */
      write(stdout,20) 'NORTH_M2RADIATION',
     &              'Northern edge, 2D momentum, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+19)=' NORTH_M2RADIATION,'
      M2_north=M2_north+1
#endif /* NORTH_M2RADIATION */
#ifdef NORTH_M3CLAMPED
      write(stdout,20) 'NORTH_M3CLAMPED',
     &                'Northern edge, 3D momentum, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' NORTH_M3CLAMPED,'
      M3_north=M3_north+1
#endif /* NORTH_M3CLAMPED */
#ifdef NORTH_M3GRADIENT
      write(stdout,20) 'NORTH_M3GRADIENT',
     &               'Northern edge, 3D momentum, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' NORTH_M3GRADIENT,'
      M3_north=M3_north+1
#endif /* NORTH_M3GRADIENT */
#ifdef NORTH_M3RADIATION
# ifdef NORTH_M3NUDGING
      write(stdout,20) 'NORTH_M3NUDGING',
     &    'Northern edge, 3D momentum, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' NORTH_M3NUDGING,'
# endif /* NORTH_M3NUDGING */
      write(stdout,20) 'NORTH_M3RADIATION',
     &              'Northern edge, 3D momentum, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+19)=' NORTH_M3RADIATION,'
      M3_north=M3_north+1
#endif /* NORTH_M3RADIATION */
#if defined GLS_MIXING || defined MY25_MIXING
# ifdef NORTH_KGRADIENT
      write(stdout,20) 'NORTH_KGRADIENT',
     &                'Northern edge, TKE fields, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' NORTH_KGRADIENT,'
      K_north=K_north+1
# endif /* NORTH_KGRADIENT */
# ifdef NORTH_KRADIATION
      write(stdout,20) 'NORTH_KRADIATION',
     &               'Northern edge, TKE fields, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' NORTH_KRADIATION,'
      K_north=K_north+1
# endif /* NORTH_KRADIATION */
#endif /* GLS_MIXING || MY25_MIXING */
#ifdef NORTH_TCLAMPED
      write(stdout,20) 'NORTH_TCLAMPED',
     &                 'Northern edge, tracers, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' NORTH_TCLAMPED,'
      T_north=T_north+1
#endif /* NORTH_TCLAMPED */
#ifdef NORTH_TGRADIENT
      write(stdout,20) 'NORTH_TGRADIENT',
     &                 'Northern edge, tracers, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' NORTH_TGRADIENT,'
      T_north=T_north+1
#endif /* NORTH_TGRADIENT */
#ifdef NORTH_TRADIATION
# ifdef NORTH_TNUDGING
      write(stdout,20) 'NORTH_TNUDGING',
     &        'Northern edge, tracers, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' NORTH_TNUDGING,'
# endif /* NORTH_TNUDGING */
      write(stdout,20) 'NORTH_TRADIATION',
     &                 'Northern edge, tracers, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' NORTH_TRADIATION,'
      T_north=T_north+1
#endif /* NORTH_TRADIATION */
#ifdef NO_WRITE_GRID
      write(stdout,20) 'NO_WRITE_GRID',
     &              'Not Writing grid arrays into NetCDF ouput files.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' NO_WRITE_GRID,'
#endif /* NO_WRITE_GRID */
#ifdef NUDGING_SSH
      write(stdout,20) 'NUDGING_SSH',
     &                 'Nudging SSH observations.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' NUDGING_SSH,'
#endif /* NUDGING_SSH */
#ifdef NUDGING_SST
      write(stdout,20) 'NUDGING_SST',
     &                 'Nudging SST observations.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' NUDGING_SST,'
#endif /* NUDGING_SST */
#ifdef NUDGING_T
      write(stdout,20) 'NUDGING_T',
     &                 'Nudging tracers observations.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' NUDGING_T,'
#endif /* NUDGING_T */
#ifdef NUDGING_UV
      write(stdout,20) 'NUDGING_UV',
     &                 'Nudging horizontal currents observations.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' NUDGING_UV,'
#endif /* NUDGING_UV */
#ifdef NUDGING_UVsur
      write(stdout,20) 'NUDGING_UVsur',
     &                 'Nudging surface currents observations.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' NUDGING_UVsur,'
#endif /* NUDGING_UVsur */
#ifdef NS_PERIODIC
      write(stdout,20) 'NS_PERIODIC',
     &                 'North-South periodic boundaries.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' NS_PERIODIC,'
      FS_north=FS_north+1
      FS_south=FS_south+1
      M2_north=M2_north+1
      M2_south=M2_south+1
      M3_north=M3_north+1
      M3_south=M3_south+1
      K_north=K_north+1
      K_south=K_south+1
      T_north=T_north+1
      T_south=T_south+1
#endif /* NS_PERIODIC */
#if defined N2S2_HORAVG && (defined GLS_MIXING || defined MY25_MIXING)
      write(stdout,20) 'N2S2_HORAVG',
     &                 'Horizontal smoothing of buoyancy and shear.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' N2S2_HORAVG,'
#endif /* N2S2_HORAVG && (GLS_MIXING || MY25_MIXING) */
#ifdef OUT_DOUBLE
      write(stdout,20) 'OUT_DOUBLE',
     &               'Double precision output fields in NetCDF files.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' OUT_DOUBLE,'
#endif /* OUT_DOUBLE */
#ifdef OBC_VOLCONS
      write(stdout,20) 'OBC_VOLCONS',
     &                 'Enforce mass conservation on open boundaries.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' OBC_VOLCONS,'
#endif /* OBC_VOLCONS */
#ifdef _OPENMP
      write(stdout,20) '_OPENMP',
     &                 'OpenMP parallel directives.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' _OPENMP,'
#endif /* _OPENMP */
#ifdef OVERFLOW
      write(stdout,20) 'OVERFLOW',
     &                 'gravitational/overflow Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' OVERFLOW,'
      iexample=iexample+1
#endif /* OVERFLOW */
#ifdef PJ_GRADP
      write(stdout,20) 'PJ_GRADP',
     &                 'Finite volume Pressure Jacobian (Lin, 1997).'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' PJ_GRADP,'
#endif /* PJ_GRADP */
#ifdef PJ_GRADPQ2
      write(stdout,20) 'PJ_GRADPQ2',
     &   'Quartic 2 polynomial Pressure Jacobian (Shchepetkin, 2000).'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' PJ_GRADPQ2,'
#endif /* PJ_GRADPQ2 */
#ifdef PJ_GRADPQ4
      write(stdout,20) 'PJ_GRADPQ4',
     &   'Quartic 4 polynomial Pressure Jacobian (Shchepetkin, 2000).'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' PJ_GRADPQ4,'
#endif /* PJ_GRADPQ4 */
#if defined POWER_LAW && defined SOLVE3D
      write(stdout,20) 'POWER_LAW',
     &             'Power-law shape time-averaging barotropic filter.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' POWER_LAW,'
#endif /* POWER_LAW && SOLVE3D */
#ifdef PROFILE
      write(stdout,20) 'PROFILE',
     &                 'Time profiling activated .'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' PROFILE,'
#endif /* PROFILE */
#ifdef QCORRECTION
      write(stdout,20) 'QCORRECTION',
     &                 'Surface net heat flux correction.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' QCORRECTION,'
#endif /* QCORRECTION */
#if defined GLS_MIXING || defined MY25_MIXING
# if defined K_C2ADVECTION
      write(stdout,20) 'K_C2ADVECTION',
     &    'Second-order centered differences advection of TKE fields.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' K_C2ADVECTION,'
# elif defined K_C4ADVECTION
      write(stdout,20) 'K_C4ADVECTION',
     &    'Fourth-order centered differences advection of TKE fields.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' K_C4ADVECTION,'
# else
      write(stdout,20) 'K_GSCHEME',
     &            'Third-order upstream bias advection of TKE fields.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' K_GSCHEME,'
# endif
# ifdef TKE_DIF2
      write(stdout,20) 'TKE_DIF2',
     &                 'Harmonic mixing of TKE fields.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' TKE_DIF2,'
# endif
# ifdef TKE_DIF4
      write(stdout,20) 'TKE_DIF4',
     &                 'Biharmonic mixing of TKE fields.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' TKE_DIF4,'
# endif
#endif /* GLS_MIXING || MY25_MIXING */
#ifdef RADIATION_2D
      write(stdout,20) 'RADIATION_2D',
     &           'Use tangential phase speed in radiation conditions.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' RADIATION_2D,'
#endif /* RADIATION_2D */
#ifdef RANDOM_ESPERT
      write(stdout,20) 'RANDOM_ESPERT',
     &                 'Random Error Subspace perturbations.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' RANDOM_ESPERT,'
#endif /* RANDOM_ESPERT */
#if defined LMD_MIXING
# ifdef RI_HORAVG
      write(stdout,20) 'RI_HORAVG',
     &                 'Smooth Richardson number horizontally.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' RI_HORAVG,'
# endif /* RI_HORAVG */
# ifdef RI_VERAVG
      write(stdout,20) 'RI_VERAVG',
     &                 'Smooth Richardson number vertically.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' RI_VERAVG,'
# endif /* RI_VERAVG */
#endif /* LMD_MIXING */
#ifdef RIVERPLUME
      write(stdout,20) 'RIVERPLUME',
     &                 'River Plume Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' RIVERPLUME,'
      iexample=iexample+1
#endif /* RIVERPLUME */
#ifdef RST_SINGLE
      write(stdout,20) 'RST_SINGLE',
     &               'Single precision fields in restart NetCDF file.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' RST_SINGLE,'
#else
      write(stdout,20) '!RST_SINGLE',
     &               'Double precision fields in restart NetCDF file.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' !RST_SINGLE,'
#endif /* RST_SINGLE */
#ifdef SALINITY
      write(stdout,20) 'SALINITY',
     &                 'Using salinity.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' SALINITY,'
#endif /* SALINITY */
#ifdef SCORRECTION
      write(stdout,20) 'SCORRECTION',
     &                 'Surface salinity flux correction.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' SCORRECTION,'
#endif /* SCORRECTION */
#ifdef SEAMOUNT
      write(stdout,20) 'SEAMOUNT',
     &                 'Seamount Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' SEAMOUNT,'
      iexample=iexample+1
#endif /* SEAMOUNT */
#ifdef SED_TEST1
      write(stdout,20) 'SED_TEST1',
     &                 'Suspended sediment test in a Channel.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' SED_TEST1,'
      iexample=iexample+1
#endif /* SED_TEST1 */
#ifdef SERIAL
      write(stdout,20) 'SERIAL',
     &                 'Serial Code Configuration.'
      is=lenstr(Coptions)+1
      Coptions(is:is+8)=' SERIAL,'
#endif /* SERIAL */
#ifdef SG_BBL
      write(stdout,20) 'SG_BBL',
     &                 'Styles and Glenn Bottom Boundary Layer.'
      is=lenstr(Coptions)+1
      Coptions(is:is+8)=' SG_BBL,'
# ifdef SG_LOGINT
      write(stdout,20) 'SG_LOGINT',
     &                 'Bottom currents logarithmic interpolation.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' SG_LOGINT,'
# endif /* SG_LOGINT */
# ifdef SG_ZNOT
      write(stdout,20) 'SG_ZNOT',
     &                 'Internal computation of bottom roughness.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' SG_ZNOT,'
# endif /* SG_ZNOT */
#endif /* SG_BBL */
#ifdef SRELAXATION
      write(stdout,20) 'SRELAXATION',
     &                 'Surface salinity relaxation as surface flux.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' SRELAXATION,'
#endif /* SRELAXATION */
#ifdef SHELFRONT
      write(stdout,20) 'SHELFRONT',
     &                 'Shelf Front Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' SHELFRONT,'
      iexample=iexample+1
#endif /* SHELFRONT */
#ifdef SMAGORINSKY
      write(stdout,20) 'SMAGORINSKY',
     &               'Smagorinsky horizontal mixing parameterization.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' SMAGORINSKY,'
#endif /* SMAGORINSKY */
#ifdef SOLAR_SOURCE
      write(stdout,20) 'SOLAR_SOURCE',
     &                 'Solar Radiation Source Term.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' SOLAR_SOURCE,'
#endif /* SOLAR_SOURCE */
#ifdef SOLITON
      write(stdout,20) 'SOLITON',
     &                 'Equatorial Rossby Soliton Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' SOLITON,'
      iexample=iexample+1
#endif /* SOLITON */
#ifdef SOLVE3D
      write(stdout,20) 'SOLVE3D',
     &                 'Solving 3D Primitive Equations.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' SOLVE3D,'
#endif /* SOLVE3D */
#ifdef SOUTH_FSCLAMPED
      write(stdout,20) 'SOUTH_FSCLAMPED',
     &               'Southern edge, free-surface, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' SOUTH_FSCLAMPED,'
      FS_south=FS_south+1
#endif /* SOUTH_FSCLAMPED */
#ifdef SOUTH_FSCHAPMAN
      write(stdout,20) 'SOUTH_FSCHAPMAN',
     &               'Southern edge, free-surface, Chapman condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' SOUTH_FSCHAPMAN,'
      FS_south=FS_south+1
#endif /* SOUTH_FSCHAPMAN */
#ifdef SOUTH_FSGRADIENT
      write(stdout,20) 'SOUTH_FSGRADIENT',
     &              'Southern edge, free-surface, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' SOUTH_FSGRADIENT,'
      FS_south=FS_south+1
#endif /* SOUTH_FSGRADIENT */
#ifdef SOUTH_FSRADIATION
# ifdef SOUTH_FSNUDGING
      write(stdout,20) 'SOUTH_FSNUDGING',
     &   'Southern edge, free-surface, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' SOUTH_FSNUDGING,'
# endif /* SOUTH_FSNUDGING */
      write(stdout,20) 'SOUTH_FSRADIATION',
     &             'Southern edge, free-surface, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+19)=' SOUTH_FSRADIATION,'
      FS_south=FS_south+1
#endif /* SOUTH_FSRADIATION */
#ifdef SOUTH_M2CLAMPED
      write(stdout,20) 'SOUTH_M2CLAMPED',
     &                'Southern edge, 2D momentum, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' SOUTH_M2CLAMPED,'
      M2_south=M2_south+1
#endif /* SOUTH_M2CLAMPED */
#ifdef SOUTH_M2FLATHER
      write(stdout,20) 'SOUTH_M2FLATHER',
     &                'Southern edge, 2D momentum, Flather condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' SOUTH_M2FLATHER,'
      M2_south=M2_south+1
#endif /* SOUTH_M2FLATHER */
#ifdef SOUTH_M2GRADIENT
      write(stdout,20) 'SOUTH_M2GRADIENT',
     &               'Southern edge, 2D momentum, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' SOUTH_M2GRADIENT,'
      M2_south=M2_south+1
#endif /* SOUTH_M2GRADIENT */
#ifdef SOUTH_M2RADIATION
# ifdef SOUTH_M2NUDGING
      write(stdout,20) 'SOUTH_M2NUDGING',
     &    'Southern edge, 2D momentum, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' SOUTH_M2NUDGING,'
# endif /* SOUTH_M2NUDGING */
      write(stdout,20) 'SOUTH_M2RADIATION',
     &              'Southern edge, 2D momentum, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+19)=' SOUTH_M2RADIATION,'
      M2_south=M2_south+1
#endif /* SOUTH_M2RADIATION */
#ifdef SOUTH_M3CLAMPED
      write(stdout,20) 'SOUTH_M3CLAMPED',
     &                'Southern edge, 3D momentum, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' SOUTH_M3CLAMPED,'
      M3_south=M3_south+1
#endif /* SOUTH_M3CLAMPED */
#ifdef SOUTH_M3GRADIENT
      write(stdout,20) 'SOUTH_M3GRADIENT',
     &               'Southern edge, 3D momentum, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' SOUTH_M3GRADIENT,'
      M3_south=M3_south+1
#endif /* SOUTH_M3GRADIENT */
#ifdef SOUTH_M3RADIATION
# ifdef SOUTH_M3NUDGING
      write(stdout,20) 'SOUTH_M3NUDGING',
     &    'Southern edge, 3D momentum, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' SOUTH_M3NUDGING,'
# endif /* SOUTH_M3NUDGING */
      write(stdout,20) 'SOUTH_M3RADIATION',
     &              'Southern edge, 3D momentum, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+19)=' SOUTH_M3RADIATION,'
      M3_south=M3_south+1
#endif /* SOUTH_M3RADIATION */
#if defined GLS_MIXING || defined MY25_MIXING
# ifdef SOUTH_KGRADIENT
      write(stdout,20) 'SOUTH_KGRADIENT',
     &                'Southern edge, TKE fields, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' SOUTH_KGRADIENT,'
      K_south=K_south+1
# endif /* SOUTH_KGRADIENT */
# ifdef SOUTH_KRADIATION
      write(stdout,20) 'SOUTH_KRADIATION',
     &               'Southern edge, TKE fields, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' SOUTH_KRADIATION,'
      K_south=K_south+1
# endif /* SOUTH_KRADIATION */
#endif /* GLS_MIXING || MY25_MIXING */
#ifdef SOUTH_TCLAMPED
      write(stdout,20) 'SOUTH_TCLAMPED',
     &                 'Southern edge, tracers, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' SOUTH_TCLAMPED,'
      T_south=T_south+1
#endif /* SOUTH_TCLAMPED */
#ifdef SOUTH_TGRADIENT
      write(stdout,20) 'SOUTH_TGRADIENT',
     &                 'Southern edge, tracers, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' SOUTH_TGRADIENT,'
      T_south=T_south+1
#endif /* SOUTH_TGRADIENT */
#ifdef SOUTH_TRADIATION
# ifdef SOUTH_TNUDGING
      write(stdout,20) 'SOUTH_TNUDGING',
     &        'Southern edge, tracers, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' SOUTH_TNUDGING,'
# endif /* SOUTH_TNUDGING */
      write(stdout,20) 'SOUTH_TRADIATION',
     &                 'Southern edge, tracers, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' SOUTH_TRADIATION,'
      T_south=T_south+1
#endif /* SOUTH_TRADIATION */
#ifdef SOUTHERN_WALL
      write(stdout,20) 'SOUTHERN_WALL',
     &                 'Wall boundary at Southern edge.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' SOUTHERN_WALL,'
#endif /* SOUTHERN_WALL */
#ifdef SPLINES
      write(stdout,20) 'SPLINES',
     &                 'Conservative parabolic spline reconstruction.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' SPLINES,'
#endif /* SPLINES */
#ifdef SPONGE
      write(stdout,20) 'SPONGE',
     &               'Enhanced horizontal mixing in the sponge areas.'
      is=lenstr(Coptions)+1
      Coptions(is:is+8)=' SPONGE,'
#endif /* SPONGE */
#if defined SSH_TIDES
      write(stdout,20) 'SSH_TIDES',
     &                 'Add tidal elevation to SSH climatology.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' SSH_TIDES,'
#endif /* SSH_TIDES */
#ifdef STATIONS
      write(stdout,20) 'STATIONS',
     &                 'Writing out station data.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' STATIONS,'
#endif /* STATIONS */
#ifdef TASMAN_SEA
      write(stdout,20) 'TASMAN_SEA',
     &                 'Tasman-Sea Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' TASMAN_SEA,'
      iexample=iexample+1
#endif /* TASMAN_SEA */
#if defined TCLIMATOLOGY && defined SOLVE3D
      write(stdout,20) 'TCLIMATOLOGY',
     &                 'Processing tracer climatology data.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' TCLIMATOLOGY,'
#endif /* TCLIMATOLOGY && SOLVE3D */
#if defined TCLM_NUDGING && defined SOLVE3D
      write(stdout,20) 'TCLM_NUDGING',
     &                 'Nudging toward tracer climatology.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' TCLM_NUDGING,'
#endif /* TCLM_NUDGING && SOLVE3D */

#ifdef SOLVE3D
! Advection and diffusion for tracers: horiziontal, vertical, diffusion
# if defined TS_A4HADVECTION
      write(stdout,20) 'TS_A4HADVECTION',
     &            'Fouth-order Akima horizontal advection of tracers.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' TS_A4HADVECTION,'
# elif defined TS_C2HADVECTION
      write(stdout,20) 'TS_C2HADVECTION',
     &        'Second-order centered horizontal advection of tracers.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' TS_C2HADVECTION,'
# elif defined TS_U3HADVECTION
      write(stdout,20) 'TS_U3HADVECTION',
     &    'Third-order upstream bias horizontal advection of tracers.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' TS_U3HADVECTION,'
# else
      write(stdout,20) 'TS_C4HADVECTION',
     &        'Fourth-order centered horizontal advection of tracers.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' TS_C4HADVECTION,'
# endif
# if defined TS_A4VADVECTION
      write(stdout,20) 'TS_A4VADVECTION',
     &              'Fouth-order Akima vertical advection of tracers.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' TS_A4VADVECTION,'
# elif defined TS_C2VADVECTION
      write(stdout,20) 'TS_C2VADVECTION',
     &          'Second-order centered vertical advection of tracers.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' TS_C2VADVECTION,'
# elif defined TS_SVADVECTION
      write(stdout,20) 'TS_SVADVECTION',
     &              'Parabolic splines vertical advection of tracers.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' TS_SVADVECTION,'
# else
      write(stdout,20) 'TS_C4VADVECTION',
     &          'Fourth-order centered vertical advection of tracers.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' TS_C4VADVECTION,'
# endif
# ifdef TS_DIF2
      write(stdout,20) 'TS_DIF2',
     &                 'Laplacian mixing of tracers.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' TS_DIF2,'
# endif /* TS_VIS2 */
# ifdef TS_DIF4
      write(stdout,20) 'TS_DIF4',
     &                 'Biharmonic mixing of tracers.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' TS_DIF4,'
# endif /* TS_DIF4 */
#endif /* SOLVE3D */


#if defined TS_PSOURCE && defined SOLVE3D
      write(stdout,20) 'TS_PSOURCE',
     &                 'Tracers point sources and sinks.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' TS_PSOURCE,'
#endif /* TS_PSOURCE && SOLVE3D */
#ifdef UPWELLING
      write(stdout,20) 'UPWELLING',
     &                 'Upwelling/Downwelling Example.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' UPWELLING,'
      iexample=iexample+1
#endif /* UPWELLING */
#ifdef USWEST
      write(stdout,20) 'USWEST',
     &                 'US West Coast Application.'
      is=lenstr(Coptions)+1
      Coptions(is:is+8)=' USWEST,'
      iexample=iexample+1
#endif /* USWEST */
#ifdef UV_ADV
      write(stdout,20) 'UV_ADV',
     &                 'Advection of momentum.'
      is=lenstr(Coptions)+1
      Coptions(is:is+8)=' UV_ADV,'
#endif /* UV_ADV */
#if defined UV_BAROCLINIC && \
   (defined ASSIMILATION_UVsur || defined ASSIMILATION_UV)
      write(stdout,20) 'UV_BAROCLINIC',
     &                 'Assimilation of only baroclinic currents.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' UV_BAROCLINIC,'
#endif /* UV_BAROCLINIC && (ASSIMILATION_UVsur || ASSIMILATION_UV */
#ifdef UV_COR
      write(stdout,20) 'UV_COR',
     &                 'Coriolis term.'
      is=lenstr(Coptions)+1
      Coptions(is:is+8)=' UV_COR,'
#endif /* UV_COR */
#ifdef UV_ADV
# if defined UV_C2ADVECTION
      write(stdout,20) 'UV_C2ADVECTION',
     &      'Second-order centered differences advection of momentum.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' UV_C2ADVECTION,'
# elif defined UV_C4ADVECTION
      write(stdout,20) 'UV_C4ADVECTION',
     &       'Forth-order centered differences advection of momentum.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' UV_C4ADVECTION,'
# else
#  ifdef SOLVE3D
      write(stdout,20) 'UV_U3HADVECTION',
     &              'Third-order upstream bias advection of momentum.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' UV_U3HADVECTION,'
#  else
      write(stdout,20) 'UV_C4ADVECTION',
     &       'Forth-order centered differences advection of momentum.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' UV_C4ADVECTION,'
#  endif
# endif
# ifdef UV_SADVECTION
      write(stdout,20) 'UV_SADVECTION',
     &             'Parabolic splines vertical advection of momentum.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' UV_SADVECTION,'
# endif
#endif /* UV_ADV */
#ifdef UV_PSOURCE
      write(stdout,20) 'UV_PSOURCE',
     &                 'Mass point sources and sinks.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' UV_PSOURCE,'
#endif /* UV_PSOURCE */
#if defined UV_TIDES
      write(stdout,20) 'UV_TIDES',
     &              'Add tidal currents to 2D momentum climatologies.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' UV_TIDES,'
#endif /* UV_TIDES */
#ifdef UV_VIS2
      write(stdout,20) 'UV_VIS2',
     &                 'Laplacian mixing of momentum.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' UV_VIS2,'
#endif /* UV_VIS2 */
#ifdef UV_VIS4
      write(stdout,20) 'UV_VIS4',
     &                 'Biharmonic mixing of momentum.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' UV_VIS4,'
#endif /* UV_VIS4 */
#if defined VAR_RHO_2D && defined SOLVE3D
      write(stdout,20) 'VAR_RHO_2D',
     &                 'Variable density barotropic mode.'
      is=lenstr(Coptions)+1
      Coptions(is:is+12)=' VAR_RHO_2D,'
#endif /* VAR_RHO_2D && SOLVE3D */
#if defined UV_VIS2 || defined UV_VIS4
# ifdef VISC_GRID
      write(stdout,20) 'VISC_GRID',
     &         'Horizontal viscosity coefficient scaled by grid size.'
      is=lenstr(Coptions)+1
      Coptions(is:is+11)=' VISC_GRID,'
# endif /* VISC_GRID */
#endif /* UV_VIS2 || UV_VIS4 */
#if defined WRITE_WATER && defined MASKING
      write(stdout,20) 'WRITE_WATER',
     &                 'Writing data at water points only.'
      is=lenstr(Coptions)+1
      Coptions(is:is+13)=' WRITE_WATER,'
#endif /* WRITE_WATER && MASKING */
#ifdef WEDDELL
      write(stdout,20) 'WEDDELL',
     &                 'Idealized Weddell Sea Shelf Application.'
      is=lenstr(Coptions)+1
      Coptions(is:is+9)=' WEDDELL,'
      iexample=iexample+1
#endif /* WEDDELL */
#ifdef WEST_FSCLAMPED
      write(stdout,20) 'WEST_FSCLAMPED',
     &                'Western edge, free-surface, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' WEST_FSCLAMPED,'
      FS_west=FS_west+1
#endif /* WEST_FSCLAMPED */
#ifdef WEST_FSCHAPMAN
      write(stdout,20) 'WEST_FSCHAPMAN',
     &                'Western edge, free-surface, Chapman condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' WEST_FSCHAPMAN,'
      FS_west=FS_west+1
#endif /* WEST_FSCHAPMAN */
#ifdef WEST_FSGRADIENT
      write(stdout,20) 'WEST_FSGRADIENT',
     &               'Western edge, free-surface, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' WEST_FSGRADIENT,'
      FS_west=FS_west+1
#endif /* WEST_FSGRADIENT */
#ifdef WEST_FSRADIATION
# ifdef WEST_FSNUDGING
      write(stdout,20) 'WEST_FSNUDGING',
     &    'Western edge, free-surface, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' WEST_FSNUDGING,'
# endif /* WEST_FSNUDGING */
      write(stdout,20) 'WEST_FSRADIATION',
     &              'Western edge, free-sruface, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' WEST_FSRADIATION,'
      FS_west=FS_west+1
#endif /* WEST_FSRADIATION */
#ifdef WEST_M2CLAMPED
      write(stdout,20) 'WEST_M2CLAMPED',
     &                 'Western edge, 2D momentum, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' WEST_M2CLAMPED,'
      M2_west=M2_west+1
#endif /* WEST_M2CLAMPED */
#ifdef WEST_M2FLATHER
      write(stdout,20) 'WEST_M2FLATHER',
     &                 'Western edge, 2D momentum, Flather condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' WEST_M2FLATHER,'
      M2_west=M2_west+1
#endif /* WEST_M2FLATHER */
#ifdef WEST_M2GRADIENT
      write(stdout,20) 'WEST_M2GRADIENT',
     &                'Western edge, 2D momentum, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' WEST_M2GRADIENT,'
      M2_west=M2_west+1
#endif /* WEST_M2GRADIENT */
#ifdef WEST_M2RADIATION
# ifdef WEST_M2NUDGING
      write(stdout,20) 'WEST_M2NUDGING',
     &     'Western edge, 2D momentum, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' WEST_M2NUDGING,'
# endif /* WEST_M2NUDGING */
      write(stdout,20) 'WEST_M2RADIATION',
     &               'Western edge, 2D momentum, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' WEST_M2RADIATION,'
      M2_west=M2_west+1
#endif /* WEST_M2RADIATION */
#ifdef WEST_M3CLAMPED
      write(stdout,20) 'WEST_M3CLAMPED',
     &                 'Western edge, 3D momentum, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' WEST_M3CLAMPED,'
      M3_west=M3_west+1
#endif /* WEST_M3CLAMPED */
#ifdef WEST_M3GRADIENT
      write(stdout,20) 'WEST_M3GRADIENT',
     &                'Western edge, 3D momentum, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' WEST_M3GRADIENT,'
      M3_west=M3_west+1
#endif /* WEST_M3GRADIENT */
#ifdef WEST_M3RADIATION
# ifdef WEST_M3NUDGING
      write(stdout,20) 'WEST_M3NUDGING',
     &     'Western edge, 3D momentum, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' WEST_M3NUDGING,'
# endif /* WEST_M3NUDGING */
      write(stdout,20) 'WEST_M3RADIATION',
     &               'Western edge, 3D momentum, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+18)=' WEST_M3RADIATION,'
      M3_west=M3_west+1
#endif /* WEST_M3RADIATION */
#if defined GLS_MIXING || defined MY25_MIXING
# ifdef WEST_KGRADIENT
      write(stdout,20) 'WEST_KGRADIENT',
     &                 'Western edge, TKE fields, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' WEST_KGRADIENT,'
      K_west=K_west+1
# endif /* WEST_KGRADIENT */
# ifdef WEST_KRADIATION
      write(stdout,20) 'WEST_KRADIATION',
     &                'Western edge, TKE fields, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' WEST_KRADIATION,'
      K_west=K_west+1
# endif /* WEST_KRADIATION */
#endif /* GLS_MIXING || MY25_MIXING */
#ifdef WEST_TCLAMPED
      write(stdout,20) 'WEST_TCLAMPED',
     &                 'Western edge, tracers, Clamped condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' WEST_TCLAMPED,'
      T_west=T_west+1
#endif /* WEST_TCLAMPED */
#ifdef WEST_TGRADIENT
      write(stdout,20) 'WEST_TGRADIENT',
     &                 'Western edge, tracers, gradient condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+16)=' WEST_TGRADIENT,'
      T_west=T_west+1
#endif /* WEST_TGRADIENT */
#ifdef WEST_TRADIATION
# ifdef WEST_TNUDGING
      write(stdout,20) 'WEST_TNUDGING',
     &         'Western edge, tracers, passive/active outflow/inflow.'
      is=lenstr(Coptions)+1
      Coptions(is:is+15)=' WEST_TNUDGING,'
# endif /* WEST_TNUDGING */
      write(stdout,20) 'WEST_TRADIATION',
     &                 'Western edge, tracers, radiation condition.'
      is=lenstr(Coptions)+1
      Coptions(is:is+17)=' WEST_TRADIATION,'
      T_west=T_west+1
#endif /* WEST_TRADIATION */
#ifdef WESTERN_WALL
      write(stdout,20) 'WESTERN_WALL',
     &                 'Wall boundary at Western edge.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' WESTERN_WALL,'
#endif /* WESTERN_WALL */
#ifdef WJ_GRADP
      write(stdout,20) 'WJ_GRADP',
     &             'Weighted Jacobians pressure gradient formulation.'
      is=lenstr(Coptions)+1
      Coptions(is:is+10)=' WJ_GRADP,'
#endif /* WJ_GRADP */
#ifdef ZCLIMATOLOGY
      write(stdout,20) 'ZCLIMATOLOGY',
     &               'Processing sea surface height climatology data.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' ZCLIMATOLOGY,'
#endif /* ZCLIMATOLOGY */
#ifdef ZCLM_NUDGING
      write(stdout,20) 'ZCLM_NUDGING',
     &                'Nudging toward sea surface height climatology.'
      is=lenstr(Coptions)+1
      Coptions(is:is+14)=' ZCLM_NUDGING,'
#endif /* ZCLM_NUDGING */
!
!---------------------------------------------------------------------
!  Check C-preprocessing options.
!---------------------------------------------------------------------
!
!  Stop if more than one vertical closure scheme is selected.
!
      if (ivmix.gt.1) then
        write (stdout,30)
  30    format(/,' CHECKDEFS - only one vertical closure scheme',
     &                       ' is allowed.')
        exit_flag=5
      endif
!
!  Stop if more than one biological module is selected.
!
      if (ibiology.gt.1) then
        write (stdout,40)
  40    format(/,' CHECKDEFS - only one biology module is allowed.')
        exit_flag=5
      endif

!
!  Stop if more than one model example is selected.
!
      if (iexample.gt.1) then
        write (stdout,50)
  50    format(/,' CHECKDEFS - only one model example is allowed.')
        exit_flag=5
      endif
!
!  Stop if more than one boundary conditions option for free-surface
!  is selected at each boundary edge.
!
      if (FS_east.gt.1) then
        write (stdout,60) 'free-surface','eastern edge'
        exit_flag=5
      endif
      if (FS_west.gt.1) then
        write (stdout,60) 'free-surface','western edge'
        exit_flag=5
      endif
      if (FS_north.gt.1) then
        write (stdout,60) 'free-surface','northern edge'
        exit_flag=5
      endif
      if (FS_south.gt.1) then
        write (stdout,60) 'free-surface','southern edge'
        exit_flag=5
      endif
  60  format(/,' CHECKDEFS - only one boundary condition option for',
     &       1x,a,/,13x,'is allowed at the',1x,a,'.')
!
!  Stop if more than one boundary conditions option for 2D momentum
!  is selected at each boundary edge.
!
      if (M2_east.gt.1) then
        write (stdout,60) '2D momentum','eastern edge'
        exit_flag=5
      endif
      if (M2_west.gt.1) then
        write (stdout,60) '2D momentum','western edge'
        exit_flag=5
      endif
      if (M2_north.gt.1) then
        write (stdout,60) '2D momentum','northern edge'
        exit_flag=5
      endif
      if (M2_south.gt.1) then
        write (stdout,60) '2D momentum','southern edge'
        exit_flag=5
      endif
#ifdef SOLVE3D
!
!  Stop if more than one boundary conditions option for 3D momentum
!  is selected at each boundary edge.
!
      if (M3_east.gt.1) then
        write (stdout,60) '3D momentum','eastern edge'
        exit_flag=5
      endif
      if (M3_west.gt.1) then
        write (stdout,60) '3D momentum','western edge'
        exit_flag=5
      endif
      if (M3_north.gt.1) then
        write (stdout,60) '3D momentum','northern edge'
        exit_flag=5
      endif
      if (M3_south.gt.1) then
        write (stdout,60) '3D momentum','southern edge'
        exit_flag=5
      endif
!
!  Stop if more than one boundary conditions option for tracers is
!  selected at each boundary edge.
!
      if (T_east.gt.1) then
        write (stdout,60) 'tracers','eastern edge'
        exit_flag=5
      endif
      if (T_west.gt.1) then
        write (stdout,60) 'tracers','western edge'
        exit_flag=5
      endif
      if (T_north.gt.1) then
        write (stdout,60) 'tracers','northern edge'
        exit_flag=5
      endif
      if (T_south.gt.1) then
        write (stdout,60) 'tracers','southern edge'
        exit_flag=5
      endif
# if defined GLS_MIXING || defined MY25_MIXING
!
!  Stop if more than one boundary conditions option for tracers is
!  selected at each boundary edge.
!
      if (K_east.gt.1) then
        write (stdout,60) 'TKE fields','eastern edge'
        exit_flag=5
      endif
      if (K_west.gt.1) then
        write (stdout,60) 'TKE fields','western edge'
        exit_flag=5
      endif
      if (K_north.gt.1) then
        write (stdout,60) 'TKE fields','northern edge'
        exit_flag=5
      endif
      if (K_south.gt.1) then
        write (stdout,60) 'TKE fields','southern edge'
        exit_flag=5
      endif
# endif /* GLS_MIXING || MY25_MIXING */
#endif /* SOLVE3D */
#if !defined SOLVE3D
!
!  Stop it explicit time-step splitting on shallow water set-up.
!
      if (ndtfast.gt.1) then
        write(stdout,70)
  70    format(/,' CHECKDEFS - explicit time-step splitting is ',
     &                       ' inconsistent.',
     &         /,13x,'Change parameter NDTFAST to unity.')
        exit_flag=5
      endif
#endif /* !SOLVE3D */
      return
      end
