      program check_io
!
!=====================================================================
!                                                                    !
!  This progams reads in ROMS input script (usually, "roms.in")      !
!  and prints out the time in days that input files are created      !
!  and output data is written. It is usefull to check the input      !
!  parameters NDEFHIS and NDEFAVG.                                   !
!                                                                    !
!=====================================================================
!
      implicit none
#include "netcdf.inc"
!
      common /Linput/ lcycle, ldefout
      logical         lcycle, ldefout
      common /Iinput/ navg, ndefavg, ndefhis, nhis, nrrec, nrst,
     &                ntsavg, ntimes
      integer         navg, ndefavg, ndefhis, nhis, nrrec, nrst,
     &                ntsavg, ntimes
      common /Rinput/ dt, dstart
      real*8          dt, dstart
      common /Cinput/ avgbase, avgname, hisbase, hisname, ininame,
     &                rstname
      character*80    avgbase, avgname, hisbase, hisname, ininame,
     &                rstname
!
      integer idefavg, idefhis, iic, lstr, navgrec, ncinpid, nhisrec,
     &        ntstart, status, stdout, varid
      integer lenstr
      real*8  day2sec, sec2day, tdays, time
      parameter (stdout=6, day2sec=86400.0d0, sec2day=1.0d0/86400.0d0)
!
!---------------------------------------------------------------------
!  Read in input script
!---------------------------------------------------------------------
!
      call inp_par
!
!---------------------------------------------------------------------
!  Iterate over number of time-steps.
!---------------------------------------------------------------------
!
      ntstart=1
      idefhis=0
      idefavg=0
      tdays=dstart
      time=dstart*day2sec-dt
!
!  If restart file, get initial record.
!
      if (nrrec.gt.0) then
        lstr=lenstr(ininame)
        status=nf_open(ininame(1:lstr),nf_nowrite,ncinpid)
        status=nf_inq_varid(ncinpid,'ocean_time',varid)
        status=nf_get_var1_double(ncinpid,varid,nrrec,time)
        ntstart=int((time-dstart*day2sec)/dt)+1
        if (ntstart.lt.1) ntstart=1
        if (ndefhis.gt.0) idefhis=ndefhis*(1+(ntstart-1)/ndefhis)
        if (ndefavg.gt.0) idefavg=ndefavg*(1+(ntstart-1)/ndefavg)
      endif
!
!  Check history output.
!
      time=time-dt
!
      do iic=ntstart, ntimes+1
!
        time=time+dt
        tdays=time*sec2day
!
        if (ndefhis.gt.0) then
          if ((iic.eq.ntstart).or.((iic-1).eq.idefhis)) then
            if ((nrrec.eq.0).and.(iic.eq.ntstart)) then
              idefhis=idefhis+ndefhis+nhis
            else
              idefhis=idefhis+ndefhis
            endif
            nhisrec=0
            if ((nrrec.gt.0).and.(MOD(iic-1,ndefhis).ne.0)) then
              ldefout=.false.
            else
              ldefout=.true.
            endif
            lstr=lenstr(hisbase)
            write(hisname,10) hisbase(1:lstr-3), ((iic-1)/ndefhis)+1
 10         format(a,'_',i2.2,'.nc')
            lstr=lenstr(hisname)
            write(stdout,20) hisname(1:lstr), ldefout
 20         format(/,6x,'OUTPUT  - processing new history file: ',a,
     &             4x,'defining = ',l1,/)
          endif
        else
          if (iic.eq.ntstart) then
            nhisrec=0
            lstr=lenstr(hisname)
            write(stdout,30) hisname(1:lstr)
 30         format(/,6x,'OUTPUT  - processing history file: ',a,/)
          endif
        endif
        if ((MOD(iic-1,nhis).eq.0).and.
     &      ((nrrec.eq.0).or.(iic.ne.ntstart))) then
          nhisrec=nhisrec+1
          write(stdout,40) nhisrec, tdays, iic
 40       format(1x,'WRT_HIS - wrote history record: ',
     &           i3.3,2x,'Day = ',f13.6,2x,'TimeStep = ',i8.8)
        endif
      enddo
!
!  Check average output.
!
      time=dstart*day2sec-dt
!
      do iic=ntstart, ntimes+1
!
        time=time+dt
        tdays=time*sec2day
!
        if (ndefavg.gt.0) then
          if ((iic.eq.ntstart).or.((iic-1).eq.idefavg)) then
            if ((nrrec.eq.0).and.(iic.eq.ntstart)) then
              idefavg=idefavg+ndefavg+navg
            else
              idefavg=idefavg+ndefavg
            endif
            navgrec=0
            if ((nrrec.gt.0).and.(MOD(iic-1,ndefavg).ne.0)) then
              ldefout=.false.
            else
              ldefout=.true.
            endif
            lstr=lenstr(avgbase)
            write(avgname,50) avgbase(1:lstr-3), ((iic-1)/ndefavg)+1
 50         format(a,'_',i2.2,'.nc')
            lstr=lenstr(avgname)
            write(stdout,60) avgname(1:lstr), ldefout
 60         format(/,6x,'OUTPUT  - processing new average file: ',a,
     &             4x,'defining = ',l1,/)
          endif
        else
          if (iic.eq.ntstart) then
            navgrec=0
            lstr=lenstr(avgname)
            write(stdout,70) avgname(1:lstr)
 70         format(/,6x,'OUTPUT  - processing average file: ',a,/)
          endif
        endif
        if ((iic.gt.ntstart).and.(MOD(iic-1,navg).eq.0)) then
          navgrec=navgrec+1
          write(stdout,80) navgrec, tdays, iic
 80       format(1x,'WRT_AVG - wrote average record: ',
     &           i3.3,2x,'Day = ',f13.6,2x,'TimeStep = ',i8.8)
        endif
      enddo
      stop
      end
      subroutine inp_par
!
!=====================================================================
!                                                                    !
!  This routine reads in input model parameters from standard input. !
!  It also writes out these parameters to standard output.           !
!                                                                    !
!=====================================================================
!
      implicit none
!
      common /Linput/ lcycle, ldefout
      logical         lcycle, ldefout
      common /Iinput/ navg, ndefavg, ndefhis, nhis, nrrec, nrst,
     &                ntsavg, ntimes
      integer         navg, ndefavg, ndefhis, nhis, nrrec, nrst,
     &                ntsavg, ntimes
      common /Rinput/ dt, dstart
      real*8          dt, dstart
      common /Cinput/ avgbase, avgname, hisbase, hisname, ininame,
     &                rstname
      character*80    avgbase, avgname, hisbase, hisname, ininame,
     &                rstname
!
      logical lpar
      integer icard, ipar, stdinp, stdout
      real*8  rpar
      character*80 cpar
      parameter (stdinp=5, stdout=6)
!
!---------------------------------------------------------------------
!  Read in and report input model parameters.
!---------------------------------------------------------------------
!
      icard=0
      write(stdout,10)
  10  format(/,' Model input parameters:',/)
!
!  Read input parameters according to their input card number.
!
      do while (icard.lt.99)
!
!  Read in time-stepping parameters.
!
        if (icard.eq.1) then
          read(stdinp,*,err=90) ntimes, dt, ipar
          write(stdout,20) ntimes, dt
  20      format(i10,2x,'ntimes      ',
     &             'Number of timesteps for 3-D equations.',/,
     &           f10.2,2x,'dt          ',
     &             'Timestep size (s) for 3-D equations.')
!
!  Read in input/output parameters.
!
        elseif (icard.eq.2) then
          read(stdinp,*,err=90) nrrec, lcycle, nrst, ipar, ipar, ipar
          write(stdout,30) nrrec, lcycle, nrst
  30      format(4x,i6,2x,'nrrec       ',
     &             'Number of restart records to read from disk.',/,
     &           9x,l1,2x,'lcycle      ',
     &             'Switch to recycle time-records in restart NetCDF',
     &             ' file.',/,
     &           4x,i6,2x,'nrst        ',
     &             'Number of timesteps between storage of restart ',
     &             'fields.')
!
!  Read in history and time-average files parameters.
!
        elseif (icard.eq.3) then
          read(stdinp,*,err=90) ldefout, nhis, ndefhis, ntsavg, navg,
     &                          ndefavg
          write(stdout,40) ldefout, nhis
  40      format(9x,l1,2x,'ldefout     ',
     &             'Switch to create a new output NetCDF file(s).',/,
     &           4x,i6,2x,'nhis        ',
     &             'Number of timesteps between writing fields into',
     &             /,26x,'history file.')
          if (ndefhis.gt.0) then
            write(stdout,50) ndefhis
  50        format(4x,i6,2x,'ndefhis     ',
     &               'Number of timesteps between creation of new',
     &               /,26x,'history files.')
          endif
          write(stdout,60) ntsavg, navg
  60      format(4x,i6,2x,'ntsavg      ',
     &             'Starting timestep for the accumulation of output',
     &             /,26x,'time-averaged data.',/,
     &           4x,i6,2x,'navg        ',
     &             'Number of timesteps between writing of ',
     &             'time-averaged',/,26x,'data into averages file.')
          if (ndefavg.gt.0) then
            write(stdout,70) ndefavg
  70        format(4x,i6,2x,'ndefavg     ',
     &               'Number of timesteps between creation of new',
     &               /,26x,'time-averaged files.')
          endif
!
!  Read in input lines 4-13 as a dummy real variable.
!
        elseif ((4.le.icard).and.(icard.le.13)) then
          read(stdinp,*,err=90) rpar
!
!  Read in input starting day

        elseif (icard.eq.14) then
          read(stdinp,*,err=90) rpar, dstart
          write(stdout,80) dstart
 80       format(f10.4,2x,'dstart      ',
     &          'Time stamp assigned to model initialization (days).')
!
!  Read in input lines 15-18 as a dummy real variable.
!
        elseif ((15.le.icard).and.(icard.le.18)) then
          read(stdinp,*,err=90) rpar
!
!  Read in input lines 19-24 as a dummy logical variable.
!
        elseif ((19.le.icard).and.(icard.le.24)) then
          read(stdinp,*,err=90) lpar
!
!  Read in input lines 25-26 as a dummy real variable.
!
        elseif ((25.le.icard).and.(icard.le.26)) then
          read(stdinp,*,err=90) rpar
!
!  Read in input line 27 as a dummy string.
!
        elseif (icard.eq.27) then
          read(stdinp,'(a)',err=90) cpar
!
!  Read in output restart file name, if any.
!
        elseif (icard.eq.28) then
          read(stdinp,'(a)',err=90) rstname
!
!  Read in output history file name, if any.
!
        elseif (icard.eq.29) then
          read(stdinp,'(a)',err=90) hisname
          hisbase=hisname
!
!  Read in output averages file name, if any.
!
        elseif (icard.eq.30) then
          read(stdinp,'(a)',err=90) avgname
          avgbase=avgname
!
!  Read in input line 31-32 as a dummy string.
!
        elseif ((31.le.icard).and.(icard.le.33)) then
          read(stdinp,'(a)',err=90) cpar
!
!  Read in input initial conditions file name, if any.
!
        elseif (icard.eq.34) then
          read(stdinp,'(a)',err=90) ininame
!
!  Read in other input lines as a dummy string.
!
        elseif ((35.le.icard).and.(icard.le.41)) then
          read(stdinp,'(a)',err=90) cpar
        endif
!
!  Read next input card ID.
!
        read(stdinp,*,err=90) icard
      enddo
      goto 110
!
!  Error while reading input parameters.
!
  90  write(stdout,100) icard
 100  format(/,' INP_PAR - error while reading input card: ',i2)
      stop
 110  continue
      return
      end
      integer function lenstr (string)
!
!=====================================================================
!                                                                    !
!  This function returns the  character position of the last         !
!  nonblank character in "string" after removing the leading         !
!  blank characters, if any.                                         !
!                                                                    !
!=====================================================================
!
      implicit none
      integer i, ic, istart, nchar
      character*(*) string
!
!---------------------------------------------------------------------
!  Find length of input character string.
!---------------------------------------------------------------------
!
      lenstr=0
      nchar=len(string)
!
!  Strip leading blank characters, if any.
!
      ic=0
      do i=1,nchar
        if (string(i:i).eq.' ') then
          ic=ic+1
        else
          goto 10
        endif
      enddo
 10   istart=ic+1
      if (ic.eq.nchar) return
      if (istart.lt.nchar) string=string(istart:nchar)
!
!  Strip trailing blank characters and determine the its length.
!
      do i=nchar,1,-1
        if (string(i:i).ne.' ') goto 20
      enddo
      return
 20   lenstr=i
      end
