#include "cppdefs.h"
#ifdef BVF_MIXING
      subroutine bvf_mix (tile)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine computes tracer vertical mixing as a function of the !
!  Brunt-Vaisala frequency.  The vertical mixing of momentum  is set !
!  to its background value.  If static unstable regime, the vertical !
!  mixing is set to "bvf_nu0c".                                      !
!                                                                    !
!====================================================================!
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "tile.h"
!
      call bvf_mix_tile (Istr,Iend,Jstr,Jend)
      return
      end
!
!*********************************************************************
      subroutine bvf_mix_tile (Istr,Iend,Jstr,Jend)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "mixing.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        cff
!
!  Set tracer diffusivity as function of the Brunt-vaisala frequency.
!  Set vertical viscosity to its background value.
!
      do k=1,N-1
        do j=Jstr,Jend
          do i=Istr,Iend
            Akv(i,j,k)=Akv_bak
            if (bvf(i,j,k).lt.0.0_r8) then
              Akv(i,j,k)=bvf_nu0c
              Akt(i,j,k,itemp)=bvf_nu0c
# ifdef SALINITY
              Akt(i,j,k,isalt)=bvf_nu0c
# endif /* SALINITY */
            elseif (bvf(i,j,k).eq.0.0_r8) then
              Akv(i,j,k)=Akv_bak
              Akt(i,j,k,itemp)=Akt_bak(itemp)
# ifdef SALINITY
              Akt(i,j,k,isalt)=Akt_bak(isalt)
# endif /* SALINITY */
            else
              cff=bvf_nu0/SQRT(bvf(i,j,k))
              Akt(i,j,k,itemp)=MIN(bvf_numax,MAX(bvf_numin,cff))
              Akv(i,j,k)=Akt(i,j,k,itemp)
# ifdef SALINITY
              Akt(i,j,k,isalt)=Akt(i,j,k,itemp)
# endif /* SALINITY */
            endif
          enddo
        enddo
      enddo
# if defined EW_PERIODIC || defined NS_PERIODIC
!
! Set periodic boundary conditions.
!
      call exchange_w3d_tile (Istr,Iend,Jstr,Jend,Akv)
      call exchange_w3d_tile (Istr,Iend,Jstr,Jend,
     &                        Akt(START_2D_ARRAY,0,itemp))
#  ifdef SALINITY
      call exchange_w3d_tile (Istr,Iend,Jstr,Jend,
     &                        Akt(START_2D_ARRAY,0,isalt))
#  endif /* SALINITY */
# endif /* EW_PERIODIC || NS_PERIODIC */
#else
      subroutine bvf_mix
#endif
      return
      end
