/*
** Include file "boundary.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
**  FSobc_in    Active and strong time-scale (1/sec) coefficients   **
**                for nudging towards free-surface data at  inflow. **
**  FSobc_out   Passive and weak  time-scale (1/sec) coefficients   **
**                for nudging towards free-surface data at outflow. **
**  M2obc_in    Active and strong time-scale (1/sec) coefficients   **
**                for nudging towards 2D momentum data at  inflow.  **
**  M2obc_out   Passive and weak  time-scale (1/sec) coefficients   **
**                for nudging towards 2D momentum data at outflow.  **
**  M3obc_in    Active and strong time-scale (1/sec) coefficients   **
**                for nudging towards 3D momentum data at  inflow.  **
**  M3obc_out   Passive and weak  time-scale (1/sec) coefficients   **
**                for nudging towards 3D momentum data at outflow.  **
**  Tobc_in     Active and strong time-scale (1/sec) coefficients   **
**                for nudging towards tracer data at  inflow.       **
**  Tobc_out   Passive and weak  time-scale (1/sec) coefficients    **
**                for nudging towards tracer data at outflow.       **
**                                                                  **
**********************************************************************
*/

      INTEGER_TYPE
     &        iwest,             isouth,            ieast,
     &        inorth
      parameter
     &       (iwest=1,           isouth=2,          ieast=3,
     &        inorth=4)

      common /obc2_nudgcof/
     &        FSobc_in,          FSobc_out,         M2obc_in,
     %        M2obc_out
      REAL_TYPE
     &        FSobc_in(4),       FSobc_out(4),      M2obc_in(4),
     %        M2obc_out(4)

#ifdef SOLVE3D
      common /obc3_nudgcof/
     &        M3obc_in,          M3obc_out,         Tobc_in,
     %        Tobc_out
      REAL_TYPE
     &        M3obc_in(4),       M3obc_out(4),      Tobc_in(4,NT+1),
     %        Tobc_out(4,NT+1)
#endif /* SOLVE3D */

/*
**********************************************************************
** Open boundary conditions arrays.                                 **
**********************************************************************
**                                                                  **
** zeta_east    Free-surface (m) eastern boundary conditions.       **
** zetaG_east   Latest two-time snapshots of input free-surface (m) **
**                eastern boundary data.                            **
** zeta_north   Free-surface (m) northern boundary conditions.      **
** zetaG_north  Latest two-time snapshots of input free-surface (m) **
**                northern boundary data.                           **
** zeta_south   Free-surface (m) southern boundary conditions.      **
** zetaG_south  Latest two-time snapshots of input free-surface (m) **
**                southern boundary data.                           **
** zeta_west    Free-surface (m) western boundary conditions.       **
** zetaG_west   Latest two-time snapshots of input free-surface (m) **
**                western boundary data.                            **
**                                                                  **
**********************************************************************
*/

#if defined WEST_FSOBC || defined WEST_M2OBC
      common /west_fsobc/ zeta_west
      REAL_TYPE zeta_west(0:M)
# ifndef ANA_FSOBC
      common /west_fsobcG/ zetaG_west
      REAL_TYPE zetaG_west(0:M,2)
# endif
#endif

#if defined EAST_FSOBC || defined EAST_M2OBC
      common /east_fsobc/ zeta_east
      REAL_TYPE zeta_east(0:M)
# ifndef ANA_FSOBC
      common /east_fsobcG/ zetaG_east
      REAL_TYPE zetaG_east(0:M,2)
# endif
#endif

#if defined SOUTH_FSOBC || defined SOUTH_M2OBC
      common /south_fsobc/ zeta_south
      REAL_TYPE zeta_south(0:L)
# ifndef ANA_FSOBC
      common /south_fsobcG/ zetaG_south
      REAL_TYPE zetaG_south(0:L,2)
# endif
#endif

#if defined NORTH_FSOBC || defined NORTH_M2OBC
      common /north_fsobc/ zeta_north
      REAL_TYPE zeta_north(0:L)
# ifndef ANA_FSOBC
      common /north_fsobcG/ zetaG_north
      REAL_TYPE zetaG_north(0:L,2)
# endif
#endif

/*
**********************************************************************
** 2D momentum boundary conditions.                                 **
**********************************************************************
**                                                                  **
** ubar_east    2D u-momentum (m/s) eastern boundary conditions.    **
** ubarG_east   Latest two-time snapshots of input 2D u-momentum    **
**                (m/s) eastern boundary data.                      **
** ubar_north   2D u-momentum (m/s) northern boundary conditions.   **
** ubarG_north  Latest two-time snapshots of input 2D u-momentum    **
**                (m/s) northern boundary data.                     **
** ubar_south   2D u-momentum (m/s) southern boundary conditions.   **
** ubarG_south  Latest two-time snapshots of input 2D u-momentum    **
**                (m/s) southern boundary data.                     **
** ubar_west    2D u-momentum (m/s) western boundary conditions.    **
** ubarG_west   Latest two-time snapshots of input 2D u-momentum    **
**                (m/s) western boundary data.                      **
** vbar_east    2D v-momentum (m/s) eastern boundary conditions.    **
** vbarG_east   Latest two-time snapshots of input 2D v-momentum    **
**                (m/s) eastern boundary data.                      **
** vbar_north   2D v-momentum (m/s) northern boundary conditions.   **
** vbarG_north  Latest two-time snapshots of input 2D v-momentum    **
**                (m/s) northern boundary data.                     **
** vbar_south   2D v-momentum (m/s) southern boundary conditions.   **
** vbarG_south  Latest two-time snapshots of input 2D v-momentum    **
**                (m/s) southern boundary data.                     **
** vbar_west    2D v-momentum (m/s) western boundary conditions.    **
** vbarG_west   Latest two-time snapshots of input 2D v-momentum    **
**                (m/s) western boundary data.                      **
**                                                                  **
**********************************************************************
*/

#ifdef WEST_M2OBC
      common /west_m2obc/ ubar_west, vbar_west
      REAL_TYPE ubar_west(0:M)
      REAL_TYPE vbar_west(M)
# ifndef ANA_M2OBC
      common /west_m2obcG/ ubarG_west, vbarG_west
      REAL_TYPE ubarG_west(0:M,2)
      REAL_TYPE vbarG_west(M,2)
# endif
#endif

#ifdef EAST_M2OBC
      common /east_m2obc/ ubar_east, vbar_east
      REAL_TYPE ubar_east(0:M)
      REAL_TYPE vbar_east(M)
# ifndef ANA_M2OBC
      common /east_m2obcG/ ubarG_east, vbarG_east
      REAL_TYPE ubarG_east(0:M,2)
      REAL_TYPE vbarG_east(M,2) 
# endif
#endif

#ifdef SOUTH_M2OBC
      common /south_m2obc/ ubar_south, vbar_south
      REAL_TYPE ubar_south(L)
      REAL_TYPE vbar_south(0:L)
# ifndef ANA_M2OBC
      common /south_m2obcG/ ubarG_south, vbarG_south
      REAL_TYPE ubarG_south(L,2)
      REAL_TYPE vbarG_south(0:L,2)
# endif
#endif

#ifdef NORTH_M2OBC
      common /north_m2obc/ ubar_north, vbar_north
      REAL_TYPE ubar_north(L)
      REAL_TYPE vbar_north(0:L)
# ifndef ANA_M2OBC
      common /north_m2obcG/ ubarG_north, vbarG_north
      REAL_TYPE ubarG_north(L,2)
      REAL_TYPE vbarG_north(0:L,2)
# endif
#endif

#ifdef SOLVE3D

/*
**********************************************************************
** 3D momentum boundary conditions.                                 **
**********************************************************************
**                                                                  **
** u_east       3D u-momentum (m/s) eastern boundary conditions.    **
** uG_east      Latest two-time snapshots of input 3D u-momentum    **
**                (m/s) eastern boundary data.                      **
** u_north      3D u-momentum (m/s) northern boundary conditions.   **
** uG_north     Latest two-time snapshots of input 3D u-momentum    **
**                (m/s) northern boundary data.                     **
** u_south      3D u-momentum (m/s) southern boundary conditions.   **
** uG_south     Latest two-time snapshots of input 3D u-momentum    **
**                (m/s) southern boundary data.                     **
** u_west       3D u-momentum (m/s) western boundary conditions.    **
** uG_west      Latest two-time snapshots of input 3D u-momentum    **
**                (m/s) western boundary data.                      **
** v_east       3D v-momentum (m/s) eastern boundary conditions.    **
** vG_east      Latest two-time snapshots of input 3D v-momentum    **
**                (m/s) eastern boundary data.                      **
** v_north      3D v-momentum (m/s) northern boundary conditions.   **
** vG_north     Latest two-time snapshots of input 3D v-momentum    **
**                (m/s) northern boundary data.                     **
** v_south      3D v-momentum (m/s) southern boundary conditions.   **
** vG_south     Latest two-time snapshots of input 3D v-momentum    **
**                (m/s) southern boundary data.                     **
** v_west       3D v-momentum (m/s) western boundary conditions.    **
** vG_west      Latest two-time snapshots of input 3D v-momentum    **
**                (m/s) western boundary data.                      **
**                                                                  **
**********************************************************************
*/

# ifdef WEST_M3OBC
      common /west_m3obc/ u_west, v_west
      REAL_TYPE u_west(0:M,N)
      REAL_TYPE v_west(M,N)
#  ifndef ANA_M3OBC
      common /west_m3obcG/ uG_west, vG_west
      REAL_TYPE uG_west(0:M,N,2)
      REAL_TYPE vG_west(M,N,2)
#  endif
# endif

# ifdef EAST_M3OBC
      common /east_m3obc/ u_east, v_east
      REAL_TYPE u_east(0:M,N)
      REAL_TYPE v_east(M,N)
#  ifndef ANA_M3OBC
      common /east_m3obcG/ uG_east, vG_east
      REAL_TYPE uG_east(0:M,N,2)
      REAL_TYPE vG_east(M,N,2) 
#  endif
# endif

# ifdef SOUTH_M3OBC
      common /south_m3obc/ u_south, v_south
      REAL_TYPE u_south(L,N)
      REAL_TYPE v_south(0:L,N)
#  ifndef ANA_M3OBC
      common /south_m3obcG/ uG_south, vG_south
      REAL_TYPE uG_south(L,N,2)
      REAL_TYPE vG_south(0:L,N,2)
#  endif
# endif

# ifdef NORTH_M3OBC
      common /north_m3obc/ u_north, v_north
      REAL_TYPE u_north(L,N)
      REAL_TYPE v_north(0:L,N)
#  ifndef ANA_M3OBC
      common /north_m3obcG/ uG_north, vG_north
      REAL_TYPE uG_north(L,N,2)
      REAL_TYPE vG_north(0:L,N,2)
#  endif
# endif

/*
**********************************************************************
** Tracer boundary conditions.                                      **
**********************************************************************
**                                                                  **
** t_east       Tracer (T units) eastern boundary conditions.       **
** tG_east      Latest two-time snapshops of input tracer (T units) **
**                eastern boundary data.                            **
** t_north      Tracer (T units) northern boundary conditions.      **
** tG_north     Latest two-time snapshops of input tracer (T units) **
**                northern boundary data.                           **
** t_south      Tracer (T units) southern boundary conditions.      **
** tG_south     Latest two-time snapshops of input tracer (T units) **
**                southern boundary data.                           **
** t_west       Tracer (T units) western boundary conditions.       **
** tG_west      Latest two-time snapshops of input tracer (T units) **
**                western boundary data.                            **
**                                                                  **
**********************************************************************
*/

# ifdef WEST_TOBC
      common /west_tobc/ t_west
      REAL_TYPE t_west(0:M,N,NT)
#  ifndef ANA_TOBC
      common /west_tobcG/ tG_west
      REAL_TYPE tG_west(0:M,N,2,NT)
#  endif
# endif

# ifdef EAST_TOBC
      common /east_tobc/ t_east
      REAL_TYPE t_east(0:M,N,NT)
#  ifndef ANA_TOBC
      common /east_tobcG/ tG_east
      REAL_TYPE tG_east(0:M,N,2,NT)
#  endif
# endif

# ifdef SOUTH_TOBC
      common /south_tobc/ t_south
      REAL_TYPE t_south(0:L,N,NT)
#  ifndef ANA_TOBC
      common /south_tobcG/ tG_south
      REAL_TYPE tG_south(0:L,N,2,NT)
#  endif
# endif

# ifdef NORTH_TOBC
      common /north_tobc/ t_north
      REAL_TYPE t_north(0:L,N,NT)
#  ifndef ANA_TOBC
      common /north_tobcG/ tG_north
      REAL_TYPE tG_north(0:L,N,2,NT)
#  endif
# endif

#endif /* SOLVE3D */
