#ifdef BIOLOGY

# ifdef BIO_FASHAM

/*
** Include file "biology.h".
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Parameters for Fasham et al. (1990) type model:                  **
**                                                                  **
**  AttSW    Light attenuation due to sea water [1/m].              **
**  AttChl   Light attenuation by Chlorophyll [1/(m2 mg Chl)].      **
**  BioIter  Maximum number of iterations to achieve convergence    **
**             of the nonlinear solution.                           **
**  ChlMB    Mass balance for chlorophyll molecule [mg Chl/mg C].   **
**  CPrMax   Maximum cellular chlorophyll to carbon ratio           **
**             [mg Chl/mg C].                                       **
**  K_NH4    Inverse half-saturation for Phytoplankton NH4 uptake   **
**             [m3/(mMol N)].                                       **
**  K_NO3    Inverse half-saturation for Phytoplankton NO3 uptake   **
**             [m3/(mMol N)].                                       **
**  K_Phy    Zooplankton half-saturation constant for ingestion     **
**             [1/day].                                             **
**  LDeRR    Large Detrital re-mineralization rate [1/day] to NO3.  **
**  PARfrac  Fraction of shortwave radiation that is available for  **
**             photosyntesis [non-dimensional].                     **
**  PhyCN    Phytoplankton C:N ratio [mMol C/mMol N].               **
**  PhyIP    Phytoplankton NH4 inhibition parameter [1/(mMol N)].   **
**  PhyIS    Phytoplankton, initial slope of the P-I curve          **
**             [mg C /(mg Chla W m-2 day)].                         **
**  PhyMR    Phytoplankton mortality rate [1/day] to small detritus.**
**  SDeAR    Small detritus aggregation rate into Large detritus    **
**             [1/(mMol N * day)].                                  **
**  SDeBR    Small Detrital breakdown to NH4 rate [1/day].          **
**  wLDe     Vertical sinking velocities for Large Detritus         **
**             fraction [m/day].                                    **
**  wSDe     Vertical sinking velocities for Small Detritus         **
**             fraction [m/day].                                    **
**  ZooAE    Zooplankton assimilation efficiency fraction           **
**             [non-dimensional].                                   **
**  ZooER    Zooplankton specific excretion rate [1/day].           **
**  ZooGR    Zooplankton maximum growth rate [1/day].               **
**  ZooMR    Zooplankton mortality to Detritus [1/day].             **
**                                                                  **
** Biological tracers identification indices:                       **
**                                                                  **
**  iNO3_    Nitrate concentration.                                 **
**  iPhyt    Phytoplankton concentration.                           **
**  iZoop    Zooplankton concentration.                             **
**  iNH4_    Ammonium concentration.                                **
**  iLDet    Large detritus concentration.                          **
**  iSDet    Small detritus concentration.                          **
**  iChlo    Chlorophyll/Phytoplankton ratio.                       **
**                                                                  **
**********************************************************************
*/

      common /ibiology/
     &        BioIter,           iChlo,             iNH4_,
     &        iNO3_,             iLDet,             iPhyt,
     &        iSDet,             iZoop
        
      INTEGER_TYPE
     &        BioIter,           iChlo,             iNH4_,
     &        iNO3_,             iLDet,             iPhyt,
     &        iSDet,             iZoop

      common /sbiology/
     &        AttSW,             AttChl,            ChlMB,
     &        CPrMax,            K_NH4,             K_NO3,
     &        K_Phy,             LDeRR,             PARfrac,
     &        PhyCN,             PhyIP,             PhyIS,
     &        PhyMR,             SDeAR,             SDeBR,
     &        wLDe,              wSDe,              ZooAE,
     &        ZooER,             ZooGR,             ZooMR
      REAL_TYPE
     &        AttSW,             AttChl,            ChlMB,
     &        CPrMax,            K_NH4,             K_NO3,
     &        K_Phy,             LDeRR,             PARfrac,
     &        PhyCN,             PhyIP,             PhyIS,
     &        PhyMR,             SDeAR,             SDeBR,
     &        wLDe,              wSDe,              ZooAE,
     &        ZooER,             ZooGR,             ZooMR

# endif /* BIO_FASHAM */

#endif /* BIOLOGY */
