#ifdef BBL

/*
** Include file "bbl.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Abed         wind-induced, bed wave excursion amplitude (m).     **
** Hripple      Bed ripple height (m).                              **
** Lripple      Bed ripple length (m).                              **
** Sdens        Sediment grain density (kg/m3) at RHO-points.       **
** Ssize        Sediment grain diameter size (m) at RHO-points.     **
** Ubed         Wind-induced, bed wave orbital U-velocity (m/s).    **
** Ubot         Bottom U-momentum (m/s) above bed.                  **
** Vbed         Wind-induced, bed wave orbital V-velocity (m/s).    **
** Vbot         Bottom V-momentum (m/s) above bed.                  **
** Zbnot        Hydraulic bottom roughness (m).                     **
** Zbnotc       Apparent hydraulic bottom roughness (m).            **
** bustrw       Kinematic bottom stress (m2/s2) due to wind-induced **
**                waves the XI-direction at horizontal U-points.    **
** bvstrw       Kinematic bottom stress (m2/s2) due to wind-induced **
**                waves the ETA-direction at horizontal V-points.   **
** sg_Cdmax     Upper limit on bottom darg coefficient.             **
** sg_alpha     Free parameter indicating the constant stress       **
**                region of the wave boundary layer.                **
** sg_g         Acceleration of gravity (m/s2).                     **
** sg_kappa     Von Karman constant.                                **
** sg_mp        Nondimensional closure constant.                    **
** sg_n         Maximum number of iterations for bisection method.  **
** sg_nu        Kinematic viscosity of seawater (m2/s).             **
** sg_pi        Ratio of circumference to diameter.                 **
** sg_tol       Convergence criterion.                              **
** sg_ustarcdef Default bottom stress (m/s).                        **
** sg_z100      Depth (m), 100 cm above bottom.                     **
** sg_z1p                                                           **
** sg_zrmin     Minimum allowed height (m) of current above bed.    **
**                Otherwise, logarithmic interpolation is used.     **
** sg_znotcdef  Default apparent hydraulic roughness (m).           **
** sg_znotdef   Default hydraulic roughness (m).                    **
**                                                                  **
**********************************************************************
*/

# ifdef SG_BBL

      INTEGER_TYPE sg_n
      parameter (sg_n=20)

      common /S_bbl/
     &        sg_Cdmax,          sg_alpha,          sg_g,
     &        sg_kappa,          sg_nu,             sg_pi,
     &        sg_tol,            sg_ustarcdef,      sg_z100,
     &        sg_z1min,          sg_z1p,            sg_znotcdef,
     &        sg_znotdef

      REAL_TYPE
     &        sg_Cdmax,          sg_alpha,          sg_g,
     &        sg_kappa,          sg_nu,             sg_pi,
     &        sg_tol,            sg_ustarcdef,      sg_z100,
     &        sg_z1min,          sg_z1p,            sg_znotcdef,
     &        sg_znotdef

      common /C_bbl/
     &        sg_mp

      COMPLEX_TYPE
     &        sg_mp

# endif

      common /bbl_Abed/ Abed
      REAL_TYPE Abed(GLOBAL_2D_ARRAY)

      common /bbl_Hripple/ Hripple
      REAL_TYPE Hripple(GLOBAL_2D_ARRAY)

      common /bbl_Lripple/ Lripple
      REAL_TYPE Lripple(GLOBAL_2D_ARRAY)

      common /bbl_Sdens/ Sdens
      REAL_TYPE Sdens(GLOBAL_2D_ARRAY)

      common /bbl_Ssize/ Ssize
      REAL_TYPE Ssize(GLOBAL_2D_ARRAY)

      common /bbl_Ubed/ Ubed
      REAL_TYPE Ubed(GLOBAL_2D_ARRAY)

      common /bbl_Ubot/ Ubot
      REAL_TYPE Ubot(GLOBAL_2D_ARRAY)

      common /bbl_Vbed/ Vbed
      REAL_TYPE Vbed(GLOBAL_2D_ARRAY)

      common /bbl_Vbot/ Vbot
      REAL_TYPE Vbot(GLOBAL_2D_ARRAY)

      common /bbl_Zbnot/ Zbnot
      REAL_TYPE Zbnot(GLOBAL_2D_ARRAY)

      common /bbl_Zbnotc/ Zbnotc
      REAL_TYPE Zbnotc(GLOBAL_2D_ARRAY)

      common /bbl_bustrw/ bustrw
      REAL_TYPE bustrw(GLOBAL_2D_ARRAY)

      common /bbl_bvstrw/ bvstrw
      REAL_TYPE bvstrw(GLOBAL_2D_ARRAY)

      common /bbl_Iconv/ Iconv
      INTEGER_TYPE Iconv(GLOBAL_2D_ARRAY)

#endif
