#ifdef AVERAGES

/*
** Include file "averages.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** 2D Time-averaged fields for output purposes.                     **
**                                                                  **
** avgu2d     2D velocity component (m/s) in the XI-direction.      **
** avgv2d     2D velocity component (m/s) in the ETA-direction.     **
** avgzeta    Free surface (m).                                     **
**                                                                  **
**********************************************************************
*/

      common /averages_avgu2d/ avgu2d
      REAL_TYPE avgu2d(GLOBAL_2D_ARRAY)

      common /averages_avgv2d/ avgv2d
      REAL_TYPE avgv2d(GLOBAL_2D_ARRAY)

      common /averages_avgzeta/ avgzeta
      REAL_TYPE avgzeta(GLOBAL_2D_ARRAY)

# ifdef SOLVE3D

/*
**********************************************************************
** 3D Time-averaged fields for output purposes.                     **
**********************************************************************
**                                                                  **
** avgAKs     Vertical diffusion of Salinity (m2/s).                **
** avgAKt     Vertical diffusion of temperature (m2/s).             **
** avgAKv     Vertical viscosity (m2/s).                            **
** avghbbl    Depth of oceanic bottom boundary layer (m).           **
** avghsbl    Depth of oceanic surface boundary layer (m).          **
** avgrho     Density anomaly (kg/m3).                              **
** avgt       Tracer type variables (usually, potential temperature **
**              and salinity).                                      **
** avgu3d     3D velocity component (m/s) in the XI-direction.      **
** avgv3d     3D velocity component (m/s) in the ETA-direction.     **
** avgw3d     S-coordinate [omega*Hz/mn] vertical velocity (m3/s).  **
**                                                                  **
**********************************************************************
*/

#  ifdef AVERAGES_AKS
      common /averages_avgAKs/ avgAKs
      REAL_TYPE avgAKs(GLOBAL_2D_ARRAY,0:N)
#  endif

#  ifdef AVERAGES_AKT
      common /averages_avgAKt/ avgAKt
      REAL_TYPE avgAKt(GLOBAL_2D_ARRAY,0:N)
#  endif

#  ifdef AVERAGES_AKV
      common /averages_avgAKv/ avgAKv
      REAL_TYPE avgAKv(GLOBAL_2D_ARRAY,0:N)
#  endif

#  ifdef LMD_BKPP
      common /averages_avghbbl/ avghbbl
      REAL_TYPE avghbbl(GLOBAL_2D_ARRAY)
#  endif

#  ifdef LMD_SKPP
      common /averages_avghsbl/ avghsbl
      REAL_TYPE avghsbl(GLOBAL_2D_ARRAY)
#  endif

      common /averages_avgrho/ avgrho
      REAL_TYPE avgrho(GLOBAL_2D_ARRAY,N)

      common /averages_avgt/ avgt
      REAL_TYPE avgt(GLOBAL_2D_ARRAY,N,NT)

      common /averages_avgu3d/ avgu3d
      REAL_TYPE avgu3d(GLOBAL_2D_ARRAY,N)

      common /averages_avgv3d/ avgv3d
      REAL_TYPE avgv3d(GLOBAL_2D_ARRAY,N)

      common /averages_avgw3d/ avgw3d
      REAL_TYPE avgw3d(GLOBAL_2D_ARRAY,N)

# endif
#endif
